/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.liberty.v12;

import oracle.security.xmlsec.liberty.v12.LibertyInitializer;
import oracle.security.xmlsec.liberty.v12.LibertyUtils;
import oracle.security.xmlsec.liberty.v12.ac.AuthenticationContextStatement;
import oracle.security.xmlsec.saml.SAMLInitializer;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.util.XMLUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class AuthnContext
extends XMLElement {
    private static final String[] nsURIs = new String[]{"urn:liberty:iff:2003-08", "urn:liberty:ac:2003-08", "urn:liberty:iff:2003-08"};
    private static final String[] localNames = new String[]{"AuthnContextClassRef", "AuthenticationContextStatement", "AuthenticationContextStatementRef"};

    public AuthnContext(Element element) throws DOMException {
        super(element);
    }

    public AuthnContext(Element element, String systemId) throws DOMException {
        super(element, systemId);
    }

    public AuthnContext(Document owner) throws DOMException {
        super(owner, "urn:liberty:iff:2003-08", "AuthnContext");
    }

    public void setAuthnContextClassRef(String accrURI) {
        LibertyUtils.insertChildElementWithText(this, "urn:liberty:iff:2003-08", "AuthnContextClassRef", nsURIs, localNames, accrURI, true);
    }

    public String getAuthnContextClassRef() {
        return LibertyUtils.collectTextFromChild(this, "urn:liberty:iff:2003-08", "AuthnContextClassRef");
    }

    public void setAuthnContextStatementRef(String acsrURI) {
        Document doc = this.getOwnerDocument();
        Element acsr = doc.createElementNS("urn:liberty:iff:2003-08", "AuthnContextStatementRef");
        acsr.appendChild(doc.createTextNode(acsrURI));
        XMLUtils.copyNSPrefix((Element)((Element)this.node), (Element)acsr);
        XMLUtils.removeChildren((Element)((Element)this.node), (String)"urn:liberty:iff:2003-08", (String)"AuthnContextStatementRef");
        XMLUtils.removeChildren((Element)((Element)this.node), (String)"urn:liberty:ac:2003-08", (String)"AuthenticationContextStatement");
        XMLUtils.insertChild((Element)((Element)this.node), (Element)acsr, (String[])nsURIs, (String[])localNames, (int)1);
    }

    public String getAuthnContextStatementRef() {
        return LibertyUtils.collectTextFromChild(this, "urn:liberty:iff:2003-08", "AuthnContextStatementRef");
    }

    public void setAuthenticationContextStatement(AuthenticationContextStatement authnContextStatement) {
        XMLUtils.removeChildren((Element)((Element)this.node), (String)"urn:liberty:iff:2003-08", (String)"AuthnContextStatementRef");
        XMLUtils.removeChildren((Element)((Element)this.node), (String)"urn:liberty:ac:2003-08", (String)"AuthenticationContextStatement");
        XMLUtils.insertChild((XMLElement)this, (XMLElement)authnContextStatement, (String[])nsURIs, (String[])localNames, (int)1);
    }

    public AuthenticationContextStatement getAuthenticationContextStatement() {
        NodeList list = this.getChildElementsByTagNameNS("urn:liberty:ac:2003-08", "AuthenticationContextStatement");
        if (list.getLength() > 0) {
            return new AuthenticationContextStatement((Element)list.item(0));
        }
        return null;
    }

    static {
        SAMLInitializer.initialize((int)1, (int)1);
        LibertyInitializer.initialize();
    }
}

