/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc;

import java.lang.reflect.Executable;
import java.util.logging.Logger;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.jdbc.ConnectionPoolDataSourceConnectionFactoryAdapter;
import oracle.ucp.jdbc.JDBCConnectionFactoryAdapter;
import oracle.ucp.jdbc.JDBCConnectionPool;
import oracle.ucp.jdbc.JDBCConnectionRetrievalInfo;
import oracle.ucp.util.UCPErrorHandler;

@DefaultLogger(value="oracle.ucp.jdbc")
@Supports(value={Feature.CHECK_IN, Feature.CHECK_OUT, Feature.CONN_CONSTRUCTION, Feature.CONN_DESTRUCTION})
public class PooledConnectionConnectionPool
extends JDBCConnectionPool
implements ConnectionEventListener {
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;

    public PooledConnectionConnectionPool(JDBCConnectionFactoryAdapter connectionFactoryAdapter) throws UniversalConnectionPoolException {
        super(connectionFactoryAdapter);
        this.validateConstructor(connectionFactoryAdapter);
    }

    public PooledConnection getPooledConnection(JDBCConnectionRetrievalInfo connectionRetrievalInfo) throws UniversalConnectionPoolException {
        return (PooledConnection)this.borrowConnection(connectionRetrievalInfo).getPhysicalConnection();
    }

    public boolean returnPooledConnection(PooledConnection pooledConnection) throws UniversalConnectionPoolException {
        return this.returnUsedPhysicalConnection(pooledConnection);
    }

    public boolean closePooledConnection(PooledConnection pooledConnection) throws UniversalConnectionPoolException {
        return this.closeUsedPhysicalConnection(pooledConnection);
    }

    protected void validateConstructor(JDBCConnectionFactoryAdapter connectionFactoryAdapter) throws UniversalConnectionPoolException {
        if (!(connectionFactoryAdapter instanceof ConnectionPoolDataSourceConnectionFactoryAdapter)) {
            throw UCPErrorHandler.newUniversalConnectionPoolException(105);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void discardConnection(ConnectionEvent event) {
        PooledConnection jdbcPooledConnection = (PooledConnection)event.getSource();
        if (jdbcPooledConnection != null) {
            jdbcPooledConnection.removeConnectionEventListener(this);
            PooledConnectionConnectionPool pooledConnectionConnectionPool = this;
            synchronized (pooledConnectionConnectionPool) {
                this.discardUsedConnection(jdbcPooledConnection);
            }
        }
    }

    @Override
    public void connectionClosed(ConnectionEvent event) {
    }

    @Override
    public void connectionErrorOccurred(ConnectionEvent event) {
        this.discardConnection(event);
    }

    static {
        try {
            $$$methodRef$$$7 = PooledConnectionConnectionPool.class.getDeclaredConstructor(JDBCConnectionFactoryAdapter.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc");
        try {
            $$$methodRef$$$6 = PooledConnectionConnectionPool.class.getDeclaredMethod("connectionErrorOccurred", ConnectionEvent.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc");
        try {
            $$$methodRef$$$5 = PooledConnectionConnectionPool.class.getDeclaredMethod("connectionClosed", ConnectionEvent.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc");
        try {
            $$$methodRef$$$4 = PooledConnectionConnectionPool.class.getDeclaredMethod("discardConnection", ConnectionEvent.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc");
        try {
            $$$methodRef$$$3 = PooledConnectionConnectionPool.class.getDeclaredMethod("validateConstructor", JDBCConnectionFactoryAdapter.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc");
        try {
            $$$methodRef$$$2 = PooledConnectionConnectionPool.class.getDeclaredMethod("closePooledConnection", PooledConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc");
        try {
            $$$methodRef$$$1 = PooledConnectionConnectionPool.class.getDeclaredMethod("returnPooledConnection", PooledConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc");
        try {
            $$$methodRef$$$0 = PooledConnectionConnectionPool.class.getDeclaredMethod("getPooledConnection", JDBCConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc");
    }
}

