<?php
/**
 * Zend Framework
 *
 * LICENSE
 *
 * This source file is subject to the new BSD license that is bundled
 * with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://framework.zend.com/license/new-bsd
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@zend.com so we can send you a copy immediately.
 *
 * @category   Zend
 * @package    Zend_Filter
 * @subpackage UnitTests
 * @copyright  Copyright (c) 2005-2012 Zend Technologies USA Inc. (http://www.zend.com)
 * @license    http://framework.zend.com/license/new-bsd     New BSD License
 * @version    $Id: StringTrimTest.php 24593 2012-01-05 20:35:02Z matthew $
 */

/**
 * @see Zend_Filter_StringTrim
 */
require_once 'Zend/Filter/StringTrim.php';

/**
 * @category   Zend
 * @package    Zend_Filter
 * @subpackage UnitTests
 * @copyright  Copyright (c) 2005-2012 Zend Technologies USA Inc. (http://www.zend.com)
 * @license    http://framework.zend.com/license/new-bsd     New BSD License
 * @group      Zend_Filter
 */
class Zend_Filter_StringTrimTest extends PHPUnit_Framework_TestCase
{
    /**
     * Zend_Filter_StringTrim object
     *
     * @var Zend_Filter_StringTrim
     */
    protected $_filter;

    /**
     * Creates a new Zend_Filter_StringTrim object for each test method
     *
     * @return void
     */
    public function setUp()
    {
        $this->_filter = new Zend_Filter_StringTrim();
    }

    /**
     * Ensures that the filter follows expected behavior
     *
     * @return void
     */
    public function testBasic()
    {
        $valuesExpected = array(
            'string' => 'string',
            ' str '  => 'str',
            "\ns\t"  => 's'
            );
        foreach ($valuesExpected as $input => $output) {
            $this->assertEquals($output, $this->_filter->filter($input));
        }
    }

    /**
     * Ensures that getCharList() returns expected default value
     *
     * @return void
     */
    public function testGetCharList()
    {
        $this->assertEquals(null, $this->_filter->getCharList());
    }

    /**
     * Ensures that setCharList() follows expected behavior
     *
     * @return void
     */
    public function testSetCharList()
    {
        $this->_filter->setCharList('&');
        $this->assertEquals('&', $this->_filter->getCharList());
    }

    /**
     * Ensures expected behavior under custom character list
     *
     * @return void
     */
    public function testCharList()
    {
        $this->_filter->setCharList('&');
        $this->assertEquals('a&b', $this->_filter->filter('&&a&b&&'));
    }

    /**
     * @ZF-7183
     */
    public function testZF7183()
    {
        $this->assertEquals('Зенд', $this->_filter->filter('Зенд'));
    }

    /**
     * @ZF-7902
     */
    public function testZF7902()
    {
        $this->assertEquals('/', $this->_filter->filter('/'));
    }

    /**
     * @group ZF-10691
     */
    public function testSetParamCharListToConstructor()
    {
        require_once 'Zend/Config.php';
        $config = new Zend_Config(array('charlist' => '&'));
        $filter = new Zend_Filter_StringTrim($config);
        $this->assertEquals('&', $filter->getCharList());

        $filter = new Zend_Filter_StringTrim(array('charlist' => '&'));
        $this->assertEquals('&', $filter->getCharList());

        $filter = new Zend_Filter_StringTrim('&');
        $this->assertEquals('&', $filter->getCharList());
    }
}
