package org.jdesktop.animation.timing.triggers;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.EventListener;
import org.jdesktop.animation.timing.TimingController;

public abstract class Trigger
{

	public enum TriggerAction
	{
		START, 
		STOP;
	}

    public Trigger() {
    }
    
    public Trigger(final TimingController startTimer, final Object source, final TriggerEvent event, final TimingController stopTimer) {
        this.setupListener(startTimer, source, Trigger.TriggerAction.START, event);
        this.setupListener(startTimer, source, Trigger.TriggerAction.STOP, event.getOppositeEvent());
        if (stopTimer != null) {
            this.setupListener(stopTimer, source, Trigger.TriggerAction.START, event.getOppositeEvent());
            this.setupListener(stopTimer, source, Trigger.TriggerAction.STOP, event);
        }
    }
    
    protected abstract void setupListener(final TimingController p0, final Object p1, final Trigger.TriggerAction p2, final TriggerEvent p3);
    
    protected void setupListener(final Object object, final EventListener listener, final String methodName, final Class<? extends EventListener> listenerClass) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        final Method addListenerMethod = object.getClass().getMethod(methodName, listenerClass);
        addListenerMethod.invoke(object, listener);
    }
}
