/* iod-telemetry BackupDatafile.sql version 2019.05.12.1 stkolev */
with
    v$metricname as (
        /* version 3 */
        select
            ''              as project
            ,'oracle_db'    as fleet
            ,host_name      as host
            ,'"lifecycle":"'||
                case
                    when
                        (regexp_like(instance_name,'(9[0-9])') and host_name not like '%.r1') or
                        regexp_like(host_name,'(dev|sandbox)') or
                        regexp_like(lower(sys_context('USERENV','DB_DOMAIN')),'(dev|sand)')
                        then 'DEV'
                    when
                        (regexp_like(instance_name,'(9[0-9])') and host_name like '%.r1%') or
                        regexp_like(host_name,'(test|tst)') or
                        regexp_like(lower(sys_context('USERENV','DB_DOMAIN')),'(test|tst)')
                        then 'TEST'
                    else 'PROD'
                end || '"' ||
            ',"hostclass":"'|| nvl(regexp_substr(host_name,'^([^.]*)-',1,1,NULL,1),'N/A') || '"' ||
            ',"instance_name":"'     || instance_name    || '"' ||
            ',"db_name":"'           || nvl(name,'N/A')             || '"' ||
            ',"db_domain":"'         || nvl(sys_context('USERENV','DB_DOMAIN'),'N/A') || '"' ||
            ',"db_unique_name":"'    || db_unique_name   || '"' ||
            ',"database_role":"'     || database_role    || '"' ||
            ',"fsfo_role":"'||
                case
                    when database_role = 'PRIMARY' then 'PRIMARY'
                    when database_role = 'PHYSICAL STANDBY' and lower(db_unique_name)  = lower(fs_failover_current_target) then 'STANDBY'
                    when database_role = 'PHYSICAL STANDBY' and lower(db_unique_name) != lower(fs_failover_current_target) then 'BYSTANDER'
                    else 'NONE'
                end || '"' as metric_dimensions
        from v$database, v$instance
    ),
    v$metric_history as (
        select
             con.name
            ,df.file#
            ,df.incremental_level
            ,nvl(bd.cnt_bd,0)                       cnt_bd
            ,bd.max_bd_completion_time              max_bd_completion_time
            ,nvl(bd.sum_bd_marked_corrupt,0)        sum_bd_marked_corrupt
            ,nvl(bd.sum_bd_media_corrupt,0)         sum_bd_media_corrupt
            ,nvl(bd.sum_bd_logically_corrupt,0)     sum_bd_logically_corrupt
            ,nvl(bd.sum_bd_datafile_bytes,0)        sum_bd_datafile_bytes
            ,nvl(bd.sum_bd_bytes,0)                 sum_bd_bytes
            ,nvl(bd.sum_bd_blocks_read_bytes,0)     sum_bd_blocks_read_bytes
            ,nvl(bd.sum_bp_available,0)             sum_bp_available
            ,nvl(bd.sum_bp_total,0)                 sum_bp_total
            ,nvl(bd.sum_bp_bytes,0)                 sum_bp_bytes
            from
                v$containers con
                ,(
                    select
                         bd.con_id
                        ,bd.file#
                        ,nvl(bd.incremental_level,-1)           incremental_level
                        ,count(*)                               cnt_bd
                        ,max(bd.completion_time)                max_bd_completion_time
                        ,sum(bd.marked_corrupt)                 sum_bd_marked_corrupt
                        ,sum(bd.media_corrupt)                  sum_bd_media_corrupt
                        ,sum(bd.logically_corrupt)              sum_bd_logically_corrupt
                        ,sum(bd.datafile_blocks*bd.block_size)  sum_bd_datafile_bytes
                        ,sum(bd.blocks*bd.block_size)           sum_bd_bytes
                        ,sum(bd.blocks_read*bd.block_size)      sum_bd_blocks_read_bytes
                        ,sum(pbd.available_pieces)              sum_bp_available
                        ,sum(pbd.total_pieces)                  sum_bp_total
                        ,sum(pbd.total_bytes)                   sum_bp_bytes
                    from
                         v$backup_datafile bd
                        ,v$backup_set bs
                        ,(
                            select
                                con_id
                                ,set_stamp
                                ,set_count
                                ,count(*)                    total_pieces
                                ,sum(bytes)                  total_bytes
                                ,sum(decode(status,'A',1,0)) available_pieces
                            from
                                v$backup_piece_details
                            group by
                                con_id
                                ,set_stamp
                                ,set_count
                        ) pbd
                    where
                            bd.con_id    = bs.con_id
                        and bd.set_stamp = bs.set_stamp
                        and bd.set_count = bs.set_count
                        and bs.con_id    = pbd.con_id
                        and bs.set_stamp = pbd.set_stamp
                        and bs.set_count = pbd.set_count
                        and bd.file# != 0
                        and pbd.available_pieces = pbd.total_pieces
                    group by
                        bd.con_id
                        ,bd.file#
                        ,nvl(bd.incremental_level,-1)
                    order by
                        bd.con_id
                        ,bd.file#
                        ,nvl(bd.incremental_level,-1)
                ) bd
                ,(
                    select
                        con_id
                        ,file#
                        ,incremental_level
                    from (
                        select
                            con_id,
                            file#,
                            -1 as "full",
                            0 as "inc0",
                            1 as "inc1"
                        from
                            v$datafile
                    ) unpivot (
                        incremental_level for name in (
                             "full"
                            ,"inc0"
                            ,"inc1"
                        )
                    )
                ) df
            where
                    df.con_id = con.con_id
                and df.con_id = bd.con_id (+)
                and df.file# = bd.file# (+)
                and df.incremental_level = bd.incremental_level (+)
    ),
    v$metric as (
        select
            'BackupDatafile.'|| metric_name as metric_name
            ,',"con_name":"'            || nvl(to_char(name                 ),'null')|| '"' ||
             ',"file_id":"'             || nvl(to_char(file#                ),'null')|| '"' ||
             ',"backup_type":"'         || nvl(to_char(backup_type          ),'null')|| '"' ||
             ',"incremental_level":"'   || nvl(to_char(incremental_level    ),'null')|| '"' as metric_dimensions
            ,metric_value as metric_value
        from (
            select
                name
                ,file#
                ,decode(incremental_level,-1,'FULL','INCREMENTAL') as backup_type
                ,decode(incremental_level,-1,'null',incremental_level) as incremental_level
                -- this case statement effectively ignores inc1 backups if they don't exist
                ,case
                    when min(max_bd_completion_time) is null and incremental_level = -1 then -1
                    when min(max_bd_completion_time) is null and incremental_level =  0 then -1
                    when min(max_bd_completion_time) is null and incremental_level =  1 then 0
                    else (sysdate-min(max_bd_completion_time))*86400
                 end                             as "LatestBackupAgeSeconds"
                ,sum(cnt_bd)                     as "Backups"
                ,sum(sum_bd_marked_corrupt)      as "MarkedCorrupt"
                ,sum(sum_bd_media_corrupt)       as "MediaCorrupt"
                ,sum(sum_bd_logically_corrupt)   as "LogicallyCorrupt"
            from
                v$metric_history
            group by
                name
                ,file#
                ,incremental_level
        ) unpivot (
            metric_value FOR metric_name IN (
                 "LatestBackupAgeSeconds"
                ,"Backups"
                ,"MarkedCorrupt"
                ,"MediaCorrupt"
                ,"LogicallyCorrupt"
            )
        )
    )
select
    v$metricname.project                        as project
    ,v$metricname.fleet                         as fleet
    ,v$metricname.host                          as host
    ,v$metric.metric_name                       as metric_name
    ,v$metric.metric_value                      as metric_value
    ,'{'||v$metricname.metric_dimensions||v$metric.metric_dimensions||'}' as metric_dimensions
from v$metricname,v$metric
