if [[ $# != 3 ]]; then
 echo "Usage: startDump <database> <user> <password>";
 exit 1;
fi

ROWTAG="'<row>'";
ENDROWTAG="'</row>'";
COLTAG="'<col><![CDATA['";
ENDCOLTAG="']]></col>'";

# Clear any other dat files
echo "Clearing older data files"
rm -f *.dat 

echo "Connnecting to $1 as $2";
db2 -r connect.dat "connect to $1 user $2 using $3";

if [[ $? != 0 ]]; then
 echo "Connection failed.";
 exit 20;
fi

# GET SCHEMA QUERY. 
echo "Get all schemas";
db2 +o -x -r schemas.dat "select SCHEMANAME SCHEMA_NAME from SYSCAT.SCHEMATA WHERE DEFINER <> 'SYSIBM' AND 
        SCHEMANAME <> 'NULLID' AND SCHEMANAME <> 'SQLJ' 
        AND SCHEMANAME <> 'SYSTOOLS'";
if [[ $? != 0 ]]; then
 echo "Get schemas failed.";
 exit 30;
fi

# Loop through file containing schema names and extract db objects for each of them
while read SCHEMA_NAME
do
# Create schema directory
     rm -rf "${SCHEMA_NAME}";
     mkdir "${SCHEMA_NAME}";
     if [[ $? != 0 ]]; then
       echo "Could not create schema directory ${SCHEMA_NAME}.";
       exit 40;
     fi

echo "Get all tables for schema $SCHEMA_NAME";
tablesFile="${SCHEMA_NAME}/""tables.dat";
# GET TABLES QUERY. */
db2 -x +o -r $tablesFile "select "$ROWTAG", "$COLTAG"||COLUMNS.TABSCHEMA||"$ENDCOLTAG", "$COLTAG"||COLUMNS.TABNAME||"$ENDCOLTAG",  
"$COLTAG"||COLUMNS.COLNAME||"$ENDCOLTAG", "$COLTAG"||(CASE WHEN (COLUMNS.CODEPAGE = 0 and (COLUMNS.TYPENAME = 'VARCHAR' OR COLUMNS.TYPENAME = 'CHAR' 
OR COLUMNS.TYPENAME = 'LONG VARCHAR' OR  COLUMNS.TYPENAME = 'CHARACTER'))  THEN  COLUMNS.TYPENAME || ' FOR BIT DATA' 
   ELSE COLUMNS.TYPENAME END) || "$ENDCOLTAG", "$COLTAG"||CHAR(COLUMNS.LENGTH)||"$ENDCOLTAG",  
"$COLTAG"||CHAR(COLUMNS.SCALE)||"$ENDCOLTAG", "$COLTAG"||COLUMNS.NULLS||"$ENDCOLTAG", 
"$COLTAG"||COALESCE(COLUMNS.DEFAULT, '')||"$ENDCOLTAG", "$ENDROWTAG" from 
SYSCAT.COLUMNS COLUMNS, SYSCAT.TABLES TABLES WHERE 
COLUMNS.TABSCHEMA = '${SCHEMA_NAME}' AND
COLUMNS.TABNAME = TABLES.TABNAME AND 
COLUMNS.TABSCHEMA = TABLES.TABSCHEMA AND 
TABLES.TYPE = 'T'
ORDER BY COLUMNS.TABNAME, COLUMNS.COLNO"; 

if [[ $? != 0 ]]; then
 echo "No tables found.";
fi

# GET SYNONYMS QUERY. */
echo "Get all synonyms for schema $SCHEMA_NAME";
synonymsFile="${SCHEMA_NAME}/""synonyms.dat";
db2 -x +o -r $synonymsFile "select "$ROWTAG", "$COLTAG"||TABNAME||"$ENDCOLTAG", "$COLTAG"||BASE_TABSCHEMA||"$ENDCOLTAG", 
"$COLTAG"||BASE_TABNAME||"$ENDCOLTAG", "$ENDROWTAG"  from syscat.tables 
where tabschema = '${SCHEMA_NAME}' and type = 'A'";
if [[ $? != 0 ]]; then
 echo "No synonyms found.";
fi


# GET VIEW QUERY. */
echo "Get all views for schema $SCHEMA_NAME";
viewsFile="${SCHEMA_NAME}/""views.dat";

db2 -x +o -r $viewsFile "select "$ROWTAG", "$COLTAG"||VIEWSCHEMA||"$ENDCOLTAG", "$COLTAG"||VIEWNAME||"$ENDCOLTAG", 
"$COLTAG"||COALESCE(TEXT, '')||"$ENDCOLTAG", 
"$COLTAG"||OWNER||"$ENDCOLTAG", "$COLTAG"||READONLY||"$ENDCOLTAG", "$COLTAG"||VALID||"$ENDCOLTAG", "$ENDROWTAG" 
from syscat.views 
WHERE VIEWSCHEMA = '${SCHEMA_NAME}'
ORDER BY VIEWNAME";
if [[ $? != 0 ]]; then
 echo "No views found.";
fi

# GET INDEXES QUERY. */
echo "Get all indexes for schema $SCHEMA_NAME";
indexesFile="${SCHEMA_NAME}/""indexes.dat";

db2 -x +o -r $indexesFile "select "$ROWTAG", "$COLTAG"||X.INDSCHEMA||"$ENDCOLTAG", "$COLTAG"||X.INDNAME||"$ENDCOLTAG", 
"$COLTAG"||X.INDEXTYPE||"$ENDCOLTAG", "$COLTAG"||X.TABSCHEMA||"$ENDCOLTAG", 
"$COLTAG"||X.TABNAME||"$ENDCOLTAG", "$COLTAG"||X.UNIQUERULE||"$ENDCOLTAG",
"$COLTAG"||Y.COLNAME||"$ENDCOLTAG", "$COLTAG"||CHAR(Y.COLSEQ)||"$ENDCOLTAG", "$ENDROWTAG" from 
(select INDNAME , INDSCHEMA, INDEXTYPE, TABNAME, TABSCHEMA, UNIQUERULE from SYSCAT.INDEXES WHERE 
 INDSCHEMA = '${SCHEMA_NAME}' AND UNIQUERULE <> 'P') X 
INNER JOIN
(select INDNAME, INDSCHEMA, COLNAME, COLSEQ from SYSCAT.INDEXCOLUSE WHERE INDSCHEMA = '${SCHEMA_NAME}') Y 
ON
(X.INDNAME = Y.INDNAME AND X.INDSCHEMA = Y.INDSCHEMA) 
ORDER BY X.TABNAME, X.INDNAME, Y.COLSEQ"

# GET TRIGGERS QUERY. */
echo "Get all triggers for schema $SCHEMA_NAME";
triggersFile="${SCHEMA_NAME}/""triggers.dat";

db2 -x +o -r $triggersFile "select "$ROWTAG", "$COLTAG"||TRIGSCHEMA||"$ENDCOLTAG", 
"$COLTAG"||TRIGNAME||"$ENDCOLTAG", "$COLTAG"||OWNER||"$ENDCOLTAG", "$COLTAG"||TABSCHEMA||"$ENDCOLTAG", 
"$COLTAG"||TABNAME||"$ENDCOLTAG", "$COLTAG"||TRIGEVENT||"$ENDCOLTAG", "$COLTAG"||VALID||"$ENDCOLTAG", 
"$COLTAG"||COALESCE(TEXT, '')||"$ENDCOLTAG", 
"$COLTAG"||COALESCE(REMARKS, '')||"$ENDCOLTAG", "$ENDROWTAG" 
from SYSCAT.TRIGGERS
WHERE TRIGSCHEMA = '${SCHEMA_NAME}'";
if [[ $? != 0 ]]; then
 echo "No triggers found.";
fi

# The for GET  Promary Key CONSTRAINT QUERY. */
echo "Get all primary keys for schema $SCHEMA_NAME";
primarykeysFile="${SCHEMA_NAME}/""primarykeys.dat";

db2 -x +o -r $primarykeysFile "select "$ROWTAG", "$COLTAG"||X.CONSTNAME||"$ENDCOLTAG", "$COLTAG"||X.TYPE||"$ENDCOLTAG", 
"$COLTAG"||X.TABSCHEMA||"$ENDCOLTAG", "$COLTAG"||X.TABNAME||"$ENDCOLTAG", "$COLTAG"||Z.COLNAME||"$ENDCOLTAG", 
"$COLTAG"||CHAR(Z.COLSEQ)||"$ENDCOLTAG", "$COLTAG"||COALESCE(X.REMARKS, '')||"$ENDCOLTAG", "$ENDROWTAG" from 
    (select CONSTNAME, TYPE, TABSCHEMA, TABNAME, REMARKS from SYSCAT.TABCONST where (type = 'P' OR type = 'U')) X 
    FULL OUTER JOIN 
    (select COLNAME,  COLSEQ, CONSTNAME, TABSCHEMA, TABNAME from SYSCAT.KEYCOLUSE) Z 
    on  
    (X.CONSTNAME = Z.CONSTNAME and X.TABSCHEMA = Z.TABSCHEMA and X.TABNAME = Z.TABNAME)
    WHERE X.TABSCHEMA='${SCHEMA_NAME}'
    ORDER BY X.CONSTNAME";

if [[ $? != 0 ]]; then
 echo "No primary keys found.";
fi

# The for GET  Check constraints QUERY. */
echo "Get all Check constraints for schema $SCHEMA_NAME";
constraintsFile="${SCHEMA_NAME}/""checkConstraints.dat";

db2 -x +o -r $constraintsFile "SELECT "$ROWTAG", "$COLTAG"||A.CONSTNAME||"$ENDCOLTAG", "$COLTAG"|| COALESCE(TEXT, '') ||"$ENDCOLTAG", "$COLTAG"|| A.TABSCHEMA||"$ENDCOLTAG", "$COLTAG"|| A.TABNAME ||"$ENDCOLTAG", "$COLTAG"|| COLNAME ||"$ENDCOLTAG", "$ENDROWTAG"   FROM SYSCAT.CHECKS A , SYSCAT.COLCHECKS B
  WHERE A.CONSTNAME = B.CONSTNAME AND A.TABSCHEMA = B.TABSCHEMA AND A.TABNAME=B.TABNAME AND A.TABSCHEMA = '${SCHEMA_NAME}'";

if [[ $? != 0 ]]; then
 echo "No check constraints found.";
fi

  done < "schemas.dat"



# GET PROCEDURES QUERY. */
. getProcedures.sh schemas.dat

# The for GET Foreign Key CONSTRAINT QUERY. */
. getForeignKeys.sh schemas.dat
