<?xml version="1.0"?>
<!-- 
NAME
    kudvruls.xsl
DESCRIPTION
    XSLT stylesheet for XML => DDL 
    conversion of ku$_dv_rule_set_t UDTs
    corresponding to Database Vault Rule Sets created using CREATE_RULE_SET
NOTES
    Do NOT modify this file under any circumstance. Copy the file
    if you wish to use this stylesheet with an external XML/XSL parser

MODIFIED        MM/DD/YY
    pknaggs     07/09/08 - Fix comment.
    pknaggs     04/15/08 - bug 6938028: Database Vault Protected Schema.
    pknaggs     04/15/08 - Created
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Import the kucommon.xsl script, otherwise this template will never get invoked. See line 43 in kucommon.xsl, where the comment is "Top level template for all objects", this is the xsl equivalent of 'main'.  -->
 <xsl:import href="kucommon.xsl"/>
 <!-- Top-level parameters -->
 <!-- Parameters for DDL generation -->
 <xsl:param name="PRETTY">1</xsl:param>
 <xsl:param name="SQLTERMINATOR">0</xsl:param>
 <!-- Parameters required for DoParse to function correctly. -->
 <xsl:param name="PRS_DDL">0</xsl:param>
 <xsl:param name="PRS_DELIM">\{]`</xsl:param> 
 <xsl:param name="PRS_VERB">0</xsl:param>
 <xsl:param name="PRS_OBJECT_TYPE">0</xsl:param>
 <xsl:param name="PRS_SCHEMA">0</xsl:param>
 <xsl:param name="PRS_NAME">0</xsl:param>
 <xsl:param name="PRS_GRANTEE">0</xsl:param>
 <xsl:param name="PRS_GRANTOR">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_SCHEMA">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_NAME">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_TYPE">0</xsl:param>
 <!-- Template to create a new Database Vault Rule Set -->
 <xsl:template match="DVPS_RULE_SET_T">
  <xsl:call-template name="DoParse">
   <xsl:with-param name="Verb">DBMS_MACADM</xsl:with-param>
   <xsl:with-param name="ObjectType">DVPS_RULE_SET</xsl:with-param>
  </xsl:call-template>      
  <xsl:text>BEGIN DVSYS.DBMS_MACADM.CREATE_RULE_SET(rule_set_name => </xsl:text>
  <xsl:call-template name="EscapeString">
   <xsl:with-param name="OrigStr" select="RULE_SET_NAME"/>
   <xsl:with-param name="Leading">'</xsl:with-param>
   <xsl:with-param name="Trailing">'</xsl:with-param>
  </xsl:call-template>
  <xsl:text>, description => </xsl:text>
  <xsl:call-template name="EscapeString">
   <xsl:with-param name="OrigStr" select="DESCRIPTION"/>
   <xsl:with-param name="Leading">'</xsl:with-param>
   <xsl:with-param name="Trailing">'</xsl:with-param>
   <xsl:with-param name="NullVal">NULL</xsl:with-param>
  </xsl:call-template>
  <xsl:text>, enabled => </xsl:text>
  <xsl:call-template name="EscapeString">
   <xsl:with-param name="OrigStr" select="ENABLED"/>
   <xsl:with-param name="Leading">'</xsl:with-param>
   <xsl:with-param name="Trailing">'</xsl:with-param>
   <xsl:with-param name="NullVal">NULL</xsl:with-param>
  </xsl:call-template>
  <xsl:text>, eval_options => </xsl:text>
  <xsl:choose>
   <xsl:when test="EVAL_OPTIONS">
    <xsl:value-of select="EVAL_OPTIONS"/>
   </xsl:when>
   <xsl:otherwise>
    <xsl:text>NULL</xsl:text>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:text>, audit_options => </xsl:text>
  <xsl:choose>
   <xsl:when test="AUDIT_OPTIONS">
    <xsl:value-of select="AUDIT_OPTIONS"/>
   </xsl:when>
   <xsl:otherwise>
    <xsl:text>NULL</xsl:text>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:text>, fail_options => </xsl:text>
  <xsl:choose>
   <xsl:when test="FAIL_OPTIONS">
    <xsl:value-of select="FAIL_OPTIONS"/>
   </xsl:when>
   <xsl:otherwise>
    <xsl:text>NULL</xsl:text>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:text>, fail_message => </xsl:text>
  <xsl:call-template name="EscapeString">
   <xsl:with-param name="OrigStr" select="FAIL_MESSAGE"/>
   <xsl:with-param name="Leading">'</xsl:with-param>
   <xsl:with-param name="Trailing">'</xsl:with-param>
   <xsl:with-param name="NullVal">NULL</xsl:with-param>
  </xsl:call-template>
  <xsl:text>, fail_code => </xsl:text>
  <xsl:choose>
   <xsl:when test="FAIL_CODE">
    <xsl:value-of select="FAIL_CODE"/>
   </xsl:when>
   <xsl:otherwise>
    <xsl:text>NULL</xsl:text>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:text>, handler_options => </xsl:text>
  <xsl:choose>
   <xsl:when test="HANDLER_OPTIONS">
    <xsl:value-of select="HANDLER_OPTIONS"/>
   </xsl:when>
   <xsl:otherwise>
    <xsl:text>NULL</xsl:text>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:text>, handler => </xsl:text>
  <xsl:call-template name="EscapeString">
   <xsl:with-param name="OrigStr" select="HANDLER"/>
   <xsl:with-param name="Leading">'</xsl:with-param>
   <xsl:with-param name="Trailing">'</xsl:with-param>
   <xsl:with-param name="NullVal">NULL</xsl:with-param>
  </xsl:call-template>
  <xsl:text>); END;</xsl:text>
  <!-- Terminate inner SQL statement -->
  <xsl:call-template name="DoTerminator">
   <xsl:with-param name="Text"/>
  </xsl:call-template>
 </xsl:template>
</xsl:stylesheet>
