<?xml version="1.0"?>
<!-- 
NAME
    kuaudobj.xsl
DESCRIPTION
    XSLT stylesheet for XML => DDL conversion of ku$_obj_audit_t ADTs
NOTES
    Do NOT modify this file under any circumstance. Copy the file
    if you wish to use this stylesheet with an external XML/XSL parser

MODIFIED	MM/DD/YY
    smashimo    11/19/07 - Bug 6487005: need ON DIRECTORY clause if
                           BaseObjectType=DIRECTORY
    lbarton	11/02/05 - Bug 4715313: reformat files for use with XMLSpy 
    htseng	08/02/02 - add grantee parse param
    htseng	07/25/02 - add BaseSchemaName, BaseNodeName
    htseng	09/19/01 - Merged htseng_add_xsl_stylesheets
    htseng	06/29/01 - Creation 
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Import required scripts -->
 <xsl:import href="kucommon.xsl"/>
 <!-- Top-level parameters -->
 <xsl:param name="PRETTY">1</xsl:param>
 <xsl:param name="SQLTERMINATOR">1</xsl:param>
 <xsl:variable name="NEED_COMMA" select="1"/>
 <!-- params for parse -->
 <xsl:param name="PRS_DDL">0</xsl:param>
 <xsl:param name="PRS_DELIM">\{]`</xsl:param>
 <xsl:param name="PRS_VERB">0</xsl:param>
 <xsl:param name="PRS_OBJECT_TYPE">0</xsl:param>
 <xsl:param name="PRS_SCHEMA">0</xsl:param>
 <xsl:param name="PRS_NAME">0</xsl:param>
 <xsl:param name="PRS_GRANTEE">0</xsl:param>
 <xsl:param name="PRS_GRANTOR">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_SCHEMA">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_NAME">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_TYPE">0</xsl:param>
 <xsl:template match="AUDITOBJ_T">
  <xsl:apply-templates select="AUDIT_LIST">
   <xsl:with-param name="AudType">S</xsl:with-param>
   <xsl:with-param name="AudValue">S</xsl:with-param>
  </xsl:apply-templates>
  <xsl:apply-templates select="AUDIT_LIST">
   <xsl:with-param name="AudType">S</xsl:with-param>
   <xsl:with-param name="AudValue">A</xsl:with-param>
  </xsl:apply-templates>
  <xsl:apply-templates select="AUDIT_LIST">
   <xsl:with-param name="AudType">F</xsl:with-param>
   <xsl:with-param name="AudValue">S</xsl:with-param>
  </xsl:apply-templates>
  <xsl:apply-templates select="AUDIT_LIST">
   <xsl:with-param name="AudType">F</xsl:with-param>
   <xsl:with-param name="AudValue">A</xsl:with-param>
  </xsl:apply-templates>
 </xsl:template>
 <xsl:template match="AUDIT_LIST">
  <xsl:param name="AudType"/>
  <xsl:param name="AudValue"/>
  <xsl:for-each select="AUDIT_LIST_ITEM[TYPE=$AudType and 
					VALUE=$AudValue]">
   <xsl:if test="position()=1">
    <xsl:call-template name="DoParse">
     <xsl:with-param name="Verb">AUDIT</xsl:with-param>
     <xsl:with-param name="ObjectType">AUDIT_OBJ</xsl:with-param>
     <xsl:with-param name="BaseSchemaNode" select="../../BASE_OBJ/OWNER_NAME"/>
     <xsl:with-param name="BaseNameNode" select="../../BASE_OBJ/NAME"/>
     <xsl:with-param name="BaseObjectType" select="../../BASE_OBJ/TYPE"/>
    </xsl:call-template>
    <xsl:text> AUDIT </xsl:text>
   </xsl:if>
   <xsl:value-of select="NAME"/>
   <xsl:if test="not(position()=last())">
    <xsl:text>, </xsl:text>
   </xsl:if>
   <xsl:if test="(position()=last())">
    <xsl:text> ON </xsl:text>
    <xsl:if test="../../BASE_OBJ/TYPE_NAME='DIRECTORY'">
     <xsl:text>DIRECTORY </xsl:text>
    </xsl:if>
    <xsl:apply-templates select="../../BASE_OBJ"/>
    <xsl:if test="$AudType='S' and $AudValue='S'">
     <xsl:text>BY SESSION WHENEVER SUCCESSFUL</xsl:text>
    </xsl:if>
    <xsl:if test="$AudType='F' and $AudValue='S'">
     <xsl:text>BY SESSION WHENEVER NOT SUCCESSFUL</xsl:text>
    </xsl:if>
    <xsl:if test="$AudType='S' and $AudValue='A'">
     <xsl:text>BY ACCESS WHENEVER SUCCESSFUL</xsl:text>
    </xsl:if>
    <xsl:if test="$AudType='F' and $AudValue='A'">
     <xsl:text>BY ACCESS WHENEVER NOT SUCCESSFUL</xsl:text>
    </xsl:if>
    <xsl:if test="$SQLTERMINATOR=1">
     <xsl:text>;</xsl:text>
    </xsl:if>
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa;  </xsl:text>
    </xsl:if>
   </xsl:if>
  </xsl:for-each>
 </xsl:template>
</xsl:stylesheet>
