/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.hadoop.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.sql.Connection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.spinBox.NumericSpinBox;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.common.ddl.DDLTypes;
import oracle.dbtools.data.model.Column;
import oracle.dbtools.data.model.GenericTable;
import oracle.dbtools.datatools.BaseDataFormat;
import oracle.dbtools.extract.models.ExtractListModel;
import oracle.dbtools.extract.models.ExtractObject;
import oracle.dbtools.importer.core.ImportKeys;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.backgroundTask.ui.GlassPaneTaskViewer;
import oracle.dbtools.raptor.backgroundTask.utils.DatabaseQueryTask;
import oracle.dbtools.raptor.controls.OracleConnectionComboBox;
import oracle.dbtools.raptor.controls.search.SearchPanel;
import oracle.dbtools.raptor.hadoop.core.HadoopGenericTable;
import oracle.dbtools.raptor.hadoop.core.HadoopImportDataFormat;
import oracle.dbtools.raptor.hadoop.core.HadoopKeys;
import oracle.dbtools.raptor.hadoop.core.HadoopProperties;
import oracle.dbtools.raptor.hadoop.core.HadoopStrings;
import oracle.dbtools.raptor.hadoop.core.HadoopUtils;
import oracle.dbtools.raptor.hadoop.core.OLHImportDataFormat;
import oracle.dbtools.raptor.hadoop.ui.BDACopyByTypeSearchPanel;
import oracle.dbtools.raptor.hadoop.ui.HadoopIGeneralPage;
import oracle.dbtools.raptor.hadoop.ui.HadoopUIUtils;
import oracle.dbtools.raptor.hadoop.ui.HadoopWizArb;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.ssh.core.Client;
import oracle.dbtools.raptor.ssh.core.HostConnection;
import oracle.dbtools.raptor.ssh.core.Store;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.raptor.ui.dialogs.MessageDetailsDialog;
import oracle.dbtools.raptor.ui.panels.SearchObjectsSelectionPanel;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.transfer.location.SshLocation;
import oracle.dbtools.transfer.location.SshSessionLocation;
import oracle.dbtools.transfer.utility.ScriptOutput;
import oracle.dbtools.util.Logger;
import oracle.ide.Ide;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.db.DBException;
import oracle.javatools.dialogs.MessageDialog;
import org.apache.sshd.client.session.ClientSession;

public class BDACopySingleGeneralPage
extends DefaultTraversablePanel {
    private static final long serialVersionUID = 1L;
    private static final String ROOT_DIR = "/user/<ssh_user>/oracle_warehouse";
    private static final String BIG_DATA_CL = "ORA_BIGDATA_CL_";
    private static final String BIG_DATA_CONFIG = "ORACLE_BIGDATA_CONFIG";
    private static final String NEW_LINE = "\n";
    private static final String ENV = "#!/bin/bash\n";
    private static final String DIRECT_ENV_FILE = ".sqldev_cp2hadoop_env";
    private static final String HADOOP_HOME = "export PATH=$HADOOP_HOME/bin:${PATH}";
    private static final TitledBorder DIRECT_BORDER = BorderFactory.createTitledBorder(HadoopWizArb.getString("SSH_CONN"));
    private static final TitledBorder STAGING_BORDER = BorderFactory.createTitledBorder(HadoopWizArb.getString("SSH_CONN_BDA"));
    private JPanel _sourcePanel;
    private JPanel _sourceMainPanel;
    private JPanel _sshPanel;
    private ActionListener _sConnListener;
    private JTextPane _instructions;
    protected JLabel _copyMethodLabel;
    protected JComboBox<String> _copyMethodCmp;
    protected JLabel _sDirLabel;
    protected JComboBox<String> _sDirCmp;
    protected JLabel _sClusterLabel;
    protected JComboBox<String> _sClusterCmp;
    protected JLabel _dSchemaLabel = new JLabel(StringUtils.stripMnemonic((String)HadoopWizArb.getString("SCHEMA")));
    protected JLabel _dXTabLabel;
    protected JTextField _dXTabCmp;
    protected JLabel _dDestDataFormatLabel;
    protected JComboBox<String> _dDestDataFormatCmp;
    protected JLabel _dHostLabel;
    protected JComboBox<String> _dHostCmp;
    protected JLabel _sTableInfoLabel;
    protected JTextField _sTableInfoCmp;
    protected JLabel _dRootLabel;
    protected JTextField _dRootCmp;
    protected JLabel _parallelLabel;
    protected NumericSpinBox _parallelCmp = new NumericSpinBox(1, Integer.MAX_VALUE);
    protected JCheckBox _useInBDS;
    protected JLabel _bdsXTabLabel;
    protected JTextField _bdsXTabCmp;
    private JEWTDialog _statusDialog;
    private String _hostName;
    protected HadoopProperties _hProps;
    protected JLabel _sConnLabel;
    protected OracleConnectionComboBox _sourceConnSelector = new OracleConnectionComboBox();
    protected JLabel _sObjectLabel = new JLabel(StringUtils.stripMnemonic((String)HadoopWizArb.getString("DB_OBJECT")));
    protected JPanel _sObjectPanel = new JPanel(new BorderLayout());
    protected JTextField _sObjectTFCmp = new JTextField();
    protected JLabel _sObjectLCmp = new JLabel();
    protected JButton _sFindCmp;
    private JEWTDialog _subActionDialog;
    private JPanel _searchPanel;
    protected SearchObjectsSelectionPanel _searchSelectionPanel;
    protected URL _selectedUrl;
    protected boolean _isExistingTable;
    private boolean init = false;
    private boolean _isErrorFormat = false;
    private boolean _isHostValid = false;
    private boolean _isCleanupDeployNeeded = false;
    private boolean _isConnSelected = false;
    private boolean _isStagingMethod = false;
    private boolean _isOraDirModel = false;
    private String _sourceEnv;
    private String _envFile;
    private String _rootPath;
    private String _lastRootPath;
    private String _destDir;
    private String _lastDestDir;
    private String _testDir;
    private String _cluster;
    private String _lastCluster;
    private String _lastHost;
    private String _tempDir;
    private String _tempName;
    private String _scriptEnv;
    private String _scriptRootPath;
    private String _scriptDestDir;
    private String _scriptTestDir;
    private String _connName;
    private String _schema;
    private String _origin;
    private String _bigDataConfigDir;
    private HashMap<String, String> _bigDataDirs;
    private DBObject _selectedDbo;
    private DBObject _hiveDbo;
    private HadoopGenericTable _hiveTable;
    private SshLocation _sessLoc;
    private ClientSession _clientSession;
    private DatabaseQueryTask<Boolean> _task = null;
    Component _defaultGlassPane;
    private String _taskMsgDetails;
    private String _taskMsg;
    private GlassPaneTaskViewer _glassPaneTaskViewer;
    private boolean _back = false;
    private boolean _next = false;
    private boolean _finish = false;
    protected TraversableContext _dataContext;

    private void connectionError(JComboBox jComboBox, String string, String string2) {
        this._connName = "";
        this._isConnSelected = false;
        this.enableSourceComponents(false);
        this._selectedDbo = null;
        this._selectedUrl = null;
        if (!this._isExistingTable) {
            this._bdsXTabCmp.setText("");
            this._dXTabCmp.setText("");
        }
        if (this._searchSelectionPanel != null) {
            this.resetConnection();
        }
        this._bigDataConfigDir = null;
        this._bigDataDirs = new HashMap();
        this._sClusterCmp.removeAllItems();
        this.wizardEnableButtons(true, false, false);
        MessageDetailsDialog messageDetailsDialog = new MessageDetailsDialog();
        messageDetailsDialog.showErrorDialog(string, string2);
        this._sDirCmp.setSelectedIndex(-1);
        jComboBox.setSelectedIndex(-1);
    }

    public void onEntry(TraversableContext traversableContext) {
        this._dataContext = traversableContext;
        this._hProps = (HadoopProperties)((Object)traversableContext.get("HADOOP_PROPERTIES"));
        this._isExistingTable = (Boolean)this._hProps.get(ImportKeys.IS_EXISTING_TABLE);
        this._tempName = HadoopUtils.getTempName("sqldev_c2h");
        if (!this.init) {
            if (this._isExistingTable) {
                this._hiveDbo = (DBObject)this._hProps.get(ImportKeys.DBOBJECT);
                this._hiveTable = (HadoopGenericTable)((Object)this._hProps.get(HadoopKeys.DEST_GENERIC_TABLE));
            }
            this.build();
            this.wizardEnableButtons(true, false, false);
            this.init = true;
        }
    }

    private void build() {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this.init();
        jPanel.add((Component)this.getSourcePanel(), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 23, 2, new Insets(6, 0, 0, 0), 0, 0));
        JPanel jPanel2 = new JPanel();
        jPanel.add((Component)jPanel2, new GridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 20, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel2.setBorder(BorderFactory.createEmptyBorder());
        this.add(jPanel, "Center");
    }

    protected void init() {
        this._sourceConnSelector.getJComboBox().setToolTipText(HadoopWizArb.getString("BDA_SCONN_TOOLTIP"));
        this._sourceConnSelector.getJComboBox().addItemListener(new Connector(this._sourceConnSelector));
        this._sourceConnSelector.getJComboBox().setSelectedIndex(-1);
        this._sObjectLabel = new JLabel(StringUtils.stripMnemonic((String)HadoopWizArb.getString("DB_OBJECT")));
        this._sObjectLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)HadoopWizArb.getString("DB_OBJECT")));
        this._sFindCmp = new JButton(HadoopWizArb.getString("FIND"));
        ResourceUtils.resButton((AbstractButton)this._sFindCmp, (String)HadoopWizArb.getString("FIND"));
        this._sObjectTFCmp = new JTextField();
        this._sObjectTFCmp.setEnabled(false);
        this._sObjectTFCmp.setToolTipText(HadoopWizArb.getString("DB_OBJECT_TIP"));
        this._sObjectLabel.setLabelFor(this._sObjectTFCmp);
        this._sFindCmp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BDACopySingleGeneralPage.this.openSearchPanel();
            }
        });
        this._sFindCmp.setEnabled(false);
        this.initInstructions();
        this.initCopyMethod();
        this.initConn();
        this.initOraDir();
        this.initCluster();
        this.initParallel();
        this.initDestRootLabel();
        this.initDestRootPanel();
        this.initHost();
        this.initDestXTab();
        this.initSourceTableInfo();
        this.initDestDataFormat();
        this.initUseBDS();
        this.enableSourceComponents(false);
    }

    private void initInstructions() {
        this._instructions = new JTextPane();
        this._instructions.setEditable(false);
        this._instructions.setOpaque(false);
        this._instructions.setRequestFocusEnabled(false);
        this._instructions.setFocusable(false);
        if (this._isExistingTable) {
            this._instructions.setText(HadoopWizArb.getString("COPY_BDA_GEN_INSTRUCTIONS_DIRECT_EXIST"));
        } else {
            this._instructions.setText(HadoopWizArb.getString("COPY_BDA_GEN_INSTRUCTIONS_DIRECT_NEW"));
        }
    }

    private void initCopyMethod() {
        if (this._copyMethodLabel == null) {
            this._copyMethodLabel = new JLabel(StringUtils.stripMnemonic((String)HadoopWizArb.getString("COPY_METHOD")));
            this._copyMethodLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)HadoopWizArb.getString("COPY_METHOD")));
            this._copyMethodCmp = new JComboBox();
            this._copyMethodLabel.setLabelFor(this._copyMethodCmp);
            this._copyMethodCmp.setToolTipText(HadoopWizArb.getString("COPY_METHOD_TIP"));
            this._copyMethodLabel.setToolTipText(HadoopWizArb.getString("COPY_METHOD_TIP"));
            this._copyMethodCmp.addItem(HadoopWizArb.getString("COPY_METHOD_DIRECT"));
            this._copyMethodCmp.addItem(HadoopWizArb.getString("COPY_METHOD_STAGED"));
            this._copyMethodCmp.setSelectedIndex(0);
            this._copyMethodCmp.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    BDACopySingleGeneralPage.this._isStagingMethod = BDACopySingleGeneralPage.this._copyMethodCmp.getSelectedIndex() != 0;
                    BDACopySingleGeneralPage.this._sDirLabel.setEnabled(BDACopySingleGeneralPage.this._isConnSelected && BDACopySingleGeneralPage.this._isStagingMethod);
                    BDACopySingleGeneralPage.this._sDirCmp.setEnabled(BDACopySingleGeneralPage.this._isConnSelected && BDACopySingleGeneralPage.this._isStagingMethod);
                    if (BDACopySingleGeneralPage.this._isStagingMethod) {
                        if (BDACopySingleGeneralPage.this._isConnSelected && !BDACopySingleGeneralPage.this._isOraDirModel) {
                            HadoopUIUtils.setOraDirModel(BDACopySingleGeneralPage.this._sDirCmp, BDACopySingleGeneralPage.this._connName, false);
                            BDACopySingleGeneralPage.this._isOraDirModel = true;
                        }
                        BDACopySingleGeneralPage.this._instructions.setText(BDACopySingleGeneralPage.this._isExistingTable ? HadoopWizArb.getString("COPY_BDA_GEN_INSTRUCTIONS_STAGE_EXIST") : HadoopWizArb.getString("COPY_BDA_GEN_INSTRUCTIONS_STAGE_NEW"));
                        BDACopySingleGeneralPage.this._dHostCmp.setToolTipText(HadoopWizArb.getString("SSH_CONN_BDA_TOOLTIP"));
                        BDACopySingleGeneralPage.this._dHostLabel.setToolTipText(HadoopWizArb.getString("SSH_CONN_BDA_TOOLTIP"));
                        BDACopySingleGeneralPage.this._sshPanel.setBorder(STAGING_BORDER);
                    } else {
                        BDACopySingleGeneralPage.this._instructions.setText(BDACopySingleGeneralPage.this._isExistingTable ? HadoopWizArb.getString("COPY_BDA_GEN_INSTRUCTIONS_DIRECT_EXIST") : HadoopWizArb.getString("COPY_BDA_GEN_INSTRUCTIONS_DIRECT_NEW"));
                        BDACopySingleGeneralPage.this._dHostCmp.setToolTipText(HadoopWizArb.getString("SSH_CONN_TOOLTIP"));
                        BDACopySingleGeneralPage.this._dHostLabel.setToolTipText(HadoopWizArb.getString("SSH_CONN_TOOLTIP"));
                        BDACopySingleGeneralPage.this._sshPanel.setBorder(DIRECT_BORDER);
                        if (BDACopySingleGeneralPage.this._selectedDbo != null && BDACopySingleGeneralPage.this._selectedDbo.getObjectType().equals("VIEW") && BDACopySingleGeneralPage.this._searchSelectionPanel != null) {
                            BDACopySingleGeneralPage.this.resetConnection();
                        }
                    }
                }
            });
        }
    }

    private void initOraDir() {
        if (this._sDirLabel == null) {
            this._sDirLabel = new JLabel(StringUtils.stripMnemonic((String)HadoopWizArb.getString("ORA_DIR")));
            this._sDirLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)HadoopWizArb.getString("ORA_DIR")));
            this._sDirLabel.setToolTipText(HadoopWizArb.getString("ORA_DIR_TIP"));
            this._sDirCmp = HadoopUIUtils.getSQLCombo(this._sDirLabel);
            this._sDirCmp.setToolTipText(HadoopWizArb.getString("ORA_DIR_TIP"));
            this._sDirLabel.setLabelFor(this._sDirCmp);
            this._sDirLabel.setEnabled(false);
            this._sDirCmp.setEnabled(false);
        }
    }

    private void initCluster() {
        if (this._sClusterLabel == null) {
            this._sClusterLabel = new JLabel(StringUtils.stripMnemonic((String)HadoopWizArb.getString("CLUSTER")));
            this._sClusterLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)HadoopWizArb.getString("CLUSTER")));
            this._sClusterLabel.setToolTipText(HadoopWizArb.getString("CLUSTER_TIP"));
            this._sClusterCmp = new JComboBox();
            this._sClusterCmp.setToolTipText(HadoopWizArb.getString("CLUSTER_TIP"));
            this._sClusterLabel.setLabelFor(this._sClusterCmp);
        }
    }

    protected void initParallel() {
        this._parallelLabel = new JLabel(StringUtils.stripMnemonic((String)HadoopWizArb.getString("PARALLEL")));
        this._parallelLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)HadoopWizArb.getString("PARALLEL")));
        this._parallelLabel.setLabelFor((Component)this._parallelCmp);
        this._parallelLabel.setToolTipText(HadoopWizArb.getString("BDA_PARALLEL_TIP"));
        this._parallelCmp.setIntValue(4);
        this._parallelCmp.setToolTipText(HadoopWizArb.getString("BDA_PARALLEL_TIP"));
    }

    protected void initSourceTableInfo() {
        if (this._sTableInfoLabel == null) {
            this._sTableInfoLabel = new JLabel(HadoopWizArb.getString("S_TABLE_INFO"));
            this._sTableInfoLabel.setEnabled(false);
            this._sTableInfoCmp = new JTextField();
            this._sTableInfoLabel.setLabelFor(this._sTableInfoCmp);
            this._sTableInfoCmp.setToolTipText(HadoopWizArb.getString("S_TABLE_INFO_TIP"));
            if (this._isExistingTable) {
                this._origin = this._hiveTable.getOrigin();
                this._sTableInfoCmp.setText(this._origin);
            }
            this._sTableInfoCmp.setEditable(false);
        }
    }

    protected void initDestRootLabel() {
        if (this._dRootLabel == null) {
            this._dRootLabel = new JLabel(HadoopWizArb.getString("D_ROOT_DIR"));
            this._dRootLabel.setToolTipText(HadoopWizArb.getString("D_ROOT_DIR_TIP"));
        }
    }

    protected void initDestRootPanel() {
        if (null == this._dRootCmp) {
            this._dRootLabel = new JLabel(this._isExistingTable ? StringUtils.stripMnemonic((String)HadoopWizArb.getString("DIR_LOCATION")) : StringUtils.stripMnemonic((String)HadoopWizArb.getString("ROOT_DIR")));
            this._dRootLabel.setDisplayedMnemonic(this._isExistingTable ? StringUtils.getMnemonicKeyCode((String)HadoopWizArb.getString("DIR_LOCATION")) : StringUtils.getMnemonicKeyCode((String)HadoopWizArb.getString("ROOT_DIR")));
            this._dRootCmp = new JTextField();
            this._dRootLabel.setLabelFor(this._dRootCmp);
            if (this._isExistingTable) {
                if (this._hiveTable.isDataPump()) {
                    this._dRootCmp.setToolTipText(HadoopWizArb.getString("D_ROOT_DIR_TIP"));
                    this._dRootCmp.setText(this._hiveTable.getLocation());
                    this._dRootCmp.setEditable(false);
                } else {
                    this._dRootCmp.setToolTipText(HadoopWizArb.getString("D_ROOT_DIR_TIP"));
                    this._dRootCmp.setText(ROOT_DIR);
                }
            } else {
                this._dRootCmp.setText(ROOT_DIR);
                this._dRootCmp.setToolTipText(HadoopWizArb.getString("D_ROOT_DIR_TIP"));
            }
        }
    }

    private void initHost() {
        if (this._dHostLabel == null) {
            this._dHostLabel = new JLabel(StringUtils.stripMnemonic((String)HadoopWizArb.getString("HOST")));
            this._dHostLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)HadoopWizArb.getString("HOST")));
            Store store = Client.getInstance().getStore();
            Collection collection = store.listHosts();
            this._dHostCmp = new JComboBox();
            this._dHostLabel.setLabelFor(this._dHostCmp);
            this._dHostCmp.setToolTipText(HadoopWizArb.getString("SSH_CONN_TOOLTIP"));
            this._dHostLabel.setToolTipText(HadoopWizArb.getString("SSH_CONN_TOOLTIP"));
            for (String string : collection) {
                this._dHostCmp.addItem(string);
            }
            this._dHostCmp.setSelectedIndex(-1);
            this._dHostCmp.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    BDACopySingleGeneralPage.this._hostName = (String)BDACopySingleGeneralPage.this._dHostCmp.getSelectedItem();
                    if (BDACopySingleGeneralPage.this._hostName != null && !BDACopySingleGeneralPage.this._hostName.isEmpty()) {
                        BDACopySingleGeneralPage.this._isHostValid = false;
                        BDACopySingleGeneralPage.this.tryEnableNext(false);
                        final HadoopUtils.SshTask sshTask = HadoopUtils.getOpenSshConnectionTask(HadoopUtils.setSshHostProperties(BDACopySingleGeneralPage.this._hProps, BDACopySingleGeneralPage.this._hostName));
                        if (BDACopySingleGeneralPage.this._hostName != null && !BDACopySingleGeneralPage.this._hostName.isEmpty()) {
                            sshTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

                                public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                                    try {
                                        HostConnection hostConnection = (HostConnection)sshTask.getResult();
                                        if (hostConnection != null) {
                                            BDACopySingleGeneralPage.this._clientSession = hostConnection.getSession();
                                            if (BDACopySingleGeneralPage.this._clientSession != null && HadoopUIUtils.isHostScriptExcutable(BDACopySingleGeneralPage.this._clientSession)) {
                                                BDACopySingleGeneralPage.this._isHostValid = true;
                                                BDACopySingleGeneralPage.this.restoreWizardEnableButtons();
                                                BDACopySingleGeneralPage.this._hProps.put(HadoopKeys.SSH_SESSION, BDACopySingleGeneralPage.this._clientSession);
                                                HadoopUtils.getSSHSessionLocation(BDACopySingleGeneralPage.this._hProps);
                                            }
                                        }
                                    }
                                    catch (Exception exception) {
                                        Logger.severe(HadoopUtils.class, (String)HadoopWizArb.getString("SSH_ERROR1"), (Throwable)exception);
                                        ExceptionHandler.handleException((Throwable)exception);
                                    }
                                    this.setRootCmp();
                                }

                                public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
                                    this.cleanSsh();
                                    this.setRootCmp();
                                }

                                public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
                                    Throwable throwable = raptorTaskEvent.getThrowable();
                                    Logger.severe(HadoopIGeneralPage.class, (String)HadoopWizArb.getString("SSH_ERROR1"), (Throwable)throwable);
                                    ExceptionHandler.handleException((Throwable)throwable);
                                    this.cleanSsh();
                                    this.setRootCmp();
                                }

                                private void cleanSsh() {
                                    BDACopySingleGeneralPage.this._hProps.put(HadoopKeys.SSH_SESSION, null);
                                    BDACopySingleGeneralPage.this._hProps.put(HadoopKeys.SSH_HOST, null);
                                    BDACopySingleGeneralPage.this._hProps.put(HadoopKeys.SSH_USER, null);
                                    BDACopySingleGeneralPage.this._dHostCmp.setSelectedIndex(-1);
                                }

                                private void setRootCmp() {
                                    if (!BDACopySingleGeneralPage.this._isExistingTable || !BDACopySingleGeneralPage.this._hiveTable.isDataPump()) {
                                        if (BDACopySingleGeneralPage.this._isHostValid) {
                                            BDACopySingleGeneralPage.this._dRootCmp.setText("/user/" + BDACopySingleGeneralPage.this._hProps.get(HadoopKeys.SSH_USER) + "/oracle_warehouse");
                                        } else {
                                            BDACopySingleGeneralPage.this._dRootCmp.setText(BDACopySingleGeneralPage.ROOT_DIR);
                                        }
                                    }
                                }
                            });
                            RaptorTaskManager.getInstance().addTask((RaptorTask)sshTask);
                        }
                    }
                }
            });
        }
    }

    public String getRootDir() {
        return this._dRootCmp.getText();
    }

    private void initDestXTab() {
        if (this._dXTabLabel == null) {
            this._dXTabLabel = new JLabel(StringUtils.stripMnemonic((String)HadoopWizArb.getString("XTAB")));
            this._dXTabLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)HadoopWizArb.getString("XTAB")));
            this._dXTabCmp = new JTextField();
            this._dXTabLabel.setLabelFor(this._dXTabCmp);
            this._dXTabCmp.setToolTipText(HadoopWizArb.getString("XTAB_NEW_TOOLTIP"));
            if (this._isExistingTable) {
                this._dXTabCmp.setToolTipText(HadoopWizArb.getString("XTAB_EXIST_TOOLTIP"));
                this._dXTabCmp.setText(this._hiveDbo.getObjectName());
                this._dXTabCmp.setEditable(false);
            }
        }
    }

    private void initDestDataFormat() {
        if (this._dDestDataFormatLabel == null) {
            this._dDestDataFormatLabel = new JLabel(StringUtils.stripMnemonic((String)HadoopWizArb.getString("BDA_DATA_FORMAT")));
            this._dDestDataFormatLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)HadoopWizArb.getString("BDA_DATA_FORMAT")));
            this._dDestDataFormatCmp = new JComboBox();
            this._dDestDataFormatLabel.setLabelFor(this._dDestDataFormatCmp);
            this._dDestDataFormatCmp.setToolTipText(HadoopWizArb.getString("BDA_DATA_FORMAT_TOOLTIP"));
            this._dDestDataFormatLabel.setToolTipText(HadoopWizArb.getString("BDA_DATA_FORMAT_TOOLTIP"));
            if (this._isExistingTable) {
                if (this._hiveTable.isDataPump()) {
                    this._dDestDataFormatCmp.addItem(HadoopStrings.DATA_PUMP);
                } else if (this._hiveTable.isText()) {
                    this._dDestDataFormatCmp.addItem(HadoopStrings.TEXT);
                } else if (this._hiveTable.isParquet()) {
                    this._dDestDataFormatCmp.addItem(HadoopStrings.PARQUET);
                } else if (this._hiveTable.isOrc()) {
                    this._dDestDataFormatCmp.addItem(HadoopStrings.ORC);
                } else {
                    this._isErrorFormat = true;
                }
                this._dDestDataFormatCmp.setEditable(false);
            } else {
                this._dDestDataFormatCmp.addItem(HadoopStrings.DATA_PUMP);
                this._dDestDataFormatCmp.addItem(HadoopStrings.TEXT);
                this._dDestDataFormatCmp.addItem(HadoopStrings.PARQUET);
                this._dDestDataFormatCmp.addItem(HadoopStrings.ORC);
            }
            if (!this._isErrorFormat) {
                this._dDestDataFormatCmp.setSelectedIndex(0);
            }
        }
    }

    private void initUseBDS() {
        if (this._bdsXTabLabel == null) {
            this._useInBDS = new JCheckBox(HadoopWizArb.getString("USE_IN_BDA"));
            this._bdsXTabLabel = new JLabel(HadoopWizArb.getString("XTAB"));
            this._bdsXTabLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)HadoopWizArb.getString("XTAB")));
            this._bdsXTabCmp = new JTextField();
            this._bdsXTabLabel.setLabelFor(this._bdsXTabCmp);
            this._useInBDS.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    BDACopySingleGeneralPage.this._bdsXTabLabel.setEnabled(BDACopySingleGeneralPage.this._useInBDS.isSelected());
                    BDACopySingleGeneralPage.this._bdsXTabCmp.setEnabled(BDACopySingleGeneralPage.this._useInBDS.isSelected());
                }
            });
            this._bdsXTabLabel.setEnabled(false);
            this._bdsXTabCmp.setEnabled(false);
            this._useInBDS.setVisible(false);
            this._bdsXTabLabel.setVisible(false);
            this._bdsXTabCmp.setVisible(false);
        }
    }

    protected void initConn() {
        this._sConnLabel = new JLabel(StringUtils.stripMnemonic((String)HadoopWizArb.getString("CONN_LABEL")));
        this._sConnLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)HadoopWizArb.getString("CONN_LABEL")));
        this._sConnLabel.setLabelFor(this._sourceConnSelector.getJComboBox());
        this._sConnLabel.setToolTipText(HadoopWizArb.getString("BDA_SCONN_TOOLTIP"));
        this.addSourceConnListener();
    }

    private void addSourceConnListener() {
        this._sConnListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object;
                BDACopySingleGeneralPage.this._connName = BDACopySingleGeneralPage.this.getSourceConnection();
                BDACopySingleGeneralPage.this._isConnSelected = BDACopySingleGeneralPage.this._connName != null && !BDACopySingleGeneralPage.this._connName.isEmpty();
                BDACopySingleGeneralPage.this._sDirCmp.setSelectedIndex(-1);
                if (BDACopySingleGeneralPage.this._isStagingMethod) {
                    HadoopUIUtils.setOraDirModel(BDACopySingleGeneralPage.this._sDirCmp, BDACopySingleGeneralPage.this._connName, false);
                }
                BDACopySingleGeneralPage.this.enableSourceComponents(true);
                BDACopySingleGeneralPage.this.wizardEnableButtons(true, true, false);
                BDACopySingleGeneralPage.this._selectedDbo = null;
                BDACopySingleGeneralPage.this._selectedUrl = null;
                if (!BDACopySingleGeneralPage.this._isExistingTable) {
                    BDACopySingleGeneralPage.this._bdsXTabCmp.setText("");
                    BDACopySingleGeneralPage.this._dXTabCmp.setText("");
                }
                if (BDACopySingleGeneralPage.this._searchSelectionPanel != null) {
                    BDACopySingleGeneralPage.this.resetConnection();
                }
                BDACopySingleGeneralPage.this._bigDataConfigDir = HadoopUtils.getDirectoryPath(BDACopySingleGeneralPage.this._connName, BDACopySingleGeneralPage.BIG_DATA_CONFIG);
                if (BDACopySingleGeneralPage.this._bigDataConfigDir == null || BDACopySingleGeneralPage.this._bigDataConfigDir.isEmpty()) {
                    BDACopySingleGeneralPage.this.wizardEnableButtons(true, false, false);
                    object = new MessageDetailsDialog();
                    object.showErrorDialog(HadoopWizArb.getString("COPY_BDA_CONFIG_ERROR"), HadoopWizArb.getString("COPY_BDA_CONFIG_ERROR_DETAILS2"));
                }
                BDACopySingleGeneralPage.this._bigDataDirs = HadoopUtils.getDirectoriesAndPaths(BDACopySingleGeneralPage.this._connName, BDACopySingleGeneralPage.BIG_DATA_CL);
                BDACopySingleGeneralPage.this._sClusterCmp.removeAllItems();
                if (!BDACopySingleGeneralPage.this._bigDataDirs.isEmpty()) {
                    BDACopySingleGeneralPage.this.wizardEnableButtons(true, true, false);
                    for (String string : BDACopySingleGeneralPage.this._bigDataDirs.keySet()) {
                        int n = string == null ? -1 : string.indexOf(BDACopySingleGeneralPage.BIG_DATA_CL);
                        if (n == -1) continue;
                        BDACopySingleGeneralPage.this._sClusterCmp.addItem(string.substring(BDACopySingleGeneralPage.BIG_DATA_CL.length()));
                    }
                    if (BDACopySingleGeneralPage.this._sClusterCmp.getItemCount() > 0) {
                        BDACopySingleGeneralPage.this._sClusterCmp.setSelectedIndex(0);
                    }
                } else {
                    BDACopySingleGeneralPage.this.wizardEnableButtons(true, false, false);
                    object = new MessageDetailsDialog();
                    object.showErrorDialog(HadoopWizArb.getString("COPY_BDA_CONFIG_ERROR"), HadoopWizArb.getString("COPY_BDA_CONFIG_ERROR_DETAILS"));
                }
            }
        };
        this._sourceConnSelector.getJComboBox().addActionListener(this._sConnListener);
    }

    public String getSourceConnection() {
        if (this._sourceConnSelector != null) {
            return this._sourceConnSelector.getCurrentConnectionName();
        }
        return null;
    }

    protected void resetConnection() {
        if (this._sObjectLCmp != null) {
            this._selectedUrl = null;
            this._selectedDbo = null;
            this._sObjectTFCmp = new JTextField();
            this._sObjectTFCmp.setEnabled(false);
            this._sObjectTFCmp.setToolTipText(HadoopWizArb.getString("DB_OBJECT_TIP"));
            this._sObjectLabel.setLabelFor(this._sObjectTFCmp);
            this._sObjectPanel.removeAll();
            this._sObjectPanel.add((Component)this._sObjectTFCmp, "North");
        }
    }

    protected void openSearchPanel() {
        if (this.getSourceConnection() != null) {
            String string = HadoopWizArb.getString("SEARCH_DIALOG_TITLE");
            JPanel jPanel = new JPanel(new BorderLayout(0, 16));
            HelpSystem.getHelpSystem().registerTopic((JComponent)jPanel, "f1_search_dbobject_html");
            JTextPane jTextPane = new JTextPane();
            jTextPane.setEditable(false);
            jTextPane.setOpaque(false);
            jTextPane.setRequestFocusEnabled(false);
            jTextPane.setFocusable(false);
            jTextPane.setText(HadoopWizArb.getString("FIND_INSTRUCTIONS"));
            this._searchSelectionPanel = new SearchObjectsSelectionPanel((SearchPanel)new BDACopyByTypeSearchPanel());
            this._searchSelectionPanel.updatePanel();
            DDLTypes dDLTypes = ((ExtractListModel)this._hProps.get(HadoopKeys.EXTRACT_LIST_MODEL)).getDDLTypes();
            dDLTypes.setView(this._isStagingMethod);
            dDLTypes.setMatView(true);
            dDLTypes.setShowView(this._isStagingMethod);
            dDLTypes.setShowMatView(true);
            this._searchSelectionPanel.setDDLTypes(dDLTypes);
            this._searchSelectionPanel.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    URL uRL;
                    String string = propertyChangeEvent.getPropertyName();
                    if (string.equals("APPLY") && (uRL = BDACopySingleGeneralPage.this._searchSelectionPanel.getUrl()) != null) {
                        BDACopySingleGeneralPage.this._selectedUrl = uRL;
                        BDACopySingleGeneralPage.this._selectedDbo = new DBObject(BDACopySingleGeneralPage.this._selectedUrl);
                        BDACopySingleGeneralPage.this._sObjectLCmp = new JLabel();
                        BDACopySingleGeneralPage.this._sObjectLCmp.setText(BDACopySingleGeneralPage.this._selectedDbo.getSchemaName() + "." + BDACopySingleGeneralPage.this._selectedDbo.getObjectName());
                        BDACopySingleGeneralPage.this._sObjectLCmp.setIcon(DBURLFormatHelper.getIcon((URL)BDACopySingleGeneralPage.this._selectedUrl));
                        BDACopySingleGeneralPage.this._sObjectLCmp.setToolTipText(HadoopWizArb.getString("DB_OBJECT_TIP"));
                        BDACopySingleGeneralPage.this._sObjectPanel.removeAll();
                        BDACopySingleGeneralPage.this._sObjectPanel.add((Component)BDACopySingleGeneralPage.this._sObjectLCmp, "North");
                        BDACopySingleGeneralPage.this.refreshPanel();
                        BDACopySingleGeneralPage.this._subActionDialog.setVisible(false);
                        BDACopySingleGeneralPage.this._subActionDialog.dispose();
                        if (BDACopySingleGeneralPage.this._isExistingTable) {
                            BDACopySingleGeneralPage.this.validateSelectedTable();
                        }
                    }
                }
            });
            this._searchSelectionPanel.setSelectionMode(0);
            this._searchPanel = this._searchSelectionPanel.getPanel();
            this._searchSelectionPanel.setConName(this.getSourceConnection());
            jPanel.add((Component)this._searchPanel, "Center");
            jPanel.setBackground(UIManager.getColor("EWTDialog.background"));
            this._subActionDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)jPanel, null, (String)string, (int)14);
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (actionEvent.getActionCommand().equalsIgnoreCase("apply")) {
                        BDACopySingleGeneralPage.this._selectedUrl = BDACopySingleGeneralPage.this._searchSelectionPanel.getUrl();
                        if (BDACopySingleGeneralPage.this._selectedUrl != null) {
                            BDACopySingleGeneralPage.this._selectedDbo = new DBObject(BDACopySingleGeneralPage.this._selectedUrl);
                            BDACopySingleGeneralPage.this._sObjectLCmp = new JLabel();
                            BDACopySingleGeneralPage.this._sObjectLCmp.setText(BDACopySingleGeneralPage.this._selectedDbo.getSchemaName() + "." + BDACopySingleGeneralPage.this._selectedDbo.getObjectName());
                            BDACopySingleGeneralPage.this._sObjectLCmp.setIcon(DBURLFormatHelper.getIcon((URL)BDACopySingleGeneralPage.this._selectedUrl));
                            BDACopySingleGeneralPage.this._sObjectLCmp.setToolTipText(HadoopWizArb.getString("DB_OBJECT_TIP"));
                            BDACopySingleGeneralPage.this._sObjectPanel.removeAll();
                            BDACopySingleGeneralPage.this._sObjectPanel.add((Component)BDACopySingleGeneralPage.this._sObjectLCmp, "North");
                            BDACopySingleGeneralPage.this.refreshPanel();
                            BDACopySingleGeneralPage.this._subActionDialog.setVisible(false);
                            BDACopySingleGeneralPage.this._subActionDialog.dispose();
                            if (BDACopySingleGeneralPage.this._isExistingTable) {
                                BDACopySingleGeneralPage.this.validateSelectedTable();
                            }
                        }
                    }
                }
            };
            this._subActionDialog.addActionListener(actionListener);
            Dimension dimension = jPanel.getPreferredSize();
            int n = (int)dimension.getHeight() + 100;
            int n2 = (int)dimension.getWidth() + 200;
            this._subActionDialog.setMinimumSize(n2, n);
        }
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)this._subActionDialog);
        this._subActionDialog.setVisible(true);
    }

    private void wizardEnableButtons(boolean bl, boolean bl2, boolean bl3) {
        this._dataContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(bl), Boolean.valueOf(bl2), Boolean.valueOf(bl3));
        this._back = bl;
        this._next = bl2;
        this._finish = bl3;
    }

    private void restoreWizardEnableButtons() {
        this._dataContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(this._back), Boolean.valueOf(this._next), Boolean.valueOf(this._finish));
    }

    protected void tryEnableNext(boolean bl) {
        this._dataContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(bl), Boolean.valueOf(bl), Boolean.valueOf(false));
    }

    protected void enableSourceComponents(boolean bl) {
        this._sFindCmp.setEnabled(bl);
        this._sObjectLabel.setEnabled(bl);
        this._sObjectPanel.setEnabled(bl);
        String string = this._sourceConnSelector.getCurrentConnectionName();
        boolean bl2 = string != null && !string.isEmpty();
        this._sDirLabel.setEnabled(bl2 && this._isStagingMethod && bl);
        this._sDirCmp.setEnabled(bl2 && this._isStagingMethod && bl);
        this._sClusterLabel.setEnabled(bl);
        this._sClusterCmp.setEnabled(bl);
        this._parallelLabel.setEnabled(bl);
        this._parallelCmp.setEnabled(bl);
    }

    protected JPanel getSourcePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)this._copyMethodLabel, LayoutControl.GBC.gbc((int)0, (int)0, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP));
        jPanel.add(this._copyMethodCmp, LayoutControl.GBC.gbc((int)1, (int)0, (int)2, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jPanel, "North");
        int n = 0;
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.setBorder(BorderFactory.createEmptyBorder(0, 8, 8, 8));
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.setBorder(BorderFactory.createTitledBorder(HadoopWizArb.getString("S_BORDER")));
        jPanel4.add((Component)jPanel3, "North");
        jPanel3.add((Component)this._sConnLabel, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP));
        jPanel3.add((Component)this._sourceConnSelector.getJComboBox(), LayoutControl.GBC.gbc((int)1, (int)n, (int)2, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X));
        this._sObjectPanel.add((Component)this._sObjectTFCmp, "North");
        jPanel3.add((Component)this._sObjectLabel, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP));
        jPanel3.add((Component)this._sObjectPanel, LayoutControl.GBC.gbc((int)1, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        jPanel3.add((Component)this._sFindCmp, LayoutControl.GBC.gbc((int)2, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.NONE));
        jPanel3.add((Component)this._sDirLabel, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.SECTION_LINE_START_COMP));
        jPanel3.add(this._sDirCmp, LayoutControl.GBC.gbc((int)1, (int)n, (int)2, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.SECTION_LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        jPanel3.add((Component)this._sClusterLabel, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP));
        jPanel3.add(this._sClusterCmp, LayoutControl.GBC.gbc((int)1, (int)n, (int)2, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        jPanel3.add((Component)this._parallelLabel, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP));
        jPanel3.add((Component)this._parallelCmp, LayoutControl.GBC.gbc((int)1, (int)n, (int)2, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        JPanel jPanel5 = new JPanel(new GridBagLayout());
        jPanel5.setBorder(BorderFactory.createEmptyBorder(0, 8, 8, 8));
        JPanel jPanel6 = new JPanel(new BorderLayout());
        jPanel6.setBorder(BorderFactory.createTitledBorder(HadoopWizArb.getString("D_BORDER")));
        jPanel6.add((Component)jPanel5, "North");
        n = 0;
        jPanel5.add((Component)this._dXTabLabel, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP));
        jPanel5.add((Component)this._dXTabCmp, LayoutControl.GBC.gbc((int)1, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        if (this._isExistingTable) {
            jPanel5.add((Component)this._sTableInfoLabel, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP));
            jPanel5.add((Component)this._sTableInfoCmp, LayoutControl.GBC.gbc((int)1, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        }
        jPanel5.add((Component)this._dDestDataFormatLabel, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP));
        jPanel5.add(this._dDestDataFormatCmp, LayoutControl.GBC.gbc((int)1, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        jPanel5.add((Component)this._dRootLabel, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP));
        jPanel5.add((Component)this._dRootCmp, LayoutControl.GBC.gbc((int)1, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        JPanel jPanel7 = new JPanel(new GridBagLayout());
        jPanel7.setBorder(BorderFactory.createEmptyBorder(0, 8, 8, 8));
        JPanel jPanel8 = new JPanel(new BorderLayout());
        jPanel8.add((Component)jPanel7, "North");
        n = 0;
        jPanel7.add((Component)this._bdsXTabLabel, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP));
        jPanel7.add((Component)this._bdsXTabCmp, LayoutControl.GBC.gbc((int)1, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        JPanel jPanel9 = new JPanel(new GridBagLayout());
        jPanel9.setBorder(BorderFactory.createEmptyBorder(0, 8, 8, 8));
        n = 0;
        jPanel9.add((Component)this._dHostLabel, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP));
        jPanel9.add(this._dHostCmp, LayoutControl.GBC.gbc((int)1, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        this._sshPanel = new JPanel(new BorderLayout());
        this._sshPanel.setBorder(DIRECT_BORDER);
        this._sshPanel.add((Component)jPanel9, "North");
        JPanel jPanel10 = new JPanel(new BorderLayout(0, 6));
        jPanel10.add((Component)this._instructions, "North");
        this._sourceMainPanel = new JPanel(new GridBagLayout());
        n = 0;
        this._sourceMainPanel.add((Component)jPanel10, new GridBagConstraints(0, ++n, 2, 1, 0.0, 0.0, 18, 2, new Insets(6, 0, 0, 0), 0, 0));
        this._sourceMainPanel.add((Component)jPanel2, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)2, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        this._sourceMainPanel.add((Component)this._sshPanel, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)2, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.SECTION_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X));
        this._sourceMainPanel.add((Component)jPanel4, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)2, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.SECTION_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X));
        this._sourceMainPanel.add((Component)jPanel6, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)2, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.SECTION_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X));
        n = 0;
        this._sourcePanel = new JPanel(new BorderLayout());
        this._sourcePanel.add((Component)this._sourceMainPanel, "Center");
        return this._sourcePanel;
    }

    protected void refreshPanel() {
        this._sTableInfoLabel.setEnabled(true);
        if (!this._isExistingTable) {
            if (this._selectedDbo != null) {
                this._dXTabCmp.setText(this._selectedDbo.getObjectName().toLowerCase());
            } else {
                this._dXTabCmp.setText("");
            }
        }
        this._sObjectPanel.validate();
        this._sObjectPanel.repaint();
        this._sourcePanel.validate();
        this._sourcePanel.repaint();
        super.repaint();
    }

    private void validateSelectedTable() {
        GenericTable genericTable = new GenericTable(this._selectedDbo.getConnection(), this._selectedDbo.getSchemaName(), this._selectedDbo.getObjectName());
        boolean bl = true;
        genericTable.getTable().getColumnCount();
        if (this._hiveTable.getColumnCount() == genericTable.getTable().getColumnCount()) {
            for (Column column : genericTable.getColumns()) {
                if (this._hiveTable.getColumnByName(column.getName()) != null) continue;
                bl = false;
            }
        } else {
            bl = false;
        }
        if (!bl) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)HadoopWizArb.getString("BDA_INCOMPATIBLE_SOURCE"), (String)HadoopWizArb.getString("ERROR"), null);
        }
        this.wizardEnableButtons(true, bl, false);
    }

    protected HadoopImportDataFormat getDataFormat() {
        return new OLHImportDataFormat(BaseDataFormat.IMPORT_WIZARD, BaseDataFormat.DELIMITED);
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        this._dataContext = traversableContext;
        if (traversableContext.getDirection() == 1) {
            Object object;
            this._cluster = (String)this._sClusterCmp.getSelectedItem();
            if (this._cluster == null || this._cluster.isEmpty()) {
                this.cleanup();
                throw new TraversalException(HadoopWizArb.getString("COPY_BDA_CONFIG_ERROR_DETAILS"));
            }
            this._lastCluster = (String)this._hProps.get(HadoopKeys.CLUSTER);
            this._envFile = DIRECT_ENV_FILE;
            if (this._isStagingMethod) {
                this._envFile = this._bigDataConfigDir + "/../hadoop_" + this._cluster + ".env";
                this._sourceEnv = "#!/bin/bash\nsource " + this._envFile + "\nexport PATH=$HADOOP_HOME/bin:${PATH}\n";
            } else {
                this._sourceEnv = "#!/bin/bash\nsource " + this._envFile + NEW_LINE;
            }
            this._hProps.put(HadoopKeys.ENV_FILE, this._envFile);
            this._hProps.put(HadoopKeys.ENV_SOURCE, this._sourceEnv);
            this._rootPath = this._dRootCmp.getText();
            this._destDir = "";
            DBObject dBObject = (DBObject)this._hProps.get(ImportKeys.DBOBJECT);
            this._schema = this._isExistingTable ? dBObject.getSchemaName() : HadoopUtils.getFolderSchema(dBObject);
            this._hProps.put(HadoopKeys.DEST_SCHEMA, this._schema);
            this._lastRootPath = (String)this._hProps.get(HadoopKeys.DEST_ROOT_DIR);
            this._lastDestDir = (String)this._hProps.get(HadoopKeys.DEST_DIR);
            if (this._isExistingTable && this._hiveTable.isDataPump()) {
                this._destDir = this._rootPath;
                this._hProps.put(HadoopKeys.DEST_DIR, this._destDir);
            } else {
                if (this._rootPath.endsWith("/")) {
                    this._rootPath = this._rootPath.substring(0, this._rootPath.length() - 1);
                }
                this._destDir = this._rootPath + "/" + this._schema + "." + this._dXTabCmp.getText();
            }
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd_HHmmssssss");
            StringBuilder stringBuilder = new StringBuilder(simpleDateFormat.format(new Date()));
            this._testDir = this._destDir + stringBuilder;
            this._hProps.put(HadoopKeys.USE_IN_BDS, this._useInBDS.isSelected());
            if (this._useInBDS.isSelected()) {
                this._hProps.put(HadoopKeys.BDS_TABLE, this._bdsXTabCmp.getText());
            }
            this._lastHost = (String)this._hProps.get(HadoopKeys.SSH_HOST);
            if (this._hostName == null || this._hostName.isEmpty()) {
                this.cleanup();
                throw new TraversalException(HadoopWizArb.getString("HOST_REQUIRED"));
            }
            String string = this.getSourceConnection();
            Connection connection = null;
            if (string != null) {
                try {
                    connection = Connections.getInstance().getConnection(string);
                }
                catch (Exception exception) {
                    Throwable throwable;
                    Exception exception2;
                    while (exception2 instanceof DBException && (throwable = exception2.getCause()) instanceof Exception) {
                        exception2 = (Exception)throwable;
                    }
                    ExceptionHandler.handleException((String)string, (Throwable)exception2);
                    throw new TraversalException(null);
                }
            }
            if (connection == null) {
                throw new TraversalException(HadoopWizArb.getString("NO_SOURCE_CONNECTION"));
            }
            this._hProps.put(HadoopKeys.SOURCE_CONN, connection);
            this._hProps.put(HadoopKeys.SOURCE_CONN_NAME, string);
            this._dataContext.put(HadoopKeys.SOURCE_CONN_NAME.toString(), (Object)string);
            ExtractListModel extractListModel = (ExtractListModel)this._hProps.get(HadoopKeys.EXTRACT_LIST_MODEL);
            extractListModel.setSourceConnName(string);
            this._dataContext.put("CONNECTION_NAME", (Object)extractListModel.getSourceConnName());
            ExtractObject extractObject = (ExtractObject)this._hProps.get(HadoopKeys.EXTRACT_OBJECT);
            if (extractObject == null || !extractObject.getUrl().equals(this._selectedUrl)) {
                if (this._selectedDbo == null || !this.isValidDbo(this._selectedDbo)) {
                    this.cleanup();
                    throw new TraversalException(HadoopWizArb.getString("NO_SOURCE_OBJECT"));
                }
                object = extractListModel.getOrAddExtractObject(this._selectedUrl);
                extractListModel.setSelectExtractBoth((ExtractObject)object);
                ArrayList<URL> arrayList = new ArrayList<URL>();
                arrayList.add(this._selectedUrl);
                extractListModel.setSelectExtractBoth(arrayList);
                ExtractObject extractObject2 = extractListModel.getFirstExtractObject();
                this._hProps.put(HadoopKeys.EXTRACT_OBJECT, extractObject2);
            }
            this._hProps.put(HadoopKeys.ORIGIN, this._origin);
            this._hProps.put(HadoopKeys.DDL_ENABLED, true);
            this._hProps.put(HadoopKeys.DATA_ENABLED, true);
            if (this._isStagingMethod) {
                if (this._sDirCmp == null || this._sDirCmp.getSelectedIndex() == -1) {
                    this._taskMsg = HadoopWizArb.getString("ORA_DIR_MISSING");
                    throw new TraversalException(this._taskMsg);
                }
                this._hProps.put(ImportKeys.ORADIRNAME, this._sDirCmp.getSelectedItem());
                this._hProps.put(ImportKeys.LOAD_METHOD, 3);
            } else {
                this._hProps.put(ImportKeys.LOAD_METHOD, 0);
                this._hProps.put(ImportKeys.ORADIRNAME, "");
            }
            this._hProps.put(HadoopKeys.PARALLEL, this._parallelCmp.getIntValue());
            if (!this._isExistingTable && ((object = this._dXTabCmp.getText()) == null || ((String)object).isEmpty())) {
                throw new TraversalException(HadoopWizArb.getString("DEST_XTABLE_MISSING"));
            }
            this._hProps.put(HadoopKeys.DEST_DATA_FORMAT, this._dDestDataFormatCmp.getSelectedItem());
            if (this._bigDataConfigDir == null || this._bigDataConfigDir.isEmpty()) {
                this._taskMsg = HadoopWizArb.getString("COPY_BDA_CONFIG_ERROR") + HadoopWizArb.getString("COPY_BDA_CONFIG_ERROR_DETAILS2");
                throw new TraversalException(HadoopWizArb.getString("COPY_BDA_CONFIG_ERROR") + HadoopWizArb.getString("COPY_BDA_CONFIG_ERROR_DETAILS2"));
            }
            this._scriptEnv = "ls " + this._envFile;
            this._scriptRootPath = "hadoop fs -test -d " + this._rootPath;
            this._scriptDestDir = "hadoop fs -test -d " + this._destDir;
            this._scriptTestDir = this._sourceEnv + "hadoop fs -mkdir " + this._testDir + "\nhadoop fs -rmdir " + this._testDir;
            this.doWithRaptorTask();
        }
    }

    public void doWithRaptorTask() throws TraversalException {
        this._task = new DatabaseQueryTask<Boolean>(HadoopWizArb.getString("COPY_BDA"), IRaptorTaskRunMode.NO_GUI, false, true){

            public Boolean doWork() throws TaskException {
                String string;
                BDACopySingleGeneralPage.this._taskMsg = null;
                BDACopySingleGeneralPage.this._taskMsgDetails = null;
                DBObject dBObject = (DBObject)BDACopySingleGeneralPage.this._hProps.get(ImportKeys.DBOBJECT);
                String string2 = (String)BDACopySingleGeneralPage.this._hProps.get(HadoopKeys.DEST_TABLE);
                if (!BDACopySingleGeneralPage.this._isExistingTable) {
                    string = BDACopySingleGeneralPage.this._dXTabCmp.getText();
                    if (string == null || string.isEmpty()) {
                        // empty if block
                    }
                    if (!string.equals(string2) && HadoopUtils.existsHive(dBObject.getConnection(), BDACopySingleGeneralPage.this._schema, BDACopySingleGeneralPage.this._dXTabCmp.getText())) {
                        BDACopySingleGeneralPage.this.cleanup();
                        BDACopySingleGeneralPage.this._taskMsg = HadoopWizArb.format("TABLE_EXISTS", string);
                        throw new TaskException(BDACopySingleGeneralPage.this._taskMsg);
                    }
                }
                BDACopySingleGeneralPage.this._hProps.put(HadoopKeys.DEST_TABLE, BDACopySingleGeneralPage.this._dXTabCmp.getText());
                string = null;
                if (BDACopySingleGeneralPage.this._bigDataConfigDir != null && !BDACopySingleGeneralPage.this._bigDataConfigDir.isEmpty()) {
                    if (!(BDACopySingleGeneralPage.this._isStagingMethod && BDACopySingleGeneralPage.this._hostName.equals(BDACopySingleGeneralPage.this._lastHost) && BDACopySingleGeneralPage.this._cluster.equals(BDACopySingleGeneralPage.this._lastCluster))) {
                        string = HadoopUtils.executeCommand(BDACopySingleGeneralPage.this._clientSession, BDACopySingleGeneralPage.this._scriptEnv);
                        if (((ScriptOutput)string).rc != 0) {
                            BDACopySingleGeneralPage.this.cleanup();
                            if (BDACopySingleGeneralPage.this._isStagingMethod) {
                                BDACopySingleGeneralPage.this._taskMsg = HadoopWizArb.getString("COPY_BDA_CONFIG_ERROR") + HadoopWizArb.format("COPY_BDA_CONFIG_ERROR_DETAILS3", BDACopySingleGeneralPage.this._envFile);
                                throw new TaskException(BDACopySingleGeneralPage.this._taskMsg);
                            }
                            BDACopySingleGeneralPage.this._taskMsg = HadoopWizArb.getString("COPY_BDA_CONFIG_DIRECT_ERROR") + HadoopWizArb.format("COPY_BDA_CONFIG_DIRECT_ERROR_DETAILS3", BDACopySingleGeneralPage.this._envFile);
                            throw new TaskException(BDACopySingleGeneralPage.this._taskMsg);
                        }
                    }
                    BDACopySingleGeneralPage.this._hProps.put(HadoopKeys.SSH_HOST, BDACopySingleGeneralPage.this._hostName);
                    BDACopySingleGeneralPage.this._hProps.put(HadoopKeys.CLUSTER, BDACopySingleGeneralPage.this._cluster);
                }
                BDACopySingleGeneralPage.this._sessLoc = (SshSessionLocation)BDACopySingleGeneralPage.this._hProps.get(HadoopKeys.SSH_SESSION_LOCATION);
                BDACopySingleGeneralPage.this._tempDir = "sqldev_temp/";
                BDACopySingleGeneralPage.this._tempName = HadoopUtils.getTempName("sqldev_c2h");
                if (!(BDACopySingleGeneralPage.this._isExistingTable || BDACopySingleGeneralPage.this._lastRootPath != null && BDACopySingleGeneralPage.this._rootPath.equals(BDACopySingleGeneralPage.this._lastRootPath))) {
                    string = BDACopySingleGeneralPage.this.copyAndExecuteScript(BDACopySingleGeneralPage.this._scriptRootPath);
                    BDACopySingleGeneralPage.this._isCleanupDeployNeeded = true;
                    if (((ScriptOutput)string).rc != 0) {
                        String string3 = "STDOUT: " + ((ScriptOutput)string).stdout + HadoopUtils.getTerm() + "STDERR: " + ((ScriptOutput)string).stderr + HadoopUtils.getTerm();
                        BDACopySingleGeneralPage.this._taskMsg = HadoopWizArb.getString("ROOT_DIR_ERROR");
                        BDACopySingleGeneralPage.this._taskMsgDetails = HadoopWizArb.getString("BDA_SCRIPT") + BDACopySingleGeneralPage.NEW_LINE + BDACopySingleGeneralPage.this._scriptRootPath + "\n\n" + string3;
                        BDACopySingleGeneralPage.this._hProps.put(HadoopKeys.DEST_ROOT_DIR, "");
                        BDACopySingleGeneralPage.this._hProps.put(HadoopKeys.DEST_DIR, "");
                        throw new TaskException(BDACopySingleGeneralPage.this._taskMsg);
                    }
                }
                BDACopySingleGeneralPage.this._hProps.put(HadoopKeys.DEST_ROOT_DIR, BDACopySingleGeneralPage.this._rootPath);
                if (BDACopySingleGeneralPage.this._lastDestDir == null || !BDACopySingleGeneralPage.this._destDir.equals(BDACopySingleGeneralPage.this._lastDestDir)) {
                    string = BDACopySingleGeneralPage.this.copyAndExecuteScript(BDACopySingleGeneralPage.this._scriptDestDir);
                    BDACopySingleGeneralPage.this._isCleanupDeployNeeded = true;
                    if (((ScriptOutput)string).rc != 0) {
                        string = BDACopySingleGeneralPage.this.copyAndExecuteScript(BDACopySingleGeneralPage.this._scriptTestDir);
                        BDACopySingleGeneralPage.this._isCleanupDeployNeeded = true;
                        if (((ScriptOutput)string).rc != 0) {
                            String string4 = "STDOUT: " + ((ScriptOutput)string).stdout + HadoopUtils.getTerm() + "STDERR: " + ((ScriptOutput)string).stderr + HadoopUtils.getTerm();
                            BDACopySingleGeneralPage.this._taskMsg = HadoopWizArb.format("CREATE_ROOT_DIR_ERROR", BDACopySingleGeneralPage.this._destDir);
                            BDACopySingleGeneralPage.this._taskMsgDetails = HadoopWizArb.getString("BDA_SCRIPT") + BDACopySingleGeneralPage.NEW_LINE + BDACopySingleGeneralPage.this._scriptTestDir + "\n\n" + string4;
                            throw new TaskException(BDACopySingleGeneralPage.this._taskMsg);
                        }
                    } else if (!BDACopySingleGeneralPage.this._isExistingTable) {
                        String string5 = "STDOUT: " + ((ScriptOutput)string).stdout + HadoopUtils.getTerm() + "STDERR: " + ((ScriptOutput)string).stderr + HadoopUtils.getTerm();
                        BDACopySingleGeneralPage.this._taskMsg = HadoopWizArb.format("DEST_DIR_ERROR", BDACopySingleGeneralPage.this._destDir);
                        BDACopySingleGeneralPage.this._taskMsgDetails = HadoopWizArb.getString("BDA_SCRIPT") + BDACopySingleGeneralPage.NEW_LINE + BDACopySingleGeneralPage.this._scriptTestDir + "\n\n" + string5;
                        throw new TaskException(BDACopySingleGeneralPage.this._taskMsg);
                    }
                    BDACopySingleGeneralPage.this._hProps.put(HadoopKeys.DEST_DIR, BDACopySingleGeneralPage.this._destDir);
                }
                return true;
            }

            public String getConnectionName() {
                return BDACopySingleGeneralPage.this.getSourceConnection();
            }

            public String getQuery() {
                return "";
            }
        };
        this._task.setCancellable(true);
        this._task.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

            public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                this.cleanTask();
            }

            public void taskScheduled(RaptorTaskEvent raptorTaskEvent) {
            }

            public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
                this.cleanTask();
            }

            public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
                this.cleanTask();
            }

            private void cleanTask() {
                BDACopySingleGeneralPage.this.cleanup();
                if (BDACopySingleGeneralPage.this._statusDialog != null) {
                    BDACopySingleGeneralPage.this._statusDialog.setVisible(false);
                    BDACopySingleGeneralPage.this._statusDialog.dispose();
                }
            }
        });
        this._statusDialog = null;
        RaptorTaskManager.getInstance().addTask(this._task);
        MessageDetailsDialog messageDetailsDialog = new MessageDetailsDialog();
        JPanel jPanel = messageDetailsDialog.getUIInfo(HadoopWizArb.getString("VAL_DEST"), this.getValidationDetails());
        this._statusDialog = messageDetailsDialog.getDialog((Component)jPanel);
        WizardLauncher.runDialog((JDialog)this._statusDialog);
        try {
            this._task.getResult();
            this._task = null;
        }
        catch (Exception exception) {
            Throwable throwable = exception.getCause();
            if (throwable != null && throwable instanceof TaskException) {
                if (this._taskMsgDetails != null) {
                    messageDetailsDialog = new MessageDetailsDialog();
                    messageDetailsDialog.showErrorDialog(this._taskMsg, this._taskMsgDetails);
                    throw new TraversalException(null);
                }
                throw new TraversalException(this._taskMsg);
            }
            throw new TraversalException((Object)exception);
        }
    }

    private String getValidationDetails() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(HadoopWizArb.getString("VAL_ENV_PROCESS") + NEW_LINE);
        stringBuffer.append(HadoopWizArb.getString("VAL_ENV") + NEW_LINE);
        stringBuffer.append(this._scriptEnv + NEW_LINE);
        stringBuffer.append(HadoopWizArb.getString("VAL_ROOT") + NEW_LINE);
        stringBuffer.append(this._scriptRootPath + NEW_LINE);
        stringBuffer.append(HadoopWizArb.getString("VAL_DEST_DIR1") + NEW_LINE);
        stringBuffer.append(this._scriptDestDir + NEW_LINE);
        stringBuffer.append(HadoopWizArb.getString("VAL_DEST_DIR2") + NEW_LINE);
        stringBuffer.append(this._scriptTestDir + NEW_LINE);
        stringBuffer.append(HadoopWizArb.getString("VAL_CLEANUP") + NEW_LINE);
        return stringBuffer.toString();
    }

    private ScriptOutput copyAndExecuteScript(String string) {
        String string2 = this._sourceEnv + string;
        return HadoopUtils.copyAndExecuteScript(this._sessLoc, string2, this._tempName + ".deploy", this._tempDir + "/");
    }

    private void cleanup() {
        if (this._isCleanupDeployNeeded) {
            String string = "rm " + this._tempDir + "/" + this._tempName + ".deploy\n";
            HadoopUtils.executeCommand(this._clientSession, string);
        }
    }

    private boolean isValidDbo(DBObject dBObject) {
        if (dBObject.getSchemaName() == null || dBObject.getSchemaName().isEmpty()) {
            return false;
        }
        return dBObject.getObjectName() != null && !dBObject.getObjectName().isEmpty();
    }

    public Object getExitTransition() {
        return this.getTransition();
    }

    private Object getTransition() {
        return "E";
    }

    private class Connector
    implements ItemListener {
        private OracleConnectionComboBox m_selector;

        Connector(OracleConnectionComboBox oracleConnectionComboBox) {
            this.m_selector = oracleConnectionComboBox;
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (this.m_selector.getJComboBox().getSelectedIndex() != -1) {
                BDACopySingleGeneralPage.this._isOraDirModel = false;
                boolean bl = true;
                String string = BDACopySingleGeneralPage.this.getSourceConnection();
                try {
                    Connections.getInstance().getConnection(string);
                    if (string.equals(BDACopySingleGeneralPage.this._connName)) {
                        bl = false;
                    } else {
                        BDACopySingleGeneralPage.this._connName = string;
                    }
                    BDACopySingleGeneralPage.this._isConnSelected = true;
                    if (bl) {
                        BDACopySingleGeneralPage.this._sDirCmp.setSelectedIndex(-1);
                        if (BDACopySingleGeneralPage.this._isStagingMethod) {
                            BDACopySingleGeneralPage.this._isOraDirModel = true;
                            HadoopUIUtils.setOraDirModel(BDACopySingleGeneralPage.this._sDirCmp, BDACopySingleGeneralPage.this._connName, false);
                        }
                        BDACopySingleGeneralPage.this.enableSourceComponents(true);
                        BDACopySingleGeneralPage.this.wizardEnableButtons(true, true, false);
                        BDACopySingleGeneralPage.this._selectedDbo = null;
                        BDACopySingleGeneralPage.this._selectedUrl = null;
                        if (!BDACopySingleGeneralPage.this._isExistingTable) {
                            BDACopySingleGeneralPage.this._bdsXTabCmp.setText("");
                            BDACopySingleGeneralPage.this._dXTabCmp.setText("");
                        }
                        if (BDACopySingleGeneralPage.this._searchSelectionPanel != null) {
                            BDACopySingleGeneralPage.this.resetConnection();
                        }
                        BDACopySingleGeneralPage.this._bigDataConfigDir = HadoopUtils.getDirectoryPath(BDACopySingleGeneralPage.this._connName, BDACopySingleGeneralPage.BIG_DATA_CONFIG);
                        if (BDACopySingleGeneralPage.this._bigDataConfigDir == null || BDACopySingleGeneralPage.this._bigDataConfigDir.isEmpty()) {
                            BDACopySingleGeneralPage.this.wizardEnableButtons(true, false, false);
                            BDACopySingleGeneralPage.this.connectionError(this.m_selector.getJComboBox(), HadoopWizArb.getString("COPY_BDA_CONFIG_ERROR"), HadoopWizArb.getString("COPY_BDA_CONFIG_ERROR_DETAILS2"));
                        }
                        BDACopySingleGeneralPage.this._bigDataDirs = HadoopUtils.getDirectoriesAndPaths(BDACopySingleGeneralPage.this._connName, BDACopySingleGeneralPage.BIG_DATA_CL);
                        BDACopySingleGeneralPage.this._sClusterCmp.removeAllItems();
                        if (!BDACopySingleGeneralPage.this._bigDataDirs.isEmpty()) {
                            BDACopySingleGeneralPage.this.wizardEnableButtons(true, true, false);
                            for (String string2 : BDACopySingleGeneralPage.this._bigDataDirs.keySet()) {
                                int n = string2 == null ? -1 : string2.indexOf(BDACopySingleGeneralPage.BIG_DATA_CL);
                                if (n == -1) continue;
                                BDACopySingleGeneralPage.this._sClusterCmp.addItem(string2.substring(BDACopySingleGeneralPage.BIG_DATA_CL.length()));
                            }
                            if (BDACopySingleGeneralPage.this._sClusterCmp.getItemCount() > 0) {
                                BDACopySingleGeneralPage.this._sClusterCmp.setSelectedIndex(0);
                            }
                        } else {
                            BDACopySingleGeneralPage.this.wizardEnableButtons(true, false, false);
                            MessageDetailsDialog messageDetailsDialog = new MessageDetailsDialog();
                            messageDetailsDialog.showErrorDialog(HadoopWizArb.getString("COPY_BDA_CONFIG_ERROR"), HadoopWizArb.getString("COPY_BDA_CONFIG_ERROR_DETAILS"));
                            BDACopySingleGeneralPage.this.connectionError(this.m_selector.getJComboBox(), HadoopWizArb.getString("COPY_BDA_CONFIG_ERROR"), HadoopWizArb.getString("COPY_BDA_CONFIG_ERROR_DETAILS"));
                        }
                    }
                }
                catch (Exception exception) {
                    Throwable throwable;
                    Exception exception2;
                    while (exception2 instanceof DBException && (throwable = exception2.getCause()) instanceof Exception) {
                        exception2 = (Exception)throwable;
                    }
                    BDACopySingleGeneralPage.this.connectionError(this.m_selector.getJComboBox(), HadoopWizArb.format("COPY_BDA_CONN_ERROR", Connections.getDisplayName((String)((String)this.m_selector.getJComboBox().getSelectedItem()))), exception2.getLocalizedMessage());
                }
            }
        }
    }
}

