/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.hadoop.core;

import java.awt.Component;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.swing.SwingUtilities;
import oracle.dbtools.common.utils.BasicDBObject;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.extract.models.ExtractObject;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.hadoop.core.HadoopKeys;
import oracle.dbtools.raptor.hadoop.core.HadoopProperties;
import oracle.dbtools.raptor.hadoop.ui.HadoopWizArb;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.ssh.core.Client;
import oracle.dbtools.raptor.ssh.core.HostConnection;
import oracle.dbtools.raptor.ssh.core.HostDescriptor;
import oracle.dbtools.raptor.ssh.core.Store;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.transfer.location.SshLocation;
import oracle.dbtools.transfer.location.SshSessionLocation;
import oracle.dbtools.transfer.utility.ScriptOutput;
import oracle.dbtools.util.Logger;
import oracle.ide.Ide;
import oracle.javatools.dialogs.ExceptionDialog;
import org.apache.sshd.client.channel.ChannelExec;
import org.apache.sshd.client.channel.ChannelShell;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.util.io.IoUtils;
import org.apache.sshd.sftp.client.fs.SftpFileSystem;
import org.apache.sshd.sftp.client.fs.SftpFileSystemProvider;

public class HadoopUtils {
    public static final String NEW_LINE = "\n";
    private static int timeout = 60000;

    public static boolean isHiveConnection(String string) {
        Properties properties;
        String string2;
        return !Connections.getInstance().isOracle(string) && (string2 = (properties = Connections.getInstance().getConnectionInfo(string)).getProperty("subtype")).equals("Hive");
    }

    public static DBObject getDBO(Connection connection, String string, String string2, String string3) {
        return HadoopUtils.getDBO(Connections.getInstance().getConnectionName(connection), string, string2, string3);
    }

    public static DBObject getDBO(String string, String string2, String string3, String string4) {
        URL uRL = DBURLFormatHelper.getURL((String)"sqldev.nav", (String)string, null, (String)string3, (String)string2);
        URL uRL2 = DBURLFormatHelper.getURL((URL)uRL, (String)string4);
        return new DBObject(uRL2);
    }

    public static Vector<String> getDirectories(DBObject dBObject) {
        return HadoopUtils.getDirectories(dBObject, null);
    }

    public static Vector<String> getDirectories(DBObject dBObject, String string) {
        return HadoopUtils.getDirectories(dBObject.getConnectionName(), string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static Vector<String> getDirectories(String string, String string2) {
        Vector<String> vector;
        block12: {
            ResultSet resultSet = null;
            vector = new Vector<String>();
            if (Connections.getInstance().lock(string)) {
                block11: {
                    try {
                        DBUtil dBUtil = DBUtil.getInstance((String)string);
                        Object object = "select DIRECTORY_NAME from all_directories";
                        if (string2 != null && !string2.isEmpty()) {
                            object = (String)object + " where DIRECTORY_NAME like '" + string2 + "%'";
                        }
                        resultSet = dBUtil.executeQuery((String)object, Collections.EMPTY_MAP);
                        while (resultSet.next()) {
                            vector.add(resultSet.getString(1));
                        }
                        if (resultSet == null) break block11;
                    }
                    catch (SQLException sQLException) {
                        Logger.fine(HadoopUtils.class, (Throwable)sQLException);
                        break block12;
                    }
                    catch (Exception exception) {
                        Logger.warn(HadoopUtils.class, (Throwable)exception);
                        break block12;
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                    }
                    finally {
                        if (resultSet != null) {
                            DBUtil.closeResultSet(resultSet);
                        }
                        Connections.getInstance().unlock(string);
                    }
                    DBUtil.closeResultSet((ResultSet)resultSet);
                }
                Connections.getInstance().unlock(string);
            }
        }
        return vector;
    }

    public static Vector<String> getPartitionViews(String string, String string2) {
        String string3 = "select view_name from " + string2;
        return HadoopUtils.getResultAsVector(string, string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static Vector<String> getResultAsVector(String string, String string2) {
        ResultSet resultSet = null;
        Vector<String> vector = new Vector<String>();
        if (Connections.getInstance().lock(string)) {
            block9: {
                try {
                    DBUtil dBUtil = DBUtil.getInstance((String)string);
                    resultSet = dBUtil.executeQuery(string2, Collections.EMPTY_MAP);
                    while (resultSet.next()) {
                        vector.add(resultSet.getString(1));
                    }
                    if (resultSet == null) break block9;
                }
                catch (SQLException sQLException) {
                    block10: {
                        Logger.fine(HadoopUtils.class, (Throwable)sQLException);
                        if (resultSet == null) break block10;
                        DBUtil.closeResultSet((ResultSet)resultSet);
                    }
                    Connections.getInstance().unlock(string);
                }
                catch (Exception exception) {
                    block11: {
                        Logger.warn(HadoopUtils.class, (Throwable)exception);
                        if (resultSet == null) break block11;
                        {
                            catch (Throwable throwable) {
                                if (resultSet != null) {
                                    DBUtil.closeResultSet(resultSet);
                                }
                                Connections.getInstance().unlock(string);
                                throw throwable;
                            }
                        }
                        DBUtil.closeResultSet((ResultSet)resultSet);
                    }
                    Connections.getInstance().unlock(string);
                }
                DBUtil.closeResultSet((ResultSet)resultSet);
            }
            Connections.getInstance().unlock(string);
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static HashMap<String, String> getDirectoriesAndPaths(String string, String string2) {
        HashMap<String, String> hashMap;
        block12: {
            ResultSet resultSet = null;
            hashMap = new HashMap<String, String>();
            if (Connections.getInstance().lock(string)) {
                block11: {
                    try {
                        DBUtil dBUtil = DBUtil.getInstance((String)string);
                        Object object = "select DIRECTORY_NAME, DIRECTORY_PATH from all_directories";
                        if (string2 != null && !string2.isEmpty()) {
                            object = (String)object + " where DIRECTORY_NAME like '" + string2 + "%'";
                        }
                        resultSet = dBUtil.executeQuery((String)object, Collections.EMPTY_MAP);
                        while (resultSet.next()) {
                            hashMap.put(resultSet.getString(1), resultSet.getString(2));
                        }
                        if (resultSet == null) break block11;
                    }
                    catch (SQLException sQLException) {
                        Logger.fine(HadoopUtils.class, (Throwable)sQLException);
                        break block12;
                    }
                    catch (Exception exception) {
                        Logger.warn(HadoopUtils.class, (Throwable)exception);
                        break block12;
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                    }
                    finally {
                        if (resultSet != null) {
                            DBUtil.closeResultSet(resultSet);
                        }
                        Connections.getInstance().unlock(string);
                    }
                    DBUtil.closeResultSet((ResultSet)resultSet);
                }
                Connections.getInstance().unlock(string);
            }
        }
        return hashMap;
    }

    public static String getDirectoryPath(String string, String string2) {
        return HadoopUtils.getDirectoryPath(DBUtil.getInstance((String)string), string2);
    }

    public static String getDirectoryPath(Connection connection, String string) {
        return HadoopUtils.getDirectoryPath(DBUtil.getInstance((Connection)connection), string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDirectoryPath(DBUtil dBUtil, String string) {
        try {
            String string2 = "select DIRECTORY_PATH from all_directories where DIRECTORY_NAME = '" + string + "'";
            String string3 = dBUtil.executeReturnOneCol(string2);
            return string3;
        }
        finally {
            SQLException sQLException = dBUtil.getLastException();
            if (sQLException != null) {
                Logger.fine(HadoopUtils.class, (Throwable)sQLException);
            }
        }
    }

    public static boolean isExternalTable(DBObject dBObject) {
        return HadoopUtils.isExternalTable(dBObject.getConnectionName(), dBObject.getSchemaName(), dBObject.getObjectName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isExternalTable(String string, String string2, String string3) {
        DBUtil dBUtil = DBUtil.getInstance((String)string);
        try {
            String string4 = "select count(*) from all_external_tables where table_name = :TNAME and OWNER = :OWNER";
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("TNAME", string3);
            hashMap.put("OWNER", string2);
            boolean bl = !dBUtil.executeReturnOneCol(string4, hashMap).equals("0");
            return bl;
        }
        finally {
            SQLException sQLException = dBUtil.getLastException();
            if (sQLException != null) {
                Logger.fine(HadoopUtils.class, (Throwable)sQLException);
                return false;
            }
        }
    }

    public static Throwable unravelTaskException(TaskException taskException) {
        Throwable throwable;
        Object object = taskException;
        while (object instanceof TaskException && (throwable = object.getCause()) != null) {
            object = throwable;
        }
        return object;
    }

    public static String getGlobalName(String string) {
        return HadoopUtils.getGlobalName(DBUtil.getInstance((String)string));
    }

    public static String getGlobalName(Connection connection) {
        return HadoopUtils.getGlobalName(DBUtil.getInstance((Connection)connection));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getGlobalName(DBUtil dBUtil) {
        try {
            String string = "select GLOBAL_NAME from global_name";
            String string2 = dBUtil.executeReturnOneCol(string);
            return string2;
        }
        finally {
            SQLException sQLException = dBUtil.getLastException();
            if (sQLException != null) {
                Logger.fine(HadoopUtils.class, (Throwable)sQLException);
            }
        }
    }

    public static String getTableDegree(DBObject dBObject) {
        DBUtil dBUtil = DBUtil.getInstance((Connection)dBObject.getConnection());
        String string = "select DEGREE from all_tables where TABLE_NAME = '" + dBObject.getObjectName() + "' and OWNER = '" + dBObject.getSchemaName() + "'";
        String string2 = dBUtil.executeReturnOneCol(string);
        SQLException sQLException = dBUtil.getLastException();
        if (sQLException != null) {
            Logger.warn(HadoopUtils.class, (Throwable)sQLException);
            return "4";
        }
        return string2 == null ? "4" : string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isTablePartitioned(BasicDBObject basicDBObject) {
        ResultSet resultSet = null;
        if (Connections.getInstance().lock(basicDBObject.getConnectionName())) {
            block4: {
                boolean bl;
                try {
                    DBUtil dBUtil = DBUtil.getInstance((Connection)basicDBObject.getConnection());
                    resultSet = dBUtil.executeQuery("select 1 from all_part_tables where TABLE_NAME = '" + basicDBObject.getObjectName() + "' and OWNER = '" + basicDBObject.getSchemaName() + "'", Collections.EMPTY_MAP);
                    if (resultSet == null || !resultSet.next()) break block4;
                    bl = true;
                }
                catch (SQLException sQLException) {
                    DBUtil.closeResultSet(resultSet);
                    Connections.getInstance().unlock(basicDBObject.getConnectionName());
                }
                catch (Throwable throwable) {
                    DBUtil.closeResultSet(resultSet);
                    Connections.getInstance().unlock(basicDBObject.getConnectionName());
                    throw throwable;
                }
                DBUtil.closeResultSet((ResultSet)resultSet);
                Connections.getInstance().unlock(basicDBObject.getConnectionName());
                return bl;
            }
            DBUtil.closeResultSet((ResultSet)resultSet);
            Connections.getInstance().unlock(basicDBObject.getConnectionName());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getHiveDescribe(DBObject dBObject) {
        StringBuffer stringBuffer = new StringBuffer();
        ResultSet resultSet = null;
        if (Connections.getInstance().lock(dBObject.getConnectionName())) {
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)dBObject.getConnection());
                resultSet = dBUtil.executeQuery("describe formatted " + dBObject.getSchemaName() + "." + dBObject.getObjectName(), Collections.EMPTY_MAP);
                while (resultSet.next()) {
                    stringBuffer.append(resultSet.getString(1));
                }
            }
            catch (SQLException sQLException) {
                DBUtil.closeResultSet(resultSet);
                Connections.getInstance().unlock(dBObject.getConnectionName());
            }
            catch (Throwable throwable) {
                DBUtil.closeResultSet(resultSet);
                Connections.getInstance().unlock(dBObject.getConnectionName());
                throw throwable;
            }
            DBUtil.closeResultSet((ResultSet)resultSet);
            Connections.getInstance().unlock(dBObject.getConnectionName());
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getHiveDDL(DBObject dBObject) {
        StringBuffer stringBuffer = new StringBuffer();
        ResultSet resultSet = null;
        if (Connections.getInstance().lock(dBObject.getConnectionName())) {
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)dBObject.getConnection());
                resultSet = dBUtil.executeQuery("show create table " + dBObject.getSchemaName() + "." + dBObject.getObjectName(), Collections.EMPTY_MAP);
                while (resultSet.next()) {
                    stringBuffer.append(resultSet.getString(1));
                }
            }
            catch (SQLException sQLException) {
                DBUtil.closeResultSet(resultSet);
                Connections.getInstance().unlock(dBObject.getConnectionName());
            }
            catch (Throwable throwable) {
                DBUtil.closeResultSet(resultSet);
                Connections.getInstance().unlock(dBObject.getConnectionName());
                throw throwable;
            }
            DBUtil.closeResultSet((ResultSet)resultSet);
            Connections.getInstance().unlock(dBObject.getConnectionName());
        }
        return stringBuffer.toString();
    }

    public static String[] getHiveColumns(String string) {
        int n;
        int n2 = string.indexOf("(");
        if (n2 != -1 && (n = string.indexOf(")")) != -1) {
            int n3;
            int n4;
            String[] stringArray = string.substring(n2 + 1, n - 1).split(",");
            for (n4 = 0; n4 < stringArray.length; ++n4) {
                stringArray[n4] = stringArray[n4].trim();
                int n5 = stringArray[n4].indexOf(")");
                if (n5 == -1 || (n3 = stringArray[n4].indexOf("(")) != -1) continue;
                stringArray[n4] = stringArray[n4].substring(0, n5 - 1);
                break;
            }
            String[] stringArray2 = new String[n4];
            for (n3 = 0; n3 < n4; ++n3) {
                stringArray2[n3] = stringArray[n3];
            }
            return stringArray;
        }
        return new String[0];
    }

    public static String[] getHivePartitionKeys(String string) {
        String string2;
        int n;
        String string3 = "PARTITIONED BY (";
        int n2 = string.indexOf(string3);
        if (n2 != -1 && (n = (string2 = string.substring(n2 + string3.length())).indexOf(")")) != -1) {
            String[] stringArray = string2.substring(0, n).split(",");
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = stringArray[i].trim();
            }
            return stringArray;
        }
        return new String[0];
    }

    public static boolean existsHive(Connection connection, String string, String string2) {
        DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
        try {
            String string3 = " show tables in " + string + " '" + string2 + "'";
            String string4 = dBUtil.executeReturnOneCol(string3);
            return string4 != null && !string4.isEmpty();
        }
        catch (Exception exception) {
            SQLException sQLException = dBUtil.getLastException();
            if (sQLException != null) {
                Logger.fine(HadoopUtils.class, (Throwable)sQLException);
            }
            return false;
        }
    }

    public static String getTerm() {
        return NEW_LINE;
    }

    public static String getQualifiedTableName(ExtractObject extractObject) {
        BasicDBObject basicDBObject = extractObject.getDBObject();
        return DBUtil.addDoubleQuote((String)basicDBObject.getSchemaName()) + "." + DBUtil.addDoubleQuote((String)basicDBObject.getObjectName());
    }

    public static String getSQL(ExtractObject extractObject) {
        ArrayList arrayList = extractObject.getPartitions();
        BasicDBObject basicDBObject = extractObject.getDBObject();
        String string = DBUtil.addDoubleQuote((String)basicDBObject.getSchemaName()) + "." + DBUtil.addDoubleQuote((String)basicDBObject.getObjectName());
        if (arrayList == null || arrayList.isEmpty() || arrayList.size() == 1 && ((String)arrayList.get(0)).equals("*")) {
            return "select " + extractObject.getColumns() + " from " + string + HadoopUtils.getPredicate(extractObject);
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (String string2 : arrayList) {
            stringBuffer.append("select " + extractObject.getColumns() + " from " + string + " PARTITION (" + string2 + ") " + HadoopUtils.getPredicate(extractObject) + HadoopUtils.getTerm() + " UNION ALL ");
        }
        String string3 = stringBuffer.toString();
        return string3.substring(0, string3.length() - 10);
    }

    public static String getWhere(ExtractObject extractObject) {
        ArrayList arrayList = extractObject.getPartitions();
        if (arrayList == null || arrayList.isEmpty() || arrayList.size() == 1 && ((String)arrayList.get(0)).equals("*")) {
            return extractObject.getWhere();
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : arrayList) {
            stringBuffer.append(" PARTITION (" + string + ") " + HadoopUtils.getPredicate(extractObject) + HadoopUtils.getTerm() + " UNION ALL ");
        }
        String string = stringBuffer.toString();
        return string.substring(0, string.length() - 10);
    }

    public static String getPredicate(ExtractObject extractObject) {
        Object object = extractObject.getWhere();
        if (!((String)object).equals("") && ((String)object).trim().toLowerCase().indexOf("where") != 0) {
            object = " WHERE " + (String)object;
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String execDDL(Connection connection, String string, String string2) {
        if (Connections.getInstance().lock(connection)) {
            try {
                connection.createStatement().executeUpdate(string2);
            }
            catch (Exception exception) {
                String string3 = exception.getMessage();
                return string3;
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
            return null;
        }
        return HadoopWizArb.format("EXEC_LOCK_FAILED", string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String execUpdate(String string, String string2) {
        String string3 = null;
        DBUtil dBUtil = DBUtil.getInstance((String)string);
        try {
            dBUtil.executeUpdate(string2, Collections.EMPTY_MAP);
        }
        finally {
            SQLException sQLException = dBUtil.getLastException();
            if (sQLException != null) {
                string3 = sQLException.getLocalizedMessage();
            }
        }
        return string3;
    }

    public static String getFolderSchema(DBObject dBObject) {
        URL uRL = dBObject.getURL();
        String string = DBURLFormatHelper.getSchema((URL)uRL);
        return string;
    }

    public static String getTempName(String string) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yymmdd_HHmmssssss");
        StringBuilder stringBuilder = new StringBuilder(simpleDateFormat.format(new Date()));
        return string + "_" + stringBuilder;
    }

    public static SshSessionLocation getSSHSessionLocation(HadoopProperties hadoopProperties) throws IOException {
        ClientSession clientSession = (ClientSession)hadoopProperties.get(HadoopKeys.SSH_SESSION);
        SshSessionLocation sshSessionLocation = (SshSessionLocation)hadoopProperties.get(HadoopKeys.SSH_SESSION_LOCATION);
        if (sshSessionLocation == null) {
            sshSessionLocation = new SshSessionLocation(clientSession);
            sshSessionLocation.connect();
            hadoopProperties.put(HadoopKeys.SSH_SESSION_LOCATION, sshSessionLocation);
        }
        return sshSessionLocation;
    }

    public static HostDescriptor setSshHostProperties(HadoopProperties hadoopProperties, String string) {
        hadoopProperties.put(HadoopKeys.SSH_HOST, string);
        HostDescriptor hostDescriptor = null;
        try {
            Store store = Client.getInstance().getStore();
            hostDescriptor = store.getHostDescriptor(string);
            hadoopProperties.put(HadoopKeys.SSH_USER, hostDescriptor.getUsername());
        }
        catch (Exception exception) {
            Logger.warn(HadoopUtils.class, (Throwable)exception);
        }
        return hostDescriptor;
    }

    public static SshTask getOpenSshConnectionTask(final HostDescriptor hostDescriptor) {
        SshTask sshTask = new SshTask("!Open SSH Connection!"){

            protected HostConnection doWork() throws TaskException {
                try {
                    HostConnection hostConnection = Client.getInstance().openConnection(hostDescriptor);
                    return hostConnection;
                }
                catch (IOException iOException) {
                    throw new TaskException((Throwable)iOException);
                }
            }
        };
        return sshTask;
    }

    public static String getOracleUser(HadoopProperties hadoopProperties) {
        Properties properties = (Properties)hadoopProperties.get(HadoopKeys.ORA_CONN_INFO_CLONE);
        return properties == null ? null : properties.getProperty("user");
    }

    public static String getOraclePass(HadoopProperties hadoopProperties) {
        Properties properties = (Properties)hadoopProperties.get(HadoopKeys.ORA_CONN_INFO_CLONE);
        return properties == null ? null : properties.getProperty("password");
    }

    public static String getOracleUrl(HadoopProperties hadoopProperties) {
        Properties properties = (Properties)hadoopProperties.get(HadoopKeys.ORA_CONN_INFO_CLONE);
        return properties == null ? null : properties.getProperty("customUrl");
    }

    public static ScriptOutput copyAndExecuteScript(SshLocation sshLocation, String string, String string2, String string3) {
        return sshLocation.executeScript(string, string2, string3);
    }

    public static ScriptOutput executeScript(ClientSession clientSession, String string) {
        return HadoopUtils.executeScript(clientSession, string, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ScriptOutput executeScript(ClientSession clientSession, String string, Map<String, String> map) {
        assert (string != null);
        Logger.fine(HadoopUtils.class, (String)("script = \"" + string + "\""));
        String string2 = string + "\nexit $?\n";
        ChannelShell channelShell = null;
        ScriptOutput scriptOutput = new ScriptOutput();
        try {
            Object object = clientSession;
            synchronized (object) {
                assert (clientSession != null && clientSession.isOpen());
                channelShell = clientSession.createShellChannel();
            }
            object = new ByteArrayInputStream(string2.getBytes());
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(2048);
            ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream(2048);
            channelShell.setIn((InputStream)object);
            channelShell.setOut((OutputStream)byteArrayOutputStream);
            channelShell.setErr((OutputStream)byteArrayOutputStream2);
            if (map != null && !map.isEmpty()) {
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    String string3 = entry.getKey();
                    String string4 = entry.getValue();
                    channelShell.setEnv(string3, (Object)string4);
                }
            }
            channelShell.open().verify((long)timeout);
            do {
                Thread.sleep(500L);
            } while (!channelShell.isEofSignalled());
            scriptOutput.stdout = byteArrayOutputStream.toString();
            scriptOutput.stderr = byteArrayOutputStream2.toString();
            scriptOutput.rc = channelShell.getExitStatus();
            channelShell.close();
        }
        catch (IOException iOException) {
            Logger.severe(HadoopUtils.class, (String)HadoopWizArb.getString("SSH_ERROR1"), (Throwable)iOException);
            ExceptionHandler.handleException((Throwable)iOException);
        }
        catch (Exception exception) {
            Logger.severe(HadoopUtils.class, (String)HadoopWizArb.getString("SSH_ERROR2"), (Throwable)exception);
            ExceptionHandler.handleException((Throwable)exception);
        }
        catch (Throwable throwable) {
            Logger.severe(HadoopUtils.class, (String)HadoopWizArb.getString("SSH_ERROR2"), (Throwable)throwable);
            ExceptionHandler.handleException((Throwable)throwable);
        }
        return scriptOutput;
    }

    public static ScriptOutput executeCommand(ClientSession clientSession, String string) {
        return HadoopUtils.executeSecureCommand(clientSession, string, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ScriptOutput executeSecureCommand(ClientSession clientSession, String string, Hashtable<String, String> hashtable) {
        assert (string != null);
        Logger.fine(HadoopUtils.class, (String)("script = \"" + string + "\""));
        ScriptOutput scriptOutput = new ScriptOutput();
        try {
            int n;
            Object object;
            Object object2;
            ChannelExec channelExec;
            Object object4 = clientSession;
            synchronized (object4) {
                assert (clientSession != null && clientSession.isOpen());
                channelExec = clientSession.createExecChannel(string);
                if (hashtable != null && !hashtable.isEmpty()) {
                    for (Map.Entry<String, String> object32 : hashtable.entrySet()) {
                        object2 = object32.getKey();
                        object = object32.getValue();
                        channelExec.setEnv((String)object2, object);
                    }
                }
                channelExec.open().verify((long)timeout);
            }
            object4 = new DataInputStream(channelExec.getInvertedOut());
            DataInputStream dataInputStream = new DataInputStream(channelExec.getInvertedErr());
            DataOutputStream dataOutputStream = new DataOutputStream(channelExec.getInvertedIn());
            object2 = "";
            object = new byte[1024];
            while (true) {
                int exception;
                if (((FilterInputStream)object4).available() > 0 && (exception = ((DataInputStream)object4).read((byte[])object, 0, 1024)) >= 0) {
                    object2 = (String)object2 + new String((byte[])object, 0, exception);
                    continue;
                }
                if (channelExec.isClosed()) {
                    if (((FilterInputStream)object4).available() <= 0) break;
                    continue;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception n2) {}
            }
            scriptOutput.stdout = object2;
            object2 = "";
            while (dataInputStream.available() > 0 && (n = dataInputStream.read((byte[])object, 0, 1024)) >= 0) {
                object2 = (String)object2 + new String((byte[])object, 0, n);
            }
            scriptOutput.stderr = object2;
            scriptOutput.rc = channelExec.getExitStatus();
            ((FilterInputStream)object4).close();
            dataOutputStream.close();
            channelExec.close();
        }
        catch (IOException iOException) {
            Logger.severe(HadoopUtils.class, (String)HadoopWizArb.getString("SSH_ERROR1"), (Throwable)iOException);
        }
        catch (Exception exception) {
            Logger.severe(HadoopUtils.class, (String)HadoopWizArb.getString("SSH_ERROR2"), (Throwable)exception);
        }
        return scriptOutput;
    }

    private static SftpFileSystem createFileSystem(ClientSession clientSession) throws IOException {
        String string;
        SftpFileSystemProvider sftpFileSystemProvider = new SftpFileSystemProvider(Client.getInstance().getSSHClient());
        SftpFileSystem sftpFileSystem = sftpFileSystemProvider.getFileSystem(string = SftpFileSystemProvider.getFileSystemIdentifier((ClientSession)clientSession));
        if (sftpFileSystem == null) {
            sftpFileSystem = sftpFileSystemProvider.newFileSystem(clientSession);
        }
        return sftpFileSystem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getFile(ClientSession clientSession, String string, OutputStream outputStream) throws IOException {
        long l;
        Logger.fine(HadoopUtils.class, (String)string);
        String string2 = "";
        if (clientSession == null || !clientSession.isOpen()) {
            string2 = HadoopWizArb.getString("SESSION_UNAVAIL");
            throw new IOException(string2);
        }
        SftpFileSystem sftpFileSystem = null;
        try {
            Object object = clientSession;
            synchronized (object) {
                assert (clientSession != null && clientSession.isOpen());
                sftpFileSystem = HadoopUtils.createFileSystem(clientSession);
            }
            object = sftpFileSystem.getPath(string, new String[0]);
            try (InputStream inputStream = Files.newInputStream((Path)object, new OpenOption[0]);){
                l = IoUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
            }
        }
        catch (Exception exception) {
            string2 = HadoopWizArb.format("COPY_FAILED", string);
            Logger.warn(HadoopUtils.class, (String)string2, (Throwable)exception);
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw new IOException(string2, exception);
        }
        Logger.fine(HadoopUtils.class, (String)(l + " bytes written"));
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long putFile(ClientSession clientSession, String string, ByteArrayInputStream byteArrayInputStream) throws IOException {
        long l;
        Logger.fine(HadoopUtils.class, (String)string);
        String string2 = "";
        if (clientSession == null || !clientSession.isOpen()) {
            string2 = HadoopWizArb.getString("SESSION_UNAVAIL");
            throw new IOException(string2);
        }
        SftpFileSystem sftpFileSystem = null;
        try {
            Object object = clientSession;
            synchronized (object) {
                assert (clientSession != null && clientSession.isOpen());
                sftpFileSystem = HadoopUtils.createFileSystem(clientSession);
            }
            object = sftpFileSystem.getPath(string, new String[0]);
            try (OutputStream outputStream = Files.newOutputStream((Path)object, new OpenOption[0]);){
                l = IoUtils.copy((InputStream)byteArrayInputStream, (OutputStream)outputStream);
            }
        }
        catch (Exception exception) {
            string2 = HadoopWizArb.format("COPY_FAILED", string);
            Logger.fine(HadoopUtils.class, (String)string2, (Throwable)exception);
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw new IOException(string2, exception);
        }
        Logger.fine(HadoopUtils.class, (String)(l + " bytes written"));
        return l;
    }

    public static String getUniqueName(String string) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd_HHmmssssss");
        StringBuilder stringBuilder = new StringBuilder(simpleDateFormat.format(new Date()));
        return string + stringBuilder;
    }

    public static boolean isSame(DBObject dBObject, DBObject dBObject2) {
        return dBObject.getConnectionName().equals(dBObject2.getConnectionName()) && dBObject.getSchemaName().equals(dBObject2.getSchemaName()) && dBObject.getObjectType().equals(dBObject2.getObjectType()) && dBObject.getObjectName().equals(dBObject2.getObjectName());
    }

    public static boolean isSame(BasicDBObject basicDBObject, BasicDBObject basicDBObject2) {
        return basicDBObject.getConnectionName().equals(basicDBObject2.getConnectionName()) && basicDBObject.getSchemaName().equals(basicDBObject2.getSchemaName()) && basicDBObject.getObjectType().equals(basicDBObject2.getObjectType()) && basicDBObject.getObjectName().equals(basicDBObject2.getObjectName());
    }

    private static void reportException(Throwable throwable, String string, String string2) {
        Throwable throwable2 = HadoopUtils.unravelException(throwable);
        ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)throwable2, (String)string, (String)MessageFormat.format("{0}\n\n{1}", string2, throwable2.getLocalizedMessage()), null);
    }

    private static Throwable unravelException(Throwable throwable) {
        Throwable throwable2;
        Throwable throwable3 = throwable;
        while (throwable3 instanceof IOException && (throwable2 = throwable3.getCause()) != null) {
            throwable3 = throwable2;
        }
        return throwable3;
    }

    private static void addListenerToTask(RaptorTask raptorTask, final SshRaptorTaskHandler sshRaptorTaskHandler) {
        raptorTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

            public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
                this.dispatchTaskCompletion(SshRaptorTaskHandler.State.CANCELLED, raptorTaskEvent);
            }

            public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
                this.dispatchTaskCompletion(SshRaptorTaskHandler.State.FAILED, raptorTaskEvent);
            }

            public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                this.dispatchTaskCompletion(SshRaptorTaskHandler.State.FINISHED, raptorTaskEvent);
            }

            private void dispatchTaskCompletion(final SshRaptorTaskHandler.State state, final RaptorTaskEvent raptorTaskEvent) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        sshRaptorTaskHandler.taskEnded(state, raptorTaskEvent);
                    }
                };
                if (SwingUtilities.isEventDispatchThread()) {
                    runnable.run();
                } else {
                    SwingUtilities.invokeLater(runnable);
                }
            }
        });
    }

    private static interface SshRaptorTaskHandler {
        public void taskEnded(State var1, RaptorTaskEvent var2);

        public static enum State {
            FINISHED,
            FAILED,
            CANCELLED;

        }
    }

    public static abstract class SshTask
    extends RaptorTask<HostConnection> {
        SshTask(String string) {
            super(string, true, IRaptorTaskRunMode.TASKVIEWER);
            this.setCancellable(false);
        }
    }
}

