/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.table;

import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.panels.MutExChildObjectEditorPanel;
import oracle.javatools.db.Column;
import oracle.javatools.db.ColumnSequenceProcessor;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Table;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.datatypes.PredefinedDataType;

public class ColumnSequencePanel
extends MutExChildObjectEditorPanel<Column, Table> {
    public ColumnSequencePanel() {
        super("ColumnSequencePanel", "columns");
    }

    @Override
    protected void initialiseChildComponents() {
        DBUILayoutHelper dBUILayoutHelper = this.getDBUILayoutHelper();
        dBUILayoutHelper.addChildren(this.getOrCreateWrapper("AUTO_GENERATED_SEQUENCE_TRIGGER"), new Integer[0]);
        dBUILayoutHelper.nextRow();
        dBUILayoutHelper.addChildren(this.getOrCreateWrapper("AUTO_GENERATED_SEQUENCE"), new Integer[0]);
        dBUILayoutHelper.nextRow();
        dBUILayoutHelper.add(this.getOrCreateWrapper("ColumnSequenceExpander.TriggerNullCheck"));
        dBUILayoutHelper.nextRowWithGap();
        dBUILayoutHelper.add(this.getOrCreateWrapper("ColumnSequenceExpander.ReuseSequence"));
        dBUILayoutHelper.pushUp();
        dBUILayoutHelper.layout();
    }

    @Override
    public String getChildValidationProperty() {
        return "AUTO_GENERATED_SEQUENCE_TRIGGER";
    }

    @Override
    public void initialiseProperty(Column column, DBEditorConfig dBEditorConfig) {
        column.setProperty("ColumnSequenceExpander.TriggerNullCheck", (Object)Boolean.TRUE);
        if (!dBEditorConfig.isInFlatEditor()) {
            Relation relation = column.getRelation();
            String string = dBEditorConfig.getProvider().getUniqueName("TRIGGER", (DBObject)relation.getSchema(), relation.getName() + "_TRG");
            column.setProperty("AUTO_GENERATED_SEQUENCE_TRIGGER", (Object)new ReferenceID("TRIGGER", relation.getSchema(), string));
            String string2 = dBEditorConfig.getProvider().getUniqueName("SEQUENCE", (DBObject)relation.getSchema(), relation.getName() + "_SEQ");
            column.setProperty("AUTO_GENERATED_SEQUENCE", (Object)new ReferenceID("SEQUENCE", relation.getSchema(), string2));
        }
    }

    @Override
    public void clearProperty(Column column) {
        ColumnSequenceProcessor.clearColumnSequenceProps((Column)column);
    }

    @Override
    public boolean accept(Column column) {
        DataTypeUsage dataTypeUsage;
        Relation relation = column.getRelation();
        if (DBUtil.needsBuilding((DBObject)relation, (String)"AUTO_GENERATED_SEQUENCE_TRIGGER") && (dataTypeUsage = column.getDataTypeUsage()) != null) {
            try {
                DataType dataType = DataTypeHelper.getDataType((DataTypeUsage)dataTypeUsage, (boolean)false);
                PredefinedDataType.ValueType valueType = DataTypeHelper.getValueType((DataType)dataType);
                if (PredefinedDataType.ValueType.isNumericType((PredefinedDataType.ValueType)valueType) || valueType == PredefinedDataType.ValueType.CHAR) {
                    DBUtil.ensureObjectBuilt((DBObject)relation, (String[])new String[]{"AUTO_GENERATED_SEQUENCE_TRIGGER"});
                    for (Column column2 : relation.getColumns()) {
                        ColumnSequenceProcessor.refreshColumnSequenceProps((Column)column2);
                    }
                }
            }
            catch (DBException dBException) {
                this.getLogger().warning(dBException.getMessage());
            }
        }
        return ColumnSequenceProcessor.hasColumnSequenceProps((Column)column);
    }
}

