/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.controls;

import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.AbstractCellEditor;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.text.JTextComponent;
import oracle.ide.db.PropertyDisplayRegistry;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.ideimpl.db.controls.ExtendedTable;
import oracle.ideimpl.db.controls.KeyValueTable;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.Relation;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.ora.bigdata.BigDataAccessParameter;
import oracle.javatools.db.ora.bigdata.BigDataJsonArray;
import oracle.javatools.db.ora.bigdata.BigDataJsonEntry;
import oracle.javatools.db.ora.bigdata.BigDataJsonObject;
import oracle.javatools.db.sql.ColumnUsage;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SimpleSQLFragment;
import oracle.javatools.ui.ExtendedTextField;
import oracle.javatools.ui.combo.JCheckCombo;
import oracle.javatools.util.ModelUtil;

public class BigDataJsonEntriesTable
extends KeyValueTable {
    private static final String QUOTE = "\"";
    private final String m_keyName;
    private final String m_valueName;
    private final TableCellRenderer m_cellRenderer = new Renderer();
    private Relation m_relation;
    private BigDataAccessParameter m_param;

    public BigDataJsonEntriesTable(String string, String string2) {
        super(PropertyDisplayRegistry.getDisplayName("bigDataEntries"), "BigDataJsonEntriesTable");
        this.m_keyName = string;
        this.m_valueName = string2;
    }

    @Override
    protected boolean shouldTerminateEditOnFocusLost() {
        return true;
    }

    private Vector<String> getColumnNames() {
        Vector<String> vector = new Vector<String>();
        vector.add(QUOTE + this.m_keyName + QUOTE);
        vector.add(QUOTE + this.m_valueName + QUOTE);
        return vector;
    }

    public void setBigDataJsonArray(BigDataJsonArray bigDataJsonArray, BigDataAccessParameter bigDataAccessParameter, Relation relation) {
        Serializable serializable;
        Object object;
        Object object2;
        Object object32;
        this.m_relation = relation;
        this.m_param = bigDataAccessParameter;
        String string = bigDataAccessParameter.getName();
        Vector<Vector> vector = new Vector<Vector>();
        for (Object object32 : bigDataJsonArray.getArguments()) {
            if (object32 instanceof BigDataJsonObject) {
                object2 = ((BigDataJsonObject)object32).getBigDataEntries();
                object = BigDataJsonEntry.getJsonEntryNames((String)string);
                boolean abstractCellEditor = BigDataJsonEntry.hasExtendedEntry((String)((String)object.object1()), (String)string);
                if (((BigDataJsonEntry[])object2).length <= 0) continue;
                serializable = new Vector<Object>();
                if (((BigDataJsonEntry[])object2).length == 1) {
                    ((Vector)serializable).add(object2[0]);
                } else if (((BigDataJsonEntry[])object2).length == 2) {
                    BigDataJsonEntry bigDataJsonEntry = object2[0];
                    if (abstractCellEditor && ((Object)object2).length > 1 && ModelUtil.areEqual((Object)object.object1(), (Object)bigDataJsonEntry.getName()) && !ModelUtil.areEqual((Object)object.object2(), (Object)object2[1].getName())) {
                        ((Vector)serializable).add(new BigDataJsonEntry[]{object2[0], object2[1]});
                    } else {
                        ((Vector)serializable).add(object2[0]);
                        ((Vector)serializable).add(object2[1]);
                    }
                } else if (((BigDataJsonEntry[])object2).length == 3) {
                    ((Vector)serializable).add(new BigDataJsonEntry[]{object2[0], object2[1]});
                    ((Vector)serializable).add(object2[2]);
                } else {
                    throw new IllegalStateException("Expect 2 BigDataJsonEntry");
                }
                vector.add((Vector)serializable);
                continue;
            }
            throw new IllegalStateException("Not a BigDataJsonObject");
        }
        BigDataValueArrayTableModel bigDataValueArrayTableModel = new BigDataValueArrayTableModel(vector);
        this.setModel(bigDataValueArrayTableModel);
        TableColumnModel tableColumnModel = this.getTable().getColumnModel();
        Collection collection = BigDataJsonEntry.getAllowedValueStrings((String)this.m_keyName, (String)string, (Relation)this.m_relation);
        object32 = BigDataJsonEntry.hasExtendedEntry((String)this.m_keyName, (String)string) ? new ExtendedCellEditor(this.m_keyName, collection) : (collection == null ? new SimpleCellEditor(this.m_keyName, new JTextField()) : new ComboEditor(this.m_keyName, collection, false));
        object2 = tableColumnModel.getColumn(0);
        ((TableColumn)object2).setCellEditor((TableCellEditor)object32);
        ((TableColumn)object2).setCellRenderer(this.m_cellRenderer);
        object = BigDataJsonEntry.getAllowedValueStrings((String)this.m_valueName, (String)string, (Relation)this.m_relation);
        AbstractCellEditor abstractCellEditor = object == null ? new SimpleCellEditor(this.m_valueName, (JTextComponent)new ExtendedTextField()) : new ComboEditor(this.m_valueName, (Collection<String>)object, "col".equals(this.m_valueName));
        serializable = tableColumnModel.getColumn(1);
        ((TableColumn)serializable).setCellEditor((TableCellEditor)((Object)abstractCellEditor));
        ((TableColumn)serializable).setCellRenderer(this.m_cellRenderer);
    }

    public BigDataJsonArray getBigDataJsonArray() {
        this.stopCellEditing();
        BigDataJsonArray bigDataJsonArray = new BigDataJsonArray();
        BigDataValueArrayTableModel bigDataValueArrayTableModel = (BigDataValueArrayTableModel)this.getModel();
        Vector vector = bigDataValueArrayTableModel.getDataVector();
        for (Vector vector2 : vector) {
            BigDataJsonObject bigDataJsonObject = new BigDataJsonObject();
            bigDataJsonArray.addArgument((SQLFragment)bigDataJsonObject);
            this.addBigDataJsonEntry(vector2.elementAt(0), bigDataJsonObject, this.m_keyName);
            this.addBigDataJsonEntry(vector2.elementAt(1), bigDataJsonObject, this.m_valueName);
        }
        return bigDataJsonArray;
    }

    private void addBigDataJsonEntry(Object object, BigDataJsonObject bigDataJsonObject, String string) {
        if (object instanceof BigDataJsonEntry[]) {
            for (BigDataJsonEntry bigDataJsonEntry : (BigDataJsonEntry[])object) {
                bigDataJsonObject.addBigDataEntry(bigDataJsonEntry);
            }
        } else if (object instanceof BigDataJsonEntry) {
            bigDataJsonObject.addBigDataEntry((BigDataJsonEntry)object);
        } else if (!BigDataJsonEntry.isJsonEntryOptional((String)this.m_param.getName(), (String)string)) {
            bigDataJsonObject.addBigDataEntry(new BigDataJsonEntry(string, null));
        }
    }

    private static Object getSelectedItem(JComboBox jComboBox) {
        ComboBoxEditor comboBoxEditor = jComboBox.isEditable() ? jComboBox.getEditor() : null;
        Object object = comboBoxEditor == null ? jComboBox.getSelectedItem() : comboBoxEditor.getItem();
        return object;
    }

    private class Renderer
    extends DefaultTableCellRenderer {
        private Renderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object instanceof BigDataJsonEntry[]) {
                StringBuilder stringBuilder = new StringBuilder();
                for (int i = 0; i < ((BigDataJsonEntry[])object).length; ++i) {
                    BigDataJsonEntry bigDataJsonEntry = ((BigDataJsonEntry[])object)[i];
                    if (i == 0) {
                        stringBuilder.append(bigDataJsonEntry.getValueSQLText());
                        continue;
                    }
                    stringBuilder.append(", ");
                    stringBuilder.append(bigDataJsonEntry.getSQLText());
                }
                object = stringBuilder.toString().trim();
            } else if (object instanceof BigDataJsonEntry) {
                object = ((BigDataJsonEntry)object).getValueSQLText();
            }
            return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }
    }

    private class BigDataValueArrayTableModel
    extends ExtendedTable.StringTableModel {
        BigDataValueArrayTableModel(Vector<Vector> vector) {
            super(BigDataJsonEntriesTable.this, vector, BigDataJsonEntriesTable.this.getColumnNames());
        }
    }

    private class ExtendedCellEditor
    extends AbstractCellEditor
    implements ExtendedTable.ExtendedTableCellEditor {
        private final JComboBox m_entryCombo;
        private final ExtendedTextField m_extendedEntryField;
        private final JPanel m_panel;
        private final String m_entryName;

        ExtendedCellEditor(String string, Collection<String> collection) {
            this.m_entryName = string;
            DBUIResourceHelper dBUIResourceHelper = new DBUIResourceHelper("BigDataJsonEntriesTable.ExtendedCellEditor");
            this.m_entryCombo = new JComboBox();
            for (String string2 : collection) {
                this.m_entryCombo.addItem(string2);
            }
            dBUIResourceHelper.setName(this.m_entryCombo, "EntryCombo");
            this.m_entryCombo.setEditable(true);
            this.m_entryCombo.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    ExtendedCellEditor.this.checkValueEntry();
                }
            });
            this.m_extendedEntryField = new ExtendedTextField();
            dBUIResourceHelper.setName((Component)this.m_extendedEntryField, "ExtendedEntryField");
            this.m_panel = new JPanel();
            this.m_panel.setLayout(new BoxLayout(this.m_panel, 0));
            this.m_panel.add(this.m_entryCombo);
            this.m_panel.add((Component)this.m_extendedEntryField);
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            SQLFragment sQLFragment = null;
            String string = null;
            if (object instanceof BigDataJsonEntry[]) {
                BigDataJsonEntry[] bigDataJsonEntryArray = (BigDataJsonEntry[])object;
                sQLFragment = bigDataJsonEntryArray[0].getValueFragment();
                if (bigDataJsonEntryArray.length > 1) {
                    SQLFragment sQLFragment2 = bigDataJsonEntryArray[1].getValueFragment();
                    string = sQLFragment2 == null ? null : sQLFragment2.getSQLText();
                }
            } else if (object instanceof BigDataJsonEntry) {
                sQLFragment = ((BigDataJsonEntry)object).getValueFragment();
            }
            this.m_entryCombo.setSelectedItem(sQLFragment == null ? null : sQLFragment.getSQLText());
            this.m_extendedEntryField.setText(string);
            this.checkValueEntry();
            return this.m_panel;
        }

        private String getExtendedEntryForSelection() {
            return BigDataJsonEntry.getExtendedEntryName((String)this.m_entryName, (String)((String)BigDataJsonEntriesTable.getSelectedItem(this.m_entryCombo)), (String)BigDataJsonEntriesTable.this.m_param.getName());
        }

        @Override
        public Object getCellEditorValue() {
            BigDataJsonEntry[] bigDataJsonEntryArray;
            String string = (String)BigDataJsonEntriesTable.getSelectedItem(this.m_entryCombo);
            BigDataJsonEntry bigDataJsonEntry = new BigDataJsonEntry(this.m_entryName, (SQLFragment)new SimpleSQLFragment(string));
            String string2 = this.getExtendedEntryForSelection();
            if (string2 != null) {
                BigDataJsonEntry bigDataJsonEntry2 = new BigDataJsonEntry(string2, (SQLFragment)new SimpleSQLFragment(this.m_extendedEntryField.getText()));
                bigDataJsonEntryArray = new BigDataJsonEntry[]{bigDataJsonEntry, bigDataJsonEntry2};
            } else {
                bigDataJsonEntryArray = new BigDataJsonEntry[]{bigDataJsonEntry};
            }
            return bigDataJsonEntryArray;
        }

        private void checkValueEntry() {
            if (this.getExtendedEntryForSelection() == null) {
                this.m_extendedEntryField.setVisible(false);
                this.m_entryCombo.setEditable(true);
            } else {
                this.m_extendedEntryField.setVisible(true);
                this.m_entryCombo.setEditable(false);
            }
        }

        @Override
        public void prepareComponent(Component component) {
            if (component == this.m_panel) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (ExtendedCellEditor.this.m_extendedEntryField.isVisible()) {
                            ExtendedCellEditor.this.m_extendedEntryField.requestFocusInWindow();
                        } else if (ExtendedCellEditor.this.m_entryCombo.isVisible()) {
                            ExtendedCellEditor.this.m_entryCombo.requestFocusInWindow();
                        }
                    }
                });
            }
        }
    }

    private class SimpleCellEditor
    extends AbstractCellEditor
    implements ExtendedTable.ExtendedTableCellEditor {
        private final JTextComponent m_editor;
        private final String m_entryName;

        SimpleCellEditor(String string, JTextComponent jTextComponent) {
            this.m_entryName = string;
            this.m_editor = jTextComponent;
            this.m_editor.setName("BigDataJsonEntriesTable.SimpleCellEditor");
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            if (object instanceof BigDataJsonEntry[]) {
                object = ((BigDataJsonEntry[])object)[0];
            }
            if (object instanceof BigDataJsonEntry) {
                object = ((BigDataJsonEntry)object).getValueFragment();
            }
            String string = null;
            if (object instanceof SQLFragment) {
                string = ((SQLFragment)object).getSQLText();
            }
            this.m_editor.setText(string);
            return this.m_editor;
        }

        @Override
        public Object getCellEditorValue() {
            return new BigDataJsonEntry(this.m_entryName, (SQLFragment)new SimpleSQLFragment(this.m_editor.getText()));
        }

        @Override
        public void prepareComponent(Component component) {
            if (component == this.m_editor) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (SimpleCellEditor.this.m_editor.isVisible() && !SimpleCellEditor.this.m_editor.hasFocus()) {
                            SimpleCellEditor.this.m_editor.requestFocusInWindow();
                        }
                    }
                });
            }
        }
    }

    private class ComboEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private final Collection<String> m_allowed;
        private final JComboBox m_combo;
        private final String m_entryName;

        ComboEditor(String string, Collection<String> collection, boolean bl) {
            this.m_entryName = string;
            this.m_allowed = collection;
            if (bl) {
                this.m_combo = new JCheckCombo();
                this.m_combo.setName("BigDataJsonEntriesTable.ColArrayEditor.JCheckCombo");
            } else {
                this.m_combo = new JComboBox();
                this.m_combo.setName("BigDataJsonEntriesTable.ColArrayEditor.JComboBox");
                this.m_combo.setEditable(true);
            }
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
            for (String object2 : this.m_allowed) {
                defaultComboBoxModel.addElement(object2);
            }
            if (object instanceof BigDataJsonEntry) {
                object = ((BigDataJsonEntry)object).getValueFragment();
            }
            if (this.m_combo instanceof JCheckCombo) {
                var7_7 = new TreeSet();
                if (object instanceof BigDataJsonArray) {
                    for (SQLFragment sQLFragment : ((BigDataJsonArray)object).getArguments()) {
                        this.addColumnName(sQLFragment, (Set<String>)var7_7);
                    }
                } else if (object instanceof SQLFragment) {
                    this.addColumnName((SQLFragment)object, (Set<String>)var7_7);
                }
                DefaultListSelectionModel defaultListSelectionModel = new DefaultListSelectionModel();
                Iterator iterator = var7_7.iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    if (!this.m_allowed.contains(string)) {
                        defaultComboBoxModel.insertElementAt(string, 0);
                    }
                    int n3 = defaultComboBoxModel.getIndexOf(string);
                    defaultListSelectionModel.addSelectionInterval(n3, n3);
                }
                ((JCheckCombo)this.m_combo).setModel(defaultComboBoxModel, (ListSelectionModel)defaultListSelectionModel);
            } else {
                var7_7 = null;
                if (object instanceof SQLFragment) {
                    var7_7 = ((SQLFragment)object).getSQLText();
                }
                this.m_combo.setModel(defaultComboBoxModel);
                this.m_combo.setSelectedItem(var7_7);
            }
            return this.m_combo;
        }

        private void addColumnName(SQLFragment sQLFragment, Set<String> set) {
            String string;
            if (sQLFragment != null && ModelUtil.hasLength((String)(string = sQLFragment.getSQLText()))) {
                set.add(string);
            }
        }

        @Override
        public Object getCellEditorValue() {
            Object object;
            boolean bl = this.m_combo instanceof JCheckCombo;
            boolean bl2 = BigDataJsonEntry.isJsonEntryOptional((String)BigDataJsonEntriesTable.this.m_param.getName(), (String)this.m_entryName);
            Object[] objectArray = this.m_combo.getSelectedObjects();
            if (bl || objectArray.length > 1) {
                if (objectArray.length == 0 && bl2) {
                    object = null;
                } else {
                    object = new BigDataJsonArray();
                    for (Object object2 : objectArray) {
                        object.addArgument(this.createFragment((String)object2));
                    }
                }
            } else {
                String string = (String)BigDataJsonEntriesTable.getSelectedItem(this.m_combo);
                object = string == null || !bl2 ? this.createFragment(string == null ? "" : string) : null;
            }
            return object == null ? null : new BigDataJsonEntry(this.m_entryName, (SQLFragment)object);
        }

        private SQLFragment createFragment(String string) {
            SimpleSQLFragment simpleSQLFragment;
            Column column;
            Column column2 = column = BigDataJsonEntriesTable.this.m_relation == null ? null : BigDataJsonEntriesTable.this.m_relation.getColumn(string);
            if (column != null) {
                TemporaryObjectID.setID((DBObject)column, (boolean)false);
                DBObjectID dBObjectID = column.getID();
                simpleSQLFragment = new ColumnUsage(dBObjectID);
            } else {
                simpleSQLFragment = new SimpleSQLFragment(string);
            }
            return simpleSQLFragment;
        }
    }
}

