/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.controls;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.text.Document;
import oracle.bali.ewt.text.NumberTextField;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.javatools.util.ModelUtil;

public abstract class AbstractSizeChooser
extends JPanel {
    private final JComboBox m_cmbByteMultiple = new JComboBox();
    private final NumberTextField m_fldSize = new NumberTextField();
    private final List<ChangeListener> m_listeners = new ArrayList<ChangeListener>();
    private BigInteger m_highestMultiple;
    private String m_name;
    private boolean m_listening = false;
    private final BigInteger MULTIPLIER = new BigInteger("1024");
    private final NonNullableComboBoxModel m_mdlByteMultiples = new NonNullableComboBoxModel();
    private final Map<String, BigInteger> m_multiplesAsBytes = new TreeMap<String, BigInteger>();

    public AbstractSizeChooser() {
        this((String)null);
    }

    public AbstractSizeChooser(String string) {
        this.init(string);
        try {
            this.layoutComponents();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public abstract void addByteMultiples();

    @Override
    public final void setName(String string) {
        this.m_name = string;
        this.m_cmbByteMultiple.setName(string);
        this.m_fldSize.setName(string + "_MULTIPLIER");
    }

    @Override
    public final String getName() {
        return this.m_name;
    }

    @Override
    public void setEnabled(boolean bl) {
        this.m_cmbByteMultiple.setEnabled(bl);
        this.m_fldSize.setEnabled(bl);
    }

    @Override
    public boolean isEnabled() {
        return this.m_cmbByteMultiple.isEnabled() && this.m_fldSize.isEnabled();
    }

    @Override
    public boolean isVisible() {
        return this.m_cmbByteMultiple.isVisible() && this.m_fldSize.isVisible();
    }

    @Override
    public void setVisible(boolean bl) {
        this.m_cmbByteMultiple.setVisible(bl);
        this.m_fldSize.setVisible(bl);
    }

    protected void init(String string) {
        this.m_fldSize.setDataType(BigInteger.class);
        this.m_highestMultiple = BigInteger.ONE;
        this.m_name = string;
        this.m_mdlByteMultiples.addElement((Object)"");
        this.addByteMultiples();
        this.m_cmbByteMultiple.setModel(this.m_mdlByteMultiples);
        this.m_cmbByteMultiple.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (AbstractSizeChooser.this.m_listening) {
                    AbstractSizeChooser.this.notifyListeners();
                }
            }
        });
        this.m_listening = true;
    }

    public void addByteMultiple(String string) {
        this.m_mdlByteMultiples.addElement((Object)string);
        BigInteger bigInteger = this.m_highestMultiple.multiply(this.MULTIPLIER);
        this.m_multiplesAsBytes.put(string, bigInteger);
        this.m_highestMultiple = bigInteger;
    }

    protected void layoutComponents() {
        this.setLayout(new GridBagLayout());
        this.add((Component)this.m_fldSize, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 13, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.m_cmbByteMultiple, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 4, 0, 0), 0, 0));
        this.m_cmbByteMultiple.setMaximumSize(new Dimension(10, 1));
        this.m_fldSize.setMinimumSize(new Dimension(100, 1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setText(String string) {
        this.m_listening = false;
        try {
            if (ModelUtil.hasLength((String)string)) {
                Set<String> set = this.m_multiplesAsBytes.keySet();
                BigInteger bigInteger = new BigInteger(string);
                Iterator<String> iterator = set.iterator();
                BigInteger bigInteger2 = bigInteger;
                this.m_fldSize.setNumber((Number)bigInteger);
                this.m_cmbByteMultiple.setSelectedIndex(0);
                while (iterator.hasNext()) {
                    String string2 = iterator.next();
                    BigInteger bigInteger3 = this.m_multiplesAsBytes.get(string2);
                    BigInteger[] bigIntegerArray = bigInteger.divideAndRemainder(bigInteger3);
                    if (!bigIntegerArray[1].equals(BigInteger.ZERO) || bigIntegerArray[0].compareTo(bigInteger2) == 1) continue;
                    bigInteger2 = bigIntegerArray[0];
                    this.m_cmbByteMultiple.setSelectedItem(string2);
                    this.m_fldSize.setNumber((Number)bigInteger.divide(bigInteger3));
                }
            } else {
                this.m_fldSize.setText(null);
                this.m_cmbByteMultiple.setSelectedIndex(0);
            }
        }
        finally {
            this.m_listening = true;
        }
    }

    public String getText() {
        if (ModelUtil.hasLength((String)this.m_fldSize.getText())) {
            return this.getNumber().toString();
        }
        return this.m_fldSize.getText();
    }

    public Number getNumber() {
        Object object = this.m_cmbByteMultiple.getSelectedItem();
        if (object instanceof String && ModelUtil.hasLength((String)((String)object))) {
            BigInteger bigInteger = this.m_multiplesAsBytes.get(object);
            if (ModelUtil.hasLength((String)this.m_fldSize.getText())) {
                return bigInteger.multiply(new BigInteger(this.m_fldSize.getText()));
            }
            return this.m_fldSize.getNumber();
        }
        return this.m_fldSize.getNumber();
    }

    public void setNumber(Number number) {
        if (number != null) {
            this.setText(number.toString());
        } else {
            this.m_fldSize.setNumber(null);
            this.m_cmbByteMultiple.setSelectedIndex(0);
        }
    }

    public final void addChangeListener(ChangeListener changeListener) {
        this.m_listeners.add(changeListener);
    }

    public final void removeChangeListener(ChangeListener changeListener) {
        this.m_listeners.remove(changeListener);
    }

    protected void notifyListeners() {
        for (ChangeListener changeListener : this.m_listeners) {
            changeListener.chooserChanged(this);
        }
    }

    public Document getDocument() {
        return this.m_fldSize.getDocument();
    }

    public static interface ChangeListener {
        public void chooserChanged(AbstractSizeChooser var1);
    }
}

