/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jdeveloper.nbactions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import oracle.ide.Context;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.editor.EditorManager;
import oracle.ide.view.View;
import org.openide.actions.CopyAction;
import org.openide.actions.CutAction;
import org.openide.actions.DeleteAction;
import org.openide.actions.PasteAction;
import org.openide.actions.PopupAction;
import org.openide.actions.RedoAction;
import org.openide.actions.UndoAction;
import org.openide.filesystems.FileUtil;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;

public final class NbViewController
implements Controller {
    private final View view;
    private Component component;
    private Map<String, Action> idToNbAction;
    private Map<Action, IdeAction> nbToJDevAction;
    private Set<String> wellKnownIDs;
    private Map<String, Action> nbGlobalActions;
    private Action updating;
    private PropertyChangeListener actionListener;
    private Set<Action> listening;

    public static Controller createController(View view) {
        return new NbViewController(view);
    }

    private NbViewController(View view) {
        this.view = view;
    }

    private Lookup getLookup() {
        return (Lookup)this.view.getContext().getProperty(Lookup.class.getName());
    }

    private boolean isActive() {
        TopComponent currentTC = TopComponent.getRegistry().getActivated();
        if (currentTC != null) {
            Component comp = this.component != null ? this.component : this.view.getGUI();
            return currentTC.isAncestorOf(comp);
        }
        return false;
    }

    public boolean handleEvent(IdeAction action, Context context) {
        Action nbAction = this.findNbAction(action);
        if (nbAction != null) {
            nbAction.actionPerformed(new ActionEvent(context, 0, action.getCommand()));
            return true;
        }
        if (action.getCommandId() == 48 && nbAction == null) {
            boolean enabled = EditorManager.getEditorManager().handleEvent(action, context);
            action.setEnabled(enabled);
            return enabled;
        }
        return false;
    }

    public boolean update(IdeAction action, Context context) {
        Action nbAction = this.findNbAction(action);
        if (nbAction != null) {
            this.updating = nbAction;
            this.setupListener(nbAction);
            action.setEnabled(nbAction.isEnabled());
            this.updating = null;
        }
        if (action.getCommandId() == 48 && nbAction == null) {
            boolean enabled = EditorManager.getEditorManager().update(action, context);
            action.setEnabled(enabled);
            return enabled;
        }
        return nbAction != null;
    }

    private Action findNbAction(IdeAction jdevAction) {
        String actionId;
        Action nbAction;
        if (this.component == null) {
            this.component = this.view.getGUI();
        }
        if ((nbAction = this.getNbAction(actionId = Integer.toString(jdevAction.getCommandId()))) == null) {
            nbAction = (Action)FileUtil.getConfigObject((String)("JDeveloper/Actions/" + actionId + ".shadow"), Action.class);
            if (nbAction == null) {
                nbAction = this.getWellKnownAction(actionId);
            }
            if (nbAction instanceof ContextAwareAction) {
                nbAction = ((ContextAwareAction)nbAction).createContextAwareInstance(this.getLookup());
            }
            if (nbAction != null) {
                if (this.idToNbAction == null) {
                    this.idToNbAction = new HashMap<String, Action>();
                }
                this.idToNbAction.put(actionId, nbAction);
                if (this.nbToJDevAction == null) {
                    this.nbToJDevAction = new HashMap<Action, IdeAction>();
                }
                this.nbToJDevAction.put(nbAction, jdevAction);
            }
        }
        return nbAction;
    }

    private Action getNbAction(String id) {
        return this.idToNbAction != null ? this.idToNbAction.get(id) : null;
    }

    private IdeAction getJDevAction(Action nbAction) {
        return this.nbToJDevAction != null ? this.nbToJDevAction.get(nbAction) : null;
    }

    private void setupListener(Action nbAction) {
        if (this.actionListener == null) {
            this.actionListener = new ActionListener();
        }
        if (this.listening == null) {
            this.listening = new HashSet<Action>();
        }
        this.listen(nbAction, true);
    }

    private void listen(Action nbAction, boolean listen) {
        if (listen) {
            if (!this.listening.contains(nbAction)) {
                this.listening.add(nbAction);
                nbAction.addPropertyChangeListener(this.actionListener);
            }
        } else if (this.listening.contains(nbAction)) {
            this.listening.remove(nbAction);
            nbAction.removePropertyChangeListener(this.actionListener);
        }
    }

    private Action getWellKnownAction(String actionId) {
        if (this.wellKnownIDs == null) {
            this.wellKnownIDs = new HashSet<String>();
            this.wellKnownIDs.add(Integer.toString(5));
            this.wellKnownIDs.add(Integer.toString(6));
            this.wellKnownIDs.add(Integer.toString(17));
            this.wellKnownIDs.add(Integer.toString(18));
            this.wellKnownIDs.add(Integer.toString(19));
            this.wellKnownIDs.add(Integer.toString(20));
            this.wellKnownIDs.add(Integer.toString(50));
        }
        if (this.wellKnownIDs.contains(actionId)) {
            if (this.nbGlobalActions == null) {
                this.nbGlobalActions = new HashMap<String, Action>();
                this.nbGlobalActions.put(Integer.toString(5), (Action)SystemAction.get(UndoAction.class));
                this.nbGlobalActions.put(Integer.toString(6), (Action)SystemAction.get(RedoAction.class));
                this.nbGlobalActions.put(Integer.toString(17), (Action)SystemAction.get(CutAction.class));
                this.nbGlobalActions.put(Integer.toString(18), (Action)SystemAction.get(CopyAction.class));
                this.nbGlobalActions.put(Integer.toString(19), (Action)SystemAction.get(PasteAction.class));
                this.nbGlobalActions.put(Integer.toString(20), (Action)SystemAction.get(DeleteAction.class));
                this.nbGlobalActions.put(Integer.toString(50), (Action)SystemAction.get(PopupAction.class));
            }
            return this.nbGlobalActions.get(actionId);
        }
        return null;
    }

    private class ActionListener
    implements PropertyChangeListener {
        private ActionListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent ev) {
            IdeAction jdevAction;
            Object newValue;
            if (!(ev.getSource() instanceof Action)) {
                return;
            }
            Action nbAction = (Action)ev.getSource();
            if (nbAction == NbViewController.this.updating) {
                return;
            }
            if (!NbViewController.this.isActive()) {
                NbViewController.this.listen(nbAction, false);
            } else if ("enabled".equals(ev.getPropertyName()) && (newValue = ev.getNewValue()) instanceof Boolean && !newValue.equals(ev.getOldValue()) && (jdevAction = NbViewController.this.getJDevAction(nbAction)) != null) {
                jdevAction.setEnabled(((Boolean)ev.getNewValue()).booleanValue());
            }
        }
    }
}

