/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.inspector;

import java.awt.Component;
import java.awt.Container;
import oracle.bali.inspector.PropertyEditorFactory2;
import oracle.ide.inspector.CustomComponentHandler;
import oracle.ide.inspector.Orientation;
import oracle.ide.inspector.Properties;
import oracle.ide.inspector.PropertyEditorFinder;
import oracle.ide.inspector.PropertyEditorHandler;
import oracle.ide.inspector.PropertyEditorInfo;
import oracle.ide.inspector.PropertyEditorUpdater;
import oracle.ide.inspector.layout.CustomGUIComponent;

final class RenderingOptimizer {
    private Component withFocus;
    private PropertyEditorFactory2 factoryWithFocus;
    private final CustomComponentHandler customComponentHandler = new CustomComponentHandler();
    private final PropertyEditorHandler propertyEditorHandler = new PropertyEditorHandler();

    RenderingOptimizer() {
    }

    void ensureCorrectRendering() {
        this.customComponentHandler.ensureCustomComponentIsShown();
        this.propertyEditorHandler.ensureEditorComponentIsShown();
    }

    void updateCurrentCategory(String currentCategory) {
        this.customComponentHandler.currentCategory(currentCategory);
        this.propertyEditorHandler.currentCategory(currentCategory);
    }

    void addCustomComponent(Container customComponentContainer, Component customComponent, Container labelContainer) {
        this.customComponentHandler.addCustomComponent(customComponentContainer, customComponent, labelContainer);
    }

    void addPropertyEditorInfo(PropertyEditorInfo info) {
        this.propertyEditorHandler.addPropertyEditorInfo(info);
    }

    void addCustomGuiComponent(CustomGUIComponent c) {
        this.customComponentHandler.addCustomGuiComponent(c);
    }

    boolean hasPropertyEditors() {
        return this.propertyEditorHandler.hasEditors() || this.customComponentHandler.hasCustomComponents();
    }

    void update(Properties properties, PropertyEditorUpdater editorUpdater, Orientation orientation) {
        this.propertyEditorHandler.updatePropertyEditorsWithPropertyValues(properties, editorUpdater, orientation);
        this.customComponentHandler.triggerUpdateOnCustomComponents(properties.model());
    }

    void update(Properties properties, PropertyEditorFinder editorFinder, Orientation orientation) {
        this.propertyEditorHandler.updatePropertyEditorsWithPropertyValues(properties, editorFinder, this.withFocus, orientation);
        this.customComponentHandler.triggerUpdateOnCustomComponents(properties.model());
    }

    void updateIssues(Properties properties, Orientation orientation) {
        if (this.propertyEditorHandler == null) {
            return;
        }
        this.propertyEditorHandler.updateIssues(properties, orientation);
    }

    void clear() {
        this.withFocus = null;
        this.factoryWithFocus = null;
        this.customComponentHandler.clear();
        this.propertyEditorHandler.clear();
    }

    void updateComponentWithFocus(Component c, PropertyEditorFactory2 f) {
        this.withFocus = c;
        this.factoryWithFocus = f;
    }

    void applyValueFromFocusedComponent() {
        if (this.withFocus == null || this.factoryWithFocus == null) {
            return;
        }
        this.factoryWithFocus.applyValueFrom(this.withFocus);
    }

    Component componentWithFocus() {
        return this.withFocus;
    }
}

