/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.inspector;

import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import oracle.ide.inspector.ComponentMatcher;
import oracle.ide.inspector.EditorContainer;
import oracle.ide.inspector.LabelAndEditor;
import oracle.ide.inspector.Orientation;
import oracle.ide.inspector.Properties;
import oracle.ide.inspector.PropertyEditorFinder;
import oracle.ide.inspector.PropertyEditorInfo;
import oracle.ide.inspector.PropertyEditorUpdater;
import oracle.ide.inspector.PropertyInfo;
import oracle.ide.inspector.ScrollToVisibleFocusListeners;
import oracle.ide.inspector.ValidationIssues;
import oracle.javatools.util.ModelUtil;

final class PropertyEditorHandler {
    private final Map<String, PropertyEditorInfo> editorsByCategoryAndPropertyId = new LinkedHashMap<String, PropertyEditorInfo>();
    private final Map<String, Map<String, PropertyEditorInfo>> editorsByCategory = new LinkedHashMap<String, Map<String, PropertyEditorInfo>>();
    private final List<PropertyEditorInfo> allEditors = new ArrayList<PropertyEditorInfo>();
    private String currentCategory;

    PropertyEditorHandler() {
    }

    PropertyEditorHandler(String currentCategory) {
        this.currentCategory(currentCategory);
    }

    void addPropertyEditorInfo(PropertyEditorInfo propertyEditorInfo) {
        if (!this.editorsByCategory.containsKey(this.currentCategory)) {
            this.editorsByCategory.put(this.currentCategory, new LinkedHashMap());
        }
        Map<String, PropertyEditorInfo> editorsByIdOrRow = this.editorsByCategory.get(this.currentCategory);
        String propertyIdOrRow = this.propertyIdOrRowFrom(propertyEditorInfo);
        editorsByIdOrRow.put(propertyIdOrRow, propertyEditorInfo);
        this.editorsByCategoryAndPropertyId.put(this.currentCategory + "." + propertyIdOrRow, propertyEditorInfo);
        this.allEditors.add(propertyEditorInfo);
    }

    private String propertyIdOrRowFrom(PropertyEditorInfo propertyEditorInfo) {
        String propertyId = propertyEditorInfo.propertyId();
        if (!ModelUtil.hasLength((String)propertyId)) {
            propertyId = String.valueOf(propertyEditorInfo.row());
        }
        return propertyId;
    }

    void ensureEditorComponentIsShown() {
        if (!this.editorsByCategory.containsKey(this.currentCategory)) {
            return;
        }
        Map<String, PropertyEditorInfo> editorsByIdOrRow = this.editorsByCategory.get(this.currentCategory);
        for (Map.Entry<String, PropertyEditorInfo> entry : editorsByIdOrRow.entrySet()) {
            entry.getValue().addPropertyEditorToContainer();
        }
    }

    List<PropertyEditorInfo> propertyEditorInfoIn(String category) {
        ArrayList<PropertyEditorInfo> propertyIds = new ArrayList<PropertyEditorInfo>();
        for (Map.Entry<String, PropertyEditorInfo> entry : this.editorsByCategoryAndPropertyId.entrySet()) {
            if (!entry.getKey().startsWith(category + ".")) continue;
            propertyIds.add(entry.getValue());
        }
        return propertyIds;
    }

    boolean hasEditors() {
        return !this.editorsByCategoryAndPropertyId.isEmpty();
    }

    void clear() {
        this.editorsByCategory.clear();
        this.editorsByCategoryAndPropertyId.clear();
        for (PropertyEditorInfo e : this.allEditors) {
            e.labelAndEditor().editorContainer().clear();
        }
        this.allEditors.clear();
    }

    void updatePropertyEditorsWithPropertyValues(Properties properties, PropertyEditorUpdater editorUpdater, Orientation orientation) {
        for (Map.Entry<String, PropertyEditorInfo> entry : this.editorsByCategoryAndPropertyId.entrySet()) {
            PropertyEditorInfo editorInfo = entry.getValue();
            PropertyInfo property = this.propertyFrom(properties, editorInfo);
            if (property == null) continue;
            this.updatePropertyEditor(editorInfo, property, editorUpdater, orientation);
        }
    }

    void updatePropertyEditor(PropertyEditorInfo editorInfo, PropertyInfo property, PropertyEditorUpdater editorUpdater, Orientation orientation) {
        editorUpdater.update(editorInfo.labelAndEditor(), property, orientation);
        editorInfo.updateIcon(property.iconContainer());
    }

    void updatePropertyEditorsWithPropertyValues(Properties properties, PropertyEditorFinder editorFinder, Component focusOwner, Orientation orientation) {
        Component newFocusOwner = null;
        for (Map.Entry<String, PropertyEditorInfo> entry : this.editorsByCategoryAndPropertyId.entrySet()) {
            LabelAndEditor newLabelAndEditor;
            PropertyEditorInfo editorInfo = entry.getValue();
            PropertyInfo property = this.propertyFrom(properties, editorInfo);
            if (property == null) continue;
            EditorContainer current = editorInfo.labelAndEditor().editorContainer();
            Component foundNewFocusOwner = this.findNewFocusOwner(current, (newLabelAndEditor = editorFinder.editorFor(property, orientation)).editorContainer(), focusOwner);
            if (foundNewFocusOwner != null) {
                newFocusOwner = foundNewFocusOwner;
            }
            editorInfo.update(newLabelAndEditor, property.iconContainer());
        }
        this.ensureEditorComponentIsShown();
        this.focus(newFocusOwner, focusOwner);
    }

    void updateIssues(Properties properties, Orientation orientation) {
        for (Map.Entry<String, PropertyEditorInfo> entry : this.editorsByCategoryAndPropertyId.entrySet()) {
            PropertyEditorInfo editorInfo = entry.getValue();
            PropertyInfo property = this.propertyFrom(properties, editorInfo);
            if (property == null) continue;
            Component editor = editorInfo.labelAndEditor().editorContainer().editor();
            ValidationIssues.addValidationIssuesToEditor(editor, property, orientation);
        }
    }

    PropertyInfo propertyFrom(Properties properties, PropertyEditorInfo editorInfo) {
        String propertyId = editorInfo.propertyId();
        if (ModelUtil.hasLength((String)propertyId)) {
            return properties.propertyById(editorInfo.propertyId());
        }
        return properties.propertyByIndex(editorInfo.row());
    }

    private Component findNewFocusOwner(EditorContainer current, EditorContainer toVerify, Component focusOwner) {
        if (ComponentMatcher.deepMatches(current.editor(), focusOwner)) {
            return toVerify.editor();
        }
        if (ComponentMatcher.deepMatches((Component)((Object)current.customEditorButton()), focusOwner)) {
            return toVerify.customEditorButton();
        }
        return null;
    }

    private boolean focus(Component newFocusOwner, Component currentFocusOwner) {
        if (currentFocusOwner == null) {
            return false;
        }
        if (newFocusOwner == null) {
            this.focus(currentFocusOwner);
            return true;
        }
        if (currentFocusOwner.getClass().equals(newFocusOwner.getClass())) {
            this.focus(newFocusOwner);
            return true;
        }
        if (!(newFocusOwner instanceof Container)) {
            return false;
        }
        Container container = (Container)newFocusOwner;
        for (Component child : container.getComponents()) {
            if (!this.focus(child, currentFocusOwner)) continue;
            return true;
        }
        return false;
    }

    private void focus(Component c) {
        Window parent = SwingUtilities.getWindowAncestor(c);
        if (parent == null) {
            return;
        }
        ScrollToVisibleFocusListeners.disableAutoScroll(c);
    }

    void currentCategory(String newValue) {
        this.currentCategory = newValue;
    }
}

