/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.palette;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.MouseListener;
import java.util.Iterator;
import javax.swing.JComboBox;
import javax.swing.JScrollPane;
import oracle.ide.controls.VerticalFlowLayout;
import oracle.ide.palette.PalettePage;
import oracle.ideimpl.palette.CenterPanel;
import oracle.ideimpl.palette.IconPanel;
import oracle.ideimpl.palette.PaletteItemImpl;
import oracle.ideimpl.palette.PaletteItemUI;
import oracle.ideimpl.palette.model.Item;

public class VerticalPanel
extends IconPanel
implements MouseListener {
    private BorderLayout borderLayout1 = new BorderLayout();
    private JScrollPane _verticalScroll;
    private CenterPanel _middlePanel = new CenterPanel();

    public VerticalPanel(PalettePage palettePage) {
        super(palettePage);
        this._middlePanel.addMouseListener(this);
    }

    @Override
    public void setup(JComboBox box) {
        this._verticalScroll = new JScrollPane(this._middlePanel);
        this._verticalScroll.getVerticalScrollBar().setBlockIncrement(50);
        this._verticalScroll.getVerticalScrollBar().setUnitIncrement(20);
        this._verticalScroll.setBorder(null);
        this.setLayout(this.borderLayout1);
        this.add((Component)this._verticalScroll, "Center");
    }

    @Override
    void removeChildren() {
        this._middlePanel.removeAll();
    }

    @Override
    public void addIconLabels(boolean showLabel) {
        for (PaletteItemUI paletteBut : this.getIconList()) {
            if (showLabel) {
                paletteBut.setText(paletteBut.getItem().getShortLabel());
            } else {
                paletteBut.setText("");
            }
            this._middlePanel.add(paletteBut);
        }
    }

    @Override
    public void useListView(boolean listView) {
        this.setListView(listView);
        Iterator iter = this.getIconList().iterator();
        if (listView) {
            this._middlePanel.setLayout((LayoutManager)new VerticalFlowLayout(0, 0, 0, true, false));
            this.getPalettePage().setView("list");
        } else {
            this._middlePanel.setLayout(new FlowLayout(0));
            this.getPalettePage().setView("icon");
        }
        while (iter.hasNext()) {
            PaletteItemUI iconBtn = (PaletteItemUI)iter.next();
            if (listView) {
                iconBtn.setText(iconBtn.getItem().getShortLabel());
            } else {
                iconBtn.setText("");
            }
            if (iconBtn.getItem().getItem() == null || !iconBtn.getItem().getItem().getType().equals("jsptag")) continue;
            Object tooltip = iconBtn.getItem().getLongLabel();
            if (tooltip != null && ((String)tooltip).length() > 100) {
                String firstStr = ((String)tooltip).substring(0, 50);
                String lastStr = ((String)tooltip).substring(50, 100);
                String endStr = ((String)tooltip).substring(100);
                tooltip = firstStr + "<br>" + lastStr + "<br>" + endStr;
            }
            if (tooltip == null || ((String)tooltip).equals("No Info!")) {
                iconBtn.setToolTipText("<html><b>" + iconBtn.getItem().getItem().getInfo() + ":" + iconBtn.getItem().getShortLabel() + "</b></html>");
                continue;
            }
            iconBtn.setToolTipText("<html><b>" + iconBtn.getItem().getItem().getInfo() + ":" + iconBtn.getItem().getShortLabel() + "</b><br>" + (String)tooltip + "</html>");
        }
    }

    @Override
    public void addItem(Item item) {
        PaletteItemUI paletteItemUI = new PaletteItemUI(new PaletteItemImpl(item));
        this.getIconList().add(paletteItemUI);
        this._middlePanel.add(paletteItemUI);
        this.useListView(this.getListView());
    }

    @Override
    public void removeItem(Item item) {
        for (PaletteItemUI uiItem : this.getIconList()) {
            if (uiItem.getItem().getItem() != item) continue;
            this._middlePanel.remove(uiItem);
        }
    }

    @Override
    public void removeActiveItem() {
        this._middlePanel.remove(this._controller.getPaletteUI().getActivePaletteItemUI());
        this._middlePanel.repaint();
        this._middlePanel.validate();
    }

    @Override
    public void validateScroll() {
    }
}

