/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.scheduling;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import oracle.dbtools.crest.model.PropertiesObject;
import oracle.dbtools.crest.model.scheduling.Positioned;
import oracle.dbtools.crest.model.scheduling.SchedulerChainRule;
import oracle.dbtools.crest.model.scheduling.SchedulerObject;
import oracle.dbtools.crest.model.scheduling.SchedulerStep;

public class SchedulerChain
extends SchedulerObject {
    List<SchedulerStep> steps = new ArrayList<SchedulerStep>();
    List<SchedulerChainRule> rules = new ArrayList<SchedulerChainRule>();
    public static Comparator<Positioned> POSITION_COMPARATOR = Comparator.comparing(Positioned::getPosition);
    public static String STEPS = "steps";
    public static String RULES = "rules";
    public static final String NUMBER_OF_RULES = "NUMBER_OF_RULES";
    public static final String NUMBER_OF_STEPS = "NUMBER_OF_STEPS";

    @Override
    public void initPropsList() {
        this.propsList.add("OWNER");
        this.propsList.add("CHAIN_NAME");
        this.propsList.add("EVALUATION_INTERVAL");
        this.propsList.add("ENABLED");
        this.propsList.add("COMMENTS");
    }

    @Override
    public void initDataTypes() {
        this.dataTypes.put("OWNER", "VARCHAR2");
        this.dataTypes.put("CHAIN_NAME", "VARCHAR2");
        this.dataTypes.put("ENABLED", "BOOLEAN");
        this.dataTypes.put("EVALUATION_INTERVAL", "INTERVAL DAY(3) TO SECOND(0)");
        this.dataTypes.put("COMMENTS", "VARCHAR2");
    }

    @Override
    public void initdefaults() {
    }

    @Override
    public String getName() {
        return this.getProperty("CHAIN_NAME");
    }

    @Override
    public boolean isMinimumDefined() {
        String name = this.getName();
        return name != null && !name.isEmpty();
    }

    public List<SchedulerStep> getSteps() {
        return this.steps;
    }

    public List<SchedulerChainRule> getRules() {
        return this.rules;
    }

    @Override
    public List<PropertiesObject.CollectionDescriptor> getCollectionDescriptors() {
        ArrayList<PropertiesObject.CollectionDescriptor> list = new ArrayList<PropertiesObject.CollectionDescriptor>();
        PropertiesObject.CollectionDescriptor cd = new PropertiesObject.CollectionDescriptor();
        cd.name = STEPS;
        cd.coll = this::getSteps;
        list.add(cd);
        ArrayList rules = new ArrayList();
        cd = new PropertiesObject.CollectionDescriptor();
        cd.name = RULES;
        cd.coll = this::getRules;
        list.add(cd);
        return list;
    }

    @Override
    public SchedulerObject createObjectForCollection(String collName) {
        if (collName != null && STEPS.equalsIgnoreCase(collName)) {
            return new SchedulerStep();
        }
        if (collName != null && RULES.equalsIgnoreCase(collName)) {
            return new SchedulerChainRule();
        }
        return super.createObjectForCollection(collName);
    }

    @Override
    public void addObject(String collName, PropertiesObject obj) {
        if (collName != null && STEPS.equalsIgnoreCase(collName) && obj instanceof SchedulerStep) {
            this.steps.add((SchedulerStep)obj);
            return;
        }
        if (collName != null && RULES.equalsIgnoreCase(collName) && obj instanceof SchedulerChainRule) {
            this.rules.add((SchedulerChainRule)obj);
            return;
        }
        super.addObject(collName, obj);
    }

    public int getNumberOfStepsProperty() {
        String nsteps = this.getProperty(NUMBER_OF_STEPS);
        try {
            if (nsteps != null && !nsteps.isEmpty()) {
                return Integer.parseInt(nsteps);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 0;
    }

    public int getNumberOfRulesProperty() {
        String nrules = this.getProperty(NUMBER_OF_RULES);
        try {
            if (nrules != null && !nrules.isEmpty()) {
                return Integer.parseInt(nrules);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 0;
    }

    public void addStep(SchedulerStep step) {
        this.steps.add(step);
    }

    public void addRule(SchedulerChainRule rule) {
        this.rules.add(rule);
    }
}

