/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.reflect;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.common.reflect.Required;
import oracle.dbtools.common.reflect.RequiredClass;
import oracle.dbtools.common.reflect.RequiredMethod;
import oracle.dbtools.common.util.Collections;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.common.util.Reflections;

public class Requirements
implements Required {
    private final Iterable<Required> requirements;
    private final String targetClass;
    private final Class<?>[] targetDependencies;

    private Requirements(String targetClass, Class<?>[] targetDependencies, Iterable<Required> requirements) {
        this.targetClass = targetClass;
        this.targetDependencies = targetDependencies;
        this.requirements = requirements;
    }

    @Override
    public boolean available() {
        for (Required required : this.requirements) {
            if (required.available()) continue;
            return false;
        }
        return true;
    }

    public Object instantiate(Object ... dependencies) {
        if (this.available()) {
            Class<?> type = Reflections.clazz(this.targetClass);
            Constructor<?> ctor = Reflections.constructor(type, this.targetDependencies);
            return Reflections.newInstance(ctor, dependencies);
        }
        throw new IllegalStateException();
    }

    public String toString() {
        return Iterables.join(this.requirements, ", ");
    }

    public static Builder forClass(String name) {
        return new Builder(name);
    }

    public static class Builder {
        private final String name;
        private Class<?>[] dependencies = new Class[0];
        private final List<Required> requirements = new ArrayList<Required>();

        private Builder(String name) {
            this.name = name;
        }

        public Requirements build() {
            return new Requirements(this.name, this.dependencies, this.requirements);
        }

        public Builder clazz(String name) {
            this.requirements.add(new RequiredClass(name));
            return this;
        }

        public Builder method(String name, String ... parameterTypeNames) {
            RequiredClass clazz = null;
            Iterator<Required> iter = Collections.reverseIterator(this.requirements);
            while (iter.hasNext()) {
                Required required = iter.next();
                if (!(required instanceof RequiredClass)) continue;
                clazz = (RequiredClass)required;
                break;
            }
            if (clazz == null) {
                throw new IllegalStateException();
            }
            this.requirements.add(new RequiredMethod(clazz, name, parameterTypeNames));
            return this;
        }

        public Builder dependencies(Class<?> ... dependencies) {
            this.dependencies = dependencies;
            return this;
        }
    }
}

