/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.di;

import java.lang.annotation.Annotation;
import java.util.Comparator;
import java.util.TreeSet;
import oracle.dbtools.common.di.DependencyConstraints;
import oracle.dbtools.common.di.DependencyGraph;

class ServiceChooser {
    private final DependencyGraph providers;

    ServiceChooser(DependencyGraph providers) {
        this.providers = providers;
    }

    Iterable<Class<?>> choose(Class<?> type, DependencyConstraints constraints) {
        TreeSet matches = new TreeSet((Comparator<Class<?>>)((Object)DependencyGraph.priorityComparator()));
        for (Class<?> provider : this.providers.providers(type)) {
            Annotation[] annotations = provider.getDeclaredAnnotations();
            if (!constraints.matches(annotations)) continue;
            matches.add(provider);
        }
        return matches;
    }
}

