/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.syntax;

import oracle.olapi.syntax.Condition;
import oracle.olapi.syntax.SyntaxObject;
import oracle.olapi.syntax.SyntaxObjectVisitor;
import oracle.olapi.syntax.SyntaxPrintingContext;
import oracle.olapi.syntax.TypedExpression;
import oracle.olapi.syntax.ValidationContext;

public final class BetweenCondition
extends Condition {
    private TypedExpression m_BaseExpression;
    private TypedExpression m_StartExpression;
    private TypedExpression m_EndExpression;
    private boolean m_Negated = false;

    @Override
    void toSyntax(SyntaxPrintingContext syntaxPrintingContext) {
        syntaxPrintingContext.print(this.getBaseExpression());
        if (this.isNegated()) {
            syntaxPrintingContext.append(" NOT");
        }
        syntaxPrintingContext.append(" BETWEEN ");
        syntaxPrintingContext.print(this.getStartExpression());
        syntaxPrintingContext.append(" AND ");
        syntaxPrintingContext.print(this.getEndExpression());
    }

    @Override
    public SyntaxObject validate(ValidationContext validationContext) {
        validationContext.push(this);
        this.m_BaseExpression = validationContext.validateExp(this.m_BaseExpression);
        this.m_StartExpression = validationContext.validateExp(this.m_StartExpression);
        this.m_EndExpression = validationContext.validateExp(this.m_EndExpression);
        validationContext.pop();
        return this;
    }

    @Override
    protected boolean checkIfDefinitionIsComplete() {
        return this.getBaseExpression().isDefinitionComplete() && this.getStartExpression().isDefinitionComplete() && this.getEndExpression().isDefinitionComplete();
    }

    public BetweenCondition(TypedExpression typedExpression, TypedExpression typedExpression2, TypedExpression typedExpression3, boolean bl) {
        BetweenCondition.validateValue(typedExpression);
        BetweenCondition.validateValue(typedExpression2);
        BetweenCondition.validateValue(typedExpression3);
        this.m_BaseExpression = typedExpression;
        this.m_StartExpression = typedExpression2;
        this.m_EndExpression = typedExpression3;
        this.m_Negated = bl;
        this.initialize();
    }

    public BetweenCondition(TypedExpression typedExpression, TypedExpression typedExpression2, TypedExpression typedExpression3) {
        this(typedExpression, typedExpression2, typedExpression3, false);
    }

    @Override
    public Object visit(SyntaxObjectVisitor syntaxObjectVisitor, Object object) {
        return syntaxObjectVisitor.visitBetweenCondition(this, object);
    }

    public TypedExpression getBaseExpression() {
        return this.m_BaseExpression;
    }

    public TypedExpression getStartExpression() {
        return this.m_StartExpression;
    }

    public TypedExpression getEndExpression() {
        return this.m_EndExpression;
    }

    public boolean isNegated() {
        return this.m_Negated;
    }
}

