/*
 * Decompiled with CFR 0.152.
 */
package org.strategoxt.lang;

import java.lang.management.ManagementFactory;
import java.lang.ref.WeakReference;
import org.spoofax.interpreter.core.StackTracer;

public class UncaughtExceptionHandler {
    private final WeakReference<StackTracer> stackTracer;
    private final ActualHandler handler = new ActualHandler();
    private static final ThreadLocal<Thread.UncaughtExceptionHandler> originalHandler = new ThreadLocal();
    private boolean enabled;
    private boolean dumpedError;

    public UncaughtExceptionHandler(StackTracer stackTracer) {
        this.stackTracer = new WeakReference<StackTracer>(stackTracer);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean value) {
        if (value) {
            this.enable();
        } else {
            this.disable();
        }
    }

    private void enable() {
        if (!this.enabled) {
            this.enabled = true;
            if (!(Thread.currentThread().getUncaughtExceptionHandler() instanceof UncaughtExceptionHandler)) {
                originalHandler.set(Thread.currentThread().getUncaughtExceptionHandler());
            }
            Thread.currentThread().setUncaughtExceptionHandler(this.handler);
            Runtime.getRuntime().addShutdownHook(this.handler);
        }
    }

    private void disable() {
        if (this.enabled) {
            this.enabled = false;
            try {
                Thread.currentThread().setUncaughtExceptionHandler(originalHandler.get());
                Runtime.getRuntime().removeShutdownHook(this.handler);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    protected synchronized boolean dumpError(String startMessage) {
        if (this.dumpedError) {
            return true;
        }
        StackTracer tracer = (StackTracer)this.stackTracer.get();
        if (tracer != null && tracer.getTraceDepth(true) > 0) {
            if (startMessage != null) {
                System.err.println(startMessage);
            }
            try {
                tracer.printStackTrace(true);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            this.dumpedError = true;
        } else {
            this.dumpedError = false;
        }
        return this.dumpedError;
    }

    private class ActualHandler
    extends Thread
    implements Thread.UncaughtExceptionHandler {
        private ActualHandler() {
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            if (e instanceof StackOverflowError && UncaughtExceptionHandler.this.dumpError("Fatal error at")) {
                if (this.isStackTuned()) {
                    System.err.println("Stack overflow.");
                } else {
                    System.err.println("Stack overflow (use java -ss4m to increase the stack size)");
                }
            } else {
                UncaughtExceptionHandler.this.dumpError("Fatal error at");
            }
            Thread.UncaughtExceptionHandler handler = (Thread.UncaughtExceptionHandler)originalHandler.get();
            if (handler != null) {
                handler.uncaughtException(t, e);
            }
        }

        private boolean isStackTuned() {
            for (String arg : ManagementFactory.getRuntimeMXBean().getInputArguments()) {
                if (!arg.startsWith("-Xss") && !arg.startsWith("-ss")) continue;
                return true;
            }
            return false;
        }

        @Override
        public void run() {
            UncaughtExceptionHandler.this.dumpError("Aborted at");
        }
    }

    static class Finalizer {
        final WeakReference<UncaughtExceptionHandler> handler;

        public Finalizer(UncaughtExceptionHandler handler) {
            this.handler = new WeakReference<UncaughtExceptionHandler>(handler);
        }

        protected void finalize() throws Throwable {
            UncaughtExceptionHandler handler = (UncaughtExceptionHandler)this.handler.get();
            if (handler != null) {
                handler.setEnabled(false);
            }
        }
    }
}

