/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.library.jsglr.origin;

import org.spoofax.interpreter.core.IContext;
import org.spoofax.interpreter.library.AbstractPrimitive;
import org.spoofax.interpreter.stratego.Strategy;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.jsglr.client.imploder.ImploderAttachment;
import org.spoofax.terms.StrategoAppl;
import org.spoofax.terms.attachments.OriginAttachment;
import org.spoofax.terms.attachments.ParentAttachment;

public class OriginTermFuzzyPrimitive
extends AbstractPrimitive {
    public OriginTermFuzzyPrimitive() {
        super("SSL_EXT_origin_term_fuzzy", 0, 1);
    }

    @Override
    public boolean call(IContext env, Strategy[] svars, IStrategoTerm[] tvars) {
        if (tvars.length != 1 || svars.length != 0) {
            return false;
        }
        IStrategoTerm term = tvars[0];
        IStrategoTerm originTerm = OriginAttachment.getOrigin(term);
        if (originTerm != null) {
            env.setCurrent(originTerm);
            return true;
        }
        if (!(term instanceof StrategoAppl)) {
            return false;
        }
        int i = 0;
        while (i < term.getSubtermCount()) {
            IStrategoTerm parent;
            IStrategoTerm originSubTerm = OriginAttachment.getOrigin(term.getSubterm(i));
            if (originSubTerm != null && this.isOriginRelatedFuzzy(term, parent = ParentAttachment.getParent(originSubTerm))) {
                env.setCurrent(parent);
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isOriginRelatedFuzzy(IStrategoTerm term, IStrategoTerm parent) {
        return parent != null && ImploderAttachment.hasImploderOrigin(parent) && parent.getSubtermCount() == term.getSubtermCount() && parent instanceof StrategoAppl && term instanceof StrategoAppl && ((StrategoAppl)parent).getConstructor().equals(((StrategoAppl)term).getConstructor());
    }
}

