/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.spoofax.core.config;

import java.util.Collection;
import java.util.Optional;
import mb.nabl2.config.NaBL2Config;
import mb.statix.spoofax.IStatixProjectConfig;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.ImmutableConfiguration;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.metaborg.core.config.IExportConfig;
import org.metaborg.core.config.ISourceConfig;
import org.metaborg.core.config.ProjectConfig;
import org.metaborg.core.language.LanguageIdentifier;
import org.metaborg.core.messages.IMessage;
import org.metaborg.core.messages.MessageBuilder;
import org.metaborg.spoofax.core.build.SpoofaxDefaultSources;
import org.metaborg.spoofax.core.config.ISpoofaxProjectConfig;
import org.metaborg.spoofax.core.config.language.NaBL2ConfigReaderWriter;
import org.metaborg.spoofax.core.config.language.StatixProjectConfigReaderWriter;

public class SpoofaxProjectConfig
extends ProjectConfig
implements ISpoofaxProjectConfig {
    private static final String PROP_RUNTIME = "runtime";
    private static final String PROP_NABL2 = "runtime.nabl2";
    private static final String PROP_STATIX = "runtime.statix";
    private volatile NaBL2Config nabl2Config = null;
    private volatile IStatixProjectConfig statixConfig = null;

    public SpoofaxProjectConfig(HierarchicalConfiguration<ImmutableNode> config) {
        super(config);
    }

    protected SpoofaxProjectConfig(HierarchicalConfiguration<ImmutableNode> config, String metaborgVersion, Collection<IExportConfig> sources, Collection<LanguageIdentifier> compileDeps, Collection<LanguageIdentifier> sourceDeps, Collection<LanguageIdentifier> javaDeps, NaBL2Config nabl2Config, IStatixProjectConfig statixConfig) {
        super(config, metaborgVersion, sources, compileDeps, sourceDeps, javaDeps);
        if (nabl2Config != null) {
            Optional.ofNullable(this.configurationAt(PROP_NABL2, true)).ifPresent(c -> NaBL2ConfigReaderWriter.write(nabl2Config, (HierarchicalConfiguration<ImmutableNode>)c));
        }
        if (statixConfig != null) {
            Optional.ofNullable(this.configurationAt(PROP_STATIX, true)).ifPresent(c -> StatixProjectConfigReaderWriter.write(statixConfig, (HierarchicalConfiguration<ImmutableNode>)c));
        }
    }

    @Override
    public Collection<ISourceConfig> sources() {
        Collection<ISourceConfig> sources = super.sources();
        if (sources.isEmpty()) {
            return SpoofaxDefaultSources.DEFAULT_SPOOFAX_SOURCES;
        }
        return sources;
    }

    @Override
    public NaBL2Config nabl2Config() {
        NaBL2Config result = this.nabl2Config;
        if (result == null) {
            this.nabl2Config = result = Optional.ofNullable(this.configurationAt(PROP_NABL2, false)).map(NaBL2ConfigReaderWriter::read).orElse(NaBL2Config.DEFAULT);
        }
        return result;
    }

    @Override
    public IStatixProjectConfig statixConfig() {
        IStatixProjectConfig result = this.statixConfig;
        if (result == null) {
            this.statixConfig = result = Optional.ofNullable(this.configurationAt(PROP_STATIX, false)).map(StatixProjectConfigReaderWriter::read).orElse(IStatixProjectConfig.NULL);
        }
        return result;
    }

    @Override
    public Collection<IMessage> validate(MessageBuilder mb) {
        Collection<IMessage> messages = super.validate(mb);
        Optional.ofNullable(this.configurationAt(PROP_NABL2, false)).ifPresent(c -> messages.addAll(NaBL2ConfigReaderWriter.validate((ImmutableConfiguration)c, mb)));
        return messages;
    }
}

