/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.core.config;

import com.google.inject.Inject;
import java.util.Collection;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.metaborg.core.config.AConfigService;
import org.metaborg.core.config.AConfigurationReaderWriter;
import org.metaborg.core.config.ConfigRequest;
import org.metaborg.core.config.IConfig;
import org.metaborg.core.config.ILanguageComponentConfig;
import org.metaborg.core.config.ILanguageComponentConfigService;
import org.metaborg.core.config.ILanguageComponentConfigWriter;
import org.metaborg.core.config.LanguageComponentConfig;
import org.metaborg.core.config.LanguageComponentConfigBuilder;
import org.metaborg.core.config.ProjectConfig;
import org.metaborg.core.language.ILanguageComponent;
import org.metaborg.core.messages.IMessage;
import org.metaborg.core.messages.MessageBuilder;

public class LanguageComponentConfigService
extends AConfigService<ILanguageComponent, ILanguageComponentConfig>
implements ILanguageComponentConfigService,
ILanguageComponentConfigWriter {
    private final LanguageComponentConfigBuilder configBuilder;

    @Inject
    public LanguageComponentConfigService(AConfigurationReaderWriter configReaderWriter, LanguageComponentConfigBuilder configBuilder) {
        super(configReaderWriter);
        this.configBuilder = configBuilder;
    }

    @Override
    protected FileObject getRootDirectory(ILanguageComponent languageComponent) throws FileSystemException {
        return languageComponent.location();
    }

    @Override
    protected FileObject getConfigFile(FileObject rootFolder) throws FileSystemException {
        return rootFolder.resolveFile("src-gen/metaborg.component.yaml");
    }

    @Override
    protected ConfigRequest<ILanguageComponentConfig> toConfig(HierarchicalConfiguration<ImmutableNode> config, FileObject configFile) {
        ProjectConfig projectConfig = new ProjectConfig(config);
        LanguageComponentConfig languageComponentConfig = new LanguageComponentConfig(config, projectConfig);
        MessageBuilder mb = MessageBuilder.create().asError().asInternal().withSource(configFile);
        Collection<IMessage> messages = languageComponentConfig.validate(mb);
        return new ConfigRequest<ILanguageComponentConfig>(languageComponentConfig, messages);
    }

    @Override
    protected HierarchicalConfiguration<ImmutableNode> fromConfig(ILanguageComponentConfig config) {
        if (!(config instanceof IConfig)) {
            this.configBuilder.reset();
            this.configBuilder.copyFrom(config);
            config = this.configBuilder.build(null);
        }
        return ((IConfig)((Object)config)).getConfig();
    }
}

