/*
 * Decompiled with CFR 0.152.
 */
package mb.scopegraph.pepm16.esop15.lazy;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.usethesource.capsule.Set;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Optional;
import mb.scopegraph.pepm16.CriticalEdgeException;
import mb.scopegraph.pepm16.ILabel;
import mb.scopegraph.pepm16.IOccurrence;
import mb.scopegraph.pepm16.IScope;
import mb.scopegraph.pepm16.esop15.lazy.IEsopEnv;
import mb.scopegraph.pepm16.path.IDeclPath;
import mb.scopegraph.pepm16.path.IPath;
import mb.scopegraph.pepm16.path.IResolutionPath;
import mb.scopegraph.pepm16.terms.path.Paths;
import org.metaborg.util.collection.CapsuleUtil;
import org.metaborg.util.task.ICancel;
import org.metaborg.util.task.NullCancel;

public class EsopEnvs {
    public static <S extends IScope, L extends ILabel, O extends IOccurrence, P extends IPath<S, L, O>> IEsopEnv<S, L, O, P> guarded(final EnvProvider<S, L, O, P> provider) {
        return new IEsopEnv<S, L, O, P>(){
            private static final long serialVersionUID = 42L;
            private IEsopEnv<S, L, O, P> env = null;

            private IEsopEnv<S, L, O, P> env() throws CriticalEdgeException, InterruptedException {
                if (this.env == null) {
                    this.env = provider.apply();
                }
                return this.env;
            }

            @Override
            public Collection<P> get(ICancel cancel) throws CriticalEdgeException, InterruptedException {
                return this.env().get(cancel);
            }

            public String toString() {
                StringBuilder sb = new StringBuilder();
                sb.append("#");
                try {
                    sb.append(this.env().toString());
                }
                catch (InterruptedException | CriticalEdgeException e) {
                    sb.append("?");
                }
                return sb.toString();
            }
        };
    }

    public static <S extends IScope, L extends ILabel, O extends IOccurrence, P extends IPath<S, L, O>> IEsopEnv<S, L, O, P> lazy(final LazyEnv<S, L, O, P> provider) {
        return new IEsopEnv<S, L, O, P>(){
            private static final long serialVersionUID = 42L;
            private IEsopEnv<S, L, O, P> env = null;

            private IEsopEnv<S, L, O, P> env(ICancel cancel) throws InterruptedException, CriticalEdgeException {
                if (this.env == null) {
                    this.env = provider.apply(cancel);
                }
                return this.env;
            }

            @Override
            public Collection<P> get(ICancel cancel) throws CriticalEdgeException, InterruptedException {
                return this.env(cancel).get(cancel);
            }

            public String toString() {
                StringBuilder sb = new StringBuilder();
                sb.append("~");
                try {
                    sb.append(this.env(new NullCancel()));
                }
                catch (InterruptedException | CriticalEdgeException e) {
                    sb.append("?");
                }
                return sb.toString();
            }
        };
    }

    public static <S extends IScope, L extends ILabel, O extends IOccurrence, P extends IPath<S, L, O>> IEsopEnv<S, L, O, P> init(Iterable<P> paths) {
        return new IEsopEnv<S, L, O, P>(paths){
            private static final long serialVersionUID = 42L;
            private Collection<P> _paths;
            {
                this._paths = CapsuleUtil.toSet(iterable);
            }

            @Override
            public Collection<P> get(ICancel cancel) throws InterruptedException {
                return this._paths;
            }

            public String toString() {
                return this._paths.toString();
            }
        };
    }

    @SafeVarargs
    public static <S extends IScope, L extends ILabel, O extends IOccurrence, P extends IPath<S, L, O>> IEsopEnv<S, L, O, P> shadow(final IEsopEnv.Filter<S, L, O, P> filter, IEsopEnv<S, L, O, P> ... envs) {
        return new IEsopEnv<S, L, O, P>(envs){
            private static final long serialVersionUID = 42L;
            private final Deque<IEsopEnv<S, L, O, P>> _envs;
            private final Collection<Object> _shadowed;
            private final Set.Transient<P> _paths;
            private Collection<P> paths;
            {
                this._envs = Lists.newLinkedList(Arrays.asList(iEsopEnvArray));
                this._shadowed = Sets.newHashSet();
                this._paths = Set.Transient.of();
                this.paths = null;
            }

            private Collection<P> env(ICancel cancel) throws CriticalEdgeException, InterruptedException {
                if (this.paths != null) {
                    return this.paths;
                }
                Iterator it = this._envs.iterator();
                while (it.hasNext()) {
                    cancel.throwIfCancelled();
                    IEsopEnv env = it.next();
                    Collection pts = env.get(cancel);
                    for (IPath p : pts) {
                        cancel.throwIfCancelled();
                        if (this._shadowed.contains(filter.matchToken(p))) continue;
                        this._paths.__insert((Object)p);
                    }
                    for (IPath p : pts) {
                        cancel.throwIfCancelled();
                        this._shadowed.add(filter.matchToken(p));
                    }
                    it.remove();
                    if (filter.shortCircuit() && !this._paths.isEmpty()) break;
                }
                this.paths = this._paths.freeze();
                return this.paths;
            }

            @Override
            public Collection<P> get(ICancel cancel) throws CriticalEdgeException, InterruptedException {
                return this.env(cancel);
            }

            public String toString() {
                StringBuilder sb = new StringBuilder();
                sb.append("(");
                sb.append(this.paths != null ? this.paths : this._paths);
                this._envs.stream().forEach(e -> {
                    sb.append(" <| ");
                    sb.append(e);
                });
                sb.append(")");
                return sb.toString();
            }
        };
    }

    public static <S extends IScope, L extends ILabel, O extends IOccurrence, P extends IPath<S, L, O>> IEsopEnv<S, L, O, P> union(Iterable<IEsopEnv<S, L, O, P>> envs) {
        return new IEsopEnv<S, L, O, P>(envs){
            private static final long serialVersionUID = 42L;
            private final LinkedList<IEsopEnv<S, L, O, P>> _envs;
            private final Set.Transient<P> _paths;
            private Collection<P> paths;
            {
                this._envs = Lists.newLinkedList((Iterable)iterable);
                this._paths = Set.Transient.of();
                this.paths = null;
            }

            private Collection<P> env(ICancel cancel) throws CriticalEdgeException, InterruptedException {
                if (this.paths != null) {
                    return this.paths;
                }
                ArrayList es = Lists.newArrayList();
                Iterator it = this._envs.iterator();
                while (it.hasNext()) {
                    IEsopEnv env = (IEsopEnv)it.next();
                    try {
                        Collection pts = env.get(cancel);
                        for (IPath p : pts) {
                            this._paths.__insert((Object)p);
                        }
                        it.remove();
                    }
                    catch (CriticalEdgeException e) {
                        es.add(e);
                    }
                }
                if (!es.isEmpty()) {
                    throw CriticalEdgeException.of(es);
                }
                this.paths = this._paths.freeze();
                return this.paths;
            }

            @Override
            public Collection<P> get(ICancel cancel) throws CriticalEdgeException, InterruptedException {
                return this.env(cancel);
            }

            public String toString() {
                StringBuilder sb = new StringBuilder();
                sb.append("(");
                sb.append(this.paths != null ? this.paths : this._paths);
                this._envs.stream().forEach(e -> {
                    sb.append(" U ");
                    sb.append(e);
                });
                sb.append(")");
                return sb.toString();
            }
        };
    }

    public static <S extends IScope, L extends ILabel, O extends IOccurrence, P extends IPath<S, L, O>> IEsopEnv<S, L, O, P> empty() {
        return new IEsopEnv<S, L, O, P>(){
            private static final long serialVersionUID = 42L;

            @Override
            public Collection<P> get(ICancel cancel) throws InterruptedException {
                return Collections.emptyList();
            }

            public String toString() {
                return "{}";
            }
        };
    }

    public static <S extends IScope, L extends ILabel, O extends IOccurrence> IEsopEnv.Filter<S, L, O, IResolutionPath<S, L, O>> resolutionFilter(final O ref) {
        return new IEsopEnv.Filter<S, L, O, IResolutionPath<S, L, O>>(){
            private static final long serialVersionUID = 42L;

            @Override
            public Optional<IResolutionPath<S, L, O>> test(IDeclPath<S, L, O> path) {
                return Paths.resolve(ref, path);
            }

            @Override
            public Object matchToken(IResolutionPath<S, L, O> p) {
                return p.getDeclaration().getSpacedName();
            }

            @Override
            public boolean shortCircuit() {
                return true;
            }
        };
    }

    public static <S extends IScope, L extends ILabel, O extends IOccurrence> IEsopEnv.Filter<S, L, O, IDeclPath<S, L, O>> envFilter() {
        return new IEsopEnv.Filter<S, L, O, IDeclPath<S, L, O>>(){
            private static final long serialVersionUID = 42L;

            @Override
            public Optional<IDeclPath<S, L, O>> test(IDeclPath<S, L, O> path) {
                return Optional.of(path);
            }

            @Override
            public Object matchToken(IDeclPath<S, L, O> p) {
                return p.getDeclaration().getSpacedName();
            }

            @Override
            public boolean shortCircuit() {
                return false;
            }
        };
    }

    static interface EnvProvider<S extends IScope, L extends ILabel, O extends IOccurrence, P extends IPath<S, L, O>> {
        public IEsopEnv<S, L, O, P> apply() throws CriticalEdgeException, InterruptedException;
    }

    static interface LazyEnv<S extends IScope, L extends ILabel, O extends IOccurrence, P extends IPath<S, L, O>> {
        public IEsopEnv<S, L, O, P> apply(ICancel var1) throws CriticalEdgeException, InterruptedException;
    }
}

