/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.terms.stratego;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import mb.nabl2.terms.IApplTerm;
import mb.nabl2.terms.IAttachments;
import mb.nabl2.terms.IListTerm;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.ListTerms;
import mb.nabl2.terms.Terms;
import mb.nabl2.terms.build.TermBuild;
import mb.nabl2.terms.stratego.PlaceholderVarMap;
import mb.nabl2.terms.stratego.StrategoAnnotations;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoConstructor;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.terms.util.TermUtils;

public final class StrategoPlaceholders {
    private static final String PLACEHOLDER_SUFFIX = "-Plhdr";

    private StrategoPlaceholders() {
    }

    public static boolean isLiteralVar(ITerm term) {
        return term.match(Terms.casesFix((m, appl) -> {
            if (!StrategoPlaceholders.isInjectionConstructor(appl)) {
                return false;
            }
            return StrategoPlaceholders.isLiteralVar(appl.getArgs().get(0));
        }, (m, list) -> list.match(ListTerms.casesFix((lm, cons) -> false, (lm, nil) -> false, (lm, var) -> false)), (m, string) -> false, (m, integer) -> false, (m, blob) -> false, (m, var) -> StrategoPlaceholders.isLiteralSort(StrategoPlaceholders.getSortFromAttachments(var.getAttachments()))));
    }

    public static boolean containsLiteralVar(ITerm term) {
        return term.match(Terms.casesFix((m, appl) -> {
            if (StrategoPlaceholders.isPlaceholder(appl)) {
                return StrategoPlaceholders.isLiteralSort(StrategoPlaceholders.getSortFromAttachments(appl.getAttachments()));
            }
            return appl.getArgs().stream().anyMatch(a -> (Boolean)a.match(m));
        }, (m, list) -> list.match(ListTerms.casesFix((lm, cons) -> (Boolean)cons.getHead().match(m) != false || (Boolean)cons.getTail().match(lm) != false, (lm, nil) -> false, (lm, var) -> StrategoPlaceholders.isLiteralSort(StrategoPlaceholders.getSortFromAttachments(var.getAttachments())))), (m, string) -> false, (m, integer) -> false, (m, blob) -> false, (m, var) -> StrategoPlaceholders.isLiteralSort(StrategoPlaceholders.getSortFromAttachments(var.getAttachments()))));
    }

    @Nullable
    private static IStrategoTerm getSortFromAttachments(IAttachments attachments) {
        StrategoAnnotations annotations = attachments.get(StrategoAnnotations.class);
        if (annotations == null) {
            return null;
        }
        return StrategoPlaceholders.getSortFromAnnotations(annotations.getAnnotationList());
    }

    @Nullable
    private static IStrategoTerm getSortFromAnnotations(List<IStrategoTerm> annotations) {
        for (IStrategoTerm term : annotations) {
            if (!TermUtils.isAppl(term, "OfSort", 1)) continue;
            return term.getSubterm(0);
        }
        return null;
    }

    private static boolean isLiteralSort(@Nullable IStrategoTerm term) {
        if (term == null) {
            return false;
        }
        if (!TermUtils.isAppl(term)) {
            throw new UnsupportedOperationException("Unknown sort: " + term);
        }
        IStrategoAppl appl = TermUtils.toAppl(term);
        switch (appl.getConstructor().getName()) {
            case "STRING": {
                return true;
            }
            case "OCCURRENCE": 
            case "LIST": 
            case "PATH": 
            case "SORT": 
            case "SCOPE": {
                return false;
            }
        }
        throw new UnsupportedOperationException("Unknown sort: " + term);
    }

    public static boolean isPlaceholder(IStrategoAppl term) {
        IStrategoConstructor constructor = term.getConstructor();
        return constructor.getName().endsWith(PLACEHOLDER_SUFFIX) && constructor.getArity() == 0;
    }

    public static boolean isPlaceholder(IStrategoTerm term) {
        return term instanceof IStrategoAppl && StrategoPlaceholders.isPlaceholder((IStrategoAppl)term);
    }

    public static boolean isPlaceholder(IApplTerm term) {
        return term.getOp().endsWith(PLACEHOLDER_SUFFIX) && term.getArity() == 0;
    }

    public static boolean isPlaceholder(ITerm term) {
        return term instanceof IApplTerm && StrategoPlaceholders.isPlaceholder((IApplTerm)term);
    }

    public static ITerm replacePlaceholdersByVariables(ITerm term, PlaceholderVarMap placeholderVarMap) {
        return term.match(Terms.casesFix((m, appl) -> {
            if (StrategoPlaceholders.isPlaceholder(appl)) {
                return placeholderVarMap.addPlaceholderMapping((IApplTerm)appl);
            }
            return TermBuild.B.newAppl(appl.getOp(), appl.getArgs().stream().map(a -> (ITerm)a.match(m)).collect(Collectors.toList()), appl.getAttachments());
        }, (m, list) -> list.match(ListTerms.casesFix((lm, cons) -> TermBuild.B.newCons((ITerm)cons.getHead().match(m), (IListTerm)cons.getTail().match(lm), cons.getAttachments()), (lm, nil) -> nil, (lm, var) -> var)), (m, string) -> string, (m, integer) -> integer, (m, blob) -> blob, (m, var) -> var));
    }

    public static ITerm replaceVariablesByPlaceholders(ITerm term, PlaceholderVarMap placeholderVarMap) {
        return term.match(Terms.cases(appl -> {
            if (StrategoPlaceholders.isInjectionConstructor(appl) && StrategoPlaceholders.onlyInjectionConstructorsAndVariables(appl)) {
                return StrategoPlaceholders.getPlaceholderForTerm(appl);
            }
            return TermBuild.B.newAppl(appl.getOp(), appl.getArgs().stream().map(a -> StrategoPlaceholders.replaceVariablesByPlaceholders(a, placeholderVarMap)).collect(Collectors.toList()), appl.getAttachments());
        }, list -> StrategoPlaceholders.replaceVariablesByPlaceholdersInList(list, placeholderVarMap), string -> string, integer -> integer, blob -> blob, var -> StrategoPlaceholders.getPlaceholderForVar(var, placeholderVarMap)));
    }

    public static IListTerm replaceVariablesByPlaceholdersInList(IListTerm term, PlaceholderVarMap placeholderVarMap) {
        return term.match(ListTerms.cases(cons -> TermBuild.B.newCons(StrategoPlaceholders.replaceVariablesByPlaceholders(cons.getHead(), placeholderVarMap), StrategoPlaceholders.replaceVariablesByPlaceholdersInList(cons.getTail(), placeholderVarMap), cons.getAttachments()), nil -> nil, var -> TermBuild.B.newCons(StrategoPlaceholders.replaceVariablesByPlaceholders(var, placeholderVarMap), TermBuild.B.newNil())));
    }

    public static ITerm replaceListVariablesByEmptyList(ITerm term) {
        return term.match(Terms.cases(appl -> TermBuild.B.newAppl(appl.getOp(), appl.getArgs().stream().map(StrategoPlaceholders::replaceListVariablesByEmptyList).collect(Collectors.toList()), appl.getAttachments()), list -> StrategoPlaceholders.replaceListVariablesByEmptyListInList(list), string -> string, integer -> integer, blob -> blob, var -> var));
    }

    public static IListTerm replaceListVariablesByEmptyListInList(IListTerm term) {
        return term.match(ListTerms.cases(cons -> TermBuild.B.newCons(StrategoPlaceholders.replaceListVariablesByEmptyList(cons.getHead()), StrategoPlaceholders.replaceListVariablesByEmptyListInList(cons.getTail()), cons.getAttachments()), nil -> nil, var -> TermBuild.B.newNil()));
    }

    public static boolean isInjectionConstructor(ITerm term) {
        return term instanceof IApplTerm && StrategoPlaceholders.isInjectionConstructor((IApplTerm)term);
    }

    public static boolean isInjectionConstructor(IApplTerm appl) {
        return appl.getOp().contains("2") && appl.getArgs().size() == 1 && appl.getArgs().get(0) instanceof ITermVar;
    }

    public static String getInjectionSortName(IApplTerm appl) {
        assert (StrategoPlaceholders.isInjectionConstructor(appl));
        String op = appl.getOp();
        return op.substring(0, op.indexOf(50));
    }

    public static ITermVar getInjectionArgument(IApplTerm appl) {
        assert (StrategoPlaceholders.isInjectionConstructor(appl));
        return (ITermVar)appl.getArgs().get(0);
    }

    public static boolean onlyInjectionConstructorsAndVariables(ITerm term) {
        return term.match(Terms.cases(appl -> {
            if (!StrategoPlaceholders.isInjectionConstructor(appl)) {
                return false;
            }
            return appl.getArgs().stream().allMatch(StrategoPlaceholders::onlyInjectionConstructorsAndVariables);
        }, list -> false, string -> false, integer -> false, blob -> false, var -> true));
    }

    public static int countCommonInjectionConstructors(List<ITerm> terms) {
        if (terms.isEmpty()) {
            return 0;
        }
        int level = 0;
        ArrayList<ITerm> currentTerms = new ArrayList<ITerm>(terms);
        block0: while (true) {
            ITerm candidateInjConstructor;
            IApplTerm injConstructor;
            IApplTerm iApplTerm = injConstructor = StrategoPlaceholders.isInjectionConstructor(candidateInjConstructor = (ITerm)currentTerms.get(0)) ? (IApplTerm)candidateInjConstructor : null;
            if (injConstructor == null) break;
            ArrayList<ITerm> newTerms = new ArrayList<ITerm>(currentTerms.size());
            for (ITerm term : currentTerms) {
                IApplTerm applTerm;
                if (!(term instanceof IApplTerm) || !(applTerm = (IApplTerm)term).getOp().equals(injConstructor.getOp()) || applTerm.getArity() != injConstructor.getArity()) break block0;
                assert (applTerm.getArity() == 1) : "We assume injector constructors have only one argument.";
                newTerms.add(applTerm.getArgs().get(0));
            }
            currentTerms = newTerms;
            ++level;
        }
        return level;
    }

    private static ITerm getPlaceholderForVar(ITermVar var, PlaceholderVarMap placeholderVarMap) {
        PlaceholderVarMap.Placeholder placeholder = placeholderVarMap.getPlaceholder(var);
        if (placeholder != null) {
            return placeholder.getTerm();
        }
        return StrategoPlaceholders.getPlaceholderForTerm(var);
    }

    private static ITerm getPlaceholderForTerm(ITerm term) {
        ITerm newPlaceholder = StrategoPlaceholders.getPlaceholderFromAttachments(term.getAttachments());
        return newPlaceholder != null ? newPlaceholder : TermBuild.B.newAppl("??-Plhdr", new ITerm[0]);
    }

    @Nullable
    private static ITerm getPlaceholderFromAttachments(IAttachments attachments) {
        StrategoAnnotations annotations = attachments.get(StrategoAnnotations.class);
        if (annotations == null) {
            return null;
        }
        return StrategoPlaceholders.getPlaceholderFromAnnotations(annotations.getAnnotationList());
    }

    @Nullable
    private static ITerm getPlaceholderFromAnnotations(List<IStrategoTerm> annotations) {
        for (IStrategoTerm term : annotations) {
            if (!TermUtils.isAppl(term, "OfSort", 1)) continue;
            return StrategoPlaceholders.getPlaceholderFromSortTerm(term.getSubterm(0));
        }
        return null;
    }

    @Nullable
    private static ITerm getPlaceholderFromSortTerm(IStrategoTerm term) {
        if (TermUtils.isAppl(term, "SORT", 1)) {
            return TermBuild.B.newAppl(String.valueOf(TermUtils.toJavaStringAt(term, 0)) + PLACEHOLDER_SUFFIX, new ITerm[0]);
        }
        if (TermUtils.isAppl(term, "LIST", 1)) {
            return TermBuild.B.newList(StrategoPlaceholders.getPlaceholderFromSortTerm(term.getSubterm(0)));
        }
        if (TermUtils.isAppl(term, "STRING", 0)) {
            String name = TermUtils.toAppl(term).getConstructor().getName();
            return TermBuild.B.newAppl("ID-Plhdr", new ITerm[0]);
        }
        if (TermUtils.isAppl(term, null, 0)) {
            String name = TermUtils.toAppl(term).getConstructor().getName();
            return TermBuild.B.newAppl("_" + Character.toUpperCase(name.charAt(0)) + name.substring(1).toLowerCase(), new ITerm[0]);
        }
        throw new UnsupportedOperationException("Unknown sort: " + term);
    }
}

