/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.util;

import java.net.URL;
import java.util.regex.Pattern;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.net.WildcardURLFilter;
import oracle.jdevimpl.vcs.util.res.UtilArb;

public class FileOrFolderFilter
implements URLFilter {
    private String _description;
    private String _filter;
    private boolean _applyToFiles;
    private boolean _applyToFolders;
    private boolean _applyRecursively;
    private boolean _isUserDefined;
    private Pattern _namePattern;
    private Pattern _pathPattern;

    public FileOrFolderFilter() {
    }

    public FileOrFolderFilter(String filter) {
        this(UtilArb.format("CREATE_FILTER_DESC_FILES", filter), filter, true, false);
    }

    public FileOrFolderFilter(String description, String filter, boolean files, boolean folders) {
        this.setDescription(description);
        this.setFilter(filter);
        this.setApplyToFiles(files);
        this.setApplyToFolders(folders);
        this.setUserDefined(false);
    }

    public boolean isUserDefined() {
        return this._isUserDefined;
    }

    public void setUserDefined(boolean isUserDefined) {
        this._isUserDefined = isUserDefined;
    }

    private Pattern getNamePattern() {
        if (this._namePattern == null) {
            String regexp = WildcardURLFilter.wildcard2Regexp((String)this.getFilter());
            this._namePattern = URLFileSystem.isLocalFileSystemCaseSensitive() ? Pattern.compile(regexp) : Pattern.compile(regexp, 2);
        }
        return this._namePattern;
    }

    private Pattern getPathPattern() {
        if (this._pathPattern == null) {
            String regexp = WildcardURLFilter.wildcard2Regexp((String)("*/" + this.getFilter() + "/*"));
            this._pathPattern = URLFileSystem.isLocalFileSystemCaseSensitive() ? Pattern.compile(regexp) : Pattern.compile(regexp, 2);
        }
        return this._pathPattern;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof FileOrFolderFilter) {
            FileOrFolderFilter that = (FileOrFolderFilter)o;
            return that.isApplyToFiles() == this.isApplyToFiles() && that.isApplyToFolders() == that.isApplyToFolders() && String.valueOf(that.getFilter()).equals(String.valueOf(this.getFilter())) && String.valueOf(that.getDescription()).equals(String.valueOf(this.getDescription()));
        }
        return false;
    }

    public int hashCode() {
        return (this.isApplyToFiles() ? Boolean.TRUE.hashCode() : Boolean.FALSE.hashCode()) + (this.isApplyToFolders() ? Boolean.TRUE.hashCode() : Boolean.FALSE.hashCode()) + (this.getFilter() != null ? this.getFilter().hashCode() : 0) + (this.getDescription() != null ? this.getDescription().hashCode() : 0);
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public String getDescription() {
        return this._description;
    }

    public void setFilter(String filter) {
        this._filter = filter;
        this._namePattern = null;
        this._pathPattern = null;
    }

    public String getFilter() {
        return this._filter;
    }

    public void setApplyToFiles(boolean applyToFiles) {
        this._applyToFiles = applyToFiles;
    }

    public boolean isApplyToFiles() {
        return this._applyToFiles;
    }

    public void setApplyToFolders(boolean applyToFolders) {
        this._applyToFolders = applyToFolders;
    }

    public boolean isApplyToFolders() {
        return this._applyToFolders;
    }

    public void setApplyRecursively(boolean applyRecursively) {
        this._applyRecursively = applyRecursively;
    }

    public boolean isApplyRecursively() {
        return this._applyRecursively;
    }

    public String toString() {
        return this._description;
    }

    public final boolean accept(URL url) {
        boolean isDirectory = URLFileSystem.isDirectory((URL)url);
        if (isDirectory && !this.isApplyToFolders()) {
            return false;
        }
        if (!isDirectory && !this.isApplyToFiles()) {
            return false;
        }
        if (this.getNamePattern().matcher(URLFileSystem.getFileName((URL)url)).matches()) {
            return true;
        }
        if (!this.isApplyRecursively()) {
            return false;
        }
        return this.getPathPattern().matcher(URLFileSystem.getPath((URL)url)).matches();
    }
}

