/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.spi;

import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableFactory;
import oracle.ide.docking.DockingParam;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.layout.ViewId;
import oracle.ide.log.LogManager;

public class VCSDockableViewRegistry {
    private static final Map<String, Integer> _dockableViewMap = new WeakHashMap<String, Integer>();
    public static final int EAST_OF_LOG_ORIENTATION_ID = 1;
    public static final int CENTER_WITH_LOG_ORIENTATION_ID = 2;

    private VCSDockableViewRegistry() {
    }

    public static final void registerDockableView(String viewId, int orientationId) {
        _dockableViewMap.put(ViewId.validate((String)viewId), orientationId);
    }

    public static final void deregisterDockableView(String viewId) {
        _dockableViewMap.remove(ViewId.validate((String)viewId));
    }

    public static final void showDockableView(String viewId) {
        viewId = ViewId.validate((String)viewId);
        ViewId viewIdObj = new ViewId(viewId);
        DockableFactory dockableFactory = DockStation.getDockStation().lookupFactory(viewIdObj);
        Dockable dockable = DockStation.getDockStation().findDockable(viewIdObj);
        if (dockable == null) {
            if (dockableFactory == null) {
                FeedbackManager.reportException((Throwable)new IllegalStateException("No registered dockable factory for view ID: " + viewId));
            } else {
                FeedbackManager.reportException((Throwable)new IllegalStateException("Could not create dockable for view ID: " + viewId));
            }
        }
        DockingParam param = VCSDockableViewRegistry.createDockingParam(_dockableViewMap.get(viewId));
        DockStation.getDockStation().dock(dockable, param);
        DockStation.getDockStation().setDockableVisible(dockable, true);
        DockStation.getDockStation().activateDockable(dockable);
    }

    public static final DockingParam createDockingParam(int orientationId) {
        Dockable referenceDockable = VCSDockableViewRegistry.getVisibleDockable(orientationId);
        DockingParam dockingParam = new DockingParam();
        if (referenceDockable != null) {
            dockingParam.setPosition(referenceDockable, 4);
            dockingParam.setTabbedWith(referenceDockable);
            return dockingParam;
        }
        if (orientationId == 1) {
            dockingParam.setPosition((Dockable)LogManager.getIdeLogWindow(), 1, 3);
            return dockingParam;
        }
        if (orientationId == 2) {
            dockingParam.setPosition((Dockable)LogManager.getIdeLogWindow(), 4, 3);
        }
        return dockingParam;
    }

    public static final void closeDockableView(String viewId) {
        viewId = ViewId.validate((String)viewId);
        Dockable dockable = DockStation.getDockStation().getDockable(new ViewId(viewId));
        if (dockable != null) {
            DockStation.getDockStation().close(dockable);
        }
    }

    private static final Dockable getVisibleDockable(int orientationId) {
        Iterator<String> itr = _dockableViewMap.keySet().iterator();
        while (itr.hasNext()) {
            Dockable dockable;
            DockStation dockStation;
            String viewId = ViewId.validate((String)itr.next());
            if (_dockableViewMap.get(viewId) != orientationId || !(dockStation = DockStation.getDockStation()).isDockableVisible(dockable = dockStation.getDockable(new ViewId(viewId)))) continue;
            return dockable;
        }
        return null;
    }
}

