/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.listener.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import oracle.dbtools.listener.ListenerArb;
import oracle.dbtools.listener.model.ListenerModel;
import oracle.dbtools.listener.model.ListenerSecuritySettings;
import oracle.dbtools.listener.ui.ListenerSettings;
import oracle.dbtools.listener.ui.ListenerUIUtils;
import oracle.ide.util.ResourceUtils;

public class ListenerValidationFunctionPanel
extends ListenerSettings {
    private JTextArea _validationFunction;
    private JComboBox _vfType;
    private Color _globalBGColor;
    private Color _origVFTypeBGColor;
    private int _globalVFType;
    private boolean _isGlobalShowing = false;
    private JScrollPane _scrollPane;

    public ListenerValidationFunctionPanel() {
        this.init();
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        String[] stringArray = new String[]{ListenerSecuritySettings.VALIDATION_FUNCTION_TYPE.PL_SQL.getNLS(), ListenerSecuritySettings.VALIDATION_FUNCTION_TYPE.JAVASCRIPT.getNLS()};
        this._vfType = new JComboBox<String>(stringArray);
        this._vfType.setSelectedIndex(0);
        this.setPreferredSize(new Dimension(200, 200));
        this._validationFunction = new JTextArea();
        JLabel jLabel = new JLabel();
        JLabel jLabel2 = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this._validationFunction, (String)ListenerArb.getString("VALIDATION_FUNCTION"));
        ResourceUtils.resLabel((JLabel)jLabel2, (Component)this._vfType, (String)ListenerArb.getString("VALIDATION_FUNC_TYPE"));
        JTextPane jTextPane = new JTextPane();
        jTextPane.setPreferredSize(new Dimension(200, 35));
        jTextPane.setText(ListenerArb.getString("VALIDATION_FUNCTION_DESCRIP"));
        jTextPane.setEditable(false);
        jTextPane.setOpaque(false);
        jTextPane.setRequestFocusEnabled(false);
        jTextPane.setFocusable(false);
        this._validationFunction.setRows(5);
        this._validationFunction.setLineWrap(true);
        this._validationFunction.setWrapStyleWord(true);
        Dimension dimension = new Dimension(200, 300);
        this._validationFunction.setSize(dimension);
        this._validationFunction.setPreferredSize(dimension);
        this._validationFunction.setMinimumSize(dimension);
        this._scrollPane = new JScrollPane(this._validationFunction, 22, 31);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)jLabel2, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 6), 0, 0));
        jPanel.add((Component)this._vfType, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 23, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add(Box.createHorizontalGlue(), new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        int n = 0;
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.add((Component)jPanel, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 23, 2, new Insets(8, 8, 0, 6), 0, 0));
        jPanel2.add(Box.createGlue(), new GridBagConstraints(0, ++n, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel2.add((Component)jTextPane, new GridBagConstraints(0, ++n, 1, 1, 0.4, 0.4, 23, 1, new Insets(8, 8, 0, 8), 0, 0));
        jPanel2.add((Component)jLabel, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 23, 0, new Insets(8, 8, 0, 6), 0, 0));
        jPanel2.add((Component)this._scrollPane, new GridBagConstraints(0, ++n, 1, 2, 1.0, 1.0, 23, 1, new Insets(8, 8, 0, 8), 0, 0));
        jPanel2.add(Box.createGlue(), new GridBagConstraints(0, ++n, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.addSettingsPanel(jPanel2);
    }

    private void updateValidationFunctionTypeBGColor() {
        if (this._vfType.getSelectedIndex() == this._globalVFType) {
            this._vfType.setBackground(this._globalBGColor);
            this._isGlobalShowing = true;
        } else if (this._isGlobalShowing) {
            this._vfType.setBackground(this._origVFTypeBGColor);
            this._isGlobalShowing = false;
        }
    }

    private void displayTextTopOfPane(final JScrollPane jScrollPane) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                jScrollPane.getVerticalScrollBar().setValue(0);
            }
        });
    }

    @Override
    public void assignSettings(ListenerModel listenerModel, ListenerModel listenerModel2) {
        this.initSettings(listenerModel, listenerModel2, "ValidationFunction");
        this.assignSettings(this._model);
        if (listenerModel2 != null) {
            this._origVFTypeBGColor = new Color(this._vfType.getBackground().getRGB());
            this._globalBGColor = ListenerUIUtils.getHighlightBackgroundColor();
            this._vfType.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    try {
                        ListenerValidationFunctionPanel.this.updateValidationFunctionTypeBGColor();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
    }

    @Override
    public void assignSettings(ListenerModel listenerModel) {
        if (listenerModel != null && listenerModel.getSecuritySettings() != null) {
            this._vfType.setSelectedIndex(listenerModel.getSecuritySettings().getValidationFunctionType().ordinal());
            String string = listenerModel.getSecuritySettings().getValidationFunction();
            if (string != null && !string.isEmpty() && string.trim().length() != 0) {
                this._validationFunction.setText(listenerModel.getSecuritySettings().getValidationFunction());
                this.displayTextTopOfPane(this._scrollPane);
            }
            if (this._parentModel != null) {
                this.highlightGlobalValues(this._parentModel);
            }
        }
    }

    @Override
    public ListenerModel getSettings() {
        if (this._model != null && this._model.getSecuritySettings() != null) {
            this._model.getSecuritySettings().setValidationFunction(this._validationFunction.getText());
            this._model.getSecuritySettings().setValidationFunctionType(ListenerSecuritySettings.VALIDATION_FUNCTION_TYPE.values()[this._vfType.getSelectedIndex()]);
        }
        return this._model;
    }

    @Override
    public void highlightGlobalValues(ListenerModel listenerModel) {
        this.updateTextHandler(this._validationFunction, listenerModel.getSecuritySettings().getValidationFunction());
        this._globalVFType = listenerModel.getSecuritySettings().getValidationFunctionType().ordinal();
        this.updateValidationFunctionTypeBGColor();
    }

    @Override
    public boolean isGlobalSettingsChange() {
        return this._parentModel == null && (this._validationFunction.getText() != this._model.getSecuritySettings().getValidationFunction() || this._vfType.getSelectedIndex() != this._model.getSecuritySettings().getValidationFunctionType().ordinal());
    }
}

