/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.syntax;

import com.adbs.ast.BaseSQLContext;
import com.adbs.ast.IdentCaseSensitivity;
import com.adbs.ast.MetadataContainer;
import com.adbs.ast.MetadataFilter;
import com.adbs.ast.MetadataObject;
import com.adbs.ast.SQLQualifiedName;
import com.adbs.ast.SQLQualifiedNameList;
import com.adbs.metadata.LoadMetadataHelpers;
import com.adbs.metadata.MetadataFieldsFetcherFromQuery;
import com.adbs.querybuilder.DataSource;
import com.adbs.querybuilder.DataSourcePropertiesDialog;
import com.adbs.querybuilder.Link;
import com.adbs.querybuilder.LinkPropertiesDialog;
import com.adbs.querybuilder.QueryBuilderException;
import com.adbs.syntax.BaseSyntaxProvider;
import com.adbs.syntax.SQL2003Parser;
import com.adbs.syntax.SQL2003Scanner;
import com.adbs.utils.Str;
import java.util.List;

public class SQL2003SyntaxProvider
extends BaseSyntaxProvider {
    private static final long serialVersionUID = 1L;
    private IdentCaseSensitivity identCaseSens = IdentCaseSensitivity.Insensitive;
    private boolean useInformationSchema = false;
    private boolean supportDatabases = true;
    private boolean supportSchemas = true;
    private SQLQualifiedName defaultDatabaseName = null;

    @Override
    public void dispose() {
        if (this.defaultDatabaseName != null) {
            this.defaultDatabaseName.dispose();
            this.defaultDatabaseName = null;
        }
        super.dispose();
    }

    @Override
    public BaseSyntaxProvider clone() {
        SQL2003SyntaxProvider result = (SQL2003SyntaxProvider)super.clone();
        result.identCaseSens = this.identCaseSens;
        result.useInformationSchema = this.useInformationSchema;
        return result;
    }

    @Override
    public IdentCaseSensitivity getIdentCaseSens() {
        return this.identCaseSens;
    }

    @Override
    public void setIdentCaseSens(IdentCaseSensitivity identCaseSens) {
        if (this.identCaseSens != identCaseSens) {
            this.identCaseSens = identCaseSens;
            this.sendNotifications();
        }
    }

    public boolean getUseInformationSchema() {
        return this.useInformationSchema;
    }

    public void setUseInformationSchema(boolean useInformationSchema) {
        this.useInformationSchema = useInformationSchema;
    }

    @Override
    protected Class getScannerClass() {
        return SQL2003Scanner.class;
    }

    @Override
    protected Class getParserClass() {
        return SQL2003Parser.class;
    }

    @Override
    public String getDescription() {
        return "ANSI SQL-2003";
    }

    @Override
    public void getBuiltinFunctionNames(SQLQualifiedNameList names) {
        super.getBuiltinFunctionNames(names);
        names.addBuiltin("Position");
        names.addBuiltin("Char_Length");
        names.addBuiltin("Character_Length");
        names.addBuiltin("Octet_Length");
        names.addBuiltin("Extract");
        names.addBuiltin("Cardinality");
        names.addBuiltin("Abs");
        names.addBuiltin("Mod");
        names.addBuiltin("Ln");
        names.addBuiltin("Exp");
        names.addBuiltin("Power");
        names.addBuiltin("SqRt");
        names.addBuiltin("Floor");
        names.addBuiltin("Ceil");
        names.addBuiltin("Ceiling");
        names.addBuiltin("Width_Bucket");
        names.addBuiltin("SubString");
        names.addBuiltin("Upper");
        names.addBuiltin("Lower");
        names.addBuiltin("Convert");
        names.addBuiltin("Translate");
        names.addBuiltin("Trim");
        names.addBuiltin("Overlay");
        names.addBuiltin("Normalize");
        names.addBuiltin("Current_Time");
        names.addBuiltin("LocalTime");
        names.addBuiltin("Current_Timestamp");
        names.addBuiltin("LocalTimestamp");
        names.addBuiltin("NullIf");
        names.addBuiltin("Coalesce");
        names.addBuiltin("Set");
    }

    @Override
    public boolean isSupportDatabases() {
        return this.supportDatabases;
    }

    public void setSupportDatabases(boolean supportDatabases) {
        this.supportDatabases = supportDatabases;
    }

    @Override
    public boolean isSupportSchemas() {
        return this.supportSchemas;
    }

    public void setSupportSchemas(boolean supportSchemas) {
        this.supportSchemas = supportSchemas;
    }

    @Override
    public boolean isSupportNullOrdering() {
        return true;
    }

    public void getUnionOperatorList(List sl) {
        super.getUnionOperatorList(sl);
        sl.add("Except");
        sl.add("Intersect");
    }

    @Override
    public Class getEditPropsFormClass(Object forObj) {
        if (forObj instanceof Link) {
            return LinkPropertiesDialog.class;
        }
        if (forObj instanceof DataSource) {
            return DataSourcePropertiesDialog.class;
        }
        return super.getEditPropsFormClass(forObj);
    }

    @Override
    public void loadMetadataObjects(BaseSQLContext sqlContext, MetadataContainer metadataContainer, MetadataFilter metadataFilter, SQLQualifiedName database) throws QueryBuilderException {
        if (this.useInformationSchema) {
            if (!LoadMetadataHelpers.loadMetadataObjectsSQL92(sqlContext, metadataContainer, metadataFilter, database)) {
                super.loadMetadataObjects(sqlContext, metadataContainer, metadataFilter, database);
            }
        } else {
            super.loadMetadataObjects(sqlContext, metadataContainer, metadataFilter, database);
        }
    }

    @Override
    public void loadMetadataRelations(BaseSQLContext sqlContext, MetadataContainer metadataContainer, MetadataFilter metadataFilter, SQLQualifiedName database) throws QueryBuilderException {
        if (this.useInformationSchema) {
            if (!LoadMetadataHelpers.loadMetadataRelationsSQL92(sqlContext, metadataContainer, metadataFilter, database)) {
                super.loadMetadataRelations(sqlContext, metadataContainer, metadataFilter, database);
            }
        } else {
            super.loadMetadataRelations(sqlContext, metadataContainer, metadataFilter, database);
        }
    }

    @Override
    public void loadFieldsForObjectFromServer(BaseSQLContext sqlContext, MetadataObject metadataObject) throws QueryBuilderException {
        assert (sqlContext != null);
        assert (sqlContext.getMetadataProvider() != null);
        assert (sqlContext.getMetadataProvider().canExecSQL());
        assert (metadataObject != null);
        String objectName = metadataObject.getName().getSimpleSQL(sqlContext.getSQLBuilderExpressionForServerWithoutQuotes());
        String objectSchema = metadataObject.getSchema().getSimpleSQL(sqlContext.getSQLBuilderExpressionForServerWithoutQuotes());
        String db = metadataObject.getDatabase().getSimpleSQL(sqlContext.getSQLBuilderExpressionForServer());
        String db_dot = !Str.IsNullOrEmpty(db) ? db + "." : "";
        if (!Str.IsNullOrEmpty(db) && sqlContext.isTableExists(db_dot + "INFORMATION_SCHEMA.COLUMNS") && sqlContext.isTableExists(db_dot + "INFORMATION_SCHEMA.TABLE_CONSTRAINTS") && sqlContext.isTableExists(db_dot + "INFORMATION_SCHEMA.CONSTRAINT_COLUMN_USAGE") || sqlContext.isTableExists("INFORMATION_SCHEMA.COLUMNS") && sqlContext.isTableExists("INFORMATION_SCHEMA.TABLE_CONSTRAINTS") && sqlContext.isTableExists("INFORMATION_SCHEMA.CONSTRAINT_COLUMN_USAGE")) {
            MetadataFieldsFetcherFromQuery mff = new MetadataFieldsFetcherFromQuery(sqlContext);
            if (!Str.IsNullOrEmpty(db)) {
                mff.setQuery("select c.TABLE_CATALOG, c.TABLE_SCHEMA, c.TABLE_NAME, c.COLUMN_NAME, c.DATA_TYPE, c.CHARACTER_MAXIMUM_LENGTH, c.NUMERIC_PRECISION, c.IS_NULLABLE, c.COLUMN_DEFAULT, ccu.COLUMN_NAME as PRIMARY_KEY from " + db_dot + "INFORMATION_SCHEMA.COLUMNS c left join (" + db_dot + "INFORMATION_SCHEMA.TABLE_CONSTRAINTS tc inner join  " + db_dot + "INFORMATION_SCHEMA.CONSTRAINT_COLUMN_USAGE ccu on \tccu.CONSTRAINT_NAME=tc.CONSTRAINT_NAME and ccu.CONSTRAINT_SCHEMA=tc.CONSTRAINT_SCHEMA and \tccu.CONSTRAINT_CATALOG=tc.CONSTRAINT_CATALOG and tc.CONSTRAINT_TYPE='PRIMARY KEY') on c.TABLE_NAME=tc.TABLE_NAME and c.TABLE_SCHEMA=tc.TABLE_SCHEMA and c.TABLE_CATALOG=tc.TABLE_CATALOG and c.COLUMN_NAME=ccu.COLUMN_NAME where c.TABLE_CATALOG='" + db + "' and c.TABLE_SCHEMA='" + objectSchema + "' and c.TABLE_NAME='" + objectName + "' order by c.ORDINAL_POSITION");
            } else {
                mff.setQuery("select c.TABLE_CATALOG, c.TABLE_SCHEMA, c.TABLE_NAME, c.COLUMN_NAME, c.DATA_TYPE, c.CHARACTER_MAXIMUM_LENGTH, c.NUMERIC_PRECISION, c.IS_NULLABLE, c.COLUMN_DEFAULT, ccu.COLUMN_NAME as PRIMARY_KEY from INFORMATION_SCHEMA.COLUMNS c left join (INFORMATION_SCHEMA.TABLE_CONSTRAINTS tc inner join  INFORMATION_SCHEMA.CONSTRAINT_COLUMN_USAGE ccu on \tccu.CONSTRAINT_NAME=tc.CONSTRAINT_NAME and ccu.CONSTRAINT_SCHEMA=tc.CONSTRAINT_SCHEMA and \tccu.CONSTRAINT_CATALOG=tc.CONSTRAINT_CATALOG and tc.CONSTRAINT_TYPE='PRIMARY KEY') on c.TABLE_NAME=tc.TABLE_NAME and c.TABLE_SCHEMA=tc.TABLE_SCHEMA and c.TABLE_CATALOG=tc.TABLE_CATALOG and c.COLUMN_NAME=ccu.COLUMN_NAME where c.TABLE_SCHEMA='" + objectSchema + "' and c.TABLE_NAME='" + objectName + "' order by c.ORDINAL_POSITION");
            }
            mff.setNameFieldName("COLUMN_NAME");
            mff.setServerTypeFieldName("DATA_TYPE");
            mff.setSizeFieldName("CHARACTER_MAXIMUM_LENGTH");
            mff.setPrecisionFieldName("NUMERIC_PRECISION");
            mff.setDefaultValueFieldName("COLUMN_DEFAULT");
            mff.setNullableFieldName("IS_NULLABLE");
            mff.setNonNullableValue(null);
            mff.setPrimaryFieldName("PRIMARY_KEY");
            mff.setNonPrimaryValue(null);
            mff.loadFields(metadataObject.getFields());
        }
    }

    @Override
    public void resetCachedDefaultDatabaseName() {
        if (this.defaultDatabaseName != null) {
            this.defaultDatabaseName.dispose();
        }
        this.defaultDatabaseName = null;
    }

    @Override
    public SQLQualifiedName getDefaultDatabaseName(BaseSQLContext sqlContext) throws QueryBuilderException {
        if (this.useInformationSchema) {
            this.defaultDatabaseName = LoadMetadataHelpers.getDefaultDatabaseNameSQL92(sqlContext);
            if (this.defaultDatabaseName == null) {
                this.defaultDatabaseName = super.getDefaultDatabaseName(sqlContext);
            }
        } else {
            this.defaultDatabaseName = super.getDefaultDatabaseName(sqlContext);
        }
        return this.defaultDatabaseName;
    }

    @Override
    public boolean isFixedSizeType(String type) {
        return type.compareToIgnoreCase("char") != 0 && type.compareToIgnoreCase("character") != 0 && type.compareToIgnoreCase("nchar") != 0 && type.compareToIgnoreCase("national char") != 0 && type.compareToIgnoreCase("national chararacter") != 0 && type.compareToIgnoreCase("varchar") != 0 && type.compareToIgnoreCase("char varying") != 0 && type.compareToIgnoreCase("character varying") != 0 && type.compareToIgnoreCase("nvarchar") != 0 && type.compareToIgnoreCase("national char varying") != 0 && type.compareToIgnoreCase("national character varying") != 0 && type.compareToIgnoreCase("binary") != 0 && type.compareToIgnoreCase("varbinary") != 0;
    }
}

