/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.ast;

import com.adbs.ast.AstFieldList;
import com.adbs.ast.AstToken;
import com.adbs.ast.BaseSQLContext;
import com.adbs.ast.ObjectPrefixSkipping;
import com.adbs.ast.SQLAggregateParamPrefix;
import com.adbs.ast.SQLBuilder;
import com.adbs.ast.SQLBuilderSelectFormat;
import com.adbs.ast.SQLExpressionItem;
import com.adbs.ast.SQLExpressionList;
import com.adbs.ast.SQLOrderByClause;
import com.adbs.ast.SQLQualifiedName;
import com.adbs.utils.Helpers;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SQLExpressionAggregate
extends SQLExpressionItem {
    public SQLQualifiedName name;
    public SQLAggregateParamPrefix prefix = SQLAggregateParamPrefix.All;
    public SQLExpressionList params;
    public SQLOrderByClause orderBy;

    public SQLExpressionAggregate(BaseSQLContext sqlContext) {
        super(sqlContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildFunctionName(SQLBuilder builder, SQLBuilderSelectFormat format) {
        if (this.name != null) {
            if (this.name.getCount() == 1 && this.name.dbLink == null && (this.sqlContext.isNameOfPrefixedAggregate(this.name) || this.sqlContext.isNameOfAggregate(this.name) || this.sqlContext.isNameOfStarAggregate(this.name))) {
                for (int i = this.name.getCount() - 1; i > 0; --i) {
                    builder.writeBuiltin(this.name.get(i).getToken());
                    builder.writeSymbol(".");
                }
                builder.writeBuiltin(this.name.get(0).getToken());
            } else {
                SQLQualifiedName db = Helpers.extractDatabaseFromFullName(this.name);
                try {
                    AstToken sch = Helpers.extractSchemaFromFullName(this.name);
                    try {
                        AstToken nm = Helpers.extractNameFromFullName(this.name);
                        try {
                            boolean buildDatabase;
                            boolean bl = buildDatabase = !Helpers.isQualifiedNameEmpty(db) && (builder.getObjectPrefixSkipping() == ObjectPrefixSkipping.SkipNothing || !this.sqlContext.isQualifiedNamesFullEqual(this.sqlContext.getMetadataContainer().getDefaultDatabaseName(), db));
                            if (buildDatabase) {
                                db.buildQualifiedNameNames(builder, format);
                                builder.writeSymbol(".");
                            }
                            if (sch != null) {
                                sch.buildSQL(builder, format);
                                builder.writeSymbol(".");
                            }
                            assert (nm != null);
                            nm.buildSQL(builder, format);
                            if (buildDatabase) {
                                db.buildQualifiedNameDBLink(builder, format);
                            }
                        }
                        finally {
                            if (nm != null) {
                                nm.dispose();
                            }
                        }
                    }
                    finally {
                        if (sch != null) {
                            sch.dispose();
                        }
                    }
                }
                finally {
                    db.dispose();
                }
            }
        }
    }

    @Override
    protected void getASTFields(AstFieldList l) {
        super.getASTFields(l);
        try {
            l.add(SQLExpressionAggregate.class.getField("name"));
            l.add(SQLExpressionAggregate.class.getField("params"));
            l.add(SQLExpressionAggregate.class.getField("orderBy"));
        }
        catch (Exception ex) {
            Logger.getLogger(SQLExpressionAggregate.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void buildSQLDirect(SQLBuilder builder, SQLBuilderSelectFormat format) {
        this.buildFunctionName(builder, format);
        builder.writeSymbol("(");
        if (this.params != null) {
            switch (this.prefix) {
                case Distinct: {
                    builder.writeKeyword("Distinct");
                    builder.space();
                    break;
                }
                case Unique: {
                    builder.writeKeyword("Unique");
                    builder.space();
                }
            }
            this.params.buildSQL(builder, format);
            if (this.orderBy != null) {
                builder.space();
                this.orderBy.buildOrderByKeywords(builder, format);
                builder.space();
                this.orderBy.buildSQLDirect(builder, format);
            }
        } else {
            builder.writeSymbol("*");
        }
        builder.writeSymbol(")");
    }

    @Override
    public void assign(Object source) {
        super.assign(source);
        if (source instanceof SQLExpressionAggregate) {
            this.prefix = ((SQLExpressionAggregate)source).prefix;
        }
    }
}

