/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.ast;

import com.adbs.ast.AstToken;
import com.adbs.ast.AstTokenIdentifier;
import com.adbs.ast.BaseSQLContext;
import com.adbs.ast.MetadataBase;
import com.adbs.ast.MetadataCollectionBase;
import com.adbs.ast.MetadataField;
import com.adbs.ast.MetadataObject;
import com.adbs.ast.SQLQualifiedName;
import com.adbs.querybuilder.QueryBuilderException;
import com.adbs.utils.Helpers;
import com.adbs.utils.Str;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MetadataFieldList
extends MetadataCollectionBase {
    private boolean loaded = false;

    public MetadataFieldList(MetadataBase parent, BaseSQLContext sqlContext) {
        super(parent, sqlContext, MetadataField.class);
        assert (parent == null || parent instanceof MetadataObject);
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public void setLoaded(boolean value) {
        this.loaded = value;
    }

    @Override
    public MetadataField get(int index) {
        return (MetadataField)super.get(index);
    }

    public void set(int index, MetadataField value) {
        super.set(index, value);
    }

    @Override
    protected String getXMLItemName() {
        return "field";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void assign(Object source) {
        super.assign(source);
        if (source instanceof MetadataFieldList) {
            this.loaded = ((MetadataFieldList)source).isLoaded();
            this.beginUpdate();
            try {
                this.clear();
                for (int i = 0; i < ((MetadataFieldList)source).getCount(); ++i) {
                    MetadataField f = this.add();
                    f.assign(((MetadataFieldList)source).get(i));
                }
                this.notifyUpdated();
            }
            finally {
                this.endUpdate();
            }
        }
    }

    @Override
    public MetadataField add() {
        this.loaded = true;
        return (MetadataField)super.add();
    }

    public int indexOf(MetadataField item) {
        return super.indexOf(item);
    }

    public MetadataField insert(int index, MetadataField item) {
        this.loaded = true;
        return (MetadataField)super.insert(index);
    }

    public int remove(MetadataField item) {
        return super.remove(item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetadataField addField(SQLQualifiedName fieldName, int fieldType, int size, boolean nullable, boolean readOnly, String shortDescription, String longDescription, String altName) {
        MetadataField result;
        this.beginUpdate();
        try {
            result = this.add();
            result.beginUpdate();
            try {
                result.setName(fieldName);
                result.setFieldType(fieldType);
                result.setSize(size);
                result.setNullable(nullable);
                result.setReadOnly(readOnly);
                result.setShortDescription(shortDescription);
                result.setLongDescription(longDescription);
                result.setAltName(altName);
            }
            finally {
                result.endUpdate();
            }
        }
        finally {
            this.endUpdate();
        }
        return result;
    }

    public MetadataField addField(SQLQualifiedName fieldName) {
        return this.addField(fieldName, 1111, 0, true, false, "", "", "");
    }

    public MetadataField addField(String fieldName) throws QueryBuilderException {
        SQLQualifiedName qn = null;
        try {
            qn = this.sqlContext.parseQualifiedNameQuoteIfNeed(fieldName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (qn == null) {
            throw new QueryBuilderException(Helpers.localizer.getString("strBadObjectName", "Invalid object name"));
        }
        MetadataField result = this.addField(qn);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetadataField addField(ResultSetMetaData meta, int index) throws SQLException {
        MetadataField result;
        SQLQualifiedName qn = new SQLQualifiedName(this.sqlContext);
        qn.addName(meta.getColumnName(index), this.sqlContext.getSyntaxProvider().isIdentifiersCaseSensitive());
        this.beginUpdate();
        try {
            result = this.add();
            result.beginUpdate();
            try {
                result.setName(qn);
                qn.dispose();
                result.setFieldType(meta.getColumnType(index));
                result.setSize(meta.getColumnDisplaySize(index));
                result.setPrecision(meta.getPrecision(index));
                result.setNullable(meta.isNullable(index) == 1);
                result.setReadOnly(meta.isReadOnly(index));
                result.setFieldTypeName(meta.getColumnTypeName(index));
            }
            finally {
                result.endUpdate();
            }
        }
        finally {
            this.endUpdate();
        }
        return result;
    }

    public MetadataField addField(AstToken fieldName) {
        assert (fieldName != null);
        MetadataField result = null;
        if (fieldName instanceof AstTokenIdentifier) {
            SQLQualifiedName qn = new SQLQualifiedName(this.sqlContext);
            qn.add(fieldName.clone(this.sqlContext));
            result = this.addField(qn);
            qn.dispose();
        } else {
            try {
                result = this.addField(fieldName.getToken());
            }
            catch (QueryBuilderException ex) {
                Logger.getLogger(MetadataFieldList.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int findFieldByName(String fieldName) {
        SQLQualifiedName qn = null;
        assert (!Str.IsNullOrEmpty(fieldName));
        if (this.sqlContext.getSyntaxProvider() != null) {
            try {
                qn = this.sqlContext.parseQualifiedNameQuoteIfNeed(fieldName);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                for (int i = 0; i < this.getCount(); ++i) {
                    MetadataField f = this.get(i);
                    if (!this.sqlContext.isQualifiedNamesEqual(qn, f.getName())) continue;
                    int n = i;
                    return n;
                }
            }
            finally {
                if (qn != null) {
                    qn.dispose();
                }
            }
        }
        for (int i = 0; i < this.getCount(); ++i) {
            MetadataField f = this.get(i);
            if (f.getName().getCount() != 1 || !(f.getName().get(0) instanceof AstToken) || !fieldName.equalsIgnoreCase(f.getName().get(0).getToken())) continue;
            return i;
        }
        return -1;
    }

    public int findFieldByName(SQLQualifiedName fieldName) {
        for (int i = 0; i < this.getCount(); ++i) {
            MetadataField f = this.get(i);
            if (!this.sqlContext.isQualifiedNamesEqual(f.getName(), fieldName)) continue;
            return i;
        }
        return -1;
    }
}

