/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.server;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import oracle.jdbc.LargeObjectAccessMode;
import oracle.jdbc.OracleClob;
import oracle.spatial.rdf.server.FilterException;
import oracle.spatial.rdf.server.InferenceEngine;
import oracle.spatial.rdf.server.InsertRDFHandler;
import oracle.spatial.rdf.server.QueryUtils;
import oracle.spatial.rdf.server.RDFException;
import oracle.spatial.rdf.server.SPARQLEngine;
import oracle.spatial.rdf.server.StgTabInsertRDFHandler;
import oracle.spatial.rdf.server.TranslateEngine;
import oracle.spatial.rdf.server.TypeException;
import oracle.spatial.rdf.server.UpdateEngine;
import oracle.spatial.rdf.server.parser.nq.NquadsParser;
import oracle.spatial.rdf.server.parser.sparql.ASTInput;
import oracle.spatial.rdf.server.parser.sparql.ASTTripleAtom;
import oracle.spatial.rdf.server.parser.sparql.ParseException;
import oracle.spatial.rdf.server.parser.sparql.SimpleNode;
import oracle.spatial.rdf.server.parser.sparql.sparqlParse;
import oracle.spatial.rdf.server.parser.ttl.TtlParser;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.CLOB;
import oracle.sql.Datum;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;

public class SQLEntryPoints {
    static StructDescriptor predStructDesc;
    static StructDescriptor termStructDesc;
    static ArrayDescriptor predArrayDesc;
    static ArrayDescriptor termArrayDesc;
    static Connection sconn;
    static ArrayDescriptor lvcDesc;
    static ArrayDescriptor vc2lDesc;
    static ArrayDescriptor numlDesc;
    static ArrayDescriptor rdfvcDesc;
    static ArrayDescriptor rdfgDesc;

    public static ARRAY getPatternVariables(OracleClob oracleClob) throws ParseException, SQLException, RDFException, IOException {
        return SQLEntryPoints.getPatternVariables(oracleClob, "");
    }

    public static ARRAY getPatternVariables(OracleClob oracleClob, String string) throws ParseException, SQLException, RDFException, IOException {
        String string2 = SQLEntryPoints.clobToStr(oracleClob);
        return SQLEntryPoints.getPatternVariables(string2, string);
    }

    public static ARRAY getPatternVariables(String string) throws ParseException, SQLException, RDFException {
        return SQLEntryPoints.getPatternVariables(string, "");
    }

    public static ARRAY getPatternVariables(String string, String string2) throws ParseException, SQLException, RDFException {
        TranslateEngine translateEngine = new TranslateEngine(sconn);
        String[] stringArray = translateEngine.getPatternVariables(string, string2);
        return new ARRAY(rdfvcDesc, sconn, (Object)stringArray);
    }

    public static void getSources(OracleClob oracleClob, ARRAY aRRAY, ARRAY[] aRRAYArray, ARRAY[] aRRAYArray2) throws ParseException, SQLException, RDFException, IOException {
        SQLEntryPoints.getSources(oracleClob, aRRAY, aRRAYArray, aRRAYArray2, "");
    }

    public static void getSources(OracleClob oracleClob, ARRAY aRRAY, ARRAY[] aRRAYArray, ARRAY[] aRRAYArray2, String string) throws ParseException, SQLException, RDFException, IOException {
        String string2 = SQLEntryPoints.clobToStr(oracleClob);
        SQLEntryPoints.getSources(string2, aRRAY, aRRAYArray, aRRAYArray2, string);
    }

    public static void getSources(String string, ARRAY aRRAY, ARRAY[] aRRAYArray, ARRAY[] aRRAYArray2) throws ParseException, SQLException, RDFException {
        SQLEntryPoints.getSources(string, aRRAY, aRRAYArray, aRRAYArray2, "");
    }

    public static void getSources(String string, ARRAY aRRAY, ARRAY[] aRRAYArray, ARRAY[] aRRAYArray2, String string2) throws ParseException, SQLException, RDFException {
        TranslateEngine translateEngine = new TranslateEngine(sconn);
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        HashMap hashMap = SQLEntryPoints.setupNamespaceMap(aRRAY);
        translateEngine.getSources(string, hashMap, arrayList, arrayList2, string2);
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        String[] stringArray2 = arrayList2.toArray(new String[arrayList2.size()]);
        aRRAYArray[0] = new ARRAY(rdfgDesc, sconn, (Object)stringArray);
        aRRAYArray2[0] = new ARRAY(rdfgDesc, sconn, (Object)stringArray2);
    }

    public static ARRAY getSelectVariables(String string) throws ParseException, SQLException {
        ArrayList<String> arrayList;
        block10: {
            arrayList = new ArrayList<String>();
            try {
                StreamTokenizer streamTokenizer = new StreamTokenizer(new StringReader(string));
                streamTokenizer.ordinaryChar(47);
                streamTokenizer.ordinaryChar(46);
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype == -3 && streamTokenizer.sval.equalsIgnoreCase("SELECT")) {
                    streamTokenizer.nextToken();
                    if (streamTokenizer.ttype == 42) {
                        arrayList.add("*");
                        streamTokenizer.nextToken();
                    } else if (streamTokenizer.ttype == 63) {
                        while (streamTokenizer.ttype == 63) {
                            streamTokenizer.nextToken();
                            if (streamTokenizer.ttype != -3) {
                                throw new ParseException("Invalid or unsupported syntax in the projection");
                            }
                            arrayList.add(streamTokenizer.sval.toUpperCase());
                            streamTokenizer.nextToken();
                        }
                    } else {
                        throw new ParseException("illegal token after the SELECT keyword");
                    }
                    if (streamTokenizer.ttype != -3 || !streamTokenizer.sval.equalsIgnoreCase("WHERE")) {
                        throw new ParseException("illegal token after '*'");
                    }
                    break block10;
                }
                throw new ParseException("illegal start of SELECT clause");
            }
            catch (IOException iOException) {
                throw new ParseException("unable to scan the SELECT clause " + iOException.getMessage());
            }
        }
        return new ARRAY(rdfvcDesc, sconn, (Object)arrayList.toArray(new String[arrayList.size()]));
    }

    private static void collectWalk(SimpleNode simpleNode, Connection connection, STRUCT[] sTRUCTArray, int[] nArray) throws ParseException, SQLException, RDFException {
        if (simpleNode.id == 4) {
            STRUCT[] sTRUCTArray2 = new STRUCT[3];
            ASTTripleAtom[] aSTTripleAtomArray = new ASTTripleAtom[3];
            for (int i = 0; i < 3; ++i) {
                aSTTripleAtomArray[i] = (ASTTripleAtom)simpleNode.jjtGetChild(i);
                STRUCT sTRUCT = aSTTripleAtomArray[i].type == 0 ? new STRUCT(termStructDesc, connection, new Object[]{0, 0, aSTTripleAtomArray[i].name}) : new STRUCT(termStructDesc, connection, new Object[]{1, 0, aSTTripleAtomArray[i].name});
                sTRUCTArray2[i] = sTRUCT;
            }
            STRUCT sTRUCT = new STRUCT(predStructDesc, connection, new Object[]{"predName", new ARRAY(termArrayDesc, connection, (Object)sTRUCTArray2), 1});
            int n = nArray[0];
            nArray[0] = n + 1;
            sTRUCTArray[n] = sTRUCT;
        } else {
            for (int i = 0; i < simpleNode.jjtGetNumChildren(); ++i) {
                SQLEntryPoints.collectWalk((SimpleNode)simpleNode.jjtGetChild(i), connection, sTRUCTArray, nArray);
            }
        }
    }

    public static void applyUpdate(String string, long l, String string2, String string3, String string4, OracleClob oracleClob, ARRAY aRRAY, String string5, long l2, String string6, String string7, int n, String string8, String string9, String string10, String string11, String string12, int n2) throws ParseException, SQLException, IOException, RDFException, TypeException, FilterException {
        SQLEntryPoints.applyUpdate(string, l, string2, string3, string4, oracleClob, aRRAY, string5, l2, string6, string7, n, string8, string9, string10, string11, string12, n2, null, null);
    }

    public static void applyUpdate(String string, long l, String string2, String string3, String string4, OracleClob oracleClob, ARRAY aRRAY, String string5, long l2, String string6, String string7, int n, String string8, String string9, String string10, String string11, String string12, int n2, String string13, String string14) throws ParseException, SQLException, IOException, RDFException, TypeException, FilterException {
        String string15 = SQLEntryPoints.clobToStr(oracleClob);
        UpdateEngine updateEngine = new UpdateEngine(sconn, string, l, string2, string3, string4, SQLEntryPoints.getStringArray(aRRAY), string5, l2, string6, string7, n, string8, string9, string10, string11, string12, n2, string13, string14);
        updateEngine.doUpdate(string15);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String clobToStr(OracleClob oracleClob) throws SQLException, IOException {
        int n = 10000;
        StringBuffer stringBuffer = new StringBuffer("");
        if (oracleClob != null) {
            try {
                if (!oracleClob.isOpen()) {
                    oracleClob.open(LargeObjectAccessMode.MODE_READONLY);
                }
                Reader reader = oracleClob.getCharacterStream();
                char[] cArray = new char[n];
                int n2 = -1;
                do {
                    if ((n2 = reader.read(cArray, 0, n)) <= 0) continue;
                    stringBuffer.append(cArray, 0, n2);
                } while (n2 != -1);
            }
            finally {
                if (oracleClob != null && oracleClob.isOpen()) {
                    oracleClob.close();
                }
            }
        }
        return stringBuffer.toString();
    }

    public static ARRAY translateQuerytoPredicates(ARRAY aRRAY, String string, ARRAY aRRAY2, String string2, String string3, ARRAY aRRAY3, int n) throws ParseException, SQLException, RDFException {
        TranslateEngine translateEngine = new TranslateEngine(n, sconn);
        int[] nArray = new int[]{};
        if (aRRAY != null) {
            nArray = aRRAY.getIntArray();
            int n2 = 0;
            while (n2 < nArray.length) {
                int n3 = n2++;
                nArray[n3] = nArray[n3] - 1;
            }
        }
        String[] stringArray = SQLEntryPoints.getStringArray(aRRAY2);
        HashMap hashMap = SQLEntryPoints.setupNamespaceMap(aRRAY3);
        String[][] stringArray2 = new String[1][1];
        sparqlParse sparqlParse2 = new sparqlParse((Reader)null);
        sparqlParse2.reset();
        ASTInput aSTInput = sparqlParse2.parse(string, hashMap, null);
        Connection connection = DriverManager.getConnection("jdbc:oracle:kprb:");
        predStructDesc = StructDescriptor.createDescriptor((String)"MDSYS.SEM_PREDICATE", (Connection)connection);
        termStructDesc = StructDescriptor.createDescriptor((String)"MDSYS.SEM_TERM", (Connection)connection);
        termArrayDesc = ArrayDescriptor.createDescriptor((String)"MDSYS.SEM_TERMS_TABLE", (Connection)connection);
        predArrayDesc = ArrayDescriptor.createDescriptor((String)"MDSYS.SEM_PRED_ARRAY", (Connection)connection);
        STRUCT[] sTRUCTArray = new STRUCT[20];
        int[] nArray2 = new int[]{0};
        SQLEntryPoints.collectWalk(aSTInput, connection, sTRUCTArray, nArray2);
        ARRAY aRRAY4 = new ARRAY(predArrayDesc, connection, (Object)sTRUCTArray);
        return aRRAY4;
    }

    public static void translateQueryPattern(ARRAY aRRAY, String string, ARRAY aRRAY2, String string2, String string3, ARRAY aRRAY3, int n, ARRAY[] aRRAYArray, ARRAY[] aRRAYArray2) throws ParseException, SQLException, RDFException, TypeException, FilterException {
        int[] nArray = new int[1];
        ARRAY[] aRRAYArray3 = new ARRAY[1];
        String[] stringArray = new String[1];
        SQLEntryPoints.translateQueryPattern(aRRAY, string, aRRAY2, string2, -1L, string3, null, null, null, null, aRRAY3, n, aRRAYArray, aRRAYArray2, null, null, nArray, aRRAYArray3, stringArray, null, 0);
    }

    public static void translateQueryPattern(ARRAY aRRAY, String string, ARRAY aRRAY2, String string2, String string3, ARRAY aRRAY3, int n, ARRAY[] aRRAYArray, ARRAY[] aRRAYArray2, String string4, String string5, int[] nArray, ARRAY[] aRRAYArray3, String[] stringArray) throws ParseException, SQLException, RDFException, TypeException, FilterException {
        SQLEntryPoints.translateQueryPattern(aRRAY, string, aRRAY2, string2, -1L, string3, null, null, null, null, aRRAY3, n, aRRAYArray, aRRAYArray2, string4, string5, nArray, aRRAYArray3, stringArray, null, 0);
    }

    public static void translateQueryPattern(ARRAY aRRAY, String string, ARRAY aRRAY2, String string2, long l, String string3, ARRAY aRRAY3, ARRAY aRRAY4, ARRAY aRRAY5, ARRAY aRRAY6, ARRAY aRRAY7, int n, ARRAY[] aRRAYArray, ARRAY[] aRRAYArray2, String string4, String string5, int[] nArray, ARRAY[] aRRAYArray3, String[] stringArray) throws ParseException, SQLException, RDFException, TypeException, FilterException {
        SQLEntryPoints.translateQueryPattern(aRRAY, string, aRRAY2, string2, l, string3, aRRAY3, aRRAY4, aRRAY5, aRRAY6, aRRAY7, n, aRRAYArray, aRRAYArray2, string4, string5, nArray, aRRAYArray3, stringArray, null, 0);
    }

    public static void translateQueryPattern(ARRAY aRRAY, String string, ARRAY aRRAY2, String string2, long l, String string3, ARRAY aRRAY3, ARRAY aRRAY4, ARRAY aRRAY5, ARRAY aRRAY6, ARRAY aRRAY7, int n, ARRAY[] aRRAYArray, ARRAY[] aRRAYArray2, String string4, String string5, int[] nArray, ARRAY[] aRRAYArray3, String[] stringArray, ARRAY aRRAY8, int n2) throws ParseException, SQLException, RDFException, TypeException, FilterException {
        SQLEntryPoints.translateQueryPattern(aRRAY, string, aRRAY2, string2, l, string3, aRRAY3, aRRAY4, aRRAY5, aRRAY6, aRRAY7, n, aRRAYArray, aRRAYArray2, string4, string5, nArray, aRRAYArray3, stringArray, aRRAY8, n2, null, null);
    }

    public static void translateQueryPattern(ARRAY aRRAY, OracleClob oracleClob, ARRAY aRRAY2, String string, long l, String string2, ARRAY aRRAY3, ARRAY aRRAY4, ARRAY aRRAY5, ARRAY aRRAY6, ARRAY aRRAY7, int n, ARRAY[] aRRAYArray, ARRAY[] aRRAYArray2, String string3, String string4, int[] nArray, ARRAY[] aRRAYArray3, String[] stringArray, ARRAY aRRAY8, int n2) throws ParseException, SQLException, RDFException, TypeException, FilterException, IOException {
        SQLEntryPoints.translateQueryPattern(aRRAY, oracleClob, aRRAY2, string, l, string2, aRRAY3, aRRAY4, aRRAY5, aRRAY6, aRRAY7, n, aRRAYArray, aRRAYArray2, string3, string4, nArray, aRRAYArray3, stringArray, aRRAY8, n2, null, null);
    }

    public static void translateQueryPattern(ARRAY aRRAY, OracleClob oracleClob, ARRAY aRRAY2, String string, long l, String string2, ARRAY aRRAY3, ARRAY aRRAY4, ARRAY aRRAY5, ARRAY aRRAY6, ARRAY aRRAY7, int n, ARRAY[] aRRAYArray, ARRAY[] aRRAYArray2, String string3, String string4, int[] nArray, ARRAY[] aRRAYArray3, String[] stringArray, ARRAY aRRAY8, int n2, String string5, String string6) throws ParseException, SQLException, RDFException, TypeException, FilterException, IOException {
        String string7 = SQLEntryPoints.clobToStr(oracleClob);
        SQLEntryPoints.translateQueryPattern(aRRAY, string7, aRRAY2, string, l, string2, aRRAY3, aRRAY4, aRRAY5, aRRAY6, aRRAY7, n, aRRAYArray, aRRAYArray2, string3, string4, nArray, aRRAYArray3, stringArray, aRRAY8, n2, string5, string6);
    }

    public static void translateQueryPattern(ARRAY aRRAY, String string, ARRAY aRRAY2, String string2, long l, String string3, ARRAY aRRAY3, ARRAY aRRAY4, ARRAY aRRAY5, ARRAY aRRAY6, ARRAY aRRAY7, int n, ARRAY[] aRRAYArray, ARRAY[] aRRAYArray2, String string4, String string5, int[] nArray, ARRAY[] aRRAYArray3, String[] stringArray, ARRAY aRRAY8, int n2, String string6, String string7) throws ParseException, SQLException, RDFException, TypeException, FilterException {
        int n3;
        TranslateEngine translateEngine = new TranslateEngine(n, sconn);
        translateEngine.setOptions(string4);
        int[] nArray2 = new int[]{};
        if (aRRAY != null) {
            nArray2 = aRRAY.getIntArray();
            n3 = 0;
            while (n3 < nArray2.length) {
                int n4 = n3++;
                nArray2[n4] = nArray2[n4] - 1;
            }
        }
        long[] lArray = new long[]{};
        if (aRRAY3 != null) {
            lArray = aRRAY3.getLongArray();
        }
        long[] lArray2 = new long[]{};
        if (aRRAY4 != null) {
            lArray2 = aRRAY4.getLongArray();
        }
        long[] lArray3 = new long[]{};
        if (aRRAY5 != null) {
            lArray3 = aRRAY5.getLongArray();
        }
        String[] stringArray2 = SQLEntryPoints.getStringArray(aRRAY6);
        String[] stringArray3 = SQLEntryPoints.getStringArray(aRRAY2);
        HashMap hashMap = SQLEntryPoints.setupNamespaceMap(aRRAY7);
        String[][] stringArray4 = new String[1][1];
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int[] nArray3 = aRRAY8 == null ? null : aRRAY8.getIntArray();
        String string8 = translateEngine.translateQueryPattern(nArray2, string, stringArray3, string2, l, string3, lArray, lArray2, lArray3, stringArray2, hashMap, string5, stringArray4, nArray, arrayList, stringArray, nArray3, n2, string6, string7);
        aRRAYArray[0] = SQLEntryPoints.chunkString(string8);
        aRRAYArray2[0] = new ARRAY(rdfvcDesc, sconn, (Object)stringArray4[0]);
        long[] lArray4 = new long[arrayList.size()];
        for (n3 = 0; n3 < arrayList.size(); ++n3) {
            lArray4[n3] = ((Integer)arrayList.get(n3)).longValue();
        }
        aRRAYArray3[0] = new ARRAY(numlDesc, sconn, (Object)lArray4);
    }

    public static void expandPattern(String[] stringArray, String[] stringArray2, ARRAY aRRAY, ARRAY[] aRRAYArray, int[] nArray, int[] nArray2, String string, String string2) throws ParseException, SQLException, RDFException {
        TranslateEngine translateEngine = new TranslateEngine(sconn);
        HashMap hashMap = SQLEntryPoints.setupNamespaceMap(aRRAY);
        if (stringArray[0] == null) {
            stringArray[0] = "";
        }
        if (stringArray2[0] == null) {
            stringArray2[0] = "";
        }
        long[] lArray = translateEngine.expandPattern(stringArray, stringArray2, hashMap, nArray, nArray2, string, string2);
        aRRAYArray[0] = new ARRAY(numlDesc, sconn, (Object)lArray);
    }

    public static void processVPDCriteria(String string, String[] stringArray, String[] stringArray2, ARRAY aRRAY, ARRAY[] aRRAYArray) throws ParseException, SQLException, RDFException {
        TranslateEngine translateEngine = new TranslateEngine(sconn);
        HashMap hashMap = SQLEntryPoints.setupNamespaceMap(aRRAY);
        int[] nArray = new int[16];
        int[] nArray2 = new int[16];
        String string2 = stringArray[0].trim();
        if (!string2.startsWith("{")) {
            throw new ParseException("VPD patterns expected in SPARQL syntax");
        }
        String string3 = stringArray2[0].trim();
        if (!string3.startsWith("{")) {
            throw new ParseException("VPD patterns expected in SPARQL syntax");
        }
        ArrayList<String> arrayList = translateEngine.processVPDPatterns(stringArray, stringArray2, hashMap);
        aRRAYArray[0] = new ARRAY(vc2lDesc, sconn, (Object)arrayList.toArray(new String[arrayList.size()]));
    }

    public static void doInference(ARRAY aRRAY, ARRAY aRRAY2, String string, String string2, String string3, String string4) throws SQLException, RDFException, ParseException {
        String[] stringArray = SQLEntryPoints.getStringArray(aRRAY);
        String[] stringArray2 = SQLEntryPoints.getStringArray(aRRAY2);
        InferenceEngine inferenceEngine = new InferenceEngine(stringArray, stringArray2, string, string2, sconn, string3, string4);
        inferenceEngine.run();
    }

    public static void updateInference(String string, ARRAY aRRAY, String string2, String string3, String string4, String string5, String string6) throws SQLException, RDFException, ParseException {
        String[] stringArray = SQLEntryPoints.getStringArray(aRRAY);
        InferenceEngine inferenceEngine = new InferenceEngine(string, stringArray, string2, string4, sconn, string5, string6);
        inferenceEngine.update(string3);
    }

    public static void updateInference(ARRAY aRRAY, ARRAY aRRAY2, String string, String string2, String string3, String string4, String string5) throws SQLException, RDFException, ParseException {
        String[] stringArray = SQLEntryPoints.getStringArray(aRRAY);
        String[] stringArray2 = SQLEntryPoints.getStringArray(aRRAY2);
        InferenceEngine inferenceEngine = new InferenceEngine(stringArray, stringArray2, string, string3, sconn, string4, string5);
        inferenceEngine.update(string2);
    }

    public static int hashCLOB(CLOB cLOB) throws SQLException {
        int n = -1640531527;
        long l = cLOB.length();
        for (long i = 0L; i < l; i += 4096L) {
            String string = l - i < 4096L ? cLOB.getSubString(1L + i, (int)(l - i)) : cLOB.getSubString(1L + i, 4096);
            n ^= string.hashCode();
        }
        return n;
    }

    public static HashMap setupNamespaceMap(ARRAY aRRAY) throws SQLException, RDFException {
        HashMap<String, String> hashMap;
        if (aRRAY != null) {
            Datum[] datumArray = aRRAY.getOracleArray();
            hashMap = new HashMap();
            for (int i = 0; i < datumArray.length; ++i) {
                STRUCT sTRUCT = (STRUCT)datumArray[i];
                Object[] objectArray = sTRUCT.getAttributes();
                String string = objectArray[0] != null ? (String)objectArray[0] : "";
                String string2 = (String)objectArray[1];
                if (hashMap.containsKey(string)) {
                    if (((String)hashMap.get(string)).equals(string2)) continue;
                    throw new RDFException("Multiple definitions for '" + string + "' namespace.");
                }
                hashMap.put(string, string2);
            }
        } else {
            hashMap = new HashMap<String, String>();
        }
        SPARQLEngine.addDefaultNamespacesToMap(hashMap);
        return hashMap;
    }

    protected static String[] getStringArray(ARRAY aRRAY) throws SQLException, RDFException {
        String[] stringArray = aRRAY == null ? null : (String[])aRRAY.getArray();
        return stringArray;
    }

    protected static long[] getlongArray(ARRAY aRRAY) throws SQLException, RDFException {
        long[] lArray = aRRAY == null ? null : aRRAY.getLongArray();
        return lArray;
    }

    private static boolean chunkHasValidBoundary(String string) {
        if (string == null) {
            return true;
        }
        char c = string.charAt(string.length() - 1);
        return c < '\ud800' || c > '\udbff';
    }

    private static String[] resizeArrayIfNeeded(String[] stringArray, int n) {
        String[] stringArray2 = stringArray;
        if (n == stringArray.length) {
            stringArray2 = Arrays.copyOf(stringArray, n + 1);
        }
        return stringArray2;
    }

    public static String[] chunkJavaString(String string) {
        int n = string.length() / 1300 + (string.length() % 1300 > 0 ? 1 : 0);
        String[] stringArray = new String[n];
        String string2 = "";
        int n2 = 0;
        int n3 = 0;
        while (n2 < string.length() - 1300) {
            string2 = string.substring(n2, n2 + 1300);
            int n4 = 1300;
            if (!SQLEntryPoints.chunkHasValidBoundary(string2)) {
                string2 = string.substring(n2, n2 + 1300 - 1);
                --n4;
            }
            n2 += n4;
            stringArray = SQLEntryPoints.resizeArrayIfNeeded(stringArray, n3);
            stringArray[n3] = string2;
            ++n3;
        }
        if (n2 < string.length()) {
            stringArray = SQLEntryPoints.resizeArrayIfNeeded(stringArray, n3);
            stringArray[n3] = string.substring(n2);
        }
        return stringArray;
    }

    protected static ARRAY chunkString(String string) throws SQLException {
        String[] stringArray = SQLEntryPoints.chunkJavaString(string);
        return new ARRAY(lvcDesc, sconn, (Object)stringArray);
    }

    protected static ARRAY makeSQLArray(String[] stringArray, String string) throws SQLException {
        Connection connection = DriverManager.getConnection("jdbc:oracle:kprb:");
        ArrayDescriptor arrayDescriptor = ArrayDescriptor.createDescriptor((String)string, (Connection)connection);
        ARRAY aRRAY = new ARRAY(arrayDescriptor, connection, (Object)stringArray);
        return aRRAY;
    }

    protected static ARRAY makeSQLArray(long[] lArray, String string) throws SQLException {
        Connection connection = DriverManager.getConnection("jdbc:oracle:kprb:");
        ArrayDescriptor arrayDescriptor = ArrayDescriptor.createDescriptor((String)string, (Connection)connection);
        ARRAY aRRAY = new ARRAY(arrayDescriptor, connection, (Object)lArray);
        return aRRAY;
    }

    public static String parseAndUnparse(String string, String string2, String string3) throws ParseException, SQLException, RDFException {
        TranslateEngine translateEngine = new TranslateEngine(sconn);
        return translateEngine.parseAndUnparse(string, string2, string3);
    }

    public static void loadRDF(String string, String string2, String string3, String string4, String string5, OracleClob oracleClob, String string6) throws oracle.spatial.rdf.server.parser.ttl.ParseException, oracle.spatial.rdf.server.parser.nq.ParseException, SQLException, IOException {
        String string7 = SQLEntryPoints.clobToStr(oracleClob);
        InsertRDFHandler insertRDFHandler = new InsertRDFHandler(string, string2, string3, string4, string5, null, string6);
        if (string6 != null && string6.indexOf("NQUADS=T") >= 0) {
            NquadsParser nquadsParser = NquadsParser.getParser();
            nquadsParser.parse(new ByteArrayInputStream(string7.getBytes()), insertRDFHandler);
        } else {
            TtlParser ttlParser = TtlParser.getParser();
            ttlParser.parse(new ByteArrayInputStream(string7.getBytes()), insertRDFHandler);
        }
    }

    public static void stgTabInsertTTL(String string, String string2, OracleClob oracleClob, String string3) throws oracle.spatial.rdf.server.parser.ttl.ParseException, SQLException, IOException {
        String string4 = SQLEntryPoints.clobToStr(oracleClob);
        StgTabInsertRDFHandler stgTabInsertRDFHandler = new StgTabInsertRDFHandler(string2, string, null, null, sconn, string3);
        TtlParser ttlParser = TtlParser.getParser();
        ttlParser.parse(new ByteArrayInputStream(string4.getBytes()), stgTabInsertRDFHandler);
    }

    static {
        try {
            sconn = DriverManager.getConnection("jdbc:oracle:kprb:");
            lvcDesc = ArrayDescriptor.createDescriptor((String)"MDSYS.RDF_LONGVARCHARARRAY", (Connection)sconn);
            vc2lDesc = ArrayDescriptor.createDescriptor((String)"SYS.ODCIVARCHAR2LIST", (Connection)sconn);
            numlDesc = ArrayDescriptor.createDescriptor((String)"SYS.ODCINUMBERLIST", (Connection)sconn);
            rdfvcDesc = ArrayDescriptor.createDescriptor((String)"MDSYS.RDF_VARCHARARRAY", (Connection)sconn);
            rdfgDesc = ArrayDescriptor.createDescriptor((String)"MDSYS.RDF_GRAPHS", (Connection)sconn);
        }
        catch (SQLException sQLException) {
            QueryUtils.log("Exception initializing ArrayDescriptors:");
            QueryUtils.log(sQLException.toString());
        }
    }
}

