/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.server;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import oracle.spatial.rdf.server.RDFException;
import oracle.spatial.rdf.server.SparqlQueryOptimizer;
import oracle.spatial.rdf.server.parser.sparql.ASTConditionalAndExpression;
import oracle.spatial.rdf.server.parser.sparql.ASTFilter;
import oracle.spatial.rdf.server.parser.sparql.ASTGraphPatternNotTriples;
import oracle.spatial.rdf.server.parser.sparql.Node;
import oracle.spatial.rdf.server.parser.sparql.ParseException;
import oracle.spatial.rdf.server.parser.sparql.SimpleNode;

public class FilterConjunctionRewriteOptimizer
implements SparqlQueryOptimizer {
    private static final int MAX_ITERS = 10000;

    @Override
    public Node optimizeQuery(Node node) throws RDFException, ParseException {
        int n;
        boolean bl = true;
        for (n = 0; bl && n < 10000; ++n) {
            bl = this.decomposeOneFilter(node);
        }
        if (n >= 10000) {
            throw new ParseException("FilterConjunctionRewriteOptimizer: entered infinite loop when optimizing query tree");
        }
        return node;
    }

    private boolean decomposeOneFilter(Node node) {
        LinkedList<NodePosPair> linkedList = new LinkedList<NodePosPair>();
        linkedList.add(new NodePosPair(node, 0));
        while (!linkedList.isEmpty()) {
            NodePosPair nodePosPair = (NodePosPair)linkedList.remove();
            Node node2 = nodePosPair.node;
            int n = nodePosPair.pos;
            for (int i = 0; i < node2.jjtGetNumChildren(); ++i) {
                Node node3 = node2.jjtGetChild(i);
                if (this.isConjunctiveFilter(node3)) {
                    List<ASTGraphPatternNotTriples> list = this.decomposeConjunction((ASTGraphPatternNotTriples)node3);
                    int n2 = i;
                    Node node4 = this.replaceFilterInParent(node2, list, n2);
                    Node node5 = node2.jjtGetParent();
                    node5.jjtAddChild(node4, n);
                    node4.jjtSetParent(node5);
                    return true;
                }
                linkedList.add(new NodePosPair(node3, i));
            }
        }
        return false;
    }

    private Node replaceFilterInParent(Node node, List<ASTGraphPatternNotTriples> list, int n) {
        int n2;
        Node node2 = node.cloneNode();
        int n3 = node.jjtGetNumChildren() + list.size() - 1;
        node2.jjtSetInitCapacity(n3);
        for (n2 = 0; n2 < n; ++n2) {
            Node node3 = node.jjtGetChild(n2);
            node2.jjtAddChild(node3, n2);
            node3.jjtSetParent(node2);
        }
        n2 = n;
        for (ASTGraphPatternNotTriples node4 : list) {
            node2.jjtAddChild(node4, n2);
            ++n2;
        }
        for (int i = n + 1; i < node.jjtGetNumChildren(); ++i) {
            Node node3 = node.jjtGetChild(i);
            node2.jjtAddChild(node3, n2);
            node3.jjtSetParent(node2);
            ++n2;
        }
        return node2;
    }

    private boolean isConjunctiveFilter(Node node) {
        ASTFilter aSTFilter;
        ASTGraphPatternNotTriples aSTGraphPatternNotTriples;
        boolean bl = false;
        if (((SimpleNode)node).id == 49 && (aSTGraphPatternNotTriples = (ASTGraphPatternNotTriples)node).jjtGetNumChildren() == 1 && ((SimpleNode)aSTGraphPatternNotTriples.jjtGetChild((int)0)).id == 56 && (aSTFilter = (ASTFilter)aSTGraphPatternNotTriples.jjtGetChild(0)).jjtGetNumChildren() == 1 && ((SimpleNode)aSTFilter.jjtGetChild((int)0)).id == 79) {
            bl = true;
        }
        return bl;
    }

    private List<ASTGraphPatternNotTriples> decomposeConjunction(ASTGraphPatternNotTriples aSTGraphPatternNotTriples) {
        ArrayList<ASTGraphPatternNotTriples> arrayList = new ArrayList<ASTGraphPatternNotTriples>();
        ASTConditionalAndExpression aSTConditionalAndExpression = (ASTConditionalAndExpression)aSTGraphPatternNotTriples.jjtGetChild(0).jjtGetChild(0);
        for (int i = 0; i < aSTConditionalAndExpression.jjtGetNumChildren(); ++i) {
            ASTGraphPatternNotTriples aSTGraphPatternNotTriples2 = this.buildGpntFilter(aSTConditionalAndExpression.jjtGetChild(i));
            if (this.isConjunctiveFilter(aSTGraphPatternNotTriples2)) {
                arrayList.addAll(this.decomposeConjunction(aSTGraphPatternNotTriples2));
                continue;
            }
            arrayList.add(this.buildGpntFilter(aSTConditionalAndExpression.jjtGetChild(i)));
        }
        return arrayList;
    }

    private ASTGraphPatternNotTriples buildGpntFilter(Node node) {
        ASTGraphPatternNotTriples aSTGraphPatternNotTriples = new ASTGraphPatternNotTriples(49);
        ASTFilter aSTFilter = new ASTFilter(56);
        aSTGraphPatternNotTriples.jjtAddChild(aSTFilter, 0);
        aSTFilter.jjtSetParent(aSTGraphPatternNotTriples);
        aSTFilter.jjtAddChild(node, 0);
        node.jjtSetParent(aSTFilter);
        return aSTGraphPatternNotTriples;
    }

    private static class NodePosPair {
        Node node;
        int pos;

        NodePosPair(Node node, int n) {
            this.node = node;
            this.pos = n;
        }
    }
}

