/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.ldap;

import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Vector;
import javax.naming.directory.DirContext;
import javax.security.auth.x500.X500Principal;
import oracle.security.crypto.cert.CertificateStatus;
import oracle.security.crypto.cert.CertificateValidator;
import oracle.security.crypto.cert.ValidationException;
import oracle.security.crypto.cert.X509;
import oracle.security.crypto.ldap.LDAPUtils;

public class LDAPCertificateValidator
implements CertificateValidator {
    protected transient DirContext ctx;

    public LDAPCertificateValidator() {
    }

    public LDAPCertificateValidator(DirContext ctx) {
        this.ctx = ctx;
    }

    public DirContext getDirContext() {
        return this.ctx;
    }

    public void setDirContext(DirContext ctx) {
        this.ctx = ctx;
    }

    public CertificateStatus validateCert(X509 cert) throws ValidationException {
        try {
            X509Certificate c = LDAPUtils.toJCECert(cert);
            return this.validateCert(c);
        }
        catch (CertificateException ex) {
            throw new ValidationException(ex.toString());
        }
    }

    public CertificateStatus validateCert(X509Certificate c) throws ValidationException {
        return this.validateCert(c.getSubjectX500Principal(), c);
    }

    public CertificateStatus validateCert(X500Principal subject, X509Certificate c) throws ValidationException {
        try {
            Vector cac;
            CertificateStatus cs = new CertificateStatus(2);
            if (this.ctx == null) {
                cs.setStatusCode(0);
                cs.setReason("No directory context has been set");
                return cs;
            }
            Vector uc = LDAPUtils.getUserCerts(subject, this.ctx);
            if (uc != null) {
                Enumeration e = uc.elements();
                while (e.hasMoreElements()) {
                    X509Certificate c2 = (X509Certificate)e.nextElement();
                    if (!c.equals(c2)) continue;
                    cs.setStatusCode(1);
                    return cs;
                }
            }
            if ((cac = LDAPUtils.getCACerts(subject, this.ctx)) != null) {
                Enumeration e = cac.elements();
                while (e.hasMoreElements()) {
                    X509Certificate c2 = (X509Certificate)e.nextElement();
                    if (!c.equals(c2)) continue;
                    cs.setStatusCode(1);
                    return cs;
                }
            }
            if (!(uc != null && uc.size() != 0 || cac != null && cac.size() != 0)) {
                cs.setStatusCode(0);
                cs.setReason("Subject directory entry not found, or does not contain any certificates");
            }
            return cs;
        }
        catch (Exception e) {
            throw new ValidationException(e.toString());
        }
    }
}

