/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.json.query;

import java.io.IOException;
import java.util.Iterator;
import oracle.dbtools.common.query.ResultRow;
import oracle.dbtools.common.query.ResultRows;
import oracle.dbtools.common.service.model.Property;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.util.Iterators;
import oracle.dbtools.common.util.PrimitiveTypes;
import oracle.dbtools.common.util.Transform;
import oracle.dbtools.rt.entity.Entity;
import oracle.dbtools.rt.json.query.JSONRepresentation;
import oracle.dbtools.rt.query.QueryGeneratorBase;
import oracle.dbtools.rt.query.ResultRowRepresentation;
import oracle.dbtools.rt.resource.collection.FeedItem;
import oracle.dbtools.rt.resource.collection.FeedItemTransform;
import oracle.dbtools.rt.resource.generator.ResourceGenerator;
import oracle.dbtools.rt.web.RequestEntity;

@Service(properties={@Property(name="oracle.dbtools.rt.web.ResourceGenerator", value="json/query;type=feed"), @Property(name="oracle.dbtools.rt.web.ResourceGeneratorLabel", value="JSON Feed Query"), @Property(name="oracle.dbtools.rt.web.ResourceGeneratorDescription", value="Transform the results of the supplied query into a JSON Feed document"), @Property(name="oracle.dbtools.rt.web.ResourceGeneratorExample", value="select * from oe.orders where order_id = :id ")})
public class JSONFeedGenerator
extends QueryGeneratorBase
implements ResourceGenerator {
    private final ResultRowRepresentation rep = new JSONRepresentation(false);
    public static final String JSON_FEED_TYPE = "json/query;type=feed";

    public JSONFeedGenerator() {
        super(true);
    }

    @Override
    protected Entity toRepresentation(RequestEntity request, long pageOffset, Iterator<ResultRow> rows) throws IOException {
        Iterator<FeedItem> items = this.items(rows);
        return this.rep.toRepresentation(request, pageOffset, (Iterator<ResultRow>)ResultRows.transform(items, (Transform)FeedItemTransform.INSTANCE));
    }

    private Iterator<FeedItem> items(Iterator<ResultRow> rows) {
        return Iterators.transform(rows, (Transform)new Transform<ResultRow, FeedItem>(){

            public FeedItem apply(final ResultRow row) {
                return new FeedItem(){

                    @Override
                    public String id() {
                        return PrimitiveTypes.string((Object)row.get(1));
                    }

                    @Override
                    public ResultRow item() {
                        return row;
                    }
                };
            }
        });
    }
}

