/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.markers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.ide.markers.Markable;
import oracle.ide.markers.Marker;
import oracle.ide.markers.MarkerException;
import oracle.ideimpl.markers.MarkerStore;

public class SimpleMarkerStore
implements MarkerStore {
    private final Map<Markable, Set<Marker>> markersByMarkable = new LinkedHashMap<Markable, Set<Marker>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <M extends Marker> List<M> addMarkers(M ... markers) throws MarkerException {
        if (null == markers || 0 == markers.length) {
            throw new IllegalArgumentException("At least one marker expected");
        }
        ArrayList<M> added = new ArrayList<M>();
        for (M marker : markers) {
            Markable markable = marker.markable();
            SimpleMarkerStore simpleMarkerStore = this;
            synchronized (simpleMarkerStore) {
                Set<Marker> existingMarkers = this.markersByMarkable.get(markable);
                if (null == existingMarkers) {
                    existingMarkers = new LinkedHashSet<Marker>();
                    this.markersByMarkable.put(markable, existingMarkers);
                }
                if (existingMarkers.add((Marker)marker)) {
                    added.add(marker);
                }
            }
        }
        return added;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <M extends Marker> List<M> removeMarkers(M ... markers) throws MarkerException {
        if (null == markers || 0 == markers.length) {
            throw new IllegalArgumentException("At least one marker expected");
        }
        ArrayList<M> removed = new ArrayList<M>();
        for (M marker : markers) {
            Markable markable = marker.markable();
            SimpleMarkerStore simpleMarkerStore = this;
            synchronized (simpleMarkerStore) {
                Set<Marker> existingMarkers = this.markersByMarkable.get(markable);
                if (null == existingMarkers) {
                    continue;
                }
                if (existingMarkers.remove(marker)) {
                    removed.add(marker);
                }
                if (existingMarkers.isEmpty()) {
                    this.markersByMarkable.remove(markable);
                }
            }
        }
        return removed;
    }

    @Override
    public synchronized void clear() {
        this.markersByMarkable.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<Marker> getMarkers(Markable markable) {
        SimpleMarkerStore simpleMarkerStore = this;
        synchronized (simpleMarkerStore) {
            Set<Marker> existingMarkers = this.markersByMarkable.get(markable);
            if (null == existingMarkers) {
                return Collections.emptyList();
            }
            return Collections.unmodifiableList(new ArrayList<Marker>(existingMarkers));
        }
    }

    public <M extends Marker> List<M> updateMarkers(M ... markers) {
        if (null == markers || 0 == markers.length) {
            return Collections.emptyList();
        }
        return Arrays.asList(markers);
    }

    public synchronized List<Marker> getMarkers() {
        ArrayList<Marker> markers = new ArrayList<Marker>();
        for (Set<Marker> markerSet : this.markersByMarkable.values()) {
            markers.addAll(markerSet);
        }
        return markers;
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.markersByMarkable.isEmpty();
    }

    public void dispose() {
        this.clear();
    }
}

