/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.markers;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.Set;
import oracle.ide.Context;
import oracle.ide.markers.Markable;
import oracle.ide.markers.MarkerException;
import oracle.ide.markers.annotations.MarkerAttribute;
import oracle.ide.markers.annotations.MarkerType;
import oracle.ide.model.Displayable;
import oracle.ideimpl.markers.MarkerImpl;
import oracle.ideimpl.markers.RootMarkerAttributesHandler;

@MarkerType(name="Base Marker", description="Root marker type, not intended for direct use.", handler=RootMarkerAttributesHandler.class)
public interface Marker
extends Displayable,
Comparable<Marker> {
    public Object getAttribute(String var1);

    public int getAttribute(String var1, int var2);

    public long getAttribute(String var1, long var2);

    public float getAttribute(String var1, float var2);

    public double getAttribute(String var1, double var2);

    public boolean getAttribute(String var1, boolean var2);

    public Map<String, Object> getAttributes();

    public Map<String, Object> getAttributes(String ... var1);

    public Map<String, Object> getAttributes(Map<String, Object> var1);

    @MarkerAttribute(id="timestamp", name="Timestamp", description="The date and time (in milliseconds since 12:00 AM Jan 1, 1970 UTC) that this marker was created (read-only)", readOnly=true)
    public long timestamp();

    @MarkerAttribute(id="id", name="ID", description="The unique identifier assigned to this marker at the time of creation (read-only)", readOnly=true)
    public String id();

    public Markable markable() throws MarkerException;

    public void setMarkable(Markable var1) throws MarkerException;

    public void delete() throws MarkerException;

    public boolean isDeleted();

    @MarkerAttribute(id="lastUpdated", name="Last Updated", description="The date and time of the last update (expressed as milliseconds since 12:00 AM Jan 1, 1970)", readOnly=true)
    public long lastUpdated();

    public Context context();

    public void update(Map<String, Object> var1, boolean var2) throws MarkerException;

    public Map<String, Object> removedAttributes();

    public Map<String, Object> addedAttributes();

    public Map<String, Object> modifiedAttributes();

    public boolean isFixable();

    public boolean equals(Object var1);

    public int hashCode();

    @MarkerAttribute(id="notification", name="Notification", description="The type of notification to use when a marker of this type is added to the Issues window.", readOnly=true)
    public String notification();

    public long rank();

    public Set<EventDescription> getEvents();

    public void addEvent(EventDescription var1);

    public void removeEvent(EventDescription var1);

    public static final class EventDescription {
        private final String id;
        private final String description;
        private final long timestamp = System.currentTimeMillis();

        public EventDescription(String id, String description) {
            if (null == id) {
                throw new IllegalArgumentException("Event ID must not be null");
            }
            this.id = id;
            if (null == description) {
                throw new IllegalArgumentException("Event description must not be null");
            }
            this.description = description;
        }

        public String getId() {
            return this.id;
        }

        public String getDescription() {
            return this.description;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof EventDescription)) {
                return false;
            }
            EventDescription other = (EventDescription)object;
            if (!(this.id != null ? this.id.equals(other.id) : other.id == null)) {
                return false;
            }
            return this.description.equals(other.description);
        }

        public int hashCode() {
            int PRIME = 37;
            int result = 1;
            result = 37 * result + (this.id == null ? 0 : this.id.hashCode());
            return result;
        }

        public String toString() {
            return super.toString() + " --> " + this.id + " " + this.description;
        }
    }

    public static final class Factory {
        public static <M extends Marker> M newMarker(Class<M> type, Context context) throws MarkerException {
            Marker marker;
            if (null == type) {
                throw new MarkerException("Marker type must not be null");
            }
            if (null == context) {
                throw new MarkerException("Marker context must not be null");
            }
            MarkerImpl handler = new MarkerImpl(type, context);
            try {
                marker = (Marker)Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type}, (InvocationHandler)handler);
                handler.initialize(marker);
            }
            catch (Exception e) {
                throw new MarkerException(e);
            }
            return (M)marker;
        }

        private Factory() {
        }
    }
}

