/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.osgi.boot;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class ProgressBar
extends JPanel {
    private final int BAR_INTERVAL = 14;
    private final Color STROKE_COLOR = new Color(184, 184, 184, 140);
    private final Color SEGMENT_COLOR = new Color(184, 184, 184, 77);
    private final Color BC1 = new Color(127, 127, 127, 255);
    private final Color BC2 = new Color(0, 0, 0, 0);
    private final Color BC3 = new Color(66, 66, 66, 133);
    private final Color BC4 = new Color(189, 189, 189, 214);
    private final float[] BG_POS = new float[]{0.0f, 0.5f, 0.59f, 1.0f};
    private final Color[] BG_COLORS = new Color[]{this.BC1, this.BC2, this.BC3, this.BC4};
    private final Color FC1 = new Color(209790);
    private final Color FC2 = new Color(347064);
    private final Color FC4 = new Color(418027);
    private final float[] FG_POS = new float[]{0.0f, 0.1f, 0.39f, 0.47f, 0.53f, 0.61f, 0.9f, 1.0f};
    private final Color[] FG_COLORS = new Color[]{this.FC1, this.FC2, this.FC2, this.FC4, this.FC4, this.FC2, this.FC2, this.FC1};
    private final Color GLOW_OPAQUE = new Color(255, 255, 255, 230);
    private final Color GLOW_TRANSPARENT = new Color(255, 255, 255, 0);
    private final float[] GLOW_POS = new float[]{0.0f, 0.3f, 0.98f};
    private final Color[] GLOW_COLORS = new Color[]{this.GLOW_OPAQUE, this.GLOW_OPAQUE, this.GLOW_TRANSPARENT};
    private final BasicStroke STROKE = new BasicStroke(1.0f);
    private int _top = 0;
    private int _left = 0;
    private int _width = 700;
    private int _height = 50;
    private int _barInterval = 14;
    private int _min;
    private int _max;
    private Object _progressMonitor = new Object();
    private int _progress = 0;
    private Boolean _indeterminateProgress = false;
    private Timer _timeoutTimer = null;
    private Timer _animationTimer = null;
    private RangedNumber _glow = new RangedNumber(-2, 3, 1);
    private final Runnable _repainter;

    public ProgressBar(int min, int max) {
        this._min = min;
        this._max = max;
        this.setOpaque(false);
        this._timeoutTimer = new Timer(1500, new TimeoutTimerListener());
        this._timeoutTimer.setRepeats(true);
        this._animationTimer = new Timer(200, new AnimationTimerListener());
        this._animationTimer.setRepeats(true);
        this._repainter = new Runnable(){

            @Override
            public void run() {
                ProgressBar.this.repaint();
            }
        };
    }

    public int getMin() {
        return this._min;
    }

    public void setMin(int value) {
        this._min = value;
    }

    public int getMax() {
        return this._max;
    }

    public void setMax(int value) {
        this._max = value;
    }

    public int getValue() {
        return this._progress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(int value) {
        Object object = this._progressMonitor;
        synchronized (object) {
            this.stopIndeterminate();
            this._timeoutTimer.stop();
            this._progress = value;
            SwingUtilities.invokeLater(this._repainter);
            this._timeoutTimer.start();
        }
    }

    public void stop() {
        this._animationTimer.stop();
        this._timeoutTimer.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopIndeterminate() {
        if (this._animationTimer.isRunning()) {
            Boolean bl = this._indeterminateProgress;
            synchronized (bl) {
                this._indeterminateProgress = false;
            }
            this._animationTimer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startIndeterminate() {
        this._timeoutTimer.stop();
        Boolean bl = this._indeterminateProgress;
        synchronized (bl) {
            this._indeterminateProgress = true;
        }
        this._animationTimer.start();
    }

    public void setBarInterval(int value) {
        if (this._barInterval != value) {
            this._barInterval = value;
            this.repaint();
        }
    }

    public int getBarInterval() {
        return this._barInterval;
    }

    public int getTop() {
        return this._top;
    }

    public void setTop(int value) {
        this._top = value;
    }

    public int getLeft() {
        return this._left;
    }

    public void setLeft(int value) {
        this._left = value;
    }

    @Override
    public int getWidth() {
        return this._width;
    }

    @Override
    public int getHeight() {
        return this._height;
    }

    public void setWidth(int value) {
        this._width = value;
        super.setSize(value, this._height);
    }

    public void setHeight(int value) {
        this._height = value;
        super.setSize(this._width, value);
    }

    @Override
    public void setSize(int p1, int p2) {
        this._width = p1;
        this._height = p2;
        super.setSize(p1, p2);
    }

    @Override
    public void setBounds(Rectangle rect) {
        super.setBounds(rect);
        this._width = rect.width;
        this._height = rect.height;
    }

    private int getProgressWidth(int width) {
        int result = 0;
        int numerator = this._progress * width;
        int denominator = this.getMax() - this.getMin();
        if (denominator > 0) {
            result = numerator / denominator;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintGlow(Graphics2D graphics, int left, int top, int width, int height, int glow) {
        Shape savedClip = graphics.getClip();
        try {
            graphics.setClip(left, top, width, height);
            try {
                if (width > 0) {
                    float radius = (float)width / 2.0f;
                    BufferedImage mask = new BufferedImage(width, width, 3);
                    Graphics2D maskGraphics2D = (Graphics2D)mask.getGraphics();
                    maskGraphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    RadialGradientPaint paint = new RadialGradientPaint(radius, radius, radius, this.GLOW_POS, this.GLOW_COLORS);
                    maskGraphics2D.setPaint(paint);
                    if (width > 0) {
                        maskGraphics2D.scale(1.0, (double)height * 1.5 / (double)width);
                    }
                    maskGraphics2D.fillOval(0, 0, width, width);
                    graphics.drawImage((Image)mask, left, top - height + glow, this);
                    graphics.drawImage((Image)mask, left, (int)((double)top + (double)height * 0.5) - glow, this);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        finally {
            graphics.setClip(savedClip);
        }
    }

    public void paintSegments(Graphics2D graphics, int left, int top, int width, int height) {
        graphics.setColor(this.SEGMENT_COLOR);
        for (int x = this._barInterval; x < width; x += this._barInterval) {
            graphics.drawLine(left + x, top, left + x, top + height - 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintBackground(Graphics2D graphics, int left, int top, int width, int height) {
        AlphaComposite savedComposite = (AlphaComposite)graphics.getComposite();
        try {
            AlphaComposite composite = AlphaComposite.getInstance(3, 0.3f);
            graphics.setComposite(composite);
            graphics.setPaint(new LinearGradientPaint(left, top, left, top + height, this.BG_POS, this.BG_COLORS));
            graphics.fillRect(left, top, width, height);
        }
        finally {
            graphics.setComposite(savedComposite);
        }
    }

    public void paintProgress(Graphics2D graphics, int left, int top, int width, int height) {
        graphics.setColor(this.STROKE_COLOR);
        graphics.drawRect(left, top, width - 1, height - 1);
        graphics.setPaint(new LinearGradientPaint(left - 1, top, left + width, top, this.FG_POS, this.FG_COLORS));
        graphics.fillRect(left, top, width, height);
        graphics.setPaint(new RadialGradientPaint((float)width / 2.0f, (float)height / 2.0f, (float)height / 2.0f, new float[]{0.5f, 1.0f}, new Color[]{new Color(255, 255, 255, 63), new Color(255, 255, 255, 0)}));
        graphics.fillRoundRect(left, top, width, height + 2, 4, 4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintProgressBar(Graphics g, int left, int top, int width, int height) {
        int progressWidth = this.getProgressWidth(width);
        Graphics2D graphics2D = (Graphics2D)g;
        Color savedBackgroundColor = graphics2D.getBackground();
        Stroke savedStroke = graphics2D.getStroke();
        Paint savedPaint = graphics2D.getPaint();
        try {
            int glowValue = this._glow.getValue();
            if (!this._indeterminateProgress.booleanValue() && glowValue != 0) {
                this._glow.revert();
                glowValue = this._glow.getValue();
            }
            graphics2D.setBackground(new Color(0, 0, 0, 0));
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setStroke(this.STROKE);
            this.paintBackground(graphics2D, left, top, width, height);
            this.paintProgress(graphics2D, left, top, progressWidth, height);
            this.paintGlow(graphics2D, left + 1, top + 1, progressWidth - 2, height - 2, glowValue);
            this.paintSegments(graphics2D, left, top, width, height);
        }
        finally {
            graphics2D.setStroke(savedStroke);
            graphics2D.setPaint(savedPaint);
            graphics2D.setBackground(savedBackgroundColor);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        this.paintProgressBar(g, this.getLeft(), this.getTop(), this.getWidth(), this.getHeight());
    }

    private class RangedNumber {
        private int _min;
        private int _max;
        private int _delta;
        private int _inc;
        private int _value = 0;

        RangedNumber(int min, int max, int delta) {
            this._min = min;
            this._max = max;
            this._delta = delta;
            this._inc = delta;
        }

        public void modulate() {
            this._value += this._inc;
            if (Integer.signum(this._inc) == 1 && this._value > this._max) {
                this._inc = -1 * this._delta;
                this._value = this._max;
            } else if (Integer.signum(this._inc) == -1 && this._value < this._min) {
                this._inc = this._delta;
                this._value = this._min;
            }
        }

        public void revert() {
            this._value -= Integer.signum(this._value) * this._delta;
        }

        public int getValue() {
            return this._value;
        }
    }

    private class TimeoutTimerListener
    implements ActionListener {
        private TimeoutTimerListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ProgressBar.this.startIndeterminate();
        }
    }

    private class AnimationTimerListener
    implements ActionListener {
        private AnimationTimerListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ProgressBar.this._indeterminateProgress.booleanValue()) {
                ProgressBar.this._glow.modulate();
                SwingUtilities.invokeLater(ProgressBar.this._repainter);
            }
        }
    }
}

