/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.resultsTable;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import oracle.bali.dbUI.columnPropertyEditor.ColumnWrapper;
import oracle.bali.dbUI.columnPropertyEditor.VisualColumn;
import oracle.bali.dbUI.constraint.Constrainable;
import oracle.bali.dbUI.constraint.ConstrainableModel;
import oracle.bali.dbUI.constraint.DataConstraint;
import oracle.bali.dbUI.db.Column;
import oracle.bali.dbUI.db.DataDescriptor;
import oracle.bali.dbUI.db.DataDescriptorProvider;
import oracle.bali.dbUI.db.OuterJoin;
import oracle.bali.dbUI.db.Relationship;
import oracle.bali.dbUI.db.impl.ColumnImpl;
import oracle.bali.dbUI.header.CBHeaderInputHandler;
import oracle.bali.dbUI.header.CBHeaderItemPainter;
import oracle.bali.dbUI.header.ConstraintSortHandler;
import oracle.bali.dbUI.resultsTable.ModelFactory;
import oracle.bali.dbUI.resultsTable.ResultsSpreadTable;
import oracle.bali.dbUI.resultsTable.ResultsTableCustomizer;
import oracle.bali.dbUI.resultsTable.SortableWrapper;
import oracle.bali.ewt.LWComponent;
import oracle.bali.ewt.graphics.ColorUtils;
import oracle.bali.ewt.grid.AppearanceManager;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.grid.GridDataToolTipManager;
import oracle.bali.ewt.grid.GridToolTipManager;
import oracle.bali.ewt.grid.RowGroupingAppearance;
import oracle.bali.ewt.header.GeneralHeaderSelectionManager;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.header.HeaderItemInputHandler;
import oracle.bali.ewt.model.ArrayOneDModel;
import oracle.bali.ewt.model.OneDModel;
import oracle.bali.ewt.model.Sortable;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.table.SpreadTable;
import oracle.bali.ewt.table.TableEvent;
import oracle.bali.ewt.table.TableMoveListener;
import oracle.bali.ewt.table.TableResizeAdapter;
import oracle.bali.ewt.table.TableResizeListener;
import oracle.bali.ewt.util.LocaleUtils;

public class ResultsTable
extends LWComponent
implements Accessible {
    private static final int _DEFAULT_WIDTH = 100;
    private SpreadTable _table;
    private JScrollPane _scrollBox;
    private CBHeaderInputHandler _inputHandler;
    private DataConstraint _filterConstraint;
    private ColumnWrapper[] _wrappers;
    private DataConstraint _constraint;
    private Relationship[] _relationships;
    private OuterJoin[] _outerJoins;
    private ModelFactory _factory;
    private ResultsTableCustomizer _customizer;
    private SortableWrapper _sortable;
    boolean _wrappersDirty;

    public ResultsTable() {
        this(null, null, null, null, null);
    }

    public ResultsTable(ModelFactory factory, ColumnWrapper[] wrappers) {
        this(factory, wrappers, null, null, null);
    }

    public ResultsTable(ModelFactory factory, ColumnWrapper[] wrappers, DataConstraint constraint, Relationship[] relationships) {
        this(factory, wrappers, constraint, relationships, null);
    }

    public ResultsTable(ModelFactory factory, ColumnWrapper[] wrappers, DataConstraint constraint, Relationship[] relationships, OuterJoin[] outerJoins) {
        this.setLayout(new BorderLayout());
        this._table = new ResultsSpreadTable();
        UIListener listener = new UIListener();
        this._table.addResizeListener((TableResizeListener)listener);
        this._table.addMoveListener((TableMoveListener)listener);
        Grid grid = this._table.getGrid();
        RowGroupingAppearance apperance = new RowGroupingAppearance();
        Color color = UIManager.getColor("normalIntensity");
        if (color != null) {
            apperance.setColor(ColorUtils.lighterShadeColor((Color)color));
        }
        apperance.setRows(1);
        grid.setAppearanceManager((AppearanceManager)apperance);
        grid.setToolTipManager((GridToolTipManager)new GridDataToolTipManager());
        this._scrollBox = new JScrollPane((Component)this._table);
        JDesktopPane c = new JDesktopPane();
        c.setLayout(new Layout());
        c.add("content", this._scrollBox);
        this.add("Center", c);
        this.setRelationships(relationships);
        this.setColumnWrappers(wrappers);
        this.setDataConstraint(constraint);
        this.setOuterJoins(outerJoins);
        this.setModelFactory(factory);
        this.updateResults();
    }

    public void setModelFactory(ModelFactory factory) {
        if (this._factory != factory) {
            this._factory = factory;
        }
    }

    public ModelFactory getModelFactory() {
        return this._factory;
    }

    public void setColumnWrappers(ColumnWrapper[] wrappers) {
        this._wrappersDirty = false;
        this._wrappers = null;
        if (wrappers != null) {
            this._wrappers = new ColumnWrapper[wrappers.length];
            System.arraycopy(wrappers, 0, this._wrappers, 0, wrappers.length);
        }
    }

    public ColumnWrapper[] getColumnWrappers() {
        ColumnWrapper[] wrappers = null;
        if (this._wrappersDirty) {
            int count;
            int n = count = this._wrappers == null ? 0 : this._wrappers.length;
            if (count != 0) {
                wrappers = new ColumnWrapper[count];
                for (int i = 0; i < count; ++i) {
                    if (this._wrappers[i] instanceof VisualColumn) {
                        VisualColumn vColumn = (VisualColumn)this._wrappers[i];
                        vColumn.setWidth(this.getSpreadTable().getColumnWidth(i));
                    }
                    int index = this.getSpreadTable().getGrid().getColumnVisibleIndex(i);
                    wrappers[index] = this._wrappers[i];
                }
            }
        } else if (this._wrappers != null) {
            wrappers = new ColumnWrapper[this._wrappers.length];
            System.arraycopy(this._wrappers, 0, wrappers, 0, wrappers.length);
        }
        return wrappers;
    }

    public void setDataConstraint(DataConstraint constraint) {
        if (this._constraint != constraint) {
            this._constraint = constraint;
        }
    }

    public DataConstraint getDataConstraint() {
        return this._constraint;
    }

    public void setRelationships(Relationship[] relationships) {
        this._relationships = null;
        if (relationships != null) {
            this._relationships = new Relationship[relationships.length];
            System.arraycopy(relationships, 0, this._relationships, 0, relationships.length);
        }
    }

    public Relationship[] getRelationships() {
        Relationship[] toReturn = null;
        if (this._relationships != null) {
            toReturn = new Relationship[this._relationships.length];
            System.arraycopy(this._relationships, 0, toReturn, 0, toReturn.length);
        }
        return toReturn;
    }

    public void setOuterJoins(OuterJoin[] outerJoins) {
        this._outerJoins = null;
        if (outerJoins != null) {
            this._outerJoins = new OuterJoin[outerJoins.length];
            System.arraycopy(outerJoins, 0, this._outerJoins, 0, outerJoins.length);
        }
    }

    public OuterJoin[] getOuterJoins() {
        OuterJoin[] toReturn = null;
        if (this._outerJoins != null) {
            toReturn = new OuterJoin[this._outerJoins.length];
            System.arraycopy(this._outerJoins, 0, toReturn, 0, toReturn.length);
        }
        return toReturn;
    }

    public void updateResults() {
        Grid grid;
        int index;
        this.cleanupResults();
        this._wrappersDirty = false;
        ModelFactory factory = this.getModelFactory();
        if (factory == null) {
            return;
        }
        Relationship[] relations = this._relationships;
        DataConstraint constraint = this._constraint;
        ColumnWrapper[] wrappers = this._wrappers;
        Column[] columns = ColumnWrapper.getColumns(wrappers);
        OuterJoin[] outerJoins = this._outerJoins;
        boolean validWrappers = wrappers != null && wrappers.length > 0;
        Object ds = null;
        OneDModel cds = null;
        if (validWrappers) {
            ds = factory.createModel(columns, constraint, relations, outerJoins);
            cds = this._createColumnModel(wrappers);
        }
        WrapperProvider provider = null;
        if (validWrappers) {
            provider = new WrapperProvider(wrappers);
        }
        Constrainable constrainable = null;
        Sortable sortable = null;
        if (ds != null) {
            if (!(ds instanceof Constrainable)) {
                ds = new ConstrainableModel((TwoDModel)ds, provider);
            }
            constrainable = (Constrainable)ds;
            if (ds instanceof Sortable) {
                this._sortable = null;
            } else {
                this._sortable = new SortableWrapper((TwoDModel)ds);
                ds = this._sortable;
            }
            sortable = (Sortable)ds;
        }
        this._table.setModels(ds, cds, null);
        this._updateUI();
        this._table.setScrollByColumn(false);
        if (cds != null) {
            Header header = this._table.getColumnHeader();
            for (int i = 0; i < header.getItemCount(); ++i) {
                header.setPainter(i, (Painter)new CBHeaderItemPainter());
            }
            ConstraintSortHandler h = new ConstraintSortHandler(header, constrainable, null, provider, sortable);
            h.addPropertyChangeListener(new DCListen());
            header.setItemInputHandler((HeaderItemInputHandler)h);
            this._inputHandler = h;
            if (this._filterConstraint != null) {
                this._inputHandler.setDataConstraint(this._filterConstraint);
                this._filterConstraint = null;
            }
            header.setHeaderSelectionManager(GeneralHeaderSelectionManager.getNullHeaderSelectionManager());
        }
        if ((index = (grid = this._table.getGrid()).getNextVisibleColumn(-1)) != -1) {
            this._table.setFirstColumnOnScreen(index);
        }
        if (grid.getRowCount() > 0) {
            this._table.setFirstRowOnScreen(0);
        }
        this.invalidate();
        this.repaint();
    }

    public void setCustomizer(ResultsTableCustomizer customizer) {
        if (this._customizer != customizer) {
            this._customizer = customizer;
        }
    }

    public ResultsTableCustomizer getCustomizer() {
        if (this._customizer == null) {
            this._customizer = ResultsTableCustomizer.getResultsTableCustomizer();
        }
        return this._customizer;
    }

    public void setFilterDataConstraint(DataConstraint filterConstraint) {
        if (this._inputHandler != null) {
            this._inputHandler.setDataConstraint(filterConstraint);
        } else {
            this._filterConstraint = filterConstraint;
        }
    }

    public DataConstraint getFilterDataConstraint() {
        if (this._inputHandler != null) {
            return this._inputHandler.getDataConstraint();
        }
        return this._filterConstraint;
    }

    public SpreadTable getSpreadTable() {
        return this._table;
    }

    public void cleanupResults() {
        if (this._table.getColumnHeader() != null) {
            this._table.getColumnHeader().setItemInputHandler(null);
        }
        if (this._inputHandler != null) {
            this._inputHandler.setHeader(null);
            this._inputHandler = null;
        }
        this._table.setModels(null, null, null);
        this._table.setColumnHeaderVisible(true);
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new JComponent.AccessibleJComponent(){};
        }
        return this.accessibleContext;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this._scrollBox.setEnabled(enabled);
        this._table.setEnabled(enabled);
    }

    public void requestFocus() {
        this._table.requestFocus();
    }

    void firePropertyChange(DataConstraint newValue) {
        this.firePropertyChange("dataConstraint", null, newValue);
    }

    private OneDModel _createColumnModel(ColumnWrapper[] wrappers) {
        Locale locale = LocaleUtils.getDefaultableLocale((Component)((Object)this));
        Object[] array = new String[wrappers.length];
        if (wrappers[0] instanceof VisualColumn) {
            for (int i = 0; i < wrappers.length; ++i) {
                VisualColumn column = (VisualColumn)wrappers[i];
                array[i] = column.getDisplayName(locale);
            }
        } else {
            for (int i = 0; i < wrappers.length; ++i) {
                array[i] = wrappers[i].getColumn().getDisplayName(locale);
            }
        }
        return new ArrayOneDModel(array);
    }

    private void _updateUI() {
        block6: {
            ColumnWrapper[] wrappers = this._wrappers;
            ResultsTableCustomizer custom = this.getCustomizer();
            SpreadTable table = this.getSpreadTable();
            Grid grid = table.getGrid();
            int columnCount = grid.getColumnCount();
            if (wrappers == null || wrappers.length <= 0 || wrappers.length != columnCount) break block6;
            if (wrappers[0] instanceof VisualColumn) {
                for (int i = 0; i < wrappers.length; ++i) {
                    VisualColumn vColumn = (VisualColumn)wrappers[i];
                    Column column = vColumn.getColumn();
                    grid.setColumnPainter(i, custom.getPainter(column));
                    grid.setColumnCellInputHandler(i, custom.getCellInputHandler(column));
                    table.setColumnVisible(i, vColumn.isVisible());
                    table.setColumnWidth(i, vColumn.getWidth());
                    if (this._sortable == null) continue;
                    this._sortable.setColumnComparator(i, custom.getComparator(column));
                }
            } else {
                Font font = this.getFont();
                FontMetrics fm = font == null ? null : this.getFontMetrics(font);
                for (int i = 0; i < wrappers.length; ++i) {
                    Column column = wrappers[i].getColumn();
                    grid.setColumnPainter(i, custom.getPainter(column));
                    grid.setColumnCellInputHandler(i, custom.getCellInputHandler(column));
                    table.setColumnVisible(i, custom.displayColumn(column));
                    if (fm != null) {
                        table.setColumnWidth(i, custom.getColumnWidth(column, fm));
                    } else {
                        table.setColumnWidth(i, 100);
                    }
                    if (this._sortable == null) continue;
                    this._sortable.setColumnComparator(i, custom.getComparator(column));
                }
            }
        }
    }

    private class UIListener
    extends TableResizeAdapter
    implements TableMoveListener {
        private UIListener() {
        }

        public void columnResized(TableEvent e) {
            ResultsTable.this._wrappersDirty = true;
        }

        public void columnMoving(TableEvent e) {
        }

        public void columnMoved(TableEvent e) {
            ResultsTable.this._wrappersDirty = true;
        }

        public void rowMoving(TableEvent e) {
        }

        public void rowMoved(TableEvent e) {
        }
    }

    private class Layout
    implements LayoutManager {
        private Component _content;

        private Layout() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
            if ("content".equals(name)) {
                this._content = comp;
            }
        }

        @Override
        public void removeLayoutComponent(Component comp) {
            if (this._content == comp) {
                this._content = null;
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return this._content == null ? new Dimension(0, 0) : this._content.getPreferredSize();
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this._content == null ? new Dimension(0, 0) : this._content.getMinimumSize();
        }

        @Override
        public void layoutContainer(Container parent) {
            if (this._content != null) {
                Dimension d = parent.getSize();
                this._content.setBounds(0, 0, d.width, d.height);
            }
        }
    }

    private class WrapperProvider
    implements DataDescriptorProvider {
        private Column[] _columns;

        public WrapperProvider(ColumnWrapper[] wrappers) {
            this._columns = this._getColumns(wrappers);
        }

        @Override
        public int getDescriptorCount() {
            return this._columns == null ? 0 : this._columns.length;
        }

        @Override
        public DataDescriptor getDescriptor(int index) {
            return this._columns[index];
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener listener) {
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener listener) {
        }

        private Column[] _getColumns(ColumnWrapper[] wrappers) {
            if (wrappers == null || wrappers.length == 0) {
                return null;
            }
            if (!(wrappers[0] instanceof VisualColumn)) {
                return ColumnWrapper.getColumns(wrappers);
            }
            int count = wrappers.length;
            Column[] columns = new Column[count];
            for (int i = 0; i < count; ++i) {
                VisualColumn vColumn = (VisualColumn)wrappers[i];
                Column column = vColumn.getColumn();
                columns[i] = new ColumnImpl(column.getName(), vColumn.getDisplayName(), column.getDataType(), column.getTable());
            }
            return columns;
        }
    }

    private class DCListen
    implements PropertyChangeListener {
        private DCListen() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            ResultsTable.this.firePropertyChange((DataConstraint)e.getNewValue());
        }
    }
}

