/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.lwAWT.lwMenu;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import oracle.ewt.access.AccessibleLWComponent;
import oracle.ewt.lwAWT.FocusRoot;
import oracle.ewt.lwAWT.KeyProcessor;
import oracle.ewt.lwAWT.lwMenu.BaseMIContainer;
import oracle.ewt.lwAWT.lwMenu.LWMenuItem;
import oracle.ewt.lwAWT.lwMenu.MenuUtils;
import oracle.ewt.lwAWT.lwMenu.PreferredRowLayout;
import oracle.ewt.util.ComponentUtils;
import oracle.ewt.util.InputEventUtils;
import oracle.ewt.util.WindowUtils;

public class LWMenuBar
extends BaseMIContainer {
    private KeyListener _acceleratorFilter;
    private KeyProcessor _keyProcessor;
    private boolean _altPressed;
    private boolean _consumeKeys;
    private static final int _MINIMUM_WIDTH = 100;
    private static boolean _sHandleMnemonic = false;
    private boolean _menuBarHandleMnemonic = false;

    public static final void setMnemonicHandled(boolean bl) {
        _sHandleMnemonic = bl;
    }

    public static final boolean isMnemonicHandled() {
        return _sHandleMnemonic;
    }

    @Override
    public int getOrientation() {
        return 1;
    }

    @Override
    public Object getUIClassID() {
        return "MenuBarUI";
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this._addKeyFilter();
    }

    @Override
    public Dimension getMaximumSize() {
        Dimension dimension = this.getPreferredSize();
        Dimension dimension2 = super.getMaximumSize();
        dimension2.height = dimension.height;
        return dimension2;
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension dimension = super.getMinimumSize();
        if (dimension.width > 100) {
            dimension.width = 100;
        }
        return dimension;
    }

    @Override
    public void itemSelectionChange(LWMenuItem lWMenuItem, boolean bl) {
        LWMenuItem lWMenuItem2 = this.getSelectedItem();
        super.itemSelectionChange(lWMenuItem, bl);
        LWMenuItem lWMenuItem3 = this.getSelectedItem();
        if (lWMenuItem2 == null && lWMenuItem3 != null) {
            this.addMenuGrab();
        } else if (lWMenuItem2 != null && lWMenuItem3 == null) {
            this.removeMenuGrab();
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        LWMenuItem lWMenuItem = this.getSelectedItem();
        if (lWMenuItem != null) {
            lWMenuItem.setSelected(false);
        }
        this._removeKeyFilter();
    }

    @Override
    protected LayoutManager createContentLayout() {
        return PreferredRowLayout.getInstance();
    }

    @Override
    protected void dismissMenu() {
        LWMenuItem lWMenuItem = this.getSelectedItem();
        if (lWMenuItem != null) {
            lWMenuItem.setSelected(false);
        }
    }

    protected void postProcessMenuBarKey(KeyEvent keyEvent) {
        if (LWMenuBar.isMnemonicHandled() && keyEvent.getKeyCode() == 18 && keyEvent.getID() == 402 && this.__isMnemonicHandled()) {
            keyEvent.consume();
            this.__setMnemonicHandled(false);
            return;
        }
        this._handleAccelerator(keyEvent);
        if (keyEvent.isConsumed()) {
            this._consumeKeySequence(keyEvent);
            return;
        }
        this._handleMnemonic(keyEvent);
        if (keyEvent.isConsumed()) {
            return;
        }
        this._handleAltKey(keyEvent);
    }

    @Override
    protected void processGrabbedKeyEvent(KeyEvent keyEvent) {
        if (this._consumeKeys) {
            int n = keyEvent.getID();
            if (n == 401) {
                this._consumeKeys = false;
            } else {
                if (n == 402) {
                    this._consumeKeys = false;
                }
                keyEvent.consume();
                return;
            }
        }
        super.processGrabbedKeyEvent(keyEvent);
    }

    @Override
    protected void processGrabbedMouseEvent(MouseEvent mouseEvent) {
        Component component;
        Component component2;
        int n = mouseEvent.getID();
        if (n == 501) {
            LWMenuItem lWMenuItem;
            Component component3 = (Component)mouseEvent.getSource();
            if (!MenuUtils.isMenuDescendent(component3, lWMenuItem = this.getSelectedItem())) {
                lWMenuItem.setSelected(false);
                mouseEvent.consume();
            }
        } else if (n == 502 && (component2 = (Component)mouseEvent.getSource()).isDisplayable() && ((component = ComponentUtils.getTargetComponentOutside(component2, new Point(mouseEvent.getX(), mouseEvent.getY()))) == null || component == this || MenuUtils.getRootMenuItemContainer(component) != this)) {
            LWMenuItem lWMenuItem = this.getSelectedItem();
            lWMenuItem.setSelected(false);
            mouseEvent.consume();
        }
    }

    @Override
    protected AccessibleContext createAccessibleContext() {
        return new Access();
    }

    boolean __isMnemonicHandled() {
        return this._menuBarHandleMnemonic;
    }

    void __setMnemonicHandled(boolean bl) {
        this._menuBarHandleMnemonic = bl;
    }

    private void _addKeyFilter() {
        this._keyProcessor = this._getKeyProcessor();
        if (this._keyProcessor != null) {
            this._acceleratorFilter = new AccelFilter();
            this._keyProcessor.addPostKeyListener(this._acceleratorFilter);
        }
    }

    private void _consumeKeySequence(KeyEvent keyEvent) {
        Component component = keyEvent.getComponent();
        Window window = WindowUtils.getWindow(component);
        if (WindowUtils.getFocusOwner(window) == component) {
            new KeyConsumer(keyEvent);
        }
        this._consumeKeys = true;
    }

    private KeyProcessor _getKeyProcessor() {
        KeyProcessor keyProcessor = null;
        for (Container container = this.getParent(); container != null; container = container.getParent()) {
            if (container instanceof KeyProcessor) {
                keyProcessor = (KeyProcessor)((Object)container);
            }
            if (container instanceof FocusRoot && container.isLightweight() || container instanceof Window) break;
        }
        return keyProcessor;
    }

    private void _handleAltKey(KeyEvent keyEvent) {
        if (!keyEvent.isConsumed()) {
            if (keyEvent.getKeyCode() == 18 && (InputEventUtils.getMods(keyEvent) & 0xFFFFFFF7) == 0) {
                int n = keyEvent.getID();
                if (n == 401) {
                    this._altPressed = true;
                    keyEvent.consume();
                } else if (n == 402) {
                    LWMenuItem lWMenuItem;
                    if (this._altPressed && (lWMenuItem = MenuUtils.getNextItem(this, null)) != null) {
                        lWMenuItem.setSelected(true);
                    }
                    this._altPressed = false;
                    keyEvent.consume();
                }
            } else {
                this._altPressed = false;
            }
        }
    }

    private void _handleMnemonic(KeyEvent keyEvent) {
        if (keyEvent.getID() == 401 && LWMenuBar.hasMnemonicModifier(keyEvent) && keyEvent.getKeyCode() != 0) {
            Container container = this.getContent();
            int n = container.getComponentCount();
            for (int i = 0; i < n; ++i) {
                Component component = container.getComponent(i);
                if (!(component instanceof LWMenuItem)) continue;
                LWMenuItem lWMenuItem = (LWMenuItem)component;
                lWMenuItem.handleMnemonic(keyEvent);
                if (!keyEvent.isConsumed()) continue;
                this._consumeKeySequence(keyEvent);
                break;
            }
        }
    }

    private void _handleAccelerator(KeyEvent keyEvent) {
        if (keyEvent.getID() == 401) {
            Container container = this.getContent();
            int n = container.getComponentCount();
            for (int i = 0; i < n; ++i) {
                Component component = container.getComponent(i);
                if (!(component instanceof LWMenuItem)) continue;
                ((LWMenuItem)component).handleAccelerator(keyEvent);
                if (!keyEvent.isConsumed()) continue;
                return;
            }
        }
    }

    private void _removeKeyFilter() {
        if (this._keyProcessor != null) {
            this._keyProcessor.removePostKeyListener(this._acceleratorFilter);
            this._keyProcessor = null;
            this._acceleratorFilter = null;
        }
    }

    private class Access
    extends AccessibleLWComponent {
        public Access() {
            super(LWMenuBar.this);
        }

        @Override
        public int getAccessibleChildrenCount() {
            return LWMenuBar.this.getContent().getComponentCount();
        }

        @Override
        public Accessible getAccessibleChild(int n) {
            int n2 = this.getAccessibleChildrenCount();
            if (n < 0 || n >= n2) {
                return null;
            }
            Component component = LWMenuBar.this.getContent().getComponent(n);
            if (component instanceof Accessible) {
                Accessible accessible = (Accessible)((Object)component);
                accessible.getAccessibleContext().setAccessibleParent(LWMenuBar.this);
                return accessible;
            }
            return null;
        }

        @Override
        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            accessibleStateSet.add(AccessibleState.HORIZONTAL);
            return accessibleStateSet;
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.MENU_BAR;
        }
    }

    private static class KeyConsumer
    implements KeyListener,
    FocusListener {
        private Component _comp;

        public KeyConsumer(KeyEvent keyEvent) {
            this._comp = keyEvent.getComponent();
            this._comp.addKeyListener(this);
            this._comp.addFocusListener(this);
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            keyEvent.consume();
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            keyEvent.consume();
            this._remove();
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
            keyEvent.consume();
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            this._remove();
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
        }

        private void _remove() {
            if (this._comp != null) {
                this._comp.removeKeyListener(this);
                this._comp.removeFocusListener(this);
                this._comp = null;
            }
        }
    }

    private class AccelFilter
    implements KeyListener {
        private AccelFilter() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if ((LWMenuBar.this.isShowing() || keyEvent.getKeyChar() == '-' && keyEvent.isAltDown() || keyEvent.getKeyCode() == 115 && keyEvent.isControlDown()) && LWMenuBar.this.isEnabled()) {
                LWMenuBar.this.postProcessMenuBarKey(keyEvent);
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            if ((LWMenuBar.this.isShowing() || keyEvent.getKeyChar() == '-' && keyEvent.isAltDown()) && LWMenuBar.this.isEnabled()) {
                LWMenuBar.this.postProcessMenuBarKey(keyEvent);
            }
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
            if ((LWMenuBar.this.isShowing() || keyEvent.getKeyChar() == '-' && keyEvent.isAltDown()) && LWMenuBar.this.isEnabled()) {
                LWMenuBar.this.postProcessMenuBarKey(keyEvent);
            }
        }
    }
}

