/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.laf.oracle;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import oracle.ewt.LookAndFeel;
import oracle.ewt.UIDefaults;
import oracle.ewt.laf.oracle.OracleColorScheme;
import oracle.ewt.painter.AbstractPainter;
import oracle.ewt.painter.PaintContext;
import oracle.ewt.painter.Painter;
import oracle.ewt.plaf.TableUI;

public class OracleCornerPainter
extends AbstractPainter {
    public static final int UPPER_LEFT = 0;
    public static final int UPPER_RIGHT = 1;
    public static final int LOWER_LEFT = 2;
    public static final int LOWER_RIGHT = 3;
    private static Painter _sLowerLeft;
    private static Painter _sLowerRight;
    private static Painter _sUpperLeft;
    private static Painter _sUpperRight;
    private int _corner;

    private OracleCornerPainter(int n) {
        this._corner = n;
    }

    public static Painter getPainter() {
        return OracleCornerPainter.getPainter(0);
    }

    public static Painter getPainter(int n) {
        Painter painter = null;
        switch (n) {
            case 0: {
                if (_sUpperLeft == null) {
                    _sUpperLeft = new OracleCornerPainter(0);
                }
                painter = _sUpperLeft;
                break;
            }
            case 1: {
                if (_sUpperRight == null) {
                    _sUpperRight = new OracleCornerPainter(1);
                }
                painter = _sUpperRight;
                break;
            }
            case 2: {
                if (_sLowerLeft == null) {
                    _sLowerLeft = new OracleCornerPainter(2);
                }
                painter = _sLowerLeft;
                break;
            }
            case 3: {
                if (_sLowerRight == null) {
                    _sLowerRight = new OracleCornerPainter(3);
                }
                painter = _sLowerRight;
            }
        }
        return painter;
    }

    @Override
    public Dimension getMinimumSize(PaintContext paintContext) {
        return new Dimension(0, 0);
    }

    @Override
    public int getRepaintFlags(PaintContext paintContext) {
        return 128;
    }

    @Override
    public void paint(PaintContext paintContext, Graphics graphics, int n, int n2, int n3, int n4) {
        Color color = graphics.getColor();
        Object object = paintContext.getPaintData(TableUI.KEY_DRAW_RAISED);
        boolean bl = object instanceof Boolean ? (Boolean)object : true;
        switch (this._corner) {
            case 0: {
                this._paintUpperLeft(paintContext, graphics, n, n2, n3, n4, bl);
                break;
            }
            case 1: {
                this._paintUpperRight(paintContext, graphics, n, n2, n3, n4, bl);
                break;
            }
            case 2: {
                this._paintLowerLeft(paintContext, graphics, n, n2, n3, n4, bl);
                break;
            }
            case 3: {
                this._paintLowerRight(paintContext, graphics, n, n2, n3, n4, bl);
            }
        }
        if (color != null) {
            graphics.setColor(color);
        }
    }

    private void _paintUpperLeft(PaintContext paintContext, Graphics graphics, int n, int n2, int n3, int n4, boolean bl) {
        UIDefaults uIDefaults = paintContext.getPaintUIDefaults();
        int n5 = n2 + n4 - 1;
        int n6 = n + n3 - 1;
        Color color = uIDefaults.getColor(OracleColorScheme.HEADER);
        Color color2 = uIDefaults.getColor(LookAndFeel.NORMAL_INTENSITY);
        graphics.setColor(color);
        graphics.fillRect(n, n2, n3, n4);
        graphics.setColor(color2);
        graphics.drawLine(n + 1, n5, n6, n5);
        graphics.drawLine(n6, n2 + 1, n6, n5);
        graphics.setColor(uIDefaults.getColor(LookAndFeel.CONTROL_SHADOW));
        graphics.drawLine(n, n2, n, n2 + 1);
        graphics.drawLine(n + 1, n2, n + 1, n2);
        int n7 = paintContext.getPaintState();
        if (bl && (n7 & 4) == 0) {
            graphics.setColor(Color.white);
            graphics.drawLine(n, n2 + 2, n, n5);
            graphics.drawLine(n + 1, n2 + 1, n + 1, n2 + 1);
            graphics.drawLine(n + 2, n2, n6, n2);
            graphics.setColor(color);
            graphics.drawLine(n6, n2, n6, n2);
            graphics.drawLine(n, n5, n, n5);
        } else {
            graphics.setColor(color);
            graphics.drawLine(n, n2 + 2, n, n5 - 1);
            graphics.drawLine(n + 2, n2, n6 - 1, n2);
            graphics.setColor(color2);
            graphics.drawLine(n6, n2, n6, n2);
            graphics.drawLine(n, n5, n, n5);
        }
    }

    private void _paintUpperRight(PaintContext paintContext, Graphics graphics, int n, int n2, int n3, int n4, boolean bl) {
        UIDefaults uIDefaults = paintContext.getPaintUIDefaults();
        int n5 = n2 + n4 - 1;
        int n6 = n + n3 - 1;
        Color color = uIDefaults.getColor(OracleColorScheme.HEADER);
        Color color2 = uIDefaults.getColor(LookAndFeel.NORMAL_INTENSITY);
        Color color3 = uIDefaults.getColor(LookAndFeel.CONTROL_LT_HIGHLIGHT);
        Color color4 = uIDefaults.getColor(LookAndFeel.CONTROL_DK_SHADOW);
        graphics.setColor(color);
        graphics.fillRect(n, n2, n3, n4);
        graphics.setColor(color2);
        graphics.drawLine(n6 - 1, n2, n6, n2);
        graphics.drawLine(n6, n2 + 1, n6, n2 + 1);
        int n7 = paintContext.getPaintState();
        if (bl && (n7 & 4) == 0) {
            graphics.setColor(color2);
            graphics.drawLine(n6, n2, n6, n5);
            graphics.drawLine(n, n5 - 1, n6, n5 - 1);
            graphics.setColor(color4);
            graphics.drawLine(n, n5, n6, n5);
            graphics.setColor(Color.white);
            graphics.drawLine(n, n2, n, n5 - 2);
            graphics.drawLine(n + 1, n2, n6 - 2, n2);
            graphics.drawLine(n6 - 1, n2 + 1, n6 - 1, n2 + 1);
        } else {
            graphics.setColor(color2);
            graphics.drawLine(n, n5, n6, n5);
            graphics.drawLine(n, n5 - 1, n6, n5 - 1);
        }
    }

    private void _paintLowerLeft(PaintContext paintContext, Graphics graphics, int n, int n2, int n3, int n4, boolean bl) {
        UIDefaults uIDefaults = paintContext.getPaintUIDefaults();
        int n5 = n2 + n4 - 1;
        int n6 = n + n3 - 1;
        Color color = uIDefaults.getColor(OracleColorScheme.HEADER);
        Color color2 = uIDefaults.getColor(LookAndFeel.NORMAL_INTENSITY);
        Color color3 = uIDefaults.getColor(LookAndFeel.CONTROL_LT_HIGHLIGHT);
        Color color4 = uIDefaults.getColor(LookAndFeel.CONTROL_DK_SHADOW);
        graphics.setColor(color);
        graphics.fillRect(n, n2, n3, n4);
        int n7 = paintContext.getPaintState();
        if (bl && (n7 & 4) != 0) {
            graphics.setColor(color2);
            graphics.drawLine(n6, n2, n6, n5);
            graphics.drawLine(n6 - 1, n2, n6 - 1, n5);
        } else {
            graphics.setColor(color2);
            graphics.drawLine(n + 1, n5 - 1, n + 1, n5 - 1);
            graphics.drawLine(n, n5, n6, n5);
            graphics.drawLine(n6 - 1, n2, n6 - 1, n5);
            graphics.setColor(color4);
            graphics.drawLine(n6, n2, n6, n5);
            graphics.setColor(Color.white);
            graphics.drawLine(n, n2, n6, n2);
            graphics.drawLine(n, n2, n, n5 - 2);
            graphics.drawLine(n + 1, n5 - 1, n + 1, n5 - 1);
            graphics.setColor(color);
            graphics.drawLine(n6, n2, n6, n2);
        }
    }

    private void _paintLowerRight(PaintContext paintContext, Graphics graphics, int n, int n2, int n3, int n4, boolean bl) {
        UIDefaults uIDefaults = paintContext.getPaintUIDefaults();
        int n5 = n2 + n4 - 1;
        int n6 = n + n3 - 1;
        Color color = uIDefaults.getColor(LookAndFeel.CONTROL);
        Color color2 = uIDefaults.getColor(LookAndFeel.NORMAL_INTENSITY);
        Color color3 = uIDefaults.getColor(LookAndFeel.CONTROL_LT_HIGHLIGHT);
        Color color4 = uIDefaults.getColor(LookAndFeel.CONTROL_DK_SHADOW);
        graphics.setColor(color);
        graphics.fillRect(n, n2, n3, n4);
        graphics.setColor(color2);
        graphics.drawLine(n6 - 1, n5, n6, n5);
        graphics.drawLine(n6, n5 - 1, n6, n5 - 1);
        int n7 = paintContext.getPaintState();
        if (bl && (n7 & 4) == 0) {
            graphics.setColor(color2);
            graphics.drawLine(n, n5, n6, n5);
            graphics.drawLine(n6 - 1, n2, n6 - 1, n5 - 1);
            graphics.drawLine(n6 - 2, n5 - 1, n6 - 2, n5 - 1);
            graphics.setColor(Color.white);
            graphics.drawLine(n, n2, n6, n2);
            graphics.drawLine(n, n2, n, n5 - 2);
            graphics.setColor(color);
            graphics.drawLine(n6 - 1, n2, n6 - 1, n2);
        } else {
            graphics.drawLine(n6, n2, n6, n5);
        }
    }
}

