/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.laf.generic;

import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.io.Serializable;
import java.util.Locale;
import oracle.bali.share.util.IntegerUtils;
import oracle.ewt.ColorScheme;
import oracle.ewt.HashTableDefaults;
import oracle.ewt.LookAndFeel;
import oracle.ewt.UIDefaults;
import oracle.ewt.graphics.ImageUtils;
import oracle.ewt.graphics.SynthesizingImageSet;
import oracle.ewt.laf.basic.BasicLookAndFeel;
import oracle.ewt.laf.basic.DisabledBGPainter;
import oracle.ewt.laf.basic.PerComponentUIInstantiator;
import oracle.ewt.laf.basic.SingletonUIInstantiator;
import oracle.ewt.laf.basic.StringInstantiator;
import oracle.ewt.laf.generic.FixedColorScheme;
import oracle.ewt.laf.generic.GenericGroupBoxPainter;
import oracle.ewt.laf.generic.GenericInsetBorderPainter;
import oracle.ewt.laf.generic.GenericRectanglePainter;
import oracle.ewt.laf.generic.GrayFilter;
import oracle.ewt.laf.generic.SystemColorScheme;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.FilledRectPainter;
import oracle.ewt.painter.FixedBorderPainter;
import oracle.ewt.painter.NullPainter;
import oracle.ewt.painter.PaintContext;
import oracle.ewt.painter.Painter;
import oracle.ewt.plaf.StatusBarUI;
import oracle.ewt.plaf.TextUI;
import oracle.ewt.plaf.ToolBarUI;

public class GenericLookAndFeel
extends BasicLookAndFeel
implements Serializable {
    private static ColorScheme _sColorScheme;
    private static ColorScheme[] _sAvailableSchemes;
    private static UIDefaults _sCommonDefaults;
    private static final String _PACKAGE_NAME = "oracle.ewt.laf.generic.";
    private static final String _CLASS_PREFIX = "oracle.ewt.laf.generic.Generic";
    private static final String _CLASS_NAME = "oracle.ewt.laf.generic.GenericLookAndFeel";
    private static final String _DEF_IMAGE_INSTANT = "oracle.ewt.laf.generic.GenericLookAndFeel#imageInst|";
    private static final String _DEF_CIMAGE_INSTANT = "oracle.ewt.laf.generic.GenericLookAndFeel#cImageInst|";
    private static final String _DEF_IMAGEFILTER_INSTANT = "oracle.ewt.laf.generic.GenericLookAndFeel#imageFilterInst|";

    @Override
    public String getName() {
        return "Generic";
    }

    @Override
    public String getDisplayName(Locale locale) {
        return "Generic Look and Feel";
    }

    @Override
    public String getDescription(Locale locale) {
        return "The look and feel that so many know and love";
    }

    @Override
    public boolean isNativeLookAndFeel() {
        String string = System.getProperty("os.name");
        return string != null && string.indexOf("Windows") != -1;
    }

    @Override
    public BorderPainter createGroupBoxPainter(Painter painter, Painter painter2) {
        return new GenericGroupBoxPainter(painter, painter2);
    }

    @Override
    public boolean isGroupBoxPainter(BorderPainter borderPainter) {
        return borderPainter instanceof GenericGroupBoxPainter;
    }

    @Override
    public String getGroupBoxTitle(BorderPainter borderPainter) {
        if (!this.isGroupBoxPainter(borderPainter)) {
            return null;
        }
        GenericGroupBoxPainter genericGroupBoxPainter = (GenericGroupBoxPainter)borderPainter;
        Painter painter = genericGroupBoxPainter.getLabelPainter();
        return this.getGroupBoxTitleFromLabelPainter(painter);
    }

    @Override
    protected boolean isCompatibleColorScheme(ColorScheme colorScheme) {
        return colorScheme == _sColorScheme;
    }

    @Override
    public ColorScheme getDefaultColorScheme() {
        return this.getReadOnlyColorSchemes()[0];
    }

    @Override
    public void setDefaultColorScheme(ColorScheme colorScheme) {
    }

    @Override
    public UIDefaults getDefaults(PaintContext paintContext) {
        if (_sCommonDefaults == null) {
            HashTableDefaults hashTableDefaults = new HashTableDefaults(50);
            this._initCommonFixedDefaults(hashTableDefaults);
            GenericLookAndFeel._initCommonDeferredDefaults(hashTableDefaults);
            _sCommonDefaults = hashTableDefaults;
        }
        return _sCommonDefaults;
    }

    public static Object imageFilterInst(UIDefaults uIDefaults, Object object, String string) {
        if (object.equals(LookAndFeel.DISABLING_FILTER)) {
            return new GrayFilter(1);
        }
        if (object.equals(SynthesizingImageSet.NO_MOUSE_FILTER)) {
            return new GrayFilter(0);
        }
        return null;
    }

    @Override
    protected ColorScheme[] getReadOnlyColorSchemes() {
        return _sAvailableSchemes;
    }

    protected static Image getImage(String string) {
        return ImageUtils.getImageResource(GenericLookAndFeel.class, "images/" + string);
    }

    public static Object cImageInst(UIDefaults uIDefaults, Object object, String string) {
        return ImageUtils.createFilteredImage(GenericLookAndFeel.getImage(string), _sColorScheme.createColorizingFilter());
    }

    public static Object imageInst(UIDefaults uIDefaults, Object object, String string) {
        return GenericLookAndFeel.getImage(string);
    }

    private void _initColorizedCommonDefaults(UIDefaults uIDefaults, UIDefaults uIDefaults2) {
        Color color = uIDefaults.getColor(LookAndFeel.CONTROL);
        Color color2 = uIDefaults.getColor(LookAndFeel.CONTROL_TEXT);
        Color color3 = uIDefaults.getColor(LookAndFeel.CONTROL_DK_SHADOW);
        Color color4 = uIDefaults.getColor(LookAndFeel.TEXT_HIGHLIGHT_TEXT);
        Color color5 = uIDefaults.getColor(LookAndFeel.MENU);
        Color color6 = uIDefaults.getColor(LookAndFeel.MENU_TEXT);
        Color color7 = uIDefaults.getColor(LookAndFeel.TEXT);
        Color color8 = uIDefaults.getColor(LookAndFeel.TEXT_TEXT);
        Color color9 = uIDefaults.getColor(LookAndFeel.TOOL_TIP);
        Color color10 = uIDefaults.getColor(LookAndFeel.INFO_TEXT);
        Color color11 = uIDefaults.getColor(LookAndFeel.DESKTOP);
        Color color12 = uIDefaults.getColor(LookAndFeel.WINDOW);
        Color color13 = uIDefaults.getColor(LookAndFeel.WINDOW_TEXT);
        uIDefaults2.put("BusyBar.background", color);
        uIDefaults2.put("BusyBar.foreground", color4);
        uIDefaults2.put("Button.background", color);
        uIDefaults2.put("ChoiceButton.background", color);
        uIDefaults2.put("Button.foreground", color2);
        uIDefaults2.put("CalendarTable.background", color);
        uIDefaults2.put("CheckBox.foreground", color13);
        uIDefaults2.put("Choice.background", color7);
        uIDefaults2.put("Choice.foreground", color8);
        uIDefaults2.put("ComboBox.background", color7);
        uIDefaults2.put("ComboBox.foreground", color8);
        uIDefaults2.put("DateEditor.background", color7);
        uIDefaults2.put("DateEditor.foreground", color8);
        uIDefaults2.put("Drawer.background", color);
        uIDefaults2.put("Drawer.foreground", color13);
        uIDefaults2.put("Desktop.background", color11);
        uIDefaults2.put("EwtButton.background", color);
        uIDefaults2.put("EwtButton.foreground", color2);
        uIDefaults2.put("FontPane.background", color);
        uIDefaults2.put("FontPane.foreground", color13);
        uIDefaults2.put("Grid.background", color7);
        uIDefaults2.put("Grid.foreground", color8);
        uIDefaults2.put("Label.foreground", color13);
        uIDefaults2.put("List.background", color7);
        uIDefaults2.put("List.foreground", color8);
        uIDefaults2.put("MDIRootPane.background", color5);
        uIDefaults2.put("PasswordField.background", color7);
        uIDefaults2.put("PasswordField.foreground", color8);
        uIDefaults2.put("PivotHeader.background", color);
        uIDefaults2.put("PivotTable.background", color);
        uIDefaults2.put("PopupMenu.background", color5);
        uIDefaults2.put("PopupMenu.foreground", color6);
        uIDefaults2.put("MenuBar.background", color5);
        uIDefaults2.put("MenuBar.foreground", color6);
        uIDefaults2.put("ProgressBar.background", color);
        uIDefaults2.put("ProgressBar.foreground", color8);
        uIDefaults2.put("RadioButton.foreground", color8);
        uIDefaults2.put("Ruler.background", color7);
        uIDefaults2.put("Ruler.foreground", color8);
        uIDefaults2.put("ScrollBar.background", color);
        uIDefaults2.put("ScrollBar.foreground", color3);
        uIDefaults2.put("SpinButton.background", color);
        uIDefaults2.put("Spinner.background", color7);
        uIDefaults2.put("Spinner.foreground", color8);
        uIDefaults2.put("StatusBar.background", color);
        uIDefaults2.put("TabBar.foreground", color8);
        uIDefaults2.put("TableHeader.background", color);
        uIDefaults2.put("TableHeader.foreground", color2);
        uIDefaults2.put("TableScrollPane.background", color);
        uIDefaults2.put("Table.background", color);
        uIDefaults2.put("Table.foreground", color8);
        uIDefaults2.put("TextArea.background", color7);
        uIDefaults2.put("TextArea.foreground", color8);
        uIDefaults2.put("TextField.background", color7);
        uIDefaults2.put("TextField.foreground", color8);
        uIDefaults2.put("EWTToggleButton.background", color);
        uIDefaults2.put("EWTToggleButton.foreground", color2);
        uIDefaults2.put("ToolBar.background", color);
        uIDefaults2.put("ToolBar.foreground", color2);
        uIDefaults2.put("ToolTip.background", color9);
        uIDefaults2.put("ToolTip.foreground", color10);
        uIDefaults2.put("Tree.background", color7);
        uIDefaults2.put("Tree.foreground", color8);
        uIDefaults2.put("Window.background", color5);
        uIDefaults2.put("TabPanel.itemBackground", color);
        uIDefaults2.put("TabBar.selectedItemBackground", color);
        uIDefaults2.put("TabBar.inactiveSelectedItemBackground", color);
        Object[] objectArray = new Object[]{"ArrowBoxUI", new SingletonUIInstantiator(), "BusyBarUI", new SingletonUIInstantiator(), "ButtonUI", new SingletonUIInstantiator(), "CalendarTableUI", new SingletonUIInstantiator(), "CheckBoxUI", new SingletonUIInstantiator(), "ChoiceUI", new SingletonUIInstantiator(), "ComboBoxUI", new SingletonUIInstantiator(), "ComponentUI", new SingletonUIInstantiator(), "DateEditorUI", new SingletonUIInstantiator(), "DrawerUI", new SingletonUIInstantiator(), "FontPaneUI", new SingletonUIInstantiator(), "EwtButtonUI", new SingletonUIInstantiator(), "GridUI", new SingletonUIInstantiator(), "LabelUI", new SingletonUIInstantiator(), "ListUI", new SingletonUIInstantiator(), "MenuSeparatorUI", new SingletonUIInstantiator(), "MeterUI", new SingletonUIInstantiator(), "MDIRootPaneUI", new SingletonUIInstantiator(), "PasswordFieldUI", new SingletonUIInstantiator(), "RadioButtonUI", new SingletonUIInstantiator(), "EWTToggleButtonUI", new SingletonUIInstantiator(), "PivotGridUI", new SingletonUIInstantiator(), "PivotHeaderUI", new SingletonUIInstantiator(), "PivotTableUI", new SingletonUIInstantiator(), "ProgressBarUI", new SingletonUIInstantiator(), "RulerUI", new SingletonUIInstantiator(), "ScrollBarUI", new SingletonUIInstantiator(), "ScrollPaneUI", new SingletonUIInstantiator(), "ShuttleUI", new SingletonUIInstantiator(), "SplitPaneUI", new SingletonUIInstantiator(), "SliderUI", new SingletonUIInstantiator(), "SpinButtonUI", new SingletonUIInstantiator(), "SpinnerUI", new SingletonUIInstantiator(), "StatusBarUI", new SingletonUIInstantiator(), "TabBarUI", new SingletonUIInstantiator(), "TabbedPaneUI", new SingletonUIInstantiator(), "TableUI", new SingletonUIInstantiator(), "TableHeaderUI", new SingletonUIInstantiator(), "TableScrollPaneUI", new SingletonUIInstantiator(), "TextAreaUI", new SingletonUIInstantiator(), "TextFieldUI", new SingletonUIInstantiator(), "TitleBarUI", new SingletonUIInstantiator(), "ToolBarUI", new SingletonUIInstantiator(), "ToolTipUI", new SingletonUIInstantiator(), "TreeUI", new SingletonUIInstantiator(), "WizardUI", new SingletonUIInstantiator()};
        uIDefaults2.putDefaults(objectArray);
    }

    private void _initCommonFixedDefaults(UIDefaults uIDefaults) {
        BasicLookAndFeel.initCommonFixedDefaults(uIDefaults);
        Object[] objectArray = new Object[]{"AlertUI", new PerComponentUIInstantiator(), "CheckboxMenuItemUI", new PerComponentUIInstantiator(), "DesktopUI", new PerComponentUIInstantiator(), "MenuBarUI", new PerComponentUIInstantiator(), "MenuUI", new PerComponentUIInstantiator(), "MenuItemUI", new PerComponentUIInstantiator(), "RadioButtonMenuItemUI", new PerComponentUIInstantiator(), "PopupMenuUI", new PerComponentUIInstantiator(), "WindowUI", new PerComponentUIInstantiator()};
        uIDefaults.putDefaults(objectArray);
        GenericLookAndFeel._initColors(uIDefaults);
        Font font = new Font("SansSerif", 0, 12);
        uIDefaults.put("ToolBar.font", font);
        uIDefaults.put("ToolTip.font", font);
        uIDefaults.put("TitleBar.font", new Font("Dialog", 1, 12));
        uIDefaults.put(StatusBarUI.STATUSBAR_BORDER, null);
        uIDefaults.put(StatusBarUI.STATUSBAR_ITEM_BORDER, new GenericInsetBorderPainter(new FixedBorderPainter(null, 1, 1, 1, 1), false, true));
        GenericInsetBorderPainter genericInsetBorderPainter = new GenericInsetBorderPainter();
        uIDefaults.put(TextUI.TEXT_FIELD_LOWERED_BORDER, genericInsetBorderPainter);
        GenericInsetBorderPainter genericInsetBorderPainter2 = new GenericInsetBorderPainter(new FixedBorderPainter(1, 1, 1, 1), false, false);
        uIDefaults.put(TextUI.TEXT_AREA_LOWERED_BORDER, genericInsetBorderPainter2);
        GenericRectanglePainter genericRectanglePainter = new GenericRectanglePainter(new GenericRectanglePainter());
        uIDefaults.put(TextUI.TEXT_FIELD_PLAIN_BORDER, genericRectanglePainter);
        uIDefaults.put(TextUI.TEXT_AREA_PLAIN_BORDER, genericRectanglePainter);
        GenericInsetBorderPainter genericInsetBorderPainter3 = new GenericInsetBorderPainter(true);
        uIDefaults.put(TextUI.TEXT_FIELD_RAISED_BORDER, genericInsetBorderPainter3);
        uIDefaults.put(TextUI.TEXT_AREA_RAISED_BORDER, genericInsetBorderPainter3);
        uIDefaults.put(ToolBarUI.TOOLBAR_HORIZONTAL_BORDER, new FixedBorderPainter(0, 5, 0, 5));
        uIDefaults.put(ToolBarUI.TOOLBAR_VERTICAL_BORDER, new FixedBorderPainter(5, 0, 5, 0));
        uIDefaults.put(ToolBarUI.BASE_IMAGE_STATE, IntegerUtils.getInteger((int)16));
        uIDefaults.put(WINDOW_ACTIVATION_REPAINTING, Boolean.FALSE);
        GenericInsetBorderPainter genericInsetBorderPainter4 = new GenericInsetBorderPainter(new FixedBorderPainter(2, 2, 2, 2), false, true);
        uIDefaults.put("Alert.border", new FixedBorderPainter(5, 5, 5, 5));
        uIDefaults.put("BusyBar.border", genericInsetBorderPainter4);
        uIDefaults.put("Choice.border", genericInsetBorderPainter);
        uIDefaults.put("ComboBox.border", genericInsetBorderPainter);
        uIDefaults.put("DateEditor.border", genericInsetBorderPainter);
        uIDefaults.put("Grid.border", genericInsetBorderPainter);
        uIDefaults.put("List.border", genericInsetBorderPainter);
        uIDefaults.put("PasswordField.border", genericInsetBorderPainter);
        uIDefaults.put("ProgressBar.border", genericInsetBorderPainter4);
        uIDefaults.put("ScrollPane.border", genericInsetBorderPainter);
        uIDefaults.put("Spinner.border", genericInsetBorderPainter);
        uIDefaults.put("Table.border", genericInsetBorderPainter);
        uIDefaults.put("TableScrollPane.border", genericInsetBorderPainter);
        uIDefaults.put("TextArea.border", genericInsetBorderPainter);
        uIDefaults.put("TextField.border", genericInsetBorderPainter2);
        uIDefaults.put("TitleBar.border", new FixedBorderPainter(null, 1, 2, 1, 2, true, true));
        uIDefaults.put("ToolTip.border", new GenericRectanglePainter(new FixedBorderPainter(1, 2, 1, 2)));
        Painter painter = uIDefaults.getPainter(DISABLED_BG_PAINTER);
        BorderPainter borderPainter = NullPainter.getPainter();
        DisabledBGPainter disabledBGPainter = new DisabledBGPainter(FilledRectPainter.getPainter(), TextUI.TEXT_IS_EDITABLE_KEY);
        uIDefaults.put("BusyBar.fill", painter);
        uIDefaults.put("Choice.fill", painter);
        uIDefaults.put("ComboBox.fill", painter);
        uIDefaults.put("DateEditor.fill", painter);
        uIDefaults.put("Grid.fill", painter);
        uIDefaults.put("List.fill", borderPainter);
        uIDefaults.put("PasswordField.fill", disabledBGPainter);
        uIDefaults.put("ProgressBar.fill", painter);
        uIDefaults.put("Scrollbar.fill", borderPainter);
        uIDefaults.put("Spinner.fill", painter);
        uIDefaults.put("TabBar.fill", borderPainter);
        uIDefaults.put("Table.fill", painter);
        uIDefaults.put("TextArea.fill", disabledBGPainter);
        uIDefaults.put("TextField.fill", disabledBGPainter);
        uIDefaults.put("Tree.fill", painter);
        this._initColorizedCommonDefaults(uIDefaults, uIDefaults);
    }

    private static void _initColors(UIDefaults uIDefaults) {
        _sColorScheme.initializeColors(uIDefaults);
    }

    private static void _initColorizedDeferredDefaults(UIDefaults uIDefaults) {
        Object[] objectArray = new Object[]{"Slider.pointerStrip", new StringInstantiator("oracle.ewt.laf.generic.GenericLookAndFeel#cImageInst|sliderArrowStrip.gif", false), "SpinButton.upStrip", new StringInstantiator("oracle.ewt.laf.generic.GenericLookAndFeel#cImageInst|spinUpStrip.gif", false), "SpinButton.downStrip", new StringInstantiator("oracle.ewt.laf.generic.GenericLookAndFeel#cImageInst|spinDownStrip.gif", false), "SpinButton.leftStrip", new StringInstantiator("oracle.ewt.laf.generic.GenericLookAndFeel#cImageInst|spinLeftStrip.gif", false), "SpinButton.rightStrip", new StringInstantiator("oracle.ewt.laf.generic.GenericLookAndFeel#cImageInst|spinRightStrip.gif", false), "Choice.arrowImage", new StringInstantiator("oracle.ewt.laf.generic.GenericLookAndFeel#cImageInst|choiceStrip.gif", false), "BusyBar.stripImage", new StringInstantiator("oracle.ewt.laf.generic.GenericLookAndFeel#cImageInst|busyStrip.gif", false), "Tree.openImage", new StringInstantiator("oracle.ewt.laf.generic.GenericLookAndFeel#cImageInst|expand.gif", false), "Tree.closedImage", new StringInstantiator("oracle.ewt.laf.generic.GenericLookAndFeel#cImageInst|collapse.gif", false), "Tree.multiItemDrag", new StringInstantiator("oracle.ewt.laf.generic.GenericLookAndFeel#cImageInst|multiItemDrag.gif", false), "checkboxStrip", new StringInstantiator("oracle.ewt.laf.generic.GenericLookAndFeel#cImageInst|checkboxStrip.gif", false), "radioButtonStrip", new StringInstantiator("oracle.ewt.laf.generic.GenericLookAndFeel#cImageInst|radioButtonStrip.gif", false), "menuCheckBoxStrip", new StringInstantiator("oracle.ewt.laf.generic.GenericLookAndFeel#cImageInst|menuCheckBoxStrip.gif", false), "menuRadioButtonStrip", new StringInstantiator("oracle.ewt.laf.generic.GenericLookAndFeel#cImageInst|menuRadioButtonStrip.gif", false), "Shuttle.rightArrow", new StringInstantiator("oracle.ewt.laf.generic.GenericLookAndFeel#cImageInst|rightArrow.gif", false), "Shuttle.rightAllArrow", new StringInstantiator("oracle.ewt.laf.generic.GenericLookAndFeel#cImageInst|rightAllArrow.gif", false), "Shuttle.leftArrow", new StringInstantiator("oracle.ewt.laf.generic.GenericLookAndFeel#cImageInst|leftArrow.gif", false), "Shuttle.leftAllArrow", new StringInstantiator("oracle.ewt.laf.generic.GenericLookAndFeel#cImageInst|leftAllArrow.gif", false), "Shuttle.downArrow", new StringInstantiator("oracle.ewt.laf.generic.GenericLookAndFeel#cImageInst|downArrow.gif", false), "Shuttle.downAllArrow", new StringInstantiator("oracle.ewt.laf.generic.GenericLookAndFeel#cImageInst|downAllArrow.gif", false), "Shuttle.upArrow", new StringInstantiator("oracle.ewt.laf.generic.GenericLookAndFeel#cImageInst|upArrow.gif", false), "Shuttle.upAllArrow", new StringInstantiator("oracle.ewt.laf.generic.GenericLookAndFeel#cImageInst|upAllArrow.gif", false), "Shuttle.reorderUpRight", new StringInstantiator("oracle.ewt.laf.generic.GenericLookAndFeel#cImageInst|reorderUpRight.gif", false), "Shuttle.reorderDownRight", new StringInstantiator("oracle.ewt.laf.generic.GenericLookAndFeel#cImageInst|reorderDownRight.gif", false), "Shuttle.reorderUpLeft", new StringInstantiator("oracle.ewt.laf.generic.GenericLookAndFeel#cImageInst|reorderUpLeft.gif", false), "Shuttle.reorderDownLeft", new StringInstantiator("oracle.ewt.laf.generic.GenericLookAndFeel#cImageInst|reorderDownLeft.gif", false), "ScrollBar.alleyImage", new StringInstantiator("oracle.ewt.laf.generic.GenericLookAndFeel#cImageInst|alleyStipple.gif", false), "SpinButton.rightArrow", new StringInstantiator("oracle.ewt.laf.generic.GenericLookAndFeel#cImageInst|spinRightArrow.gif", false), "SpinButton.leftArrow", new StringInstantiator("oracle.ewt.laf.generic.GenericLookAndFeel#cImageInst|spinLeftArrow.gif", false), "SpinButton.downArrow", new StringInstantiator("oracle.ewt.laf.generic.GenericLookAndFeel#cImageInst|spinDownArrow.gif", false), "SpinButton.upArrow", new StringInstantiator("oracle.ewt.laf.generic.GenericLookAndFeel#cImageInst|spinUpArrow.gif", false), "TabBar.scrollLeft", new StringInstantiator("oracle.ewt.laf.generic.GenericLookAndFeel#cImageInst|tableft.gif", false), "TabBar.scrollRight", new StringInstantiator("oracle.ewt.laf.generic.GenericLookAndFeel#cImageInst|tabright.gif", false), "TabBar.scrollBoth", new StringInstantiator("oracle.ewt.laf.generic.GenericLookAndFeel#cImageInst|tabboth.gif", false), "TabBar.visibleStrip", new StringInstantiator("oracle.ewt.laf.generic.GenericLookAndFeel#cImageInst|tabvisstrip.gif", false), "TabBar.visible", new StringInstantiator("oracle.ewt.laf.generic.GenericTabBarUI", false)};
        uIDefaults.putDefaults(objectArray);
    }

    private static void _initCommonDeferredDefaults(UIDefaults uIDefaults) {
        GenericLookAndFeel._initColorizedDeferredDefaults(uIDefaults);
        Object[] objectArray = new Object[]{"CollapsedNodePainter", new StringInstantiator("oracle.ewt.laf.generic.GenericTreeUI", false), "ExpandedNodePainter", new StringInstantiator("oracle.ewt.laf.generic.GenericTreeUI", false), "UpScrollPainter", new StringInstantiator("oracle.ewt.laf.generic.GenericScrollBarUI", false), "DownScrollPainter", new StringInstantiator("oracle.ewt.laf.generic.GenericScrollBarUI", false), "LeftScrollPainter", new StringInstantiator("oracle.ewt.laf.generic.GenericScrollBarUI", false), "RightScrollPainter", new StringInstantiator("oracle.ewt.laf.generic.GenericScrollBarUI", false), "UpScrollSet", new StringInstantiator("oracle.ewt.laf.generic.GenericScrollBarUI", false), "DownScrollSet", new StringInstantiator("oracle.ewt.laf.generic.GenericScrollBarUI", false), "LeftScrollSet", new StringInstantiator("oracle.ewt.laf.generic.GenericScrollBarUI", false), "RightScrollSet", new StringInstantiator("oracle.ewt.laf.generic.GenericScrollBarUI", false), "checkboxSet", new StringInstantiator("oracle.ewt.laf.generic.GenericCheckBoxUI", false), "radioButtonSet", new StringInstantiator("oracle.ewt.laf.generic.GenericRadioButtonUI", false), "DefaultCellPainter", new StringInstantiator("oracle.ewt.laf.generic.GenericGridUI", false), "DefaultHeaderPainter", new StringInstantiator("oracle.ewt.laf.generic.GenericTableHeaderUI", false), "CheckBoxPainter", new StringInstantiator("oracle.ewt.laf.generic.GenericCheckBoxUI", false), "CheckBoxComponentPainter", new StringInstantiator("oracle.ewt.laf.generic.GenericCheckBoxUI", false), "RadioButtonPainter", new StringInstantiator("oracle.ewt.laf.generic.GenericRadioButtonUI", false), "RadioButtonComponentPainter", new StringInstantiator("oracle.ewt.laf.generic.GenericRadioButtonUI", false), "Grid.checkPainter", new StringInstantiator("oracle.ewt.laf.generic.GenericGridUI", false), "Grid.radioPainter", new StringInstantiator("oracle.ewt.laf.generic.GenericGridUI", false), "Alert.errorImage", new StringInstantiator("oracle.ewt.laf.generic.GenericLookAndFeel#imageInst|stop.gif", false), "Alert.warningImage", new StringInstantiator("oracle.ewt.laf.generic.GenericLookAndFeel#imageInst|caution.gif", false), "Alert.informationImage", new StringInstantiator("oracle.ewt.laf.generic.GenericLookAndFeel#imageInst|note.gif", false), "Alert.questionImage", new StringInstantiator("oracle.ewt.laf.generic.GenericLookAndFeel#imageInst|question.gif", false), "ColorChoice.arrow", new StringInstantiator("oracle.ewt.laf.generic.GenericLookAndFeel#imageInst|colorChoice.gif", false), "Grid.checkImage", new StringInstantiator("oracle.ewt.laf.generic.GenericLookAndFeel#imageInst|check.gif", false), LookAndFeel.DISABLING_FILTER, new StringInstantiator(_DEF_IMAGEFILTER_INSTANT, true), SynthesizingImageSet.NO_MOUSE_FILTER, new StringInstantiator(_DEF_IMAGEFILTER_INSTANT, true), "HorizInsetSeparator", new StringInstantiator("oracle.ewt.laf.generic.GenericSeparatorPainter", false), "HorizOutsetSeparator", new StringInstantiator("oracle.ewt.laf.generic.GenericSeparatorPainter", false), "VertInsetSeparator", new StringInstantiator("oracle.ewt.laf.generic.GenericSeparatorPainter", false), "VertOutsetSeparator", new StringInstantiator("oracle.ewt.laf.generic.GenericSeparatorPainter", false), "FileChooser.folder", new StringInstantiator("oracle.ewt.laf.generic.GenericLookAndFeel#imageInst|folder.gif", false), "Window.closeStrip", new StringInstantiator("oracle.ewt.laf.generic.GenericLookAndFeel#imageInst|closeStrip.gif", false), "Window.maximizeStrip", new StringInstantiator("oracle.ewt.laf.generic.GenericLookAndFeel#imageInst|maximizeStrip.gif", false), "Window.minimizeStrip", new StringInstantiator("oracle.ewt.laf.generic.GenericLookAndFeel#imageInst|minimizeStrip.gif", false), "Window.restoreStrip", new StringInstantiator("oracle.ewt.laf.generic.GenericLookAndFeel#imageInst|restoreStrip.gif", false)};
        uIDefaults.putDefaults(objectArray);
    }

    static {
        String string = System.getProperty("os.name");
        _sColorScheme = string.startsWith("Windows") ? new SystemColorScheme() : new FixedColorScheme();
        _sAvailableSchemes = new ColorScheme[]{_sColorScheme};
    }
}

