/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.grid;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import oracle.ewt.dateEditor.DateEditor;
import oracle.ewt.grid.Cell;
import oracle.ewt.grid.CellInputHandler;
import oracle.ewt.grid.Grid;
import oracle.ewt.painter.DirectionalBorderPainter;
import oracle.ewt.util.InputEventUtils;

public class DateInputHandler
extends CellInputHandler {
    private DateEditor _DateEditor;
    static boolean _dirty;
    private DateFormat _format;

    public DateInputHandler(DateFormat dateFormat) {
        this._format = dateFormat;
    }

    public void setDateFormat(DateFormat dateFormat) {
        this._format = dateFormat;
    }

    public DateFormat getDateFormat() {
        return this._format;
    }

    @Override
    public void focusGained(AWTEvent aWTEvent, Grid grid, int n, int n2) {
        if (aWTEvent instanceof MouseEvent) {
            grid.startCellEdit(n, n2);
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent, Grid grid, int n, int n2) {
        Cell cell = grid.getFocusCell();
        if (cell.column == n && cell.row == n2 && InputEventUtils.isLeftMouseButton(mouseEvent)) {
            grid.startCellEdit(n, n2);
        }
        super.mousePressed(mouseEvent, grid, n, n2);
    }

    @Override
    public void keyTyped(KeyEvent keyEvent, Grid grid, int n, int n2) {
        if (keyEvent.getKeyChar() == '\t' || keyEvent.getKeyChar() == '\u001b' || keyEvent.getKeyChar() == '\n' || keyEvent.getKeyChar() == '\r') {
            return;
        }
        grid.startCellEdit(n, n2);
    }

    @Override
    public synchronized Component getEditControl(Grid grid, int n, int n2) {
        if (this._DateEditor == null) {
            DateEditor dateEditor = new DateEditor();
            dateEditor.addPropertyChangeListener(new Dirty());
            dateEditor.setBorderPainter(new DirectionalBorderPainter(0, 0, 0, 3));
            this._DateEditor = dateEditor;
        }
        return this._DateEditor;
    }

    @Override
    public boolean isDirty(Grid grid, int n, int n2) {
        return _dirty;
    }

    @Override
    public void startEdit(Grid grid, int n, int n2, Object object) {
        DateEditor dateEditor = (DateEditor)this.getEditControl(grid, n, n2);
        dateEditor.setCalendar(this.getDateFormat().getCalendar());
        if (object == null || object instanceof Date) {
            dateEditor.setDate((Date)object);
        } else {
            String string = object.toString();
            try {
                dateEditor.setDateString(string);
            }
            catch (ParseException parseException) {
                throw new IllegalArgumentException("data " + object + " must be a Date");
            }
        }
        dateEditor.setDateFormat(this.getDateFormat());
        _dirty = false;
    }

    @Override
    public synchronized Object commitEdit(Grid grid, int n, int n2) {
        DateEditor dateEditor = (DateEditor)this.getEditControl(grid, n, n2);
        Date date = dateEditor.getDate();
        return date;
    }

    private static class Dirty
    implements PropertyChangeListener {
        private Dirty() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("date".equals(propertyChangeEvent.getPropertyName())) {
                _dirty = true;
            }
        }
    }
}

