/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.drawer;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import oracle.ewt.ColorScheme;
import oracle.ewt.button.PushButton;
import oracle.ewt.drawer.DrawerPopup;
import oracle.ewt.painter.Painter;
import oracle.ewt.plaf.DrawerUI;
import oracle.ewt.popup.PopupOwner;
import oracle.ewt.popup.PopupUtils;
import oracle.ewt.util.LookAndFeelUtils;

public class Drawer
extends PushButton {
    public static final int ORIENTATION_RIGHT = 0;
    public static final int ORIENTATION_TOP = 1;
    public static final int ORIENTATION_BOTTOM = 2;
    public static final int ORIENTATION_LEFT = 3;
    private Closer _closer;
    private DrawerPopup _popup;
    private PopupOwner _owner;
    private int _orientation;

    public Drawer(Component component) {
        this.setFocusable(false);
        this._popup = new DrawerPopup(this, component);
        this._orientation = 0;
    }

    public int getOrientation() {
        return this._orientation;
    }

    public void setOrientation(int n) {
        if (n < 0 || n > 3) {
            throw new IllegalArgumentException();
        }
        this._orientation = n;
    }

    public void openPopup() {
        if (this._owner != null) {
            return;
        }
        this._addOrRemoveListeners(true);
        Dimension dimension = this._getPopupSize();
        Dimension dimension2 = this.getSize();
        Dimension dimension3 = new Dimension();
        Rectangle rectangle = this.getBounds();
        int n = this.getOrientation();
        int n2 = 0;
        int n3 = this.getDrawerUI().getPopUpOverlap(this);
        if (this._isHorizontal()) {
            dimension3.height = dimension.height = dimension2.height - 2;
            if (n == 0) {
                rectangle.x = 0;
                n2 = 13;
            } else {
                rectangle.x = n3;
                n2 = 8;
            }
            rectangle.y = 1;
            rectangle.width -= n3;
        } else {
            dimension3.width = dimension.width = dimension2.width - 2;
            rectangle.x = 1;
            if (n == 1) {
                rectangle.y = n3;
                n2 = 16;
            } else {
                rectangle.y = 0;
                n2 = 17;
            }
            rectangle.height -= n3;
        }
        this._owner = PopupUtils.displayPopupRelativeTo((Component)this, (Component)this._popup, rectangle, dimension, dimension3, n2);
        if (this._owner != null) {
            this._popup.open();
        }
    }

    public void closePopup() {
        this._popup.close();
        this.popupClosed();
    }

    public void closePopupLater() {
        this._popup.closeLater();
    }

    @Override
    public void setColorScheme(ColorScheme colorScheme) {
        if (colorScheme != this.getColorScheme()) {
            super.setColorScheme(colorScheme);
            LookAndFeelUtils.setComponentTreeColorScheme(this._popup, colorScheme);
        }
    }

    @Override
    public Object getUIClassID() {
        return "DrawerUI";
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        Dimension dimension2 = this._getPopupSize();
        if (this._isHorizontal()) {
            if (dimension.height < dimension2.height + 2) {
                dimension.height = dimension2.height + 2;
            }
        } else if (dimension.width < dimension2.width + 2) {
            dimension.width = dimension2.width + 2;
        }
        return dimension;
    }

    @Override
    protected int getPaintState() {
        int n = super.getPaintState();
        if (this._owner != null) {
            n |= 0x10;
        }
        return n;
    }

    @Override
    protected void activate(int n) {
        if (this._owner != null && this._popup.getParent() == null) {
            this._popup.close();
        }
        if (this._owner == null) {
            this.openPopup();
        } else {
            this.closePopup();
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.closePopup();
    }

    @Override
    public Painter getPainter() {
        return this.getDrawerUI().getPainter(this);
    }

    protected final DrawerUI getDrawerUI() {
        return (DrawerUI)this.getUI();
    }

    final void popupClosed() {
        this._addOrRemoveListeners(false);
        PopupOwner popupOwner = this._owner;
        if (popupOwner != null) {
            popupOwner.removePopup(this._popup);
        }
        this._owner = null;
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _addOrRemoveListeners(boolean bl) {
        Object object = this.getTreeLock();
        synchronized (object) {
            Closer closer = this._getCloser();
            for (Container container = this; container != null; container = container.getParent()) {
                if (bl) {
                    container.addComponentListener(closer);
                } else {
                    container.removeComponentListener(closer);
                }
                if (!(container instanceof Window)) continue;
                if (bl) {
                    ((Window)container).addWindowListener(closer);
                    break;
                }
                ((Window)container).removeWindowListener(closer);
                break;
            }
        }
    }

    private boolean _isHorizontal() {
        int n = this.getOrientation();
        return n == 3 || n == 0;
    }

    private Dimension _getPopupSize() {
        DrawerPopup drawerPopup = this._popup;
        drawerPopup.setFont(this.getFont());
        drawerPopup.setLocale(this.getLocale());
        drawerPopup.setReadingDirection(this.getActualReadingDirection());
        return drawerPopup.getPreferredSize();
    }

    private Closer _getCloser() {
        if (this._closer == null) {
            this._closer = new Closer();
        }
        return this._closer;
    }

    private class Closer
    extends WindowAdapter
    implements ComponentListener {
        private Closer() {
        }

        @Override
        public void windowIconified(WindowEvent windowEvent) {
            Drawer.this.closePopup();
        }

        @Override
        public void windowDeactivated(WindowEvent windowEvent) {
            Drawer.this.closePopup();
        }

        @Override
        public void componentHidden(ComponentEvent componentEvent) {
            Drawer.this.closePopup();
        }

        @Override
        public void componentShown(ComponentEvent componentEvent) {
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            Drawer.this.closePopup();
        }

        @Override
        public void componentMoved(ComponentEvent componentEvent) {
            Drawer.this.closePopup();
        }
    }
}

