/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.color;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.accessibility.AccessibleContext;
import oracle.bali.share.util.IntegerUtils;
import oracle.ewt.LookAndFeel;
import oracle.ewt.UIDefaults;
import oracle.ewt.dataSource.ArrayTwoDDataSource;
import oracle.ewt.dataSource.TwoDDataSource;
import oracle.ewt.graphics.Appearance;
import oracle.ewt.grid.AbstractAppearanceManager;
import oracle.ewt.grid.AccessibleGrid;
import oracle.ewt.grid.Cell;
import oracle.ewt.grid.CellInputHandler;
import oracle.ewt.grid.Grid;
import oracle.ewt.grid.GridEvent;
import oracle.ewt.grid.GridFocusListener;
import oracle.ewt.grid.GridToolTipClient;
import oracle.ewt.grid.StandardNavigator;
import oracle.ewt.painter.AbstractBorderPainter;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.NullPainter;
import oracle.ewt.painter.PaintContext;
import oracle.ewt.plaf.ComponentUI;
import oracle.ewt.util.ImmInsets;
import oracle.ewt.util.LocaleUtils;

public class ColorGrid
extends Grid {
    public static final String PROPERTY_SELECTED_COLOR = "selectedColor";
    private static final String _RESOURCE_BUNDLE = "oracle.ewt.color.resource.ColorBundle";
    private static final String _ACCESSIBLE_BUNDLE = "oracle.ewt.access.resource.AccessibilityBundle";
    private static final String _KEY_TOOLTIP = "COLORPALETTE.TOOLTIP";
    private static final String _KEY_NO_COLOR = "COLORPALETTE.NO_COLOR";
    private static final ImmInsets _SMALL_INSETS = new ImmInsets(1, 1, 1, 1);
    private static final ImmInsets _LARGE_INSETS = new ImmInsets(2, 2, 2, 2);
    private static final int _COLUMN_WIDTH = 16;
    private static final int _ROW_HEIGHT = 16;
    private static final int _COLUMN_COUNT = 16;
    private static final int _ROW_COUNT = 14;
    static final Color[][] __sDEFAULT_PALETTE = new Color[][]{{new Color(153, 0, 51), new Color(255, 51, 102), new Color(204, 0, 51), new Color(255, 0, 51), new Color(255, 0, 51), new Color(255, 153, 153), new Color(204, 51, 102), new Color(255, 204, 255), new Color(204, 51, 153), new Color(153, 51, 102), new Color(153, 51, 102), new Color(102, 0, 51), new Color(204, 51, 153), new Color(255, 153, 204), new Color(255, 102, 204), new Color(255, 153, 255)}, {new Color(255, 102, 153), new Color(204, 0, 102), new Color(255, 0, 102), new Color(255, 51, 153), new Color(255, 0, 153), new Color(255, 51, 204), new Color(255, 0, 204), new Color(255, 102, 255), new Color(255, 51, 255), new Color(255, 0, 255), new Color(204, 0, 153), new Color(153, 0, 102), new Color(204, 102, 204), new Color(204, 51, 204), new Color(204, 153, 255), new Color(204, 102, 255)}, {new Color(204, 51, 255), new Color(153, 51, 153), new Color(204, 0, 204), new Color(204, 0, 255), new Color(153, 0, 204), new Color(153, 0, 153), new Color(204, 153, 204), new Color(153, 102, 153), new Color(102, 51, 102), new Color(102, 0, 153), new Color(153, 51, 204), new Color(102, 0, 102), new Color(153, 0, 255), new Color(153, 51, 255), new Color(153, 102, 204), new Color(51, 0, 51)}, {new Color(102, 51, 153), new Color(102, 150, 204), new Color(102, 0, 204), new Color(153, 102, 255), new Color(51, 0, 102), new Color(102, 0, 255), new Color(102, 51, 255), new Color(204, 204, 255), new Color(153, 153, 255), new Color(153, 153, 204), new Color(102, 102, 204), new Color(102, 102, 255), new Color(102, 102, 153), new Color(51, 51, 102), new Color(51, 51, 153), new Color(51, 0, 153)}, {new Color(51, 0, 204), new Color(51, 0, 255), new Color(51, 51, 255), new Color(51, 51, 204), new Color(0, 102, 255), new Color(0, 102, 255), new Color(51, 102, 255), new Color(51, 102, 204), new Color(0, 0, 102), new Color(0, 0, 51), new Color(0, 0, 255), new Color(0, 0, 153), new Color(0, 51, 204), new Color(0, 0, 204), new Color(51, 102, 153), new Color(0, 102, 204)}, {new Color(153, 204, 255), new Color(102, 153, 255), new Color(0, 51, 102), new Color(102, 153, 204), new Color(0, 102, 153), new Color(51, 153, 204), new Color(0, 153, 204), new Color(102, 204, 255), new Color(51, 153, 255), new Color(0, 51, 153), new Color(0, 153, 255), new Color(51, 204, 255), new Color(0, 204, 255), new Color(153, 255, 255), new Color(102, 255, 255), new Color(51, 255, 255)}, {new Color(0, 255, 255), new Color(0, 204, 204), new Color(0, 153, 153), new Color(102, 153, 153), new Color(153, 204, 204), new Color(204, 255, 255), new Color(51, 204, 204), new Color(102, 204, 204), new Color(51, 153, 153), new Color(51, 102, 102), new Color(0, 102, 102), new Color(0, 51, 51), new Color(0, 255, 204), new Color(51, 255, 204), new Color(51, 204, 153), new Color(0, 204, 153)}, {new Color(102, 255, 204), new Color(153, 255, 204), new Color(0, 255, 153), new Color(51, 153, 102), new Color(0, 102, 51), new Color(51, 102, 51), new Color(102, 153, 102), new Color(102, 204, 102), new Color(153, 204, 153), new Color(102, 255, 102), new Color(51, 153, 51), new Color(153, 204, 153), new Color(102, 255, 153), new Color(51, 255, 153), new Color(51, 204, 102), new Color(0, 204, 102)}, {new Color(102, 204, 153), new Color(0, 153, 102), new Color(0, 153, 51), new Color(153, 204, 153), new Color(0, 204, 102), new Color(204, 255, 204), new Color(204, 255, 153), new Color(153, 255, 102), new Color(153, 255, 51), new Color(0, 255, 51), new Color(51, 255, 51), new Color(0, 204, 51), new Color(51, 204, 51), new Color(102, 204, 51), new Color(0, 255, 0), new Color(102, 204, 51)}, {new Color(0, 102, 0), new Color(0, 51, 0), new Color(0, 153, 0), new Color(51, 255, 0), new Color(102, 255, 0), new Color(153, 255, 0), new Color(102, 204, 0), new Color(0, 204, 0), new Color(51, 204, 0), new Color(51, 153, 0), new Color(153, 204, 102), new Color(102, 153, 51), new Color(153, 204, 51), new Color(51, 102, 0), new Color(102, 153, 0), new Color(153, 204, 0)}, {new Color(204, 255, 102), new Color(204, 255, 51), new Color(204, 255, 0), new Color(153, 153, 0), new Color(204, 204, 0), new Color(204, 204, 51), new Color(51, 51, 0), new Color(102, 102, 0), new Color(153, 153, 51), new Color(204, 204, 102), new Color(102, 102, 51), new Color(153, 153, 102), new Color(204, 204, 153), new Color(255, 255, 204), new Color(255, 255, 153), new Color(255, 255, 102)}, {new Color(255, 255, 51), new Color(255, 255, 0), new Color(255, 204, 0), new Color(255, 204, 102), new Color(255, 204, 51), new Color(204, 153, 51), new Color(153, 102, 0), new Color(204, 153, 0), new Color(255, 153, 0), new Color(204, 102, 0), new Color(153, 51, 0), new Color(204, 102, 51), new Color(102, 51, 0), new Color(255, 153, 102), new Color(255, 102, 51), new Color(255, 153, 51)}, {new Color(255, 102, 0), new Color(204, 51, 0), new Color(153, 102, 51), new Color(51, 0, 0), new Color(102, 51, 51), new Color(153, 102, 102), new Color(204, 153, 153), new Color(153, 51, 51), new Color(204, 102, 102), new Color(255, 204, 204), new Color(204, 51, 51), new Color(204, 51, 51), new Color(255, 102, 102), new Color(102, 0, 0), new Color(153, 0, 0), new Color(204, 0, 0)}, {new Color(255, 0, 0), new Color(255, 51, 0), new Color(204, 153, 102), new Color(255, 204, 153), new Color(255, 255, 255), new Color(204, 204, 204), new Color(153, 153, 153), new Color(102, 102, 102), new Color(51, 51, 51), new Color(0, 0, 0), new Color(255, 255, 255), new Color(255, 255, 255), new Color(255, 255, 255), new Color(255, 255, 255), new Color(255, 255, 255), new Color(255, 255, 255)}};
    private int _armedColumn;
    private int _armedRow;
    private int _selectedColumn;
    private int _selectedRow;
    private PropertyChangeSupport _propertyChangeSupport;
    private boolean _inDropDown;

    public ColorGrid() {
        this(null, null);
    }

    public ColorGrid(TwoDDataSource twoDDataSource, Color color) {
        Listener listener = new Listener();
        this.setDefaultInputHandler(listener);
        this.addFocusListener(listener);
        this.setDefaultRowHeight(16);
        this.setDefaultColumnWidth(16);
        this.setDefaultPainter(NullPainter.getPainter());
        this.setAppearanceManager(new ColorAppearanceManager());
        this.setHorizontalSeparatorsVisible(false);
        this.setVerticalSeparatorsVisible(false);
        this.setGridSelection(null);
        this.setGridKeyNavigator(new Navigate());
        this.setOverlayBorderVisible(false);
        this.setBorder(null);
        this.setDrawFocusCellHighlite(false);
        this._selectedRow = -1;
        this._selectedColumn = -1;
        this._armedRow = -1;
        this._armedColumn = -1;
        this.setColorPalette(twoDDataSource);
        this.setSelectedColor(color);
        this.setBackground(this.getUIDefaults().getColor(LookAndFeel.CONTROL));
        this.setToolTipValue(new Tooltip());
    }

    public void setColorPalette(TwoDDataSource twoDDataSource) {
        if (twoDDataSource == null) {
            twoDDataSource = ColorGrid.getDefaultColorPalette();
        }
        if (this.getDataSource() != twoDDataSource) {
            this.setDataSource(twoDDataSource);
            this.setPreferredRowsOnScreen(this.getRowCount());
            this.setPreferredColumnsOnScreen(this.getColumnCount());
            this.invalidate();
            this.repaint();
        }
    }

    public TwoDDataSource getColorPalette() {
        return this.getDataSource();
    }

    public void setSelectedColor(Color color) {
        boolean bl = false;
        int n = -1;
        int n2 = -1;
        if (color == null) {
            bl = true;
        } else {
            for (int i = 0; i < this.getColumnCount(); ++i) {
                for (int j = 0; j < this.getRowCount(); ++j) {
                    if (!color.equals(this._getColor(i, j))) continue;
                    n = i;
                    n2 = j;
                    bl = true;
                }
            }
        }
        if (!bl) {
            throw new IllegalArgumentException("Color not found " + color);
        }
        this._setSelectedColor(n, n2);
    }

    public Color getSelectedColor() {
        if (this._selectedColumn == -1 || this._selectedRow == -1) {
            return null;
        }
        return this._getColor(this._selectedColumn, this._selectedRow);
    }

    public static TwoDDataSource getDefaultColorPalette() {
        ArrayTwoDDataSource arrayTwoDDataSource = new ArrayTwoDDataSource(16, 14);
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 14; ++j) {
                arrayTwoDDataSource.setData(i, j, __sDEFAULT_PALETTE[j][i]);
            }
        }
        return arrayTwoDDataSource;
    }

    public static Color getClosestColor(TwoDDataSource twoDDataSource, Color color) {
        int n = twoDDataSource.getColumnCount();
        int n2 = twoDDataSource.getRowCount();
        int n3 = color.getRed();
        int n4 = color.getGreen();
        int n5 = color.getBlue();
        Color color2 = null;
        int n6 = Integer.MAX_VALUE;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                int n7;
                int n8;
                Color color3 = (Color)twoDDataSource.getData(i, j);
                if (color3 == null) continue;
                int n9 = n3 - color3.getRed();
                int n10 = n9 * n9 + (n8 = n4 - color3.getGreen()) * n8 + (n7 = n5 - color3.getBlue()) * n7;
                if (n10 == 0) {
                    return color3;
                }
                if (n10 >= n6) continue;
                n6 = n10;
                color2 = color3;
            }
        }
        return color2;
    }

    public Color getClosestColor(Color color) {
        return ColorGrid.getClosestColor(this.getColorPalette(), color);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this._propertyChangeSupport == null) {
            this._propertyChangeSupport = new PropertyChangeSupport(this);
        }
        this._propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this._propertyChangeSupport != null) {
            this._propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
        }
    }

    @Override
    public void paintCanvasInterior(Graphics graphics) {
        super.paintCanvasInterior(graphics);
        if (this._selectedColumn != -1 && this._selectedRow != -1 && (this._selectedColumn != this._armedColumn || this._selectedRow != this._armedRow)) {
            Rectangle rectangle = graphics.getClipBounds();
            Rectangle rectangle2 = this._getCellRect(this._selectedColumn, this._selectedRow);
            rectangle2.x -= 2;
            rectangle2.y -= 2;
            rectangle2.width += 4;
            rectangle2.height += 4;
            if (rectangle.intersects(rectangle2)) {
                Color color = this._getColor(this._selectedColumn, this._selectedRow);
                PaintContext paintContext = this.getPaintContext();
                UIDefaults uIDefaults = paintContext.getPaintUIDefaults();
                Color color2 = uIDefaults.getColor(LookAndFeel.DARK_INTENSITY);
                graphics.setColor(color);
                graphics.fillRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                graphics.setColor(Color.white);
                graphics.drawLine(rectangle2.x, rectangle2.y, rectangle2.x, rectangle2.y + rectangle2.height - 2);
                graphics.drawLine(rectangle2.x, rectangle2.y, rectangle2.x + rectangle2.width - 2, rectangle2.y);
                graphics.setColor(color2);
                graphics.drawLine(rectangle2.x + 1, rectangle2.y + rectangle2.height - 1, rectangle2.x + rectangle2.width - 1, rectangle2.y + rectangle2.height - 1);
                graphics.drawLine(rectangle2.x + rectangle2.width - 1, rectangle2.y + 1, rectangle2.x + rectangle2.width - 1, rectangle2.y + rectangle2.height - 1);
            }
        }
    }

    @Override
    public void setUI(ComponentUI componentUI) {
        super.setUI(componentUI);
        this.setOverlayBorderVisible(false);
        this.setBorder(null);
        this.setBackground(this.getUIDefaults().getColor(LookAndFeel.CONTROL));
    }

    protected String getAccessibleName(int n, int n2, Color color) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle(_ACCESSIBLE_BUNDLE, LocaleUtils.getTranslationLocale(this.getLocale()));
        if (color == null) {
            return resourceBundle.getString(_KEY_NO_COLOR);
        }
        String string = resourceBundle.getString(_KEY_TOOLTIP);
        MessageFormat messageFormat = new MessageFormat(string);
        Object[] objectArray = new Object[]{IntegerUtils.getInteger((int)color.getRed()), IntegerUtils.getInteger((int)color.getGreen()), IntegerUtils.getInteger((int)color.getBlue())};
        return messageFormat.format(objectArray);
    }

    @Override
    protected AccessibleGrid createAccessibleGrid() {
        return new Access();
    }

    @Override
    protected void firePropertyChange(String string, Object object, Object object2) {
        if (this._propertyChangeSupport != null) {
            this._propertyChangeSupport.firePropertyChange(string, object, object2);
        }
    }

    @Override
    protected void processFocusEvent(FocusEvent focusEvent) {
        super.processFocusEvent(focusEvent);
        Cell cell = this.getFocusCell();
        if (focusEvent.getID() == 1004 && cell != null && !this._inDropDown) {
            this._setSelectedColor(cell.column, cell.row);
        }
    }

    void replaceSelectedColor(Color color) {
        if (this._selectedColumn != -1 && this._selectedRow != -1) {
            this.getDataSource().setData(this._selectedColumn, this._selectedRow, color);
            this.paintCell(this._selectedColumn, this._selectedRow, true);
        }
    }

    void paintCell(int n, int n2, boolean bl) {
        if (bl || this._armedColumn == n && this._armedRow == n2) {
            Rectangle rectangle = this._getCellRect(n, n2);
            rectangle.x -= 2;
            rectangle.y -= 2;
            rectangle.width += 4;
            rectangle.height += 4;
            --rectangle.x;
            --rectangle.y;
            ++rectangle.width;
            ++rectangle.height;
            this.paintImmediateCanvas(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        } else {
            super.paintCell(n, n2);
        }
    }

    void setArmedCell(int n, int n2) {
        int n3 = this._armedColumn;
        int n4 = this._armedRow;
        this._armedColumn = n;
        this._armedRow = n2;
        boolean bl = n3 == this._selectedColumn && n4 == this._selectedRow;
        this.paintCell(n3, n4, bl);
        this.paintCell(this._armedColumn, this._armedRow, false);
        AccessibleContext accessibleContext = this.accessAccessibleContext();
        if (accessibleContext != null) {
            AccessibleGrid accessibleGrid = (AccessibleGrid)accessibleContext;
            int n5 = accessibleGrid.getAccessibleIndexAt(n3, n4);
            int n6 = accessibleGrid.getAccessibleIndexAt(this._armedColumn, this._armedRow);
            accessibleGrid.firePropertyChange("AccessibleActiveDescendant", n5 == -1 ? null : accessibleContext.getAccessibleChild(n5), n6 == -1 ? null : accessibleContext.getAccessibleChild(n6));
        }
    }

    int getArmedColumn() {
        return this._armedColumn;
    }

    int getArmedRow() {
        return this._armedRow;
    }

    int getSelectedColumn() {
        return this._selectedColumn;
    }

    int getSelectedRow() {
        return this._selectedRow;
    }

    void setInDropDown(boolean bl) {
        this._inDropDown = bl;
    }

    String __colorToString(Color color) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle(_RESOURCE_BUNDLE, LocaleUtils.getTranslationLocale(this.getLocale()));
        if (color == null) {
            return resourceBundle.getString(_KEY_NO_COLOR);
        }
        String string = resourceBundle.getString(_KEY_TOOLTIP);
        MessageFormat messageFormat = new MessageFormat(string);
        Object[] objectArray = new Object[]{IntegerUtils.getInteger((int)color.getRed()), IntegerUtils.getInteger((int)color.getGreen()), IntegerUtils.getInteger((int)color.getBlue())};
        return messageFormat.format(objectArray);
    }

    private Rectangle _getCellRect(int n, int n2) {
        Rectangle rectangle = new Rectangle();
        rectangle.x = this.getColumnPosition(n);
        rectangle.y = this.getRowPosition(n2);
        rectangle.width = this.getColumnWidth(n);
        rectangle.height = this.getRowHeight(n2);
        return rectangle;
    }

    private Color _getColor(int n, int n2) {
        return (Color)this.getDataSource().getData(n, n2);
    }

    private void _setSelectedColor(int n, int n2) {
        Color color;
        Color color2 = this._selectedColumn != -1 && this._selectedRow != -1 ? this._getColor(this._selectedColumn, this._selectedRow) : null;
        this._selectedColumn = n;
        this._selectedRow = n2;
        boolean bl = this._selectedColumn != -1 && this._selectedRow != -1;
        Color color3 = color = bl ? this._getColor(this._selectedColumn, this._selectedRow) : null;
        if (bl && !this._inDropDown) {
            this.setArmedCell(-1, -1);
        }
        this.repaint();
        this.firePropertyChange(PROPERTY_SELECTED_COLOR, color2, color);
    }

    private class Access
    extends AccessibleGrid {
        public Access() {
            super(ColorGrid.this);
        }

        @Override
        public String getAccessibleName(int n, int n2, Object object) {
            return ColorGrid.this.getAccessibleName(n, n2, (Color)object);
        }
    }

    private class Navigate
    extends StandardNavigator {
        private Navigate() {
        }

        @Override
        public Cell enter(Grid grid, Cell cell, KeyEvent keyEvent, boolean bl) {
            return cell;
        }
    }

    private class Tooltip
    extends GridToolTipClient {
        private Tooltip() {
        }

        @Override
        protected Object getCellToolTipValue(Grid grid, int n, int n2) {
            Color color = (Color)grid.getDataSource().getData(n, n2);
            return ColorGrid.this.__colorToString(color);
        }

        @Override
        protected boolean shouldDisplay(Grid grid, int n, int n2) {
            return true;
        }
    }

    private class ColorAppearanceManager
    extends AbstractAppearanceManager {
        private BorderPainter _armedBorderPainter;
        private BorderPainter _normalBorderPainter;
        private Appearance _appearance;

        private ColorAppearanceManager() {
        }

        @Override
        public Appearance getCellPaintingAppearance(int n, int n2) {
            if (this._appearance == null) {
                this._appearance = new Appearance();
            }
            this._appearance.setBackground(ColorGrid.this._getColor(n, n2));
            if (n == ColorGrid.this._armedColumn && n2 == ColorGrid.this._armedRow) {
                this._appearance.setBorderPainter(this._getArmedBorderPainter());
            } else {
                this._appearance.setBorderPainter(this._getNormalBorderPainter());
            }
            return this._appearance;
        }

        private BorderPainter _getArmedBorderPainter() {
            if (this._armedBorderPainter == null) {
                this._armedBorderPainter = new ArmedBorderPainter();
            }
            return this._armedBorderPainter;
        }

        private BorderPainter _getNormalBorderPainter() {
            if (this._normalBorderPainter == null) {
                this._normalBorderPainter = new NormalBorderPainter();
            }
            return this._normalBorderPainter;
        }

        private class NormalBorderPainter
        extends AbstractBorderPainter {
            private NormalBorderPainter() {
            }

            @Override
            protected boolean isBorderTransparent(PaintContext paintContext) {
                return true;
            }

            @Override
            protected void paintBorder(PaintContext paintContext, Graphics graphics, int n, int n2, int n3, int n4) {
                UIDefaults uIDefaults = paintContext.getPaintUIDefaults();
                Color color = uIDefaults.getColor(LookAndFeel.DARK_INTENSITY);
                Color color2 = uIDefaults.getColor(LookAndFeel.NORMAL_INTENSITY);
                if (color == null) {
                    color = Color.black;
                }
                if (color2 == null) {
                    color2 = Color.lightGray;
                }
                int n5 = n + n3 - 1;
                int n6 = n2 + n4 - 1;
                graphics.setColor(Color.white);
                graphics.drawLine(n + 1, n2, n5 - 1, n2);
                graphics.drawLine(n, n2 + 1, n, n6 - 1);
                graphics.drawLine(n + 1, n2 + 1, n + 1, n2 + 1);
                graphics.setColor(color);
                graphics.drawLine(n + 2, n6, n5 - 1, n6);
                graphics.drawLine(n5, n2 + 2, n5, n6 - 1);
                graphics.setColor(color2);
                graphics.drawLine(n + 1, n6, n + 1, n6 - 1);
                graphics.drawLine(n5, n2 + 1, n5 - 1, n2 + 1);
                graphics.drawLine(n5 - 1, n6 - 1, n5 - 1, n6 - 1);
            }

            @Override
            protected ImmInsets getOwnInsets(PaintContext paintContext) {
                return _LARGE_INSETS;
            }

            @Override
            protected ImmInsets getOwnFillInsets(PaintContext paintContext) {
                return _SMALL_INSETS;
            }
        }

        private class ArmedBorderPainter
        extends AbstractBorderPainter {
            private ArmedBorderPainter() {
            }

            @Override
            protected boolean isBorderTransparent(PaintContext paintContext) {
                return true;
            }

            @Override
            protected void paintBorder(PaintContext paintContext, Graphics graphics, int n, int n2, int n3, int n4) {
                UIDefaults uIDefaults = paintContext.getPaintUIDefaults();
                Color color = uIDefaults.getColor(LookAndFeel.NORMAL_INTENSITY);
                graphics.setColor(ColorGrid.this.getBackground());
                int n5 = n + n3 - 1;
                int n6 = n2 + n4 - 1;
                graphics.drawLine(n + 1, n2 + 1, n + 1, n2 + 1);
                graphics.drawLine(n5 - 1, n6 - 1, n5 - 1, n6 - 1);
                graphics.drawLine(n5 - 1, n2 + 1, n5 - 1, n2 + 1);
                graphics.drawLine(n + 1, n6 - 1, n + 1, n6 - 1);
            }

            @Override
            protected ImmInsets getOwnInsets(PaintContext paintContext) {
                return _LARGE_INSETS;
            }

            @Override
            protected ImmInsets getOwnFillInsets(PaintContext paintContext) {
                return _SMALL_INSETS;
            }
        }
    }

    private class Listener
    extends CellInputHandler
    implements GridFocusListener {
        private Listener() {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent, Grid grid, int n, int n2) {
            ColorGrid.this.setArmedCell(n, n2);
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent, Grid grid, int n, int n2) {
            ColorGrid.this.setArmedCell(-1, -1);
        }

        @Override
        public void focusCellChanging(GridEvent gridEvent) {
        }

        @Override
        public void focusCellChanged(GridEvent gridEvent) {
            Cell cell = ColorGrid.this.getFocusCell();
            if (cell == null) {
                ColorGrid.this._setSelectedColor(-1, -1);
            } else {
                ColorGrid.this._setSelectedColor(cell.column, cell.row);
            }
        }
    }
}

