/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.liberty.v12.metadata;

import java.util.Date;
import java.util.List;
import oracle.security.xmlsec.dsig.SigningException;
import oracle.security.xmlsec.dsig.XSSignature;
import oracle.security.xmlsec.liberty.v12.LibDSigUtils;
import oracle.security.xmlsec.liberty.v12.LibertyInitializer;
import oracle.security.xmlsec.liberty.v12.LibertyUtils;
import oracle.security.xmlsec.liberty.v12.metadata.AdditionalMetaLocation;
import oracle.security.xmlsec.liberty.v12.metadata.ContactPerson;
import oracle.security.xmlsec.liberty.v12.metadata.KeyDescriptor;
import oracle.security.xmlsec.liberty.v12.metadata.Organization;
import oracle.security.xmlsec.saml.SAMLInitializer;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.util.XMLUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class ProviderDescriptor
extends XMLElement {
    public static final String PROTOCOL_SUPPORT_11 = "http://projectliberty.org/schemas/core/2002/12";
    public static final String PROTOCOL_SUPPORT_12 = "urn:liberty:iff:2003-08";
    private static final String[] nsURIs = new String[]{"urn:liberty:metadata:2003-08", "urn:liberty:metadata:2003-08", "urn:liberty:metadata:2003-08", "urn:liberty:metadata:2003-08", "urn:liberty:metadata:2003-08", "urn:liberty:metadata:2003-08", "urn:liberty:metadata:2003-08", "urn:liberty:metadata:2003-08", "urn:liberty:metadata:2003-08", "urn:liberty:metadata:2003-08", "urn:liberty:metadata:2003-08", "urn:liberty:metadata:2003-08", "urn:liberty:metadata:2003-08", "urn:liberty:metadata:2003-08", "urn:liberty:metadata:2003-08", "urn:liberty:metadata:2003-08", "urn:liberty:metadata:2003-08", "http://www.w3.org/2000/09/xmldsig#"};
    private static final String[] localNames = new String[]{"KeyDescriptor", "SoapEndpoint", "SingleLogoutServiceURL", "SingleLogoutServiceReturnURL", "FederationTerminationServiceURL", "FederationTerminationServiceReturnURL", "FederationTerminationNotificationProtocolProfile", "SingleLogoutProtocolProfile", "RegisterNameIdentifierProtocolProfile", "RegisterNameIdentifierServiceURL", "RegisterNameIdentifierServiceReturnURL", "NameIdentifierMappingProtocolProfile", "NameIdentifierMappingEncryptionProfile", "Organization", "ContactPerson", "AdditionalMetaLocation", "Extension", "Signature"};
    private static final String[] nsURIsPrecedeDSig = new String[]{"urn:liberty:metadata:2003-08", "urn:liberty:metadata:2003-08", "urn:liberty:metadata:2003-08", "urn:liberty:metadata:2003-08", "urn:liberty:metadata:2003-08", "urn:liberty:metadata:2003-08", "urn:liberty:metadata:2003-08", "urn:liberty:metadata:2003-08", "urn:liberty:metadata:2003-08", "urn:liberty:metadata:2003-08", "urn:liberty:metadata:2003-08", "urn:liberty:metadata:2003-08", "urn:liberty:metadata:2003-08", "urn:liberty:metadata:2003-08", "urn:liberty:metadata:2003-08", "urn:liberty:metadata:2003-08", "urn:liberty:metadata:2003-08"};
    private static final String[] localNamesPrecedeDSig = new String[]{"KeyDescriptor", "SoapEndpoint", "SingleLogoutServiceURL", "SingleLogoutServiceReturnURL", "FederationTerminationServiceURL", "FederationTerminationServiceReturnURL", "FederationTerminationNotificationProtocolProfile", "SingleLogoutProtocolProfile", "RegisterNameIdentifierProtocolProfile", "RegisterNameIdentifierServiceURL", "RegisterNameIdentifierServiceReturnURL", "NameIdentifierMappingProtocolProfile", "NameIdentifierMappingEncryptionProfile", "Organization", "ContactPerson", "AdditionalMetaLocation", "Extension"};

    protected ProviderDescriptor(Element element) throws DOMException {
        super(element);
    }

    protected ProviderDescriptor(Element element, String systemId) throws DOMException {
        super(element, systemId);
    }

    protected ProviderDescriptor(Document owner) throws DOMException {
        this(owner, PROTOCOL_SUPPORT_12, "providerDescriptorType");
        this.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:liberty:metadata:2003-08");
        this.addNSPrefixAttrDefault("urn:liberty:metadata:2003-08");
    }

    protected ProviderDescriptor(Document owner, String nsURI, String localName) throws DOMException {
        super(owner, nsURI, localName);
    }

    public void setId(String id) throws DOMException {
        this.setAttribute("id", id);
    }

    public String getId() {
        if (this.hasAttribute("id")) {
            return this.getAttribute("id");
        }
        return null;
    }

    public void setValidUntil(Date validUntil) throws DOMException {
        this.setAttribute("validUntil", XMLUtils.formatDateTime((Date)validUntil));
    }

    public Date getValidUntil() {
        if (this.hasAttribute("validUntil")) {
            return XMLUtils.parseDateTime((String)this.getAttribute("validUntil"));
        }
        return null;
    }

    public void setCacheDuration(String duration) throws DOMException {
        this.setAttribute("cacheDuration", duration);
    }

    public String getCacheDuration() {
        if (this.hasAttribute("cacheDuration")) {
            return this.getAttribute("cacheDuration");
        }
        return null;
    }

    public void setProtocolSupportEnumeration(String protocols) throws DOMException {
        this.setAttribute("protocolSupportEnumeration", protocols);
    }

    public String getProtocolSupportEnumeration() {
        if (this.hasAttribute("protocolSupportEnumeration")) {
            return this.getAttribute("protocolSupportEnumeration");
        }
        return null;
    }

    public void addKeyDescriptor(KeyDescriptor keyDesc) {
        XMLUtils.insertChild((XMLElement)this, (XMLElement)keyDesc, (String[])nsURIs, (String[])localNames);
    }

    public List getKeyDescriptors() {
        return LibertyUtils.getChildElements(this, "urn:liberty:metadata:2003-08", "KeyDescriptor");
    }

    public void setSoapEndpoint(String soapEndpointURL) {
        LibertyUtils.insertChildElementWithText(this, "urn:liberty:metadata:2003-08", "SoapEndpoint", nsURIs, localNames, soapEndpointURL, true);
    }

    public String getSoapEndpoint() {
        return LibertyUtils.collectTextFromChild(this, "urn:liberty:metadata:2003-08", "SoapEndpoint");
    }

    public void setSingleLogoutServiceURL(String logoutServiceURL) {
        LibertyUtils.insertChildElementWithText(this, "urn:liberty:metadata:2003-08", "SingleLogoutServiceURL", nsURIs, localNames, logoutServiceURL, true);
    }

    public String getSingleLogoutServiceURL() {
        return LibertyUtils.collectTextFromChild(this, "urn:liberty:metadata:2003-08", "SingleLogoutServiceURL");
    }

    public void setSingleLogoutServiceReturnURL(String logoutReturnURL) {
        LibertyUtils.insertChildElementWithText(this, "urn:liberty:metadata:2003-08", "SingleLogoutServiceReturnURL", nsURIs, localNames, logoutReturnURL, true);
    }

    public String getSingleLogoutServiceReturnURL() {
        return LibertyUtils.collectTextFromChild(this, "urn:liberty:metadata:2003-08", "SingleLogoutServiceReturnURL");
    }

    public void setFederationTerminationServiceURL(String fedTermServiceURL) {
        LibertyUtils.insertChildElementWithText(this, "urn:liberty:metadata:2003-08", "FederationTerminationServiceURL", nsURIs, localNames, fedTermServiceURL, true);
    }

    public String getFederationTerminationServiceURL() {
        return LibertyUtils.collectTextFromChild(this, "urn:liberty:metadata:2003-08", "FederationTerminationServiceURL");
    }

    public void setFederationTerminationServiceReturnURL(String fedTermReturnURL) {
        LibertyUtils.insertChildElementWithText(this, "urn:liberty:metadata:2003-08", "FederationTerminationServiceReturnURL", nsURIs, localNames, fedTermReturnURL, true);
    }

    public String getFederationTerminationServiceReturnURL() {
        return LibertyUtils.collectTextFromChild(this, "urn:liberty:metadata:2003-08", "FederationTerminationServiceReturnURL");
    }

    public void addFederationTerminationNotificationProtocolProfile(String fedTermProfURL) {
        LibertyUtils.insertChildElementWithText(this, "urn:liberty:metadata:2003-08", "FederationTerminationNotificationProtocolProfile", nsURIs, localNames, fedTermProfURL, false);
    }

    public List getFederationTerminationNotificationProtocolProfiles() {
        return LibertyUtils.collectTextFromChildren(this, "urn:liberty:metadata:2003-08", "FederationTerminationNotificationProtocolProfile");
    }

    public void addSingleLogoutProtocolProfile(String logoutProfURI) {
        LibertyUtils.insertChildElementWithText(this, "urn:liberty:metadata:2003-08", "SingleLogoutProtocolProfile", nsURIs, localNames, logoutProfURI, false);
    }

    public List getSingleLogoutProtocolProfiles() {
        return LibertyUtils.collectTextFromChildren(this, "urn:liberty:metadata:2003-08", "SingleLogoutProtocolProfile");
    }

    public void addRegisterNameIdentifierProtocolProfile(String regNameProfURI) {
        LibertyUtils.insertChildElementWithText(this, "urn:liberty:metadata:2003-08", "RegisterNameIdentifierProtocolProfile", nsURIs, localNames, regNameProfURI, false);
    }

    public List getRegisterNameIdentifierProtocolProfiles() {
        return LibertyUtils.collectTextFromChildren(this, "urn:liberty:metadata:2003-08", "RegisterNameIdentifierProtocolProfile");
    }

    public void setRegisterNameIdentifierServiceURL(String regNameServiceURL) {
        LibertyUtils.insertChildElementWithText(this, "urn:liberty:metadata:2003-08", "RegisterNameIdentifierServiceURL", nsURIs, localNames, regNameServiceURL, true);
    }

    public String getRegisterNameIdentifierServiceURL() {
        return LibertyUtils.collectTextFromChild(this, "urn:liberty:metadata:2003-08", "RegisterNameIdentifierServiceURL");
    }

    public void setRegisterNameIdentifierServiceReturnURL(String regNameReturnURL) {
        LibertyUtils.insertChildElementWithText(this, "urn:liberty:metadata:2003-08", "RegisterNameIdentifierServiceReturnURL", nsURIs, localNames, regNameReturnURL, true);
    }

    public String getRegisterNameIdentifierServiceReturnURL() {
        return LibertyUtils.collectTextFromChild(this, "urn:liberty:metadata:2003-08", "RegisterNameIdentifierServiceReturnURL");
    }

    public void addNameIdentifierMappingProtocolProfile(String profileURI) {
        LibertyUtils.insertChildElementWithText(this, "urn:liberty:metadata:2003-08", "NameIdentifierMappingProtocolProfile", nsURIs, localNames, profileURI, false);
    }

    public List getNameIdentifierMappingProtocolProfiles() {
        return LibertyUtils.collectTextFromChildren(this, "urn:liberty:metadata:2003-08", "NameIdentifierMappingProtocolProfile");
    }

    public void addNameIdentifierMappingEncryptionProfile(String profileURI) {
        LibertyUtils.insertChildElementWithText(this, "urn:liberty:metadata:2003-08", "NameIdentifierMappingEncryptionProfile", nsURIs, localNames, profileURI, false);
    }

    public List getNameIdentifierMappingEncryptionProfiles() {
        return LibertyUtils.collectTextFromChildren(this, "urn:liberty:metadata:2003-08", "NameIdentifierMappingEncryptionProfile");
    }

    public void setOrganization(Organization org) {
        LibertyUtils.setChildElement(this, org, nsURIs, localNames);
    }

    public Organization getOrganization() {
        return (Organization)LibertyUtils.getChildElement(this, "urn:liberty:metadata:2003-08", "Organization");
    }

    public void addContactPerson(ContactPerson contact) {
        XMLUtils.insertChild((XMLElement)this, (XMLElement)contact, (String[])nsURIs, (String[])localNames);
    }

    public List getContactPersons() {
        return LibertyUtils.getChildElements(this, "urn:liberty:metadata:2003-08", "ContactPerson");
    }

    public void addAdditionalMetaLocation(AdditionalMetaLocation metadataLoc) {
        XMLUtils.insertChild((XMLElement)this, (XMLElement)metadataLoc, (String[])nsURIs, (String[])localNames);
    }

    public List getAdditionalMetaLocations() {
        return LibertyUtils.getChildElements(this, "urn:liberty:metadata:2003-08", "AdditionalMetaLocation");
    }

    public XSSignature addSignature(String signatureMethod, String c14nMethod, String digestMethod) throws DOMException, SigningException {
        String id = this.getId();
        if (id == null || id.length() == 0) {
            throw new SigningException("Cannot add ds:Signature, missing 'id' attribute");
        }
        XMLUtils.removeChildren((Element)((Element)this.node), (String)"http://www.w3.org/2000/09/xmldsig#", (String)"Signature");
        return LibDSigUtils.addSignature(this, id, signatureMethod, c14nMethod, digestMethod, nsURIsPrecedeDSig, localNamesPrecedeDSig);
    }

    public XSSignature getSignature() {
        return (XSSignature)LibertyUtils.getChildElement(this, "http://www.w3.org/2000/09/xmldsig#", "Signature");
    }

    static {
        SAMLInitializer.initialize((int)1, (int)1);
        LibertyInitializer.initialize();
    }
}

