/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.editors;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.dba.navigator.DbaConnection;
import oracle.dbtools.raptor.dba.navigator.editors.DbControlNode;
import oracle.dbtools.raptor.dba.navigator.editors.DbaEditorArb;
import oracle.dbtools.raptor.dialogs.conn.ConnectionInfoPanel;
import oracle.dbtools.raptor.navigator.db.DatabaseConnection;
import oracle.dbtools.raptor.utils.ConnectionCanceledException;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controls.WaitCursor;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.UpdateMessage;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.ClosureException;
import oracle.javatools.util.SwingClosure;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.pool.OracleDataSource;

public class DbControlEditor
extends Editor {
    private static String SKIP = "LEAVE_PREVIOUS_MESSAGE";
    private String HELPTAG = "f1_dbanavmanagedatabase_html";
    private JPanel _jpOuter;
    private String _status = "";
    private boolean _refreshGui = false;
    private String _promptedPasswordThisImpression = null;
    private JLabel _statusLabel = new JLabel(this._status);
    private JLabel _startedMountOpen = new JLabel(this._status);
    private JCheckBox _forceCheckBox = new JCheckBox(DbaEditorArb.getString("FORCE_DATABASE_STARTUP"));
    private JCheckBox _restrictCheckBox = new JCheckBox(DbaEditorArb.getString("RESTRICT_ACCESS_TO_DATABASE"));
    private JTextField _pfileTextField = null;
    private JButton _jbRefresh = new JButton(DbaEditorArb.getString("REFRESH"));
    private JButton _jbCancel = new JButton(DbaEditorArb.getString("CANCEL_SHUTDOWN_NORMAL"));
    private JButton _jbHelp = new JButton(DbaEditorArb.getString("HELP"));
    OracleConnection _shutdownNormalConn = null;
    private boolean _closeCalled = false;
    Usedialog _tryBeqDialog = Usedialog.NOTSET;
    private ConnectState _lastConnectState = ConnectState.UNKNOWN;
    String name = null;

    public DbControlEditor() {
        this._jbRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (DbControlEditor.this._closeCalled) {
                    return;
                }
                DbControlEditor.this._promptedPasswordThisImpression = null;
                DbControlEditor.this.setStatusLabel("");
                DbControlEditor.this.setTryBeqDialog(Usedialog.NOTSET);
                DbControlEditor.this.refresh(Boolean.FALSE);
            }
        });
        this._jbHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (DbControlEditor.this._jpOuter != null) {
                    if (DbControlEditor.this._closeCalled) {
                        return;
                    }
                    HelpSystem.getHelpSystem().showHelp((JComponent)DbControlEditor.this._jpOuter);
                }
            }
        });
        HelpSystem.getHelpSystem().registerTopic((JComponent)this._jbHelp, this.HELPTAG);
        this._jbCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DbControlEditor.this.cancelShutdownNormalConn();
            }
        });
        this._startedMountOpen.setBorder(BorderFactory.createEtchedBorder(0));
        this._statusLabel.setBorder(BorderFactory.createEtchedBorder(0));
    }

    public void open() {
    }

    public void close() {
        this.cancelShutdownNormalConn();
        this._closeCalled = true;
    }

    public synchronized void setContext(Context context) {
        Element element = this.getSelection(context);
        this.name = element instanceof DatabaseConnection ? ((DatabaseConnection)element).getQualifiedConnectionName() : (element instanceof DbControlNode ? ((DbControlNode)element).getQualifiedConnectionName() : "");
        super.setContext(context);
    }

    private Element getSelection(Context context) {
        Element[] elementArray;
        Node node = context.getNode();
        if (node == null && (elementArray = context.getSelection()) != null && elementArray.length == 1) {
            node = elementArray[0];
        }
        return node;
    }

    public Component getGUI() {
        if (this._jpOuter == null) {
            this._jpOuter = new JPanel();
            this._refreshGui = true;
        }
        if (this._refreshGui) {
            this.init(Boolean.FALSE);
            this._refreshGui = false;
        }
        HelpSystem.getHelpSystem().registerTopic((JComponent)this._jpOuter, this.HELPTAG);
        return this._jpOuter;
    }

    public void update(Object object, UpdateMessage updateMessage) {
    }

    public void clear() {
        if (this._jpOuter != null) {
            this._jpOuter.removeAll();
            this._jpOuter.revalidate();
            this._jpOuter.repaint();
            this._refreshGui = true;
            HelpSystem.getHelpSystem().registerTopic((JComponent)this._jpOuter, this.HELPTAG);
        }
    }

    public void refreshLater(final Boolean bl) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (DbControlEditor.this._closeCalled) {
                    return;
                }
                try {
                    if (DbControlEditor.this._closeCalled) {
                        return;
                    }
                    DbControlEditor.this.refresh(bl);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public void setStartedMountOpenAndRefresh(final ConnectState connectState, final Boolean bl, final String string) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    if (DbControlEditor.this._closeCalled) {
                        return;
                    }
                    DbControlEditor.this._lastConnectState = connectState;
                    DbControlEditor.this.setStartedMountOpen(connectState);
                    if (string == null) {
                        DbControlEditor.this.setStatusLabel("");
                    } else {
                        DbControlEditor.this.setStatusLabel(string);
                    }
                    if (bl.equals(Boolean.FALSE)) {
                        DbControlEditor.this.refresh(bl);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public void setStartedMountOpen(final ConnectState connectState) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    if (DbControlEditor.this._closeCalled) {
                        return;
                    }
                    DbControlEditor.this._lastConnectState = connectState;
                    DbControlEditor.this._startedMountOpen.setText(connectState.toString());
                    if (connectState.equals((Object)ConnectState.CONNECTING) || connectState.equals((Object)ConnectState.PROCESSING) || connectState.equals((Object)ConnectState.SHUTDOWNNORMAL)) {
                        DbControlEditor.this._jbRefresh.setEnabled(false);
                    } else {
                        DbControlEditor.this._jbRefresh.setEnabled(true);
                    }
                    DbControlEditor.this.refresh(Boolean.TRUE);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                throw new Exception("Error");
            }
            catch (Exception exception) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
            }
        }
    }

    public ConnectState getLastConnectState() {
        return this._lastConnectState;
    }

    public void setStatusLabel(final String string) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    if (DbControlEditor.this._closeCalled) {
                        return;
                    }
                    String string2 = string;
                    if (string2.equals(SKIP)) {
                        return;
                    }
                    if (string2 == null) {
                        string2 = "";
                    }
                    if (string2.length() > 81) {
                        string2 = string2.substring(0, 80);
                    }
                    DbControlEditor.this._statusLabel.setText(string2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    String getStatusLabel() {
        return this._statusLabel.getText();
    }

    private JPanel getInfoPanel(Boolean bl, ConnectState[] connectStateArray) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.add((Component)this._jbRefresh, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 12, 0, new Insets(5, 5, 0, 0), 0, 0));
        jPanel2.add(Box.createHorizontalGlue(), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(5, 5, 0, 0), 0, 0));
        jPanel.add((Component)jPanel2, new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        JLabel jLabel = new JLabel(DbaEditorArb.getString("DATABASE_OVERALL_STATE"));
        jLabel.setHorizontalAlignment(2);
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        if (!bl.equals(Boolean.TRUE)) {
            this.getStatus();
        }
        jPanel.remove(jPanel2);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.add((Component)this._jbRefresh, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 12, 0, new Insets(5, 5, 0, 0), 0, 0));
        jPanel3.add(Box.createHorizontalGlue(), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(5, 5, 0, 0), 0, 0));
        jPanel.add((Component)jPanel3, new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        connectStateArray[0] = this.getLastConnectState();
        this._startedMountOpen.setText(connectStateArray[0].toString());
        jPanel.add((Component)this._startedMountOpen, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        JLabel jLabel2 = new JLabel(DbaEditorArb.getString("COMMAND_FEEDBACK"));
        jLabel2.setHorizontalAlignment(2);
        jPanel4.add((Component)jLabel2, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 0, 0), 0, 0));
        jPanel4.add((Component)this._statusLabel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 11, 1, new Insets(5, 5, 0, 5), 0, 0));
        jPanel.add((Component)jPanel4, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 18, 2, new Insets(0, 5, 0, 0), 0, 0));
        jPanel.setBorder(BorderFactory.createEtchedBorder(0));
        return jPanel;
    }

    private JPanel getActionPanel(ConnectState[] connectStateArray) {
        JButton jButton;
        JComponent jComponent;
        JComponent jComponent2;
        Object object;
        JComponent jComponent3;
        boolean bl = false;
        JPanel jPanel = new JPanel(new GridBagLayout());
        int n = 0;
        if (connectStateArray[0].equals((Object)ConnectState.CONNECTING)) {
            jPanel.add((Component)new JLabel(DbaEditorArb.getString("STATUS_CONNECTING")), new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 18, 0, new Insets(0, 5, 0, 0), 0, 0));
            bl = true;
            n = 1;
        } else if (connectStateArray[0].equals((Object)ConnectState.PROCESSING)) {
            jPanel.add((Component)new JLabel(DbaEditorArb.getString("STATUS_PROCESSING")), new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 18, 0, new Insets(0, 5, 0, 0), 0, 0));
            bl = true;
            n = 1;
        } else if (connectStateArray[0].equals((Object)ConnectState.SHUTDOWNNORMAL)) {
            jPanel.add((Component)this._jbCancel, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 18, 0, new Insets(2, 5, 2, 0), 0, 0));
            jPanel.add(Box.createHorizontalGlue(), new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(0, 5, 0, 0), 0, 0));
        } else if (connectStateArray[0].equals((Object)ConnectState.INVALID_USERNAME_PASSWORD)) {
            jPanel.add((Component)new JLabel(DbaEditorArb.getString("INVALID_USERNAME_PASSWORD_LONG")), new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 18, 0, new Insets(0, 5, 0, 0), 0, 0));
            bl = true;
            n = 1;
        }
        if (connectStateArray[0].equals((Object)ConnectState.CANT_CONNECT) || connectStateArray[0].equals((Object)ConnectState.UNKNOWN)) {
            JPanel jPanel2;
            jComponent3 = new JComboBox<Object>(new Object[]{"NOMOUNT", "MOUNT", "OPEN"});
            ((JComboBox)jComponent3).setSelectedIndex(2);
            object = new JLabel("STARTUP");
            ((JLabel)object).setHorizontalAlignment(2);
            jPanel.add((Component)object, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
            jPanel.add((Component)jComponent3, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
            jComponent2 = this._forceCheckBox;
            jComponent = this._restrictCheckBox;
            jButton = new JButton(DbaEditorArb.getString("GO"));
            jButton.addActionListener(new ActionListener(){
                final /* synthetic */ JComboBox val$cb;
                final /* synthetic */ JCheckBox val$forceDbStartup;
                final /* synthetic */ JCheckBox val$accessDb;
                {
                    this.val$cb = jComboBox;
                    this.val$forceDbStartup = jCheckBox;
                    this.val$accessDb = jCheckBox2;
                }

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (DbControlEditor.this._closeCalled) {
                        return;
                    }
                    DbControlEditor.this.setStatusLabel(null);
                    DbControlEditor.this.startup((String)this.val$cb.getSelectedItem(), this.val$forceDbStartup.isSelected(), this.val$accessDb.isSelected());
                }
            });
            jPanel.add((Component)jButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
            int n2 = 1;
            if (this._pfileTextField != null) {
                jPanel2 = new JPanel(new GridBagLayout());
                JLabel jLabel = new JLabel(DbaEditorArb.getString("PFILE"));
                jLabel.setHorizontalAlignment(2);
                jPanel2.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(5, 5, 0, 10), 0, 0));
                jPanel2.add((Component)this._pfileTextField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(5, 5, 0, 5), 0, 0));
                jPanel.add((Component)jPanel2, new GridBagConstraints(0, 1, 3, 1, 1.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
            } else {
                n2 = 0;
            }
            jPanel2 = new JPanel(new GridBagLayout());
            jPanel2.add(Box.createHorizontalGlue(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(5, 5, 0, 0), 0, 0));
            jPanel2.add((Component)jComponent, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 12, 0, new Insets(5, 5, 0, 0), 0, 0));
            jPanel2.add((Component)jComponent2, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 12, 0, new Insets(5, 5, 0, 0), 0, 0));
            jPanel.add((Component)jPanel2, new GridBagConstraints(0, 1 + n2, 3, 1, 1.0, 0.0, 18, 0, new Insets(0, 5, 0, 0), 0, 0));
            bl = true;
            n = 2 + n2;
        }
        if (connectStateArray[0].equals((Object)ConnectState.STARTED) || connectStateArray[0].equals((Object)ConnectState.MOUNTED) || connectStateArray[0].equals((Object)ConnectState.UNKNOWN)) {
            if (bl) {
                jComponent3 = new JSeparator(0);
                jComponent3.setPreferredSize(new Dimension(200, 5));
                jComponent3.setBorder(BorderFactory.createEtchedBorder(0));
                jComponent3.setVisible(true);
                jPanel.add((Component)jComponent3, new GridBagConstraints(0, n, 3, 1, 1.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
                bl = false;
                ++n;
            }
            int n3 = 0;
            object = null;
            if (connectStateArray[0].equals((Object)ConnectState.STARTED)) {
                object = new Object[]{"MOUNT"};
                n3 = 0;
            } else if (connectStateArray[0].equals((Object)ConnectState.MOUNTED)) {
                object = new Object[]{"OPEN"};
                n3 = 0;
            } else {
                object = new Object[]{"MOUNT", "OPEN"};
                n3 = 1;
            }
            jComponent2 = new JComboBox<Object>((E[])object);
            ((JComboBox)jComponent2).setSelectedIndex(n3);
            jComponent = new JLabel("ALTER DATABASE");
            jComponent.setHorizontalAlignment(2);
            jPanel.add((Component)jComponent, new GridBagConstraints(0, n, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
            jPanel.add(jComponent2, new GridBagConstraints(1, n, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
            jButton = new JButton(DbaEditorArb.getString("GO"));
            jButton.addActionListener(new ActionListener(){
                final /* synthetic */ JComboBox val$cb2;
                {
                    this.val$cb2 = jComboBox;
                }

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (DbControlEditor.this._closeCalled) {
                        return;
                    }
                    DbControlEditor.this.setStatusLabel(null);
                    DbControlEditor.this.alterdb("ALTER DATABASE " + this.val$cb2.getSelectedItem());
                }
            });
            jPanel.add((Component)jButton, new GridBagConstraints(2, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
            bl = true;
            ++n;
        }
        if (connectStateArray[0].equals((Object)ConnectState.STARTED) || connectStateArray[0].equals((Object)ConnectState.MOUNTED) || connectStateArray[0].equals((Object)ConnectState.OPEN) || connectStateArray[0].equals((Object)ConnectState.UNKNOWN)) {
            if (bl) {
                jComponent3 = new JSeparator(0);
                jComponent3.setPreferredSize(new Dimension(200, 5));
                jComponent3.setBorder(BorderFactory.createEtchedBorder(0));
                jComponent3.setVisible(true);
                jPanel.add((Component)jComponent3, new GridBagConstraints(0, n, 3, 1, 1.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
                bl = false;
                ++n;
            }
            jComponent3 = new JComboBox<Object>(new Object[]{"ABORT", "IMMEDIATE", "NORMAL", "TRANSACTIONAL", "TRANSACTIONAL LOCAL"});
            ((JComboBox)jComponent3).setSelectedIndex(1);
            object = new JLabel("SHUTDOWN");
            ((JLabel)object).setHorizontalAlignment(2);
            jPanel.add((Component)object, new GridBagConstraints(0, n, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
            jPanel.add((Component)jComponent3, new GridBagConstraints(1, n, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
            jComponent2 = new JButton(DbaEditorArb.getString("GO"));
            ((AbstractButton)jComponent2).addActionListener(new ActionListener(){
                final /* synthetic */ JComboBox val$cb3;
                {
                    this.val$cb3 = jComboBox;
                }

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (DbControlEditor.this._closeCalled) {
                        return;
                    }
                    DbControlEditor.this.setStatusLabel(null);
                    DbControlEditor.this._status = "";
                    DbControlEditor.this.shutdown((String)this.val$cb3.getSelectedItem());
                }
            });
            jPanel.add((Component)jComponent2, new GridBagConstraints(2, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        }
        jPanel.setBorder(BorderFactory.createEtchedBorder(0));
        return jPanel;
    }

    private void init(Boolean bl) {
        if (this._closeCalled) {
            return;
        }
        ConnectState[] connectStateArray = new ConnectState[]{null};
        if (this._jpOuter == null) {
            this._jpOuter = new JPanel();
        }
        this.clear();
        this._jpOuter.setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        JPanel jPanel2 = this.getInfoPanel(bl, connectStateArray);
        if (this._jpOuter == null) {
            this._jpOuter = new JPanel();
        }
        this.clear();
        this._jpOuter.setLayout(new GridBagLayout());
        jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)new Label(DbaEditorArb.getString("INFORMATION")), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(5, 5, 0, 0), 0, 0));
        jPanel.add((Component)jPanel2, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 5, 0, 0), 0, 0));
        jPanel.add((Component)new Label(DbaEditorArb.getString("ACTIONS")), new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 18, 0, new Insets(5, 5, 0, 0), 0, 0));
        JPanel jPanel3 = this.getActionPanel(connectStateArray);
        jPanel.add((Component)jPanel3, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 5, 0, 0), 0, 0));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridBagLayout());
        jPanel4.add((Component)this._jbHelp, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 0, 5, 0), 0, 0));
        jPanel4.add(Box.createHorizontalGlue(), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 5, 0, 0), 0, 0));
        jPanel.add((Component)jPanel4, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 5, 0, 0), 0, 0));
        jPanel.add(Box.createVerticalGlue(), new GridBagConstraints(0, 5, 1, 1, 0.0, 1.0, 18, 0, new Insets(0, 5, 0, 0), 0, 0));
        jPanel.add(Box.createHorizontalGlue(), new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(0, 5, 0, 0), 0, 0));
        this._jpOuter.add((Component)jPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this._jpOuter.add(Box.createVerticalGlue(), new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 18, 0, new Insets(0, 5, 0, 0), 0, 0));
        this._jpOuter.add(Box.createHorizontalGlue(), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(0, 5, 0, 0), 0, 0));
        jPanel2.validate();
        jPanel3.validate();
        jPanel2.setVisible(true);
        jPanel3.setVisible(true);
        jPanel.validate();
        this._jpOuter.validate();
        jPanel.setVisible(true);
        this._jpOuter.setVisible(true);
        this._refreshGui = Boolean.FALSE;
    }

    public void refresh(Boolean bl) {
        if (this._closeCalled) {
            return;
        }
        this.clear();
        this.init(bl);
        this.reqFocus();
    }

    String[] getEventThreadProperties() {
        Properties properties = Connections.getInstance().getConnectionInfo(this.name);
        String string = properties.getProperty("customUrl");
        String string2 = properties.getProperty("user");
        String string3 = properties.getProperty("password");
        if (string3 == null) {
            if (this._promptedPasswordThisImpression == null) {
                this._promptedPasswordThisImpression = this.passwordGetPassword(string2);
            }
            string3 = this._promptedPasswordThisImpression;
        }
        if (string3 == null) {
            this.setStatusLabel(DbaEditorArb.getString("NO_PASSWORD"));
            this.setStartedMountOpen(ConnectState.CANT_CONNECT);
        }
        return new String[]{string, string2, string3};
    }

    private OracleConnection commonCodeGetConnectionImpl(String[] stringArray, boolean bl, boolean bl2) throws SQLException {
        Runnable runnable;
        String string = stringArray[0];
        String string2 = stringArray[1];
        String string3 = stringArray[2];
        OracleDataSource oracleDataSource = new OracleDataSource();
        Properties properties = new Properties();
        properties.setProperty("user", string2);
        properties.setProperty("password", string3);
        properties.setProperty("internal_logon", "sysdba");
        if (bl) {
            properties.setProperty("prelim_auth", "true");
        }
        oracleDataSource.setConnectionProperties(properties);
        if (bl2) {
            if (string.equals("jdbc:oracle:oci8:@")) {
                return null;
            }
            runnable = new Runnable(){

                @Override
                public void run() {
                    if (DbControlEditor.this.getTryBeqDialog().equals((Object)Usedialog.NOTSET)) {
                        int n = MessageDialog.confirmOrCancel((Component)Ide.getMainWindow(), (Object)DbaEditorArb.getString("USE_BEQ_MESSAGE"), (String)DbaEditorArb.getString("USE_BEQ_TITLE"), (String)null, (boolean)true);
                        if (n == 1) {
                            DbControlEditor.this.setTryBeqDialog(Usedialog.TRUE);
                        } else if (n == 0) {
                            DbControlEditor.this.setTryBeqDialog(Usedialog.FALSE);
                        }
                    }
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                try {
                    if (this.getTryBeqDialog().equals((Object)Usedialog.NOTSET)) {
                        SwingUtilities.invokeAndWait(runnable);
                    }
                }
                catch (InterruptedException interruptedException) {
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, interruptedException.getStackTrace()[0].toString(), interruptedException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, invocationTargetException.getStackTrace()[0].toString(), invocationTargetException);
                }
            }
            if (!this.getTryBeqDialog().equals((Object)Usedialog.TRUE)) {
                return null;
            }
            oracleDataSource.setURL("jdbc:oracle:oci8:@");
        } else {
            oracleDataSource.setURL(string);
        }
        runnable = null;
        try {
            runnable = (OracleConnection)oracleDataSource.getConnection();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            throw new SQLException(unsatisfiedLinkError);
        }
        return runnable;
    }

    private OracleConnection commonCodeGetConnection(String[] stringArray, boolean bl) throws SQLException {
        OracleConnection oracleConnection;
        block3: {
            oracleConnection = null;
            try {
                oracleConnection = this.commonCodeGetConnectionImpl(stringArray, bl, false);
            }
            catch (SQLException sQLException) {
                if (sQLException.getMessage().toLowerCase().startsWith("ora-01017")) {
                    throw sQLException;
                }
                oracleConnection = this.commonCodeGetConnectionImpl(stringArray, bl, true);
                if (oracleConnection != null) break block3;
                throw sQLException;
            }
        }
        return oracleConnection;
    }

    private void startup(final String string, final boolean bl, final boolean bl2) {
        try {
            this.setStatusLabel(DbaEditorArb.format("BEGINNING", "STARTUP " + string));
            final String[] stringArray = this.getEventThreadProperties();
            if (stringArray[2] == null) {
                return;
            }
            this.setStartedMountOpen(ConnectState.PROCESSING);
            RaptorTask<Object> raptorTask = new RaptorTask<Object>("STARTUP", true, IRaptorTaskRunMode.NO_GUI){

                protected Object doWork() throws TaskException {
                    OracleConnection oracleConnection = null;
                    OracleConnection oracleConnection2 = null;
                    Statement statement = null;
                    try {
                        if (bl && bl2) {
                            oracleConnection = DbControlEditor.this.commonCodeGetConnection(stringArray, true);
                            oracleConnection.shutdown(OracleConnection.DatabaseShutdownMode.ABORT);
                            oracleConnection.close();
                        }
                        oracleConnection = DbControlEditor.this.commonCodeGetConnection(stringArray, true);
                        if (bl && !bl2) {
                            oracleConnection.startup(OracleConnection.DatabaseStartupMode.FORCE);
                        } else if (bl2) {
                            oracleConnection.startup(OracleConnection.DatabaseStartupMode.RESTRICT);
                        } else {
                            oracleConnection.startup(OracleConnection.DatabaseStartupMode.NO_RESTRICTION);
                        }
                        oracleConnection.close();
                        oracleConnection2 = DbControlEditor.this.commonCodeGetConnection(stringArray, false);
                        statement = oracleConnection2.createStatement();
                        if (string.equals("MOUNT") || string.equals("OPEN")) {
                            statement.executeUpdate("ALTER DATABASE MOUNT");
                        }
                        if (string.equals("OPEN")) {
                            statement.executeUpdate("ALTER DATABASE OPEN");
                        }
                        statement.close();
                        oracleConnection2.close();
                        DbControlEditor.this.setStatusLabel(DbaEditorArb.format("SUCCEEDED", "STARTUP"));
                    }
                    catch (Exception exception) {
                        DbControlEditor.this.setStatusLabel("STARTUP: " + exception.getLocalizedMessage());
                        throw new TaskException((Throwable)exception);
                    }
                    finally {
                        if (statement != null) {
                            try {
                                statement.close();
                            }
                            catch (SQLException sQLException) {}
                        }
                        if (oracleConnection != null) {
                            try {
                                oracleConnection.close();
                            }
                            catch (SQLException sQLException) {}
                        }
                        if (oracleConnection2 != null) {
                            try {
                                oracleConnection2.close();
                            }
                            catch (SQLException sQLException) {}
                        }
                    }
                    return null;
                }
            };
            raptorTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

                public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                    DbControlEditor.this.refreshLater(Boolean.FALSE);
                }

                public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
                    DbControlEditor.this.refreshLater(Boolean.FALSE);
                }
            });
            raptorTask.setCancellable(false);
            RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
        }
        catch (Exception exception) {
            this.setStatusLabel("STARTUP: " + exception.getLocalizedMessage());
            ExceptionHandler.handleException((Throwable)exception);
        }
    }

    private void alterdb(final String string) {
        try {
            this.setStatusLabel(DbaEditorArb.format("BEGINNING", string));
            final String[] stringArray = this.getEventThreadProperties();
            if (stringArray[2] == null) {
                return;
            }
            this.setStartedMountOpen(ConnectState.PROCESSING);
            RaptorTask<Object> raptorTask = new RaptorTask<Object>("ALTER DATABASE", true, IRaptorTaskRunMode.NO_GUI){

                protected Object doWork() throws TaskException {
                    OracleConnection oracleConnection = null;
                    Statement statement = null;
                    try {
                        oracleConnection = DbControlEditor.this.commonCodeGetConnection(stringArray, false);
                        statement = oracleConnection.createStatement();
                        statement.executeUpdate(string);
                        statement.close();
                        oracleConnection.close();
                        DbControlEditor.this.setStatusLabel(DbaEditorArb.format("SUCCEEDED", string));
                    }
                    catch (Exception exception) {
                        DbControlEditor.this.setStatusLabel("ALTER DATABASE: " + exception.getLocalizedMessage());
                        throw new TaskException((Throwable)exception);
                    }
                    finally {
                        if (statement != null) {
                            try {
                                statement.close();
                            }
                            catch (SQLException sQLException) {}
                        }
                        if (oracleConnection != null) {
                            try {
                                oracleConnection.close();
                            }
                            catch (SQLException sQLException) {}
                        }
                    }
                    return null;
                }
            };
            raptorTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

                public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                    DbControlEditor.this.refreshLater(Boolean.FALSE);
                }

                public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
                    DbControlEditor.this.refreshLater(Boolean.FALSE);
                }
            });
            raptorTask.setCancellable(false);
            RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
        }
        catch (Exception exception) {
            this.setStatusLabel(string + ": " + exception.getLocalizedMessage());
            ExceptionHandler.handleException((Throwable)exception);
        }
    }

    private void shutdown(final String string) {
        try {
            this.setStatusLabel(DbaEditorArb.format("BEGINNING", "SHUTDOWN " + string));
            final String[] stringArray = this.getEventThreadProperties();
            if (stringArray[2] == null) {
                return;
            }
            this.setStartedMountOpen(ConnectState.PROCESSING);
            RaptorTask<Object> raptorTask = new RaptorTask<Object>("SHUTDOWN", true, IRaptorTaskRunMode.NO_GUI){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected Object doWork() throws TaskException {
                    OracleConnection oracleConnection = null;
                    Statement statement = null;
                    try {
                        oracleConnection = DbControlEditor.this.commonCodeGetConnection(stringArray, false);
                        HashMap<String, OracleConnection.DatabaseShutdownMode> hashMap = new HashMap<String, OracleConnection.DatabaseShutdownMode>();
                        hashMap.put("ABORT", OracleConnection.DatabaseShutdownMode.ABORT);
                        hashMap.put("IMMEDIATE", OracleConnection.DatabaseShutdownMode.IMMEDIATE);
                        hashMap.put("NORMAL", OracleConnection.DatabaseShutdownMode.CONNECT);
                        hashMap.put("TRANSACTIONAL", OracleConnection.DatabaseShutdownMode.TRANSACTIONAL);
                        hashMap.put("TRANSACTIONAL LOCAL", OracleConnection.DatabaseShutdownMode.TRANSACTIONAL_LOCAL);
                        if (string.toUpperCase().equals("NORMAL")) {
                            DbControlEditor.this.setStatusLabel(DbaEditorArb.getString("SHUTDOWN_NORMAL"));
                        }
                        if (hashMap.get(string) != null) {
                            if (string.equals("NORMAL")) {
                                DbControlEditor.this.AllowkillMe(oracleConnection);
                            } else {
                                oracleConnection.shutdown((OracleConnection.DatabaseShutdownMode)hashMap.get(string));
                            }
                        } else {
                            oracleConnection.shutdown((OracleConnection.DatabaseShutdownMode)hashMap.get("IMMEDIATE"));
                        }
                        if (string != "ABORT") {
                            statement = oracleConnection.createStatement();
                            ResultSet resultSet = null;
                            try {
                                resultSet = statement.executeQuery("select status from v$instance");
                                if (resultSet.next()) {
                                    String string2 = resultSet.getString(1).toUpperCase();
                                    if (!string2.equals("STARTED") && !string2.equals("MOUNTED")) {
                                        statement.close();
                                        statement = oracleConnection.createStatement();
                                        statement.executeUpdate("ALTER DATABASE CLOSE NORMAL");
                                    }
                                    if (!string2.equals("STARTED")) {
                                        statement.executeUpdate("ALTER DATABASE DISMOUNT");
                                    }
                                }
                            }
                            finally {
                                if (resultSet != null) {
                                    try {
                                        resultSet.close();
                                    }
                                    catch (SQLException sQLException) {}
                                }
                            }
                            statement.close();
                            oracleConnection.shutdown(OracleConnection.DatabaseShutdownMode.FINAL);
                        }
                        oracleConnection.close();
                        DbControlEditor.this.setStatusLabel(DbaEditorArb.format("SUCCEEDED", "SHUTDOWN"));
                    }
                    catch (Exception exception) {
                        DbControlEditor.this.setStatusLabel("SHUTDOWN: " + exception.getLocalizedMessage());
                        throw new TaskException((Throwable)exception);
                    }
                    finally {
                        if (statement != null) {
                            try {
                                statement.close();
                            }
                            catch (SQLException sQLException) {}
                        }
                        if (oracleConnection != null) {
                            try {
                                oracleConnection.close();
                            }
                            catch (SQLException sQLException) {}
                        }
                    }
                    return null;
                }
            };
            raptorTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

                public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                    DbControlEditor.this.refreshLater(Boolean.FALSE);
                }

                public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
                    DbControlEditor.this.refreshLater(Boolean.FALSE);
                }
            });
            raptorTask.setCancellable(false);
            RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
        }
        catch (Exception exception) {
            this.setStatusLabel("SHUTDOWN: " + exception.getLocalizedMessage());
            ExceptionHandler.handleException((Throwable)exception);
        }
    }

    private void AllowkillMe(OracleConnection oracleConnection) throws SQLException {
        try {
            this.setShutdownNormalConn(oracleConnection);
            this.setStartedMountOpenAndRefresh(ConnectState.SHUTDOWNNORMAL, Boolean.TRUE, DbaEditorArb.getString("SHUTDOWN_NORMAL"));
            oracleConnection.shutdown(OracleConnection.DatabaseShutdownMode.CONNECT);
            this.tearDownShutdownNormalConn();
        }
        finally {
            this.tearDownShutdownNormalConn();
            this.setStartedMountOpenAndRefresh(ConnectState.PROCESSING, Boolean.TRUE, DbaEditorArb.getString("SHUTDOWN_NORMAL"));
        }
    }

    private void getStatus() {
        try {
            if (this.getLastConnectState().equals((Object)ConnectState.CONNECTING)) {
                return;
            }
            this.setStartedMountOpen(ConnectState.CONNECTING);
            final String[] stringArray = this.getEventThreadProperties();
            if (stringArray[2] == null) {
                return;
            }
            RaptorTask<Object> raptorTask = new RaptorTask<Object>("SHUTDOWN", true, IRaptorTaskRunMode.NO_GUI){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected Object doWork() throws TaskException {
                    OracleConnection oracleConnection = null;
                    Statement statement = null;
                    ResultSet resultSet = null;
                    try {
                        oracleConnection = DbControlEditor.this.commonCodeGetConnection(stringArray, false);
                        statement = oracleConnection.createStatement();
                        resultSet = statement.executeQuery("select status from v$instance");
                        if (resultSet.next()) {
                            String string = resultSet.getString(1).toUpperCase();
                            if (string.equals("STARTED")) {
                                DbControlEditor.this.setStartedMountOpenAndRefresh(ConnectState.STARTED, Boolean.TRUE, SKIP);
                            } else if (string.equals("MOUNTED")) {
                                DbControlEditor.this.setStartedMountOpenAndRefresh(ConnectState.MOUNTED, Boolean.TRUE, SKIP);
                            } else if (string.equals("OPEN")) {
                                DbControlEditor.this.setStartedMountOpenAndRefresh(ConnectState.OPEN, Boolean.TRUE, SKIP);
                            }
                        } else {
                            DbControlEditor.this.setStartedMountOpenAndRefresh(ConnectState.UNKNOWN, Boolean.TRUE, SKIP);
                        }
                    }
                    catch (Exception exception) {
                        Exception exception2;
                        if (exception.getMessage().toLowerCase().startsWith("ora-01034")) {
                            OracleConnection oracleConnection2 = null;
                            try {
                                oracleConnection2 = DbControlEditor.this.commonCodeGetConnection(stringArray, true);
                            }
                            catch (Exception exception3) {
                                exception2 = exception3;
                            }
                            finally {
                                if (oracleConnection2 != null) {
                                    try {
                                        oracleConnection2.close();
                                    }
                                    catch (Exception exception4) {}
                                }
                            }
                        }
                        if (exception2.getMessage().toLowerCase().startsWith("ora-01017")) {
                            DbControlEditor.this.setStartedMountOpenAndRefresh(ConnectState.INVALID_USERNAME_PASSWORD, Boolean.TRUE, SKIP);
                        } else {
                            DbControlEditor.this.setStartedMountOpenAndRefresh(ConnectState.CANT_CONNECT, Boolean.TRUE, SKIP);
                        }
                        throw new TaskException((Throwable)exception2);
                    }
                    finally {
                        if (resultSet != null) {
                            try {
                                resultSet.close();
                            }
                            catch (SQLException sQLException) {}
                        }
                        if (statement != null) {
                            try {
                                statement.close();
                            }
                            catch (SQLException sQLException) {}
                        }
                        if (oracleConnection != null) {
                            try {
                                oracleConnection.close();
                            }
                            catch (SQLException sQLException) {}
                        }
                    }
                    return null;
                }
            };
            raptorTask.setCancellable(false);
            RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
        }
        catch (Exception exception) {
            this.setStatusLabel(exception.getLocalizedMessage());
            ExceptionHandler.handleException((Throwable)exception);
        }
    }

    public String getTabLabel() {
        return Connections.getDisplayName((String)this.name);
    }

    public String getTitleLabel() {
        return Connections.getDisplayName((String)this.name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DbControlEditor openNewEditor(DbaConnection dbaConnection) {
        DbControlEditor dbControlEditor = null;
        DbControlNode dbControlNode = new DbControlNode();
        WaitCursor waitCursor = Ide.getWaitCursor();
        String string = Connections.getDisplayName((String)dbaConnection.getConnectionName());
        try {
            dbControlNode.setConnection(Connections.getInstance().getUniqueConnection(dbaConnection.getConnectionName()));
            dbControlNode.setDisplayName(string);
            dbControlNode.setConnName(dbaConnection.getConnectionName());
            dbControlNode.setQualifiedConnectionName(dbaConnection.getQualifiedConnectionName());
            Context context = Context.newIdeContext((Node)dbControlNode);
            OpenEditorOptions openEditorOptions = new OpenEditorOptions(context);
            openEditorOptions.setFlags(1);
            waitCursor.show();
            dbControlEditor = (DbControlEditor)EditorManager.getEditorManager().openEditor(openEditorOptions);
        }
        catch (Exception exception) {
        }
        finally {
            waitCursor.hide();
        }
        return dbControlEditor;
    }

    private String passwordGetPassword(String string) {
        GetPassword getPassword = new GetPassword(string);
        try {
            getPassword.run();
        }
        catch (ClosureException closureException) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, closureException.getStackTrace()[0].toString(), closureException);
            return null;
        }
        String[] stringArray = getPassword.getResult();
        if (stringArray[1].equals("NO CLICK")) {
            return null;
        }
        return stringArray[0];
    }

    private synchronized Usedialog getTryBeqDialog() {
        return this._tryBeqDialog;
    }

    private synchronized void setTryBeqDialog(Usedialog usedialog) {
        this._tryBeqDialog = usedialog;
    }

    private synchronized void tearDownShutdownNormalConn() {
        this._shutdownNormalConn = null;
    }

    private synchronized void cancelShutdownNormalConn() {
        try {
            if (this._shutdownNormalConn != null) {
                this._shutdownNormalConn.cancel();
            }
        }
        catch (Exception exception) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
        }
    }

    private synchronized void setShutdownNormalConn(OracleConnection oracleConnection) {
        this._shutdownNormalConn = oracleConnection;
    }

    private void reqFocus() {
        OpenEditorOptions openEditorOptions = new OpenEditorOptions(this.getContext());
        openEditorOptions.setFlags(5);
        EditorManager.getEditorManager().openEditor(openEditorOptions);
    }

    static enum Usedialog {
        NOTSET,
        TRUE,
        FALSE;

    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum ConnectState {
        CONNECTING{

            public String toString() {
                return DbaEditorArb.getString("CONNECTING");
            }
        }
        ,
        CANT_CONNECT{

            public String toString() {
                return DbaEditorArb.getString("CANNOT_CONNECT");
            }
        }
        ,
        UNKNOWN{

            public String toString() {
                return DbaEditorArb.getString("UNKNOWN");
            }
        }
        ,
        PROCESSING{

            public String toString() {
                return DbaEditorArb.getString("PROCESSING");
            }
        }
        ,
        SHUTDOWNNORMAL{

            public String toString() {
                return DbaEditorArb.getString("SHUTDOWN_NORMAL");
            }
        }
        ,
        INVALID_USERNAME_PASSWORD{

            public String toString() {
                return DbaEditorArb.getString("INVALID_USERNAME_PASSWORD");
            }
        }
        ,
        STARTED,
        MOUNTED,
        OPEN;

    }

    private static class GetPassword
    extends SwingClosure {
        private String m_newPass1;
        private String m_user;
        private String m_errorOut = "NO CLICK";

        GetPassword(String string) {
            this.m_user = string;
        }

        String[] getResult() {
            return new String[]{this.m_newPass1, this.m_errorOut};
        }

        public void runImpl() {
            Properties properties = new Properties();
            properties.setProperty("user", this.m_user);
            try {
                ConnectionInfoPanel.promptForConnection((Properties)properties);
                this.m_newPass1 = properties.getProperty("password");
                this.m_errorOut = "OK";
            }
            catch (ConnectionCanceledException connectionCanceledException) {
                this.m_newPass1 = "";
            }
        }
    }
}

