/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.scriptprocessors;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.dba.DbaNavigatorResources;
import oracle.dbtools.raptor.dba.navigator.actions.scriptprocessors.RMANScriptProcessorActionControl;
import oracle.dbtools.raptor.ui.Utils;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.actions.ScriptProcessor;
import oracle.dbtools.raptor.ui.actions.ScriptProcessorContext;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.ceditor.keymap.EditorFactory;
import oracle.javatools.editor.BasicEditorPane;

public class RMANScriptProcessor
implements ScriptProcessor {
    private String _commandFilePath;
    private boolean _saveScriptToFile;
    private boolean _processingDeclined;
    private boolean noCredential;
    private boolean _scriptError;
    private boolean _scheduledActionsNotConfigured;
    private ActionDialog _dialog;
    boolean _cancelled = false;

    public RMANScriptProcessor() {
    }

    public RMANScriptProcessor(ActionDialog actionDialog) {
        this._dialog = actionDialog;
    }

    public BasicEditorPane getEditorPane() {
        BasicEditorPane basicEditorPane = EditorFactory.createIdeEditorPane();
        return basicEditorPane;
    }

    public String getScriptEditorTabName() {
        return DbaNavigatorResources.getString("RMAN_TAB");
    }

    public String getSuccessMessage() {
        if (this._saveScriptToFile) {
            return DbaNavigatorResources.format("FILE_SAVE_SUCCESS", this._commandFilePath);
        }
        return DbaNavigatorResources.format("RMAN_SCRIPT_SUCCESS", new Object[0]);
    }

    public String getFailureMessage(Exception exception) {
        Object object = null;
        if (this._saveScriptToFile) {
            object = DbaNavigatorResources.getString("FILE_SAVE_FAILURE");
        } else {
            if (this._processingDeclined) {
                return null;
            }
            object = this.noCredential ? DbaNavigatorResources.format("NO_CREDENTIAL", new Object[0]) : (this._scriptError ? DbaNavigatorResources.format("RMAN_SCRIPT_FAILURE", new Object[0]) : (this._scheduledActionsNotConfigured ? DbaNavigatorResources.getString("UNABLE_TO_RUN_RMAN") : DbaNavigatorResources.format("SCHEDULER_JOB_FAILURE", new Object[0])));
        }
        String string = exception.getLocalizedMessage();
        if (string != null) {
            object = (String)object + "\n- " + string;
        }
        return object;
    }

    public boolean isCancellable() {
        return true;
    }

    public void cancel() {
        this._cancelled = true;
    }

    public void processScript(ScriptProcessorContext scriptProcessorContext) throws Exception {
        this._saveScriptToFile = scriptProcessorContext.getParameter("RMANScriptProcessor/Type").equals(RMANScriptProcessorActionControl.SAVE_TO_FILE);
        if (this._saveScriptToFile) {
            this.saveScriptToFile(scriptProcessorContext);
        } else {
            this.runSchedulerJob(scriptProcessorContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveScriptToFile(ScriptProcessorContext scriptProcessorContext) throws Exception {
        this._commandFilePath = scriptProcessorContext.getParameter("RMANScriptProcessor/FilePath");
        if (this._commandFilePath == null || this._commandFilePath.equals("")) {
            throw new FileNotFoundException(DbaNavigatorResources.getString("FILE_NOT_SPECIFIED"));
        }
        File file = new File(this._commandFilePath);
        try (FileWriter fileWriter = new FileWriter(file);){
            fileWriter.write(scriptProcessorContext.getScript());
        }
        RMANScriptProcessorActionControl.updateDefaultSaveDir(this._commandFilePath);
    }

    private void runSchedulerJob(ScriptProcessorContext scriptProcessorContext) throws Exception {
        String string;
        this._processingDeclined = false;
        Connection connection = scriptProcessorContext.getConnection();
        boolean bl = this.runJob(connection, string = scriptProcessorContext.getParameter("RMANScriptProcessor/Job"), scriptProcessorContext.getActionTitle(), scriptProcessorContext.getParameter("RMANScriptProcessor/Credential"), scriptProcessorContext.getScript());
        if (!bl) {
            throw new SQLException();
        }
        bl = this.waitForJobCompletion(connection, string);
        if (!bl) {
            throw new SQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean runJob(Connection connection, String string, String string2, String string3, String string4) throws Exception {
        if (string3 == null || string3.isEmpty()) {
            this.noCredential = true;
            return false;
        }
        boolean bl = true;
        if (Connections.getInstance().lock(connection)) {
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                dBUtil.setRaiseError(true);
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("JOB_NAME", string);
                hashMap.put("SCRIPT", "connect target / \n" + string4);
                hashMap.put("CREDENTIAL", string3);
                String string5 = this.getQuery(connection, "scheduleRMANJob");
                dBUtil.execute(string5, hashMap);
                connection.commit();
                RMANScriptProcessorActionControl.updateDefaultCredential(string3);
            }
            catch (SQLException sQLException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitForJobCompletion(Connection connection, String string) throws Exception {
        boolean bl = false;
        if (Connections.getInstance().lock(connection)) {
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                dBUtil.setRaiseError(true);
                boolean bl2 = false;
                while (!bl2 && !this._cancelled) {
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put("JOB_NAME", string);
                    ResultSet resultSet = dBUtil.executeOracleQuery(this.getQuery(connection, "getRMANJobResult"), hashMap);
                    if (resultSet != null) {
                        try {
                            while (resultSet.next()) {
                                String string2 = resultSet.getString("STATUS");
                                if (string2 == null) continue;
                                bl2 = true;
                                String string3 = resultSet.getString("OUTPUT");
                                boolean bl3 = string2.equals("SUCCEEDED");
                                if (bl3) {
                                    this._scriptError = string3.contains("ERROR MESSAGE");
                                }
                                bl = bl3 && !this._scriptError;
                            }
                        }
                        finally {
                            DBUtil.closeResultSet((ResultSet)resultSet);
                        }
                    }
                    connection.commit();
                    if (bl2) continue;
                    try {
                        Thread.currentThread();
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            catch (SQLException sQLException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
        }
        return bl;
    }

    private String getQuery(Connection connection, String string) {
        return Utils.getQuery(this.getClass(), (Connection)connection, (String)string);
    }
}

